/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.common.util.AccrualCalculateAdapter;
import com.kingdee.eas.fm.common.util.AccrualCalculatorElementNeededInfo;
import com.kingdee.eas.fm.im.IIntTerm;
import com.kingdee.eas.fm.im.IntTermFactory;
import com.kingdee.eas.fm.im.IntTermInfo;
import com.kingdee.eas.fm.im.TermTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;

public class AccrualCalculate_PreDrawing
extends AccrualCalculateAdapter {
    public AccrualCalculate_PreDrawing(AccrualCalculatorElementNeededInfo acen) {
        super(acen);
    }

    @Override
    protected BigDecimal getPrincipal() {
        return this.acen.getDepositBalance().subtract(this.acen.getFloorAmt());
    }

    public BigDecimal calcCurrentAccrual() {
        return Constants.ZERO;
    }

    @Override
    protected Date getStartDate() {
        ArrayList<Date> li = new ArrayList<Date>();
        li.add(this.acen.getEffectedDate());
        li.add(this.acen.getLastPreDate());
        return this.getMaxDate(li);
    }

    @Override
    protected Date getEndDate() {
        ArrayList<Date> li = new ArrayList<Date>();
        li.add(this.acen.getCustomerEndDate());
        li.add(this.acen.getMaturityDate());
        Date minDate = this.getMinDate(li);
        return DateUtil.getBeforeDay((Date)minDate);
    }

    @Override
    protected BigDecimal getPeriodicalRate(Context ctx) {
        BigDecimal returnValue = Constants.ZERO;
        if (this.acen.getTimeDepositType() == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || this.acen.getTimeDepositType() == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER) {
            returnValue = this.acen.getYearRate();
        } else if (this.acen.getTimeDepositType() == TimeDepositTypeEnum.CALLDEPOSIT_INNER || this.acen.getTimeDepositType() == TimeDepositTypeEnum.CALLDEPOSIT_OUTER) {
            try {
                returnValue = this.getYearRate(ctx, this.acen.getIntRateType(), this.acen.getFloatting(), this.acen.getCurrency(), this.acen.getBizDate());
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e);
            }
        }
        return returnValue;
    }

    @Override
    public BigDecimal calcUnVerifyAmt() {
        return Constants.ZERO;
    }

    @Override
    public BigDecimal calcStrikedAmt() {
        return Constants.ZERO;
    }

    @Override
    protected boolean doCalcPeriodicalAccrual() {
        return true;
    }

    @Override
    protected boolean doCalcCurrentAccrual() {
        return true;
    }

    @Override
    protected BigDecimal getIntervalDays() {
        Date startDate = this.getStartDate();
        Date endDate = this.getEndDate();
        if (this.isCalByMonth()) {
            IntTermInfo intTermInfo = null;
            try {
                IIntTerm iIntTerm = this.ctx == null ? IntTermFactory.getRemoteInstance() : IntTermFactory.getLocalInstance((Context)this.ctx);
                if (null != iIntTerm && null != this.acen.getIntTerm()) {
                    intTermInfo = (IntTermInfo)iIntTerm.getValue((IObjectPK)new ObjectUuidPK(this.acen.getIntTerm().getId()));
                }
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (intTermInfo != null && (TermTypeEnum.YEAR.equals((Object)intTermInfo.getType()) || TermTypeEnum.MONTH.equals((Object)intTermInfo.getType()))) {
                int i = this.getDiffDaysByMonth(startDate, endDate);
                return new BigDecimal(String.valueOf(i));
            }
        }
        int days = DateUtil.getDiffDays((Date)startDate, (Date)endDate);
        return new BigDecimal(String.valueOf(days));
    }

    public int getDiffDaysByMonth(Date beginDate, Date endDate) {
        GregorianCalendar gCal = (GregorianCalendar)GregorianCalendar.getInstance();
        gCal.setTime(beginDate);
        int y1 = gCal.get(1);
        int m1 = gCal.get(2);
        int d1 = gCal.get(5);
        gCal.setTime(endDate);
        gCal.add(5, 1);
        int y2 = gCal.get(1);
        int m2 = gCal.get(2);
        int d2 = gCal.get(5);
        if (d1 == 31) {
            d1 = 30;
        }
        if (d2 == 31) {
            d2 = 30;
        }
        int days = 360 * (y2 - y1) + 30 * (m2 - m1) + (d2 - d1);
        return days;
    }

    @Override
    protected void checkEmtpy() {
        if (this.acen.getDepositBalance() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"84_AccrualCalculate_PreDrawing"));
        }
        if (this.acen.getFloorAmt() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"85_AccrualCalculate_PreDrawing"));
        }
        if (this.acen.getCurrency() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"86_AccrualCalculate_PreDrawing"));
        }
        if (this.acen.getBizDate() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"87_AccrualCalculate_PreDrawing"));
        }
    }

    @Override
    protected String getMsgHeader() {
        return EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"88_AccrualCalculate_PreDrawing");
    }

    @Override
    protected int getPrecision(Context ctx) {
        return super.getPrecision(ctx);
    }
}

