/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.common.UnDepositTypeEnum;
import com.kingdee.eas.fm.common.util.AccrualCalculateAdapter;
import com.kingdee.eas.fm.common.util.AccrualCalculatorElementNeededInfo;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.Date;

public class AccrualCalculate_UnDeposit
extends AccrualCalculateAdapter {
    public AccrualCalculate_UnDeposit(AccrualCalculatorElementNeededInfo acen) {
        super(acen);
    }

    @Override
    protected BigDecimal getPrincipal() {
        BigDecimal floorAmt = Constants.ZERO;
        if (this.acen.isLastUnde()) {
            floorAmt = this.acen.getFloorAmtTmp();
        }
        return this.acen.getUnDepositAmt().subtract(floorAmt);
    }

    @Override
    protected Date getEndDate() {
        return DateUtil.getBeforeDay((Date)this.acen.getUnDepositDate());
    }

    @Override
    protected Date getStartDate() {
        return this.acen.getEffectedDate();
    }

    @Override
    protected boolean doCalcPeriodicalAccrual() {
        boolean doCalcPeriodicalAccrual = false;
        if (this.acen.getUnDepositTypeEnum() == UnDepositTypeEnum.MATURE_UNDEPOSIT || this.acen.getUnDepositTypeEnum() == UnDepositTypeEnum.CONSULT_UNDEPOSIT) {
            doCalcPeriodicalAccrual = true;
        }
        return doCalcPeriodicalAccrual;
    }

    @Override
    protected boolean doCalcCurrentAccrual() {
        boolean doCalcCurrentAccrual = false;
        if (this.acen.getUnDepositTypeEnum() == UnDepositTypeEnum.MATURE_UNDEPOSIT || this.acen.getUnDepositTypeEnum() == UnDepositTypeEnum.AHEAD_UNDEPOSIT || this.acen.getUnDepositTypeEnum() == UnDepositTypeEnum.UN_CONSULT_UNDEPOSIT) {
            doCalcCurrentAccrual = true;
        }
        return doCalcCurrentAccrual;
    }

    @Override
    protected BigDecimal getPeriodicalRate(Context ctx) {
        return this.acen.getYearRate();
    }

    @Override
    protected BigDecimal getCurrentRate() {
        return this.acen.getCurYearRate();
    }

    @Override
    protected BigDecimal getIntervalDays() {
        if (!this.isCalByMonth()) {
            return this.getDays();
        }
        if (this.acen.getStartDate() != null && this.acen.getUnDepositTypeEnum() == UnDepositTypeEnum.MATURE_UNDEPOSIT && this.acen.getEffectedDate().after(this.acen.getStartDate())) {
            return this.getDays();
        }
        if (this.acen.getTimeDepositType() != TimeDepositTypeEnum.CALLDEPOSIT_INNER && this.acen.getTimeDepositType() != TimeDepositTypeEnum.CALLDEPOSIT_OUTER && !this.isOther()) {
            return super.getIntervalDaysByIntTerm();
        }
        return this.getDays();
    }

    private BigDecimal getDays() {
        Date startDate = null;
        Date endDate = null;
        if (this.acen.getUnDepositTypeEnum() == UnDepositTypeEnum.MATURE_UNDEPOSIT) {
            startDate = this.acen.getEffectedDate();
            endDate = this.acen.getMaturityDate();
        } else if (this.acen.getUnDepositTypeEnum() == UnDepositTypeEnum.CONSULT_UNDEPOSIT) {
            startDate = this.getStartDate();
            endDate = this.getEndDate();
        }
        if (startDate == null || endDate == null) {
            return Constants.ZERO;
        }
        int days = DateUtil.getDiffDays((Date)startDate, (Date)endDate);
        return new BigDecimal(String.valueOf(days));
    }

    @Override
    protected BigDecimal getCurrentIntervalDays() {
        Date startDate = null;
        Date endDate = null;
        int days = 0;
        if (this.acen.getUnDepositTypeEnum() == UnDepositTypeEnum.MATURE_UNDEPOSIT) {
            startDate = DateUtil.getAfterDay((Date)this.acen.getMaturityDate());
            days = DateUtil.getDiffDays((Date)startDate, (Date)(endDate = this.getEndDate()));
            if (days < 0) {
                days = 0;
            }
        } else if (this.acen.getUnDepositTypeEnum() == UnDepositTypeEnum.AHEAD_UNDEPOSIT || this.acen.getUnDepositTypeEnum() == UnDepositTypeEnum.UN_CONSULT_UNDEPOSIT) {
            startDate = this.acen.getEffectedDate();
            endDate = this.getEndDate();
            days = DateUtil.getDiffDays((Date)startDate, (Date)endDate);
        }
        return new BigDecimal(String.valueOf(days));
    }

    @Override
    protected void checkEmtpy() {
        if (this.acen.getUnDepositAmt() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"93_AccrualCalculate_UnDeposit"));
        }
        if (this.acen.getUnDepositDate() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"94_AccrualCalculate_UnDeposit"));
        }
        if (this.acen.getEffectedDate() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"95_AccrualCalculate_UnDeposit"));
        }
        if (this.acen.getUnDepositTypeEnum() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"96_AccrualCalculate_UnDeposit"));
        }
        if (this.acen.getCurYearRate() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"97_AccrualCalculate_UnDeposit"));
        }
        if (this.acen.getYearRate() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"98_AccrualCalculate_UnDeposit"));
        }
    }

    @Override
    protected String getMsgHeader() {
        return EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"99_AccrualCalculate_UnDeposit");
    }

    @Override
    protected int getPrecision(Context ctx) {
        return super.getPrecision(ctx);
    }
}

