/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.ReceivableBillEntryVO;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.SettlementBillSourceEnum;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizRelateReceivableBillUtil {
    private static Logger logger = Logger.getLogger((String)BizRelateReceivableBillUtil.class.getName());

    public static void relateReceivableBill(Context ctx, CoreBaseInfo info, IObjectPK pk) throws BOSException, EASBizException {
        if (!EmptyUtil.isEmpty((Object)pk) && info != null && info.get("receivableBillEntrys") != null && info.get("receivableBillEntrys") instanceof List) {
            SettlementBillInfo sInfo;
            List list = (List)info.get("receivableBillEntrys");
            BizRelateReceivableBillUtil.deleteReceivableEntry(ctx, info, pk);
            IReceivableBill iReceivableBill = ctx == null ? ReceivableBillFactory.getRemoteInstance() : ReceivableBillFactory.getLocalInstance((Context)ctx);
            boolean isFromPay = false;
            boolean isDisposer = true;
            if (info instanceof SettlementBillInfo && SettlementBillSourceEnum.PAYMENTBILL.equals((Object)(sInfo = (SettlementBillInfo)info).getSource()) && !EmptyUtil.isEmpty((String)sInfo.getSourceBillId()) && BOSUuid.read((String)sInfo.getSourceBillId()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString())) {
                IPaymentBill iPaymentBill = ctx == null ? PaymentBillFactory.getRemoteInstance() : PaymentBillFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("settlementType.ntType.*"));
                PaymentBillInfo pInfo = iPaymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(sInfo.getSourceBillId()), sic);
                if (pInfo.getSettlementType() != null && pInfo.getSettlementType().getNtType() != null && NTTypeGroupEnum.RECEIVABLE.equals((Object)pInfo.getSettlementType().getNtType().getSuperGroup()) && pInfo.getSettlementNumber() != null) {
                    isDisposer = false;
                }
            }
            if (isDisposer) {
                PaymentBillInfo paymentBillInfo = new PaymentBillInfo();
                if (BOSUuid.read((String)pk.toString()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString())) {
                    paymentBillInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo(pk);
                    boolean bl = isFromPay = paymentBillInfo.isIsSchCreated() || !EmptyUtil.isEmpty((Object)ctx.get((Object)"fromSchedule"));
                }
                if (!isFromPay) {
                    for (int i = 0; i < list.size(); ++i) {
                        ReceivableBillEntryVO entryVO = (ReceivableBillEntryVO)list.get(i);
                        EntityViewInfo evi = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("id", (Object)entryVO.getReceivableBillID()));
                        evi.setFilter(filter);
                        ReceivableBillCollection collection = iReceivableBill.getReceivableBillCollection(evi);
                        if (collection.size() <= 0 || EmptyUtil.isEmpty((Object)entryVO.getEndorseAmt()) || entryVO.getEndorseAmt().compareTo(collection.get(0).getAvailableAmt()) <= 0) continue;
                        String msg = "";
                        msg = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"43_common", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"43_common");
                        throw new FMException(FMException.COMMMONEXCEPTION, new String[]{msg});
                    }
                }
            }
            try {
                ReceivableBillEntryVO entryVO;
                if (!isFromPay && isDisposer) {
                    String recSql = "update T_NT_ReceivableBill set FLockAmt = FLockAmt+?,FAvailableAmt = FAvailableAmt-? where FId=?";
                    ArrayList<Object[]> recParamsList = new ArrayList<Object[]>();
                    for (int i = 0; i < list.size(); ++i) {
                        entryVO = (ReceivableBillEntryVO)list.get(i);
                        BigDecimal amt = entryVO.getEndorseAmt();
                        recParamsList.add(new Object[]{amt, amt, entryVO.getReceivableBillID()});
                    }
                    DbUtil.executeBatch((Context)ctx, (String)recSql, recParamsList);
                }
                if (list.size() > 0) {
                    String sql = "insert into T_FM_ReceivableBillEntry(FID,FBillID,FBillType,FReceivableBillID,FReceivableBillNum,FElecBillStatus,FSeq,FEndorseAmt) values(?,?,?,?,?,?,?,?)";
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                    for (int i = 0; i < list.size(); ++i) {
                        entryVO = (ReceivableBillEntryVO)list.get(i);
                        paramsList.add(new Object[]{pk.toString() + "_" + i, pk.toString(), entryVO.getBillType(), entryVO.getReceivableBillID(), entryVO.getReceivableBillNum(), entryVO.getElecBillStatus(), entryVO.getSeq(), !EmptyUtil.isEmpty((Object)entryVO.getEndorseAmt()) ? entryVO.getEndorseAmt() : BigDecimal.ZERO});
                    }
                    DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
                }
            }
            catch (Exception e) {
                logger.error((Object)"\u6279\u91cf\u63d2\u5165\u4e1a\u52a1\u5355\u636e\u4e0e\u7968\u636e\u7684\u5173\u7cfb\u5206\u5f55\u5f02\u5e38", (Throwable)e);
                String msg = "";
                msg = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"33_common", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"33_common");
                throw new FMException(FMException.COMMMONEXCEPTION, new String[]{msg});
            }
        }
    }

    public static void deleteReceivableEntry(Context ctx, CoreBaseInfo info, IObjectPK pk) throws BOSException, EASBizException {
        try {
            if (!EmptyUtil.isEmpty((Object)pk)) {
                SettlementBillInfo sInfo;
                boolean isDisposer = true;
                if (info instanceof PaymentBillInfo) {
                    PaymentBillInfo pInfo = (PaymentBillInfo)info;
                    if (pInfo.isIsSchCreated()) {
                        isDisposer = false;
                    }
                } else if (info instanceof SettlementBillInfo && SettlementBillSourceEnum.PAYMENTBILL.equals((Object)(sInfo = (SettlementBillInfo)info).getSource()) && !EmptyUtil.isEmpty((String)sInfo.getSourceBillId()) && BOSUuid.read((String)sInfo.getSourceBillId()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString())) {
                    IPaymentBill iPaymentBill = ctx == null ? PaymentBillFactory.getRemoteInstance() : PaymentBillFactory.getLocalInstance((Context)ctx);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("settlementType.ntType.*"));
                    PaymentBillInfo pInfo = iPaymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(sInfo.getSourceBillId()), sic);
                    if (pInfo.getSettlementType() != null && pInfo.getSettlementType().getNtType() != null && NTTypeGroupEnum.RECEIVABLE.equals((Object)pInfo.getSettlementType().getNtType().getSuperGroup()) && pInfo.getSettlementNumber() != null) {
                        isDisposer = false;
                    }
                }
                if (isDisposer) {
                    String sSQL = "Select * From T_FM_ReceivableBillEntry Where FBillID = '" + pk.toString() + "'";
                    HashMap map = new HashMap();
                    ISQLExecutor exec = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sSQL) : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sSQL);
                    IRowSet rs = exec.executeSQL();
                    String recSql = "update T_NT_ReceivableBill set FLockAmt = FLockAmt-?,FAvailableAmt = FAvailableAmt+? where FId=?";
                    ArrayList<Object[]> recParamsList = new ArrayList<Object[]>();
                    while (rs.next()) {
                        recParamsList.add(new Object[]{rs.getBigDecimal("FEndorseAmt"), rs.getBigDecimal("FEndorseAmt"), rs.getString("FReceivableBillID")});
                    }
                    if (recParamsList.size() > 0) {
                        DbUtil.executeBatch((Context)ctx, (String)recSql, recParamsList);
                    }
                }
                DbUtil.execute((Context)ctx, (String)"delete from T_FM_ReceivableBillEntry where FBillID = ?", (Object[])new Object[]{pk.toString()});
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u5220\u9664\u4e1a\u52a1\u5355\u636e\u4e0e\u7968\u636e\u7684\u5173\u7cfb\u5206\u5f55\u5f02\u5e38", (Throwable)e);
            String msg = "";
            msg = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"34_common", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"34_common");
            throw new FMException(FMException.COMMMONEXCEPTION, new String[]{msg});
        }
    }

    public static List<ReceivableBillEntryVO> getReceivableEntryList(Context ctx, CoreBaseInfo info) throws BOSException, EASBizException {
        ArrayList<ReceivableBillEntryVO> entrylist = new ArrayList();
        try {
            if (info != null && info.get("receivableBillEntrys") != null && info.get("receivableBillEntrys") instanceof List) {
                entrylist = (List)info.get("receivableBillEntrys");
            } else {
                String sSQL = "Select * From T_FM_ReceivableBillEntry Where FBillID = '" + info.getId().toString() + "'";
                ISQLExecutor exec = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sSQL) : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sSQL);
                IRowSet rs = exec.executeSQL();
                while (rs.next()) {
                    ReceivableBillEntryVO entryVO = new ReceivableBillEntryVO();
                    entryVO.setBillID(info.getId().toString());
                    entryVO.setReceivableBillID(rs.getString("FReceivableBillID"));
                    entryVO.setReceivableBillNum(rs.getString("FReceivableBillNum"));
                    entryVO.setBillType(rs.getString("FBillType"));
                    entryVO.setElecBillStatus(rs.getString("FElecBillStatus"));
                    entryVO.setSeq(rs.getInt("FSeq"));
                    entryVO.setEndorseAmt(rs.getBigDecimal("FEndorseAmt"));
                    entrylist.add(entryVO);
                }
            }
            return entrylist;
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u4e1a\u52a1\u5355\u636e\u4e0e\u7968\u636e\u7684\u5173\u7cfb\u5206\u5f55\u5f02\u5e38", (Throwable)e);
            String msg = "";
            msg = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"35_common", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"35_common");
            throw new FMException(FMException.COMMMONEXCEPTION, new String[]{msg});
        }
    }

    public static List<ReceivableBillEntryVO> assembleReceivableEntryList(Object[] notes, String settleNum, int billType) {
        ArrayList<ReceivableBillEntryVO> entrylist;
        block25: {
            String recStr;
            String settleStr;
            String payStr;
            block23: {
                Object note;
                block24: {
                    entrylist = new ArrayList<ReceivableBillEntryVO>();
                    payStr = EASResource.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"40_common");
                    settleStr = EASResource.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"41_common");
                    recStr = EASResource.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"42_common");
                    if (EmptyUtil.isEmpty((Object[])notes) || notes.length <= 0) break block23;
                    note = notes[0];
                    if (!(note instanceof ReceivableBillInfo)) break block24;
                    ReceivableBillCollection recCol = new ReceivableBillCollection();
                    for (int i = 0; i < notes.length; ++i) {
                        ReceivableBillInfo receivableinfo = (ReceivableBillInfo)notes[i];
                        recCol.add((ReceivableBillInfo)notes[i]);
                        ReceivableBillEntryVO entryVO = new ReceivableBillEntryVO();
                        if (billType == 1) {
                            entryVO.setBillType(payStr);
                        } else if (billType == 2) {
                            entryVO.setBillType(settleStr);
                        } else if (billType == 3) {
                            entryVO.setBillType(recStr);
                        }
                        entryVO.setReceivableBillID(receivableinfo.getId().toString());
                        entryVO.setReceivableBillNum(receivableinfo.getDraftNumber());
                        entryVO.setSeq(i + 1);
                        if (EmptyUtil.isEmpty((Object)receivableinfo.getEndorseAmt())) {
                            entryVO.setEndorseAmt(receivableinfo.getAvailableAmt());
                        } else {
                            entryVO.setEndorseAmt(receivableinfo.getEndorseAmt());
                        }
                        if (receivableinfo.getElecBillStatus() != null) {
                            entryVO.setElecBillStatus(receivableinfo.getElecBillStatus().getValue());
                        }
                        entrylist.add(entryVO);
                    }
                    break block25;
                }
                if (!(note instanceof PayableBillInfo)) break block25;
                PayableBillCollection payCol = new PayableBillCollection();
                for (int i = 0; i < notes.length; ++i) {
                    payCol.add((PayableBillInfo)notes[i]);
                    PayableBillInfo payableinfo = (PayableBillInfo)notes[i];
                    ReceivableBillEntryVO entryVO = new ReceivableBillEntryVO();
                    if (billType == 1) {
                        entryVO.setBillType(payStr);
                    } else if (billType == 2) {
                        entryVO.setBillType(settleStr);
                    } else if (billType == 3) {
                        entryVO.setBillType(recStr);
                    }
                    entryVO.setReceivableBillID(payableinfo.getId().toString());
                    entryVO.setReceivableBillNum(payableinfo.getDraftNumber());
                    entryVO.setSeq(i + 1);
                    if (payableinfo.getElecBillStatus() != null) {
                        entryVO.setElecBillStatus(payableinfo.getElecBillStatus().getValue());
                    }
                    entrylist.add(entryVO);
                }
                break block25;
            }
            if (!EmptyUtil.isEmpty((String)settleNum)) {
                String[] settleNumAry = settleNum.trim().split(";");
                for (int i = 0; i < settleNumAry.length; ++i) {
                    ReceivableBillEntryVO entryVO = new ReceivableBillEntryVO();
                    if (billType == 1) {
                        entryVO.setBillType(payStr);
                    } else if (billType == 2) {
                        entryVO.setBillType(settleStr);
                    } else if (billType == 3) {
                        entryVO.setBillType(recStr);
                    }
                    entryVO.setReceivableBillNum(settleNumAry[i]);
                    entryVO.setSeq(i + 1);
                    entrylist.add(entryVO);
                }
            }
        }
        return entrylist;
    }

    public static List<ReceivableBillEntryVO> assembleReceivableEntryListByID(Context ctx, String receivableIdStr) throws BOSException, EASBizException {
        ArrayList<ReceivableBillEntryVO> entrylist = new ArrayList<ReceivableBillEntryVO>();
        try {
            if (!EmptyUtil.isEmpty((String)receivableIdStr)) {
                String[] receivableIdArr = receivableIdStr.split(";");
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set(receivableIdArr), CompareType.INCLUDE));
                evi.setFilter(filter);
                ReceivableBillCollection collection = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillCollection(evi);
                String billType = "";
                billType = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"40_common", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"40_common");
                for (int i = 0; i < collection.size(); ++i) {
                    ReceivableBillInfo receivableinfo = collection.get(i);
                    String sSQL = "Select * From T_FM_ReceivableBillEntry Where FReceivableBillID = '" + receivableinfo.getId().toString() + "'";
                    ISQLExecutor exec = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sSQL) : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sSQL);
                    IRowSet rs = exec.executeSQL();
                    if (!rs.next() && (!EmptyUtil.isEmpty((CoreBaseInfo)receivableinfo.getCashier()) || !EmptyUtil.isEmpty((Object)receivableinfo.getLockAmt()) && receivableinfo.getLockAmt().compareTo(BigDecimal.ZERO) > 0 || !EmptyUtil.isEmpty((Object)receivableinfo.getAvailableAmt()) && receivableinfo.getAvailableAmt().compareTo(BigDecimal.ZERO) == 0)) {
                        throw new FMException(FMException.RECEIVABLEBILL_NOT);
                    }
                    ReceivableBillEntryVO entryVO = new ReceivableBillEntryVO();
                    entryVO.setBillType(billType);
                    entryVO.setReceivableBillID(receivableinfo.getId().toString());
                    entryVO.setReceivableBillNum(receivableinfo.getDraftNumber());
                    entryVO.setEndorseAmt(receivableinfo.getBillAmt());
                    entryVO.setSeq(i + 1);
                    if (receivableinfo.getElecBillStatus() != null) {
                        entryVO.setElecBillStatus(receivableinfo.getElecBillStatus().getValue());
                    }
                    entrylist.add(entryVO);
                }
            }
            return entrylist;
        }
        catch (FMException e) {
            logger.error((Object)"\u7ec4\u88c5\u4e1a\u52a1\u5355\u636e\u4e0e\u7968\u636e\u5173\u8054\u5173\u7cfb\u5206\u5f55\u5f02\u5e38\uff0c\u8d44\u91d1\u5f02\u5e38\uff1a", (Throwable)((Object)e));
            throw new FMException(FMException.RECEIVABLEBILL_NOT);
        }
        catch (Exception e) {
            logger.error((Object)"\u7ec4\u88c5\u4e1a\u52a1\u5355\u636e\u4e0e\u7968\u636e\u5173\u8054\u5173\u7cfb\u5206\u5f55\u5f02\u5e38", (Throwable)e);
            String msg = "";
            msg = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"36_common", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"36_common");
            throw new FMException(FMException.COMMMONEXCEPTION, new String[]{msg});
        }
    }

    public static void verifySettlementNum(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        SettlementTypeInfo settType = info.getSettlementType();
        if (settType != null && settType.getNtType() != null && (NTTypeGroupEnum.RECEIVABLE.equals((Object)settType.getNtType().getSuperGroup()) || NTTypeGroupEnum.RECEIVABLE_BankAccept.equals((Object)settType.getNtType().getGroup()) || NTTypeGroupEnum.RECEIVABLE_CommerceAccept.equals((Object)settType.getNtType().getGroup())) && !EmptyUtil.isEmpty((String)info.getSettlementNumber()) && !info.isIsCBPay()) {
            IContextHelper iContextHelper;
            IReceivableBill iReceivableBill;
            String txtSettleNum = info.getSettlementNumber();
            List<ReceivableBillEntryVO> entryList = BizRelateReceivableBillUtil.getReceivableEntryList(ctx, (CoreBaseInfo)info);
            Map<String, Integer> result = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> amtResult = new HashMap<String, BigDecimal>();
            BigDecimal receivableBillAmt = Constants.ZERO;
            int billSize = 0;
            if (ctx == null) {
                iReceivableBill = ReceivableBillFactory.getRemoteInstance();
                iContextHelper = ContextHelperFactory.getRemoteInstance();
            } else {
                iReceivableBill = ReceivableBillFactory.getLocalInstance((Context)ctx);
                iContextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
            }
            if (entryList.size() > 0 && entryList.get(0).getReceivableBillID() != null) {
                HashSet<String> idSet = new HashSet<String>();
                BigDecimal amt = Constants.ZERO;
                for (int i = 0; i < entryList.size(); ++i) {
                    idSet.add(entryList.get(i).getReceivableBillID().toString());
                    amtResult.put(entryList.get(i).getReceivableBillID().toString(), entryList.get(i).getEndorseAmt());
                    amt = amt.add(entryList.get(i).getEndorseAmt());
                }
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                evi.setFilter(filter);
                ReceivableBillCollection collection = iReceivableBill.getReceivableBillCollection(evi);
                int billSizeNew = collection.size();
                for (int i = 0; collection != null && i < collection.size(); ++i) {
                    ReceivableBillInfo receivableBillInfo = collection.get(i);
                }
                result.put("amt", (Integer)((Object)amt));
                result.put("billSize", billSizeNew);
            } else {
                String[] settleNumAry = info.getSettlementNumber().trim().split(";");
                boolean receivableNeedAudit = iContextHelper.getBooleanParam("NT011", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
                FilterInfo filter = BizRelateReceivableBillUtil.getFilterInfo(FMHelper.Array2Set(settleNumAry), info.getCurrency(), info.getCompany().getId().toString(), receivableNeedAudit);
                boolean exists = iReceivableBill.exists(filter);
                if (exists) {
                    String msg = "";
                    msg = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"37_common", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"37_common");
                    throw new FMException(FMException.COMMMONEXCEPTION, new String[]{msg});
                }
                if (settleNumAry.length != info.getSettlementNums().size()) {
                    String msg = "";
                    msg = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"38_common", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"38_common");
                    throw new FMException(FMException.COMMMONEXCEPTION, new String[]{msg});
                }
                result = BizRelateReceivableBillUtil.getSettleNumInfo(ctx, info.getSettlementNums(), info.getCurrency(), info.getCompany().getId().toString(), receivableNeedAudit);
            }
            receivableBillAmt = (BigDecimal)result.get("amt");
            billSize = (Integer)result.get("billSize");
            if (billSize != 0 && !EmptyUtil.isEmpty((String)txtSettleNum) && info.getActPayAmt().compareTo(receivableBillAmt) != 0) {
                String msg = "";
                msg = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"39_common", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(receivableBillAmt)}) : EASResource.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"39_common", (Object[])new String[]{String.valueOf(receivableBillAmt)});
                throw new FMException(FMException.COMMMONEXCEPTION, new String[]{msg});
            }
        }
    }

    public static Map getSettleNumInfo(Context ctx, Set draftNumber, CurrencyInfo currency, String currentCompanyId, boolean receivableNeedAudit) {
        HashMap<String, Number> result = new HashMap<String, Number>();
        BigDecimal amt = Constants.ZERO;
        int billSize = 0;
        if (EmptyUtil.isEmpty((Collection)draftNumber)) {
            result.put("amt", amt);
            result.put("billSize", billSize);
            return result;
        }
        FilterInfo filter = BizRelateReceivableBillUtil.getFilterInfo(draftNumber, currency, currentCompanyId, receivableNeedAudit);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        ReceivableBillCollection receivableBillCollection = new ReceivableBillCollection();
        try {
            IReceivableBill iReceivableBill = ctx == null ? ReceivableBillFactory.getRemoteInstance() : ReceivableBillFactory.getLocalInstance((Context)ctx);
            receivableBillCollection = iReceivableBill.getReceivableBillCollection(evi);
            billSize = receivableBillCollection.size();
            for (int i = 0; receivableBillCollection != null && i < receivableBillCollection.size(); ++i) {
                ReceivableBillInfo receivableBill = receivableBillCollection.get(i);
                amt = amt.add(receivableBill.getBillAmt());
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        result.put("amt", amt);
        result.put("billSize", billSize);
        return result;
    }

    private static FilterInfo getFilterInfo(Set draftNumber, CurrencyInfo currency, String currentCompanyId, boolean receivableNeedAudit) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompanyId));
        if (receivableNeedAudit) {
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)"8"));
        } else {
            HashSet<Integer> statusSet = new HashSet<Integer>();
            statusSet.add(1);
            statusSet.add(8);
            filter.getFilterItems().add(new FilterItemInfo("billState", statusSet, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("isPledge", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isPledge", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isDisPledge", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isTrustee", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isPoolPledge", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isPoolTrustee", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("draftnumber", (Object)draftNumber, CompareType.INCLUDE));
        filter.setMaskString("#0 AND #1 AND (#2 OR (#3 AND #4)) AND #5 AND #6 AND #7 AND #8");
        if (currency != null) {
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency.getId().toString()));
            filter.setMaskString("#0 AND #1 AND (#2 OR (#3 AND #4)) AND #5 AND #6 AND #7 AND #8 AND #9");
        }
        return filter;
    }

    public static void setSettleNumLength(Context ctx, PaymentBillInfo info) {
        String settNum;
        if (info == null) {
            return;
        }
        SettlementTypeInfo settType = info.getSettlementType();
        if (settType != null && settType.getNtType() != null && (NTTypeGroupEnum.RECEIVABLE.equals((Object)settType.getNtType().getSuperGroup()) || NTTypeGroupEnum.RECEIVABLE_BankAccept.equals((Object)settType.getNtType().getGroup()) || NTTypeGroupEnum.RECEIVABLE_CommerceAccept.equals((Object)settType.getNtType().getGroup())) && !EmptyUtil.isEmpty((String)info.getSettlementNumber()) && !info.isIsCBPay() && (settNum = info.getSettlementNumber()).length() > 800) {
            info.setSettlementNumber(settNum.substring(0, 800));
        }
    }
}

