/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.util.app.DbUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;

public class DWETLUtil {
    public static DWETLUtil getInstance() throws BOSException {
        return new DWETLUtil();
    }

    public DataItem etl(Context ctx, String file, String dwTable, Class loaderClass) throws BOSException {
        String policy;
        DataItem item = (DataItem)this.parseXml(file, loaderClass).get(dwTable);
        if (item != null && (policy = item.getPolicy()).equalsIgnoreCase("overwrite")) {
            this.overWriteETL(ctx, item);
        }
        return item;
    }

    private void overWriteETL(Context ctx, DataItem item) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" TRUNCATE TABLE ").append(item.getDwTable());
        DbUtil.execute((Context)ctx, (String)sb.toString());
        DbUtil.execute((Context)ctx, (String)item.getSql());
    }

    private Map parseXml(String file, Class loaderClass) throws BOSException {
        Element root;
        String clPath = loaderClass.getName();
        String shortName = clPath.substring(clPath.lastIndexOf(46) + 1);
        String interfaceName = 'I' + shortName.substring(0, shortName.length() - "ControllerBean".length());
        String interfacePath = clPath.substring(0, clPath.length() - shortName.length() - "app.".length()) + interfaceName;
        try {
            root = XMLParser.parseXML((InputStream)Class.forName(interfacePath).getResourceAsStream("config/" + file)).getRootElement();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        List childrens = root.getChildren();
        HashMap<String, DataItem> itemMap = new HashMap<String, DataItem>();
        int size = childrens.size();
        for (int i = 0; i < size; ++i) {
            Element element = (Element)childrens.get(i);
            DataItem item = new DataItem();
            item.setType(element.getAttributeValue("type"));
            item.setDwTable(element.getAttributeValue("dwtable"));
            item.setPolicy(element.getAttributeValue("policy"));
            List sqlList = element.getChildren();
            Element elementSql = (Element)sqlList.get(0);
            item.setSql(elementSql.getText());
            if (sqlList.size() > 1) {
                Element elementParams = (Element)sqlList.get(1);
                List paramsList = elementParams.getChildren();
                ArrayList<String> params = new ArrayList<String>();
                int subsize = paramsList.size();
                for (int j = 0; j < subsize; ++j) {
                    Element elementParam = (Element)paramsList.get(j);
                    if (elementParam.getAttribute("system") != null) {
                        params.add(elementParam.getText() + ":" + elementParam.getAttributeValue("system"));
                        continue;
                    }
                    params.add(((Element)paramsList.get(j)).getText());
                }
                item.setParameters(params);
            }
            itemMap.put(item.getDwTable(), item);
        }
        return itemMap;
    }

    static class DataItem {
        private String type;
        private String dwTable;
        private String policy;
        private String sql;
        private String system;
        private List parameters;

        DataItem() {
        }

        public String getDwTable() {
            return this.dwTable;
        }

        public void setDwTable(String dwTable) {
            this.dwTable = dwTable;
        }

        public String getPolicy() {
            return this.policy;
        }

        public void setPolicy(String policy) {
            this.policy = policy;
        }

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public List getParameters() {
            return this.parameters;
        }

        public void setParameters(List parameters) {
            this.parameters = parameters;
        }

        public String getSystem() {
            return this.system;
        }

        public void setSystem(String system) {
            this.system = system;
        }
    }
}

