/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.eas.base.core.Constants;
import java.math.BigDecimal;

public class FMBillBigDecimalUtil {
    public static final BigDecimal MIN_VALUE = new BigDecimal("0");
    public static final BigDecimal MAX_VALUE = new BigDecimal("9999999999999");
    public static final BigDecimal _MAX_VALUE = new BigDecimal("-9999999999999");

    public static boolean gt(Object number1, Object number2) {
        if (!FMBillBigDecimalUtil.compareBeforeCheck(number1, number2)) {
            return false;
        }
        BigDecimal one = (BigDecimal)number1;
        BigDecimal two = (BigDecimal)number2;
        return one.compareTo(two) > 0;
    }

    public static boolean lt(Object number1, Object number2) {
        if (!FMBillBigDecimalUtil.compareBeforeCheck(number1, number2)) {
            return false;
        }
        BigDecimal one = (BigDecimal)number1;
        BigDecimal two = (BigDecimal)number2;
        return one.compareTo(two) < 0;
    }

    public static boolean ge(Object number1, Object number2) {
        return !FMBillBigDecimalUtil.lt(number1, number2);
    }

    public static boolean le(Object number1, Object number2) {
        return !FMBillBigDecimalUtil.gt(number1, number2);
    }

    public static boolean eq(Object number1, Object number2) {
        if (!FMBillBigDecimalUtil.compareBeforeCheck(number1, number2)) {
            return false;
        }
        BigDecimal one = (BigDecimal)number1;
        BigDecimal two = (BigDecimal)number2;
        return one.compareTo(two) == 0;
    }

    public static boolean ne(Object number1, Object number2) {
        return !FMBillBigDecimalUtil.eq(number1, number2);
    }

    private static boolean compareBeforeCheck(Object number1, Object number2) {
        if (number1 == null || number2 == null) {
            return false;
        }
        if (!(number1 instanceof BigDecimal)) {
            return false;
        }
        return number2 instanceof BigDecimal;
    }

    public static boolean isEqZero(Object number) {
        BigDecimal number2 = Constants.ZERO;
        return FMBillBigDecimalUtil.eq(number, number2);
    }

    public static boolean isGtZero(Object number) {
        BigDecimal number2 = Constants.ZERO;
        return FMBillBigDecimalUtil.gt(number, number2);
    }

    public static boolean isGeZero(Object number) {
        BigDecimal number2 = Constants.ZERO;
        return FMBillBigDecimalUtil.ge(number, number2);
    }

    public static boolean isLtZero(Object number) {
        BigDecimal number2 = Constants.ZERO;
        return FMBillBigDecimalUtil.lt(number, number2);
    }

    public static boolean isLeZero(Object number) {
        BigDecimal number2 = Constants.ZERO;
        return FMBillBigDecimalUtil.le(number, number2);
    }

    public static boolean isEqualsOneHundred(Object number) {
        BigDecimal number2 = Constants.ONE_HUNDRED;
        return FMBillBigDecimalUtil.eq(number, number2);
    }

    public static BigDecimal add(BigDecimal a, BigDecimal b) {
        if (a == null) {
            a = Constants.ZERO;
        }
        if (b == null) {
            b = Constants.ZERO;
        }
        return a.add(b);
    }

    public static BigDecimal subtract(BigDecimal a, BigDecimal b) {
        if (a == null) {
            a = Constants.ZERO;
        }
        if (b == null) {
            b = Constants.ZERO;
        }
        return a.subtract(b);
    }

    public static BigDecimal multiply(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return Constants.ZERO;
        }
        return a.multiply(b);
    }

    public static BigDecimal divide(BigDecimal a, BigDecimal b, int scale) {
        if (a == null) {
            a = Constants.ZERO;
        }
        if (b == null) {
            b = Constants.ZERO;
        }
        return a.divide(b, scale, 4);
    }
}

