/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.ColumnItemData;
import com.kingdee.eas.fm.common.util.CellData;
import com.kingdee.eas.fm.common.util.ExtendPro;
import com.kingdee.eas.fm.common.util.SingleRow;
import com.kingdee.eas.fm.common.util.TableSnapShot;
import com.kingdee.eas.fm.common.util.UserDefineColumnCollection;
import com.kingdee.eas.fm.common.util.UserDefineColumnInfo;
import com.kingdee.eas.util.client.EASResource;
import java.util.List;
import org.apache.log4j.Logger;

public class KDTableSnapShot
implements TableSnapShot {
    private static Logger logger = CoreUIObject.getLogger(KDTableSnapShot.class);
    private String[] headTitles;
    private String[] titleKeys;
    private String[] mappingFieldName;
    private SingleRow[] rowList;
    private KDTable tblMain;
    private UserDefineColumnCollection udcc;

    public KDTableSnapShot(KDTable tblMain, UserDefineColumnCollection udcc) {
        this.tblMain = tblMain;
        this.udcc = udcc == null ? new UserDefineColumnCollection() : udcc;
    }

    public void init() {
        int rowCount = this.tblMain.getRowCount();
        this.rowList = new SingleRow[rowCount];
        KDTColumns kdCols = this.tblMain.getColumns();
        List columns = kdCols.getColumns();
        int colunmCount = columns.size();
        int userDefineColumnCount = this.udcc.size();
        int columnCountTotal = colunmCount + userDefineColumnCount;
        this.titleKeys = new String[columnCountTotal];
        this.headTitles = new String[columnCountTotal];
        this.mappingFieldName = new String[columnCountTotal];
        this.assembleTableColumn(columns, colunmCount, columnCountTotal);
        this.assembleUserDefineColumn(colunmCount, userDefineColumnCount);
        for (int i = 0; i < rowCount; ++i) {
            CellData[] cells = new CellData[columnCountTotal];
            IRow rowData = this.tblMain.getRow(i);
            this.assembleTableColumnValue(colunmCount, cells, columnCountTotal, rowData);
            this.assembleUserDefineColumnValue(colunmCount, userDefineColumnCount, cells);
            this.rowList[i] = new SingleRow(cells);
        }
    }

    public void initSelected() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int selectRowIndex = selectRows.length;
        this.rowList = new SingleRow[selectRowIndex];
        logger.info((Object)selectRows);
        KDTColumns kdCols = this.tblMain.getColumns();
        List columns = kdCols.getColumns();
        int colunmCount = columns.size();
        int userDefineColumnCount = this.udcc.size();
        int columnCountTotal = colunmCount + userDefineColumnCount;
        this.titleKeys = new String[columnCountTotal];
        this.headTitles = new String[columnCountTotal];
        this.mappingFieldName = new String[columnCountTotal];
        this.assembleTableColumn(columns, colunmCount, columnCountTotal);
        this.assembleUserDefineColumn(colunmCount, userDefineColumnCount);
        for (int i = 0; i < selectRowIndex; ++i) {
            CellData[] cells = new CellData[columnCountTotal];
            IRow rowData = this.tblMain.getRow(selectRows[i]);
            this.assembleTableColumnValue(colunmCount, cells, columnCountTotal, rowData);
            this.assembleUserDefineColumnValue(colunmCount, userDefineColumnCount, cells);
            this.rowList[i] = new SingleRow(cells);
        }
    }

    private void assembleUserDefineColumn(int colunmCount, int userDefineColumnCount) {
        for (int j = 0; j < userDefineColumnCount; ++j) {
            UserDefineColumnInfo uudi = this.udcc.getIndex(j);
            this.titleKeys[j + colunmCount] = uudi.getName();
            this.headTitles[j + colunmCount] = uudi.getAlias();
        }
    }

    private void assembleTableColumn(List columns, int colunmCount, int columnCountTotal) {
        boolean[] columnsVision = new boolean[columnCountTotal];
        for (int i = 0; i < colunmCount; ++i) {
            KDTColumn columnS = (KDTColumn)columns.get(i);
            if (columnS.getUserObject() != null) {
                Object obj = columnS.getUserObject();
                if (obj instanceof com.kingdee.eas.framework.config.ColumnItemData) {
                    this.headTitles[i] = ((com.kingdee.eas.framework.config.ColumnItemData)obj).getTitle();
                    columnsVision[i] = !((com.kingdee.eas.framework.config.ColumnItemData)obj).isHidden();
                } else {
                    this.headTitles[i] = ((ColumnItemData)obj).getTitle();
                    columnsVision[i] = !((ColumnItemData)obj).isHidden();
                }
            } else {
                this.headTitles[i] = columnS.getKey();
                columnsVision[i] = true;
            }
            this.titleKeys[i] = columnS.getKey();
            if (this.mappingFieldName[i] != null) continue;
            this.mappingFieldName[i] = this.titleKeys[i];
        }
    }

    private void assembleUserDefineColumnValue(int filledColumnCount, int userDefineColumnCount, CellData[] cells) {
        for (int n = 0; n < userDefineColumnCount; ++n) {
            CellData cd;
            UserDefineColumnInfo uudi = this.udcc.getIndex(n);
            cells[n + filledColumnCount] = cd = new CellData(uudi.getColumnValue(), String.class, null, uudi.getName(), uudi.getName());
        }
    }

    private void assembleTableColumnValue(int colunmCount, CellData[] cells, int columnCountTotal, IRow rowData) {
        Class cls = null;
        for (int m = 0; m < colunmCount; ++m) {
            Object cellValue = rowData.getCell(this.titleKeys[m]).getValue();
            if (cellValue != null && cellValue instanceof Boolean) {
                Boolean b = (Boolean)cellValue;
                cellValue = b != false ? EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"112_KDTableSnapShot") : EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"113_KDTableSnapShot");
            }
            CellData cd = new CellData(cellValue, cls, null, this.titleKeys[m], this.mappingFieldName[m] == null ? this.titleKeys[m] : this.mappingFieldName[m]);
            String format = this.tblMain.getColumn(this.titleKeys[m]).getStyleAttributes().getNumberFormat();
            ExtendPro expro = new ExtendPro(false, format, 8);
            cd.setExpro(expro);
            cells[m] = cd;
        }
    }

    @Override
    public String[] getHeadTitles() {
        return this.headTitles;
    }

    public void setHeadTitles(String[] headTitles) {
        this.headTitles = headTitles;
    }

    @Override
    public SingleRow[] getRowList() {
        return this.rowList;
    }

    public void setRowList(SingleRow[] rowList) {
        this.rowList = rowList;
    }

    @Override
    public String[] getTitleKeys() {
        return this.titleKeys;
    }

    public void setTitleKeys(String[] titleKeys) {
        this.titleKeys = titleKeys;
    }

    public String[] getMappingFieldName() {
        return this.titleKeys;
    }

    public void setMappingFieldName(String[] mappingFieldName) {
        this.mappingFieldName = mappingFieldName;
    }
}

