/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ctl.AssureBillCollection;
import com.kingdee.eas.fm.ctl.AssureBillException;
import com.kingdee.eas.fm.ctl.AssureBillFactory;
import com.kingdee.eas.fm.ctl.AssureBillHelper;
import com.kingdee.eas.fm.ctl.AssureBillInfo;
import com.kingdee.eas.fm.ctl.AssureBillStateEnum;
import com.kingdee.eas.fm.ctl.app.AbstractAssureBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class AssureBillControllerBean
extends AbstractAssureBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ctl.app.AssureBillControllerBean");

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, pk, model);
        this.processInfo(model);
        super._update(ctx, pk, model);
    }

    protected FilterInfo getFilterForCheckNumber(CoreBillBaseInfo model) {
        FilterInfo filter = new FilterInfo();
        AssureBillInfo info = (AssureBillInfo)model;
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
        return filter;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AssureBillInfo info = (AssureBillInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        if (info.getAssureCloseDate() == null) {
            Calendar calendar = Calendar.getInstance();
            if (info.getEndDate() != null) {
                calendar.setTime(info.getEndDate());
                calendar.set(5, calendar.get(5) + 1);
                info.setAssureCloseDate(calendar.getTime());
            } else {
                info.setAssureCloseDate(null);
            }
        }
        this._checkNumberDup(ctx, (IObjectValue)info);
        BigDecimal assLocalLimitAmut = info.getAssureLimitAmt().multiply(info.getExRate());
        if (Constants.MAX_VALUE.compareTo(assLocalLimitAmut) <= 0) {
            throw new FMException(FMException.VALUEOVERFLOW, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"0_AssureBillControllerBean", (Locale)ctx.getLocale())});
        }
        info.setAsLocalLimitAmt(assLocalLimitAmut);
        return super._addnew(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, null, model);
        this.processInfo(model);
        return super._submit(ctx, model);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, pk, model);
        this.processInfo(model);
        super._submit(ctx, pk, model);
    }

    @Override
    protected void _cancel(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("canceled");
        AssureBillInfo assInfo = AssureBillFactory.getLocalInstance(ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(id));
        if (assInfo.isCanceled()) {
            throw new AssureBillException(AssureBillException.ALREADYCANCEL);
        }
        UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        String cancelUser = currentUser == null ? "" : currentUser.getName();
        Timestamp currentDate = new Timestamp(System.currentTimeMillis());
        DbUtil.execute((Context)ctx, (String)"update T_CTL_AssureBill set FIsCanceled=1,FCancelor=?,FCancelDate=? where FId=?", (Object[])new Object[]{cancelUser, currentDate, id});
    }

    @Override
    protected void _unCancel(Context ctx, String id) throws BOSException, EASBizException {
        AssureBillInfo assInfo = AssureBillFactory.getLocalInstance(ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(id));
        if (!assInfo.isCanceled()) {
            throw new AssureBillException(AssureBillException.ALREADYCANCEL);
        }
        DbUtil.execute((Context)ctx, (String)"update T_CTL_AssureBill set FIsCanceled=0,FCancelor=null,FCancelDate=null where FId=?", (Object[])new Object[]{id});
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AssureBillInfo lgBillInfo = this.getAssureBillInfo(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)lgBillInfo, (String)lgBillInfo.getCompany().getId().toString());
        super._delete(ctx, pk);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AssureBillInfo info = this.getAssureBillInfo(ctx, pk);
        if (AssureBillHelper.isCanAudit(info)) {
            this.doAudit(ctx, info);
        }
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AssureBillInfo info = this.getAssureBillInfo(ctx, pk);
        if (AssureBillHelper.isCanAntiAudit(info)) {
            this.doAnitAudit(ctx, info);
        }
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AssureBillInfo info = this.getAssureBillInfo(ctx, pk);
        this.doAudit(ctx, info);
    }

    @Override
    protected void _antiAudit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AssureBillInfo info = this.getAssureBillInfo(ctx, pk);
        this.doAnitAudit(ctx, info);
    }

    @Override
    protected void _batchSubmit(Context ctx, Set idSet) throws BOSException, EASBizException {
        AssureBillInfo info;
        int i;
        if (idSet == null || idSet.size() <= 0) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        AssureBillCollection coll = this.getAssureBillCollection(ctx, evi);
        int size = coll.size();
        for (i = 0; i < size; ++i) {
            info = coll.get(i);
            if (AssureBillStateEnum.SAVE.equals((Object)info.getState())) continue;
            throw new AssureBillException(AssureBillException.CAN_NOT_SUBMIT);
        }
        for (i = 0; i < size; ++i) {
            info = coll.get(i);
            info.setState(AssureBillStateEnum.SUBMIT);
            this.submit(ctx, (CoreBaseInfo)info);
        }
    }

    protected void updateInnerCompanyId(Context ctx, AssureBillInfo assBillInfo) throws EASBizException, BOSException {
        String companyName = assBillInfo.getAssuredCompany();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)companyName));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(evi);
        if (coll.size() == 1) {
            assBillInfo.setAssuredComInnerId(coll.get(0).getId().toString());
        } else if (coll.size() <= 0) {
            assBillInfo.setAssuredComInnerId(null);
        } else {
            throw new AssertionError((Object)"more than one!");
        }
    }

    private void processInfo(IObjectValue model) {
        AssureBillInfo info = (AssureBillInfo)model;
        if (info.getContactAmount() == null) {
            info.setContactAmount(Constants.ZERO);
        }
        if (info.getContactLocalAmt() == null) {
            info.setContactLocalAmt(Constants.ZERO);
        }
        if (info.getAssureLimitAmt() == null) {
            info.setAssureLimitAmt(Constants.ZERO);
        }
        if (info.getAsLocalLimitAmt() == null) {
            info.setAsLocalLimitAmt(Constants.ZERO);
        }
        if (info.getBizLocalBalance() == null) {
            info.setBizLocalBalance(Constants.ZERO);
        }
        if (info.getAssureResAmount() == null) {
            info.setAssureResAmount(Constants.ZERO);
        }
        if (info.getAntiAssAmount() == null) {
            info.setAntiAssAmount(Constants.ZERO);
        }
        if (info.getAntiAssValue() == null) {
            info.setAntiAssValue(Constants.ZERO);
        }
        if (info.getAssureCfgFee() == null) {
            info.setAssureCfgFee(Constants.ZERO);
        }
        if (info.getAssureFee() == null) {
            info.setAssureFee(Constants.ZERO);
        }
        Calendar calendar = Calendar.getInstance();
        if (info.getEndDate() != null) {
            calendar.setTime(info.getEndDate());
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String ctime = formatter.format(new Date());
        if (info.getAssureCloseDate() == null) {
            calendar.set(5, calendar.get(5));
        } else if (info.getDeferDay() != 0) {
            calendar.set(5, calendar.get(5) + info.getDeferDay());
        }
        if (calendar.getTime() != null) {
            info.setAssureCloseDate(calendar.getTime());
        }
        try {
            if (calendar != null && formatter.parse(ctime).getTime() > calendar.getTimeInMillis()) {
                info.setCanceled(true);
            }
        }
        catch (ParseException e) {
            logger.error((Object)"", (Throwable)e);
        }
        if (info.getEndDate() == null) {
            info.setAssureCloseDate(null);
        }
    }

    private void doAudit(Context ctx, AssureBillInfo info) throws BOSException {
        String sql = "update T_CTL_AssureBill set FState = 2 where FID = '" + info.getId().toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql.toString());
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"1_AssureBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"2_AssureBillControllerBean", (Locale)ctx.getLocale())));
    }

    private void doAnitAudit(Context ctx, AssureBillInfo info) throws BOSException {
        String sql = "update T_CTL_AssureBill set FState = 1 where FID = '" + info.getId().toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql.toString());
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"1_AssureBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"3_AssureBillControllerBean", (Locale)ctx.getLocale())));
    }

    @Override
    protected void _upIsClosed(Context ctx, List listID) throws BOSException {
        String sql = "update T_CTL_AssureBill set FIsCanceled = 1 where FID in (''";
        for (int i = 0; i < listID.size(); ++i) {
            sql = sql + ",'" + listID.get(i) + "'";
        }
        sql = sql + ")";
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _upAssureEndTime(Context ctx, List listID) throws BOSException, EASBizException {
        String sql = "update T_CTL_AssureBill set FAssureCloseDate = null where FID in (''";
        for (int i = 0; i < listID.size(); ++i) {
            sql = sql + ",'" + listID.get(i) + "'";
        }
        sql = sql + ")";
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

