/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.ctl.BankFactorCollection;
import com.kingdee.eas.fm.ctl.BankFactorException;
import com.kingdee.eas.fm.ctl.BankFactorFactory;
import com.kingdee.eas.fm.ctl.BankFactorHelper;
import com.kingdee.eas.fm.ctl.BankFactorInfo;
import com.kingdee.eas.fm.ctl.FactorStateEnum;
import com.kingdee.eas.fm.ctl.app.AbstractBankFactorControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankFactorControllerBean
extends AbstractBankFactorControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ctl.app.BankFactorControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BankFactorInfo info = (BankFactorInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getFICompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"bank");
        if (model.get("number") != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", model.get("number")));
            if (this._exists(ctx, filter)) {
                throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.get("number"), ""});
            }
        }
        model.setBoolean("isCancel", false);
        model.setBoolean("isRetrade", false);
        model.setBoolean("isMortgage", false);
        model.setBoolean("Fivouchered", false);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    @Override
    protected void _repeal(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankFactorInfo info = BankFactorFactory.getLocalInstance(ctx).getBankFactorInfo(pk);
        if (!BankFactorHelper.isCanRepeal(info)) {
            throw new BankFactorException(BankFactorException.CAN_NOT_REPEAL);
        }
        String sql = "update T_CTL_BankFactor set FIsCancel = 1 where FID = '" + info.getId().toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"1_AssureBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"5_BankFactorControllerBean", (Locale)ctx.getLocale())));
    }

    @Override
    protected void _cancelRepeal(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankFactorInfo info = BankFactorFactory.getLocalInstance(ctx).getBankFactorInfo(pk);
        if (!BankFactorHelper.isCanCancelRepeal(info)) {
            throw new BankFactorException(BankFactorException.CAN_NOT_CANCEL_REPEAL);
        }
        String sql = "update T_CTL_BankFactor set FIsCancel = 0 where FID = '" + info.getId().toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"1_AssureBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"6_BankFactorControllerBean", (Locale)ctx.getLocale())));
    }

    @Override
    protected void _retrade(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankFactorInfo info = BankFactorFactory.getLocalInstance(ctx).getBankFactorInfo(pk);
        if (!BankFactorHelper.isCanRetrade(info)) {
            throw new BankFactorException(BankFactorException.CAN_NOT_RETRADE);
        }
        String sql = "update T_CTL_BankFactor set FIsRetrade = 1 where FID = '" + info.getId().toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"1_AssureBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"7_BankFactorControllerBean", (Locale)ctx.getLocale())));
    }

    @Override
    protected void _cancelRetrade(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankFactorInfo info = BankFactorFactory.getLocalInstance(ctx).getBankFactorInfo(pk);
        if (!BankFactorHelper.isCanCancelRetrade(info)) {
            throw new BankFactorException(BankFactorException.CAN_NOT_CANCEL_RETRADE);
        }
        String sql = "update T_CTL_BankFactor set FIsRetrade = 0 where FID = '" + info.getId().toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"1_AssureBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"8_BankFactorControllerBean", (Locale)ctx.getLocale())));
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankFactorInfo info = BankFactorFactory.getLocalInstance(ctx).getBankFactorInfo(pk);
        if (!BankFactorHelper.isCanAudit(info)) {
            throw new BankFactorException(BankFactorException.CAN_NOT_AUDIT);
        }
        this.doAudit(ctx, info);
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankFactorInfo info = BankFactorFactory.getLocalInstance(ctx).getBankFactorInfo(pk);
        this.doAudit(ctx, info);
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankFactorInfo info = BankFactorFactory.getLocalInstance(ctx).getBankFactorInfo(pk);
        if (!BankFactorHelper.isCanAntiAudit(info)) {
            throw new BankFactorException(BankFactorException.CAN_NOT_ANTIAUDIT);
        }
        this.doAntiAudit(ctx, info);
    }

    @Override
    protected void _anitAudit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankFactorInfo info = BankFactorFactory.getLocalInstance(ctx).getBankFactorInfo(pk);
        this.doAntiAudit(ctx, info);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum billOperStateEnum, IObjectValue relationInfo) throws BOSException, EASBizException {
        super._reverseSave(ctx, srcBillPK, srcBillVO, billOperStateEnum, relationInfo);
        BOTRelationInfo relation = (BOTRelationInfo)relationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            if (billOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                String sql = "update T_CTL_BankFactor set FFivouchered = 0 where FID = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{srcBillPK.toString()});
            } else {
                String sql = "update T_CTL_BankFactor set FFivouchered = 1 where FID = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{srcBillPK.toString()});
            }
        }
    }

    @Override
    protected void _batchSubmit(Context ctx, Set idSet) throws BOSException, EASBizException {
        BankFactorInfo info;
        int i;
        if (idSet == null || idSet.size() <= 0) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        BankFactorCollection coll = this.getBankFactorCollection(ctx, evi);
        int size = coll.size();
        for (i = 0; i < size; ++i) {
            info = coll.get(i);
            if (FactorStateEnum.SAVE.equals((Object)info.getState())) continue;
            throw new BankFactorException(BankFactorException.CAN_NOT_SUBMIT);
        }
        for (i = 0; i < size; ++i) {
            info = coll.get(i);
            info.setState(FactorStateEnum.SUBMIT);
            this.submit(ctx, (CoreBaseInfo)info);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankFactorInfo info = this.getBankFactorInfo(ctx, pk);
        if (!BankFactorHelper.isCanRemove(info)) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"9_BankFactorControllerBean", (Locale)ctx.getLocale())});
        }
        super._delete(ctx, pk);
    }

    private void doAudit(Context ctx, BankFactorInfo info) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_CTL_BankFactor set FState = ");
        sql.append(2);
        sql.append(" where FID = '");
        sql.append(info.getId().toString() + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"1_AssureBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"10_BankFactorControllerBean", (Locale)ctx.getLocale())));
    }

    private void doAntiAudit(Context ctx, BankFactorInfo info) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_CTL_BankFactor set FState = ");
        sql.append(0);
        sql.append(" where FID = '");
        sql.append(info.getId().toString() + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"1_AssureBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"11_BankFactorControllerBean", (Locale)ctx.getLocale())));
    }
}

