/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ebservice.PayBody;
import com.kingdee.bos.ebservice.PaymentDetail;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BillTypeEnum;
import com.kingdee.eas.fm.be.app.service.BankPayUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.app.FMDBHelper;
import com.kingdee.eas.fm.ctl.GuaranteeApplyCollection;
import com.kingdee.eas.fm.ctl.GuaranteeApplyInfo;
import com.kingdee.eas.fm.ctl.GuaranteeStateEnum;
import com.kingdee.eas.fm.ctl.OnlineApplyEnum;
import com.kingdee.eas.fm.ctl.app.AbstractGuaranteeApplyControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class GuaranteeApplyControllerBean
extends AbstractGuaranteeApplyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ctl.app.GuaranteeApplyControllerBean");

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        GuaranteeApplyInfo info = this.getGuaranteeApplyInfo(ctx, pk);
        if (!GuaranteeStateEnum.APPROVE.equals((Object)info.getState())) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"13_GuaranteeApplyControllerBean", (Locale)ctx.getLocale())));
        }
        this.doAntiAudit(ctx, info);
    }

    @Override
    protected void _antiAudit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        GuaranteeApplyInfo info = this.getGuaranteeApplyInfo(ctx, pk);
        if (GuaranteeStateEnum.APPROVE.equals((Object)info.getState())) {
            this.doAntiAudit(ctx, info);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        GuaranteeApplyInfo info = this.getGuaranteeApplyInfo(ctx, pk);
        if (!GuaranteeStateEnum.SUBMIT.equals((Object)info.getState())) {
            throw new EASBizException(new NumericExceptionSubItem("qq", ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"14_GuaranteeApplyControllerBean", (Locale)ctx.getLocale())));
        }
        this.doAudit(ctx, info);
    }

    private void doAudit(Context ctx, GuaranteeApplyInfo info) throws BOSException, EASBizException {
        info.setState(GuaranteeStateEnum.APPROVE);
        info.setApproval(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        info.setApprovalDate(new Date());
        this._submit(ctx, (IObjectValue)info);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"1_AssureBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"15_GuaranteeApplyControllerBean", (Locale)ctx.getLocale())));
    }

    private void doAntiAudit(Context ctx, GuaranteeApplyInfo info) throws BOSException, EASBizException {
        info.setState(GuaranteeStateEnum.SAVE);
        info.setApproval(null);
        info.setApprovalDate(null);
        this._submit(ctx, (IObjectValue)info);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"1_AssureBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"16_GuaranteeApplyControllerBean", (Locale)ctx.getLocale())));
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        GuaranteeApplyInfo info = this.getGuaranteeApplyInfo(ctx, pk);
        if (GuaranteeStateEnum.SUBMIT.equals((Object)info.getState())) {
            this.doAudit(ctx, info);
        }
    }

    @Override
    protected void _batchSubmit(Context ctx, Set idSet) throws BOSException, EASBizException {
        GuaranteeApplyInfo info;
        int i;
        if (idSet == null || idSet.size() <= 0) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        GuaranteeApplyCollection col = this.getGuaranteeApplyCollection(ctx, evi);
        int size = col.size();
        for (i = 0; i < size; ++i) {
            info = col.get(i);
            if (GuaranteeStateEnum.SAVE.equals((Object)info.getState())) continue;
            throw new EASBizException(new NumericExceptionSubItem("000", ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"17_GuaranteeApplyControllerBean", (Locale)ctx.getLocale())));
        }
        for (i = 0; i < size; ++i) {
            info = col.get(i);
            info.setState(GuaranteeStateEnum.SUBMIT);
            this.submit(ctx, (CoreBaseInfo)info);
        }
    }

    private EntityViewInfo viewGuaranteeApply(Set idSet) throws EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        return evi;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GuaranteeApplyInfo info = (GuaranteeApplyInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        this._checkNumberDup(ctx, (IObjectValue)info);
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        GuaranteeApplyInfo info = this.getGuaranteeApplyInfo(ctx, pk);
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("110", ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"18_GuaranteeApplyControllerBean", (Locale)ctx.getLocale())));
        }
        if (!FMHelper.isEmpty((String)info.getNumber())) {
            FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _commitToBE(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        GuaranteeApplyInfo info = this.getGuaranteeApplyInfo(ctx, pk);
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("110", ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"18_GuaranteeApplyControllerBean", (Locale)ctx.getLocale())));
        }
        if (info.getState() != GuaranteeStateEnum.APPROVE || info.getIsOnlineApply() != OnlineApplyEnum.NOTSUB && info.getIsOnlineApply() != OnlineApplyEnum.DEFSUB) {
            throw new EASBizException(new NumericExceptionSubItem("111", ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"19_GuaranteeApplyControllerBean", (Locale)ctx.getLocale())));
        }
        logger.debug((Object)"begin to submit GuaranteeApplyInfo");
        try {
            BankPayUtil bankPayUtil = new BankPayUtil();
            PayBody body = GuaranteeApplyControllerBean.parseGuaranteeApplyBody(ctx, info);
            BankBizInfo bizInfo = new BankBizInfo();
            bizInfo.setBankAcct("0000000000000000000");
            bizInfo.setBillType(BillTypeEnum.PAYMENT_BILL);
            bizInfo.setCurrency("CNY");
            PaymentDetail[] detail = bankPayUtil.pay(ctx, bizInfo, body);
            OnlineApplyEnum state = null;
            state = beServiceHelper.transferState((String)detail[0].getEbStatus()) != null ? OnlineApplyEnum.YESSUB : OnlineApplyEnum.NOTSUB;
            this.reverseBillState(ctx, state, info.getId().toString());
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
        }
    }

    private void reverseBillState(Context ctx, OnlineApplyEnum state, String id) throws BOSException, EASBizException {
        String sql = "Update T_CTL_GuaranteeApply set FIsOnlineApply =? where Fid=?";
        FMDBHelper.execute((Context)ctx, (String)sql, (Object[])new String[]{String.valueOf(state.getValue()), id});
    }

    public static PayBody parseGuaranteeApplyBody(Context ctx, GuaranteeApplyInfo info) throws BOSException, EASBizException, RemoteException, ServiceException {
        PayBody body = new PayBody();
        body.setBatchBizNo(String.valueOf(beServiceHelper.getSerialNumber((int)1)[0]));
        body.setTotalAmount(String.valueOf(info.getAmount()));
        body.setTotalCount("1");
        body.setVerifyField("pay");
        body.setDetails(GuaranteeApplyControllerBean.parseGuaranteeApplyDetail(ctx, info));
        return body;
    }

    public static PaymentDetail[] parseGuaranteeApplyDetail(Context ctx, GuaranteeApplyInfo info) {
        PaymentDetail[] details = new PaymentDetail[1];
        PaymentDetail detail = new PaymentDetail();
        detail.setDetailBizNo(beServiceHelper.getSerialNumber((int)1)[0]);
        detail.setPayeeAccName(info.getReceiver());
        detail.setPayeeBankName(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"28_GuaranteeApplyControllerBean", (Locale)ctx.getLocale()));
        detail.setPayeeAccNo("0000000000000000");
        detail.setPayeeBankName(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"28_GuaranteeApplyControllerBean", (Locale)ctx.getLocale()));
        detail.setPayeeCountry(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"24_GuaranteeApplyControllerBean", (Locale)ctx.getLocale()));
        if (info.getCountry() != null) {
            detail.setPayeeCountry(info.getCountry().getName());
        }
        detail.setPayeeProvince(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"25_GuaranteeApplyControllerBean", (Locale)ctx.getLocale()));
        detail.setPayeeCity(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"26_GuaranteeApplyControllerBean", (Locale)ctx.getLocale()));
        detail.setAmount(String.valueOf(info.getAmount()));
        detail.setUrgent("TRUE");
        detail.setUseCode("-1");
        detail.setForceManual("TRUE");
        detail.setUse("\u7f51\u4e0a\u62a5\u9500");
        detail.setDesc(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"23_GuaranteeApplyControllerBean", (Locale)ctx.getLocale()));
        detail.setVerifyField("pay");
        detail.setPayeeType("company");
        details[0] = detail;
        return details;
    }
}

