/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ctl.ReceiveLetterInfo;
import com.kingdee.eas.fm.ctl.ReceiveStateEnum;
import com.kingdee.eas.fm.ctl.app.AbstractReceiveLetterControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ReceiveLetterControllerBean
extends AbstractReceiveLetterControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ctl.app.ReceiveLetterControllerBean");

    @Override
    protected void _Cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.updateReceiveLetterDis(ctx, pk.toString(), true);
    }

    @Override
    protected void _AntiCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.updateReceiveLetterDis(ctx, pk.toString(), false);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ReceiveLetterInfo info = this.getReceiveLetterInfo(ctx, pk);
        if (!ReceiveStateEnum.SUBMIT.equals((Object)info.getState())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"33_ReceiveLetterControllerBean", (Locale)ctx.getLocale())));
        }
        this.doAudit(ctx, info);
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ReceiveLetterInfo info = this.getReceiveLetterInfo(ctx, pk);
        if (!ReceiveStateEnum.APPROVE.equals((Object)info.getState()) || info.getAmount().doubleValue() != info.getBalance().doubleValue()) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"34_ReceiveLetterControllerBean", (Locale)ctx.getLocale())));
        }
        this.doAntiAudit(ctx, info);
    }

    private void updateReceiveLetterDis(Context ctx, String finId, boolean isDis) throws BOSException, EASBizException {
        String ssql = "UPDATE T_ctl_ReceiveLetter SET FIsDis = ? WHERE FID = ?";
        if (isDis) {
            DbUtil.execute((Context)ctx, (String)ssql, (Object[])new Object[]{new Integer(1), finId});
        } else {
            DbUtil.execute((Context)ctx, (String)ssql, (Object[])new Object[]{new Integer(0), finId});
        }
    }

    private void doAudit(Context ctx, ReceiveLetterInfo info) throws BOSException, EASBizException {
        info.setState(ReceiveStateEnum.APPROVE);
        info.setApproval(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        info.setApprovalDate(new Date());
        this.submit(ctx, (CoreBaseInfo)info);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"1_AssureBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"35_ReceiveLetterControllerBean", (Locale)ctx.getLocale())));
    }

    private void doAntiAudit(Context ctx, ReceiveLetterInfo info) throws BOSException, EASBizException {
        info.setState(ReceiveStateEnum.SAVE);
        info.setApproval(null);
        info.setApprovalDate(null);
        this.submit(ctx, (CoreBaseInfo)info);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"1_AssureBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"36_ReceiveLetterControllerBean", (Locale)ctx.getLocale())));
    }
}

