/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ctl.IReceiveLetter;
import com.kingdee.eas.fm.ctl.ReceiveLetterCollection;
import com.kingdee.eas.fm.ctl.ReceiveLetterFactory;
import com.kingdee.eas.fm.ctl.ReceiveLetterInfo;
import com.kingdee.eas.fm.ctl.ReceiveRepayCollection;
import com.kingdee.eas.fm.ctl.ReceiveRepayFactory;
import com.kingdee.eas.fm.ctl.ReceiveRepayInfo;
import com.kingdee.eas.fm.ctl.ReceiveStateEnum;
import com.kingdee.eas.fm.ctl.app.AbstractReceiveRepayControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReceiveRepayControllerBean
extends AbstractReceiveRepayControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ctl.app.ReceiveRepayControllerBean");

    @Override
    protected void _andit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ReceiveRepayInfo info = this.getReceiveRepayInfo(ctx, pk);
        if (!ReceiveStateEnum.SUBMIT.equals((Object)info.getState())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"33_ReceiveLetterControllerBean", (Locale)ctx.getLocale())));
        }
        info.setState(ReceiveStateEnum.APPROVE);
        info.setApproval(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        info.setApprovalDate(new Date());
        this.submit(ctx, (CoreBaseInfo)info);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"1_AssureBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"37_ReceiveRepayControllerBean", (Locale)ctx.getLocale())));
    }

    @Override
    protected void _antiAndit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ReceiveRepayInfo info = this.getReceiveRepayInfo(ctx, pk);
        if (!ReceiveStateEnum.APPROVE.equals((Object)info.getState())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"38_ReceiveRepayControllerBean", (Locale)ctx.getLocale())));
        }
        info.setState(ReceiveStateEnum.SUBMIT);
        info.setApproval(null);
        info.setApprovalDate(null);
        this.submit(ctx, (CoreBaseInfo)info);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"1_AssureBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"37_ReceiveRepayControllerBean", (Locale)ctx.getLocale())));
    }

    @Override
    protected Map _getReceiveMap(Context ctx, String srcId) throws BOSException, EASBizException {
        if (srcId == null) {
            return null;
        }
        HashMap<String, Serializable> receiveMap = new HashMap<String, Serializable>();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("Currency.*"));
        selector.add(new SelectorItemInfo("BankAcct.*"));
        ReceiveLetterInfo info = ReceiveLetterFactory.getLocalInstance(ctx).getReceiveLetterInfo((IObjectPK)new ObjectUuidPK(srcId), selector);
        if (info != null) {
            receiveMap.put("ReceiveLetter", info);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("srcBillNum", (Object)info.getNumber(), CompareType.EQUALS));
            evi.setFilter(filter);
            evi.getSelector().add("id");
            ReceiveRepayCollection repay = ReceiveRepayFactory.getLocalInstance(ctx).getReceiveRepayCollection(evi);
            if (repay != null) {
                receiveMap.put("SuoIndex", new Integer(repay.size() + 1));
            } else {
                receiveMap.put("SuoIndex", new Integer(1));
            }
        }
        return receiveMap;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ReceiveRepayInfo info = ReceiveRepayFactory.getLocalInstance(ctx).getReceiveRepayInfo(pk);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterinfo = new FilterInfo();
        filterinfo.getFilterItems().add(new FilterItemInfo("srcBillNum", (Object)info.getSrcBillNum(), CompareType.EQUALS));
        view.setFilter(filterinfo);
        ReceiveRepayCollection repay = ReceiveRepayFactory.getLocalInstance(ctx).getReceiveRepayCollection(view);
        if (repay == null || info.getSuoIndex() != repay.size()) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"39_ReceiveRepayControllerBean", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getSrcBillNum(), CompareType.EQUALS));
        evi.setFilter(filter);
        ReceiveLetterCollection letter = ReceiveLetterFactory.getLocalInstance(ctx).getReceiveLetterCollection(evi);
        if (repay != null && repay.size() > 0) {
            ReceiveLetterInfo letterInfo = letter.get(0);
            double value = letterInfo.getBalance().doubleValue() + info.getAmount().doubleValue();
            letterInfo.setBalance(new BigDecimal(value));
            ReceiveLetterFactory.getLocalInstance(ctx).submit((CoreBaseInfo)letterInfo);
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IReceiveLetter reclet;
        ReceiveLetterInfo receiveletter;
        ReceiveRepayInfo info = (ReceiveRepayInfo)model;
        IObjectPK pk = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterinfo = new FilterInfo();
        filterinfo.getFilterItems().add(new FilterItemInfo("number", (Object)info.getSrcBillNum(), CompareType.EQUALS));
        view.setFilter(filterinfo);
        ReceiveLetterCollection repay = ReceiveLetterFactory.getLocalInstance(ctx).getReceiveLetterCollection(view);
        if (repay != null && repay.size() > 0 && repay.get(0).getId() != null && (receiveletter = (reclet = ReceiveLetterFactory.getLocalInstance(ctx)).getReceiveLetterInfo((IObjectPK)new ObjectUuidPK(repay.get(0).getId()))) != null) {
            double value = info.getAmount().doubleValue() - receiveletter.getBalance().doubleValue();
            if (value > 0.0) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"40_ReceiveRepayControllerBean", (Locale)ctx.getLocale())));
            }
            receiveletter.setBalance(new BigDecimal(Math.abs(value)));
            pk = super._addnew(ctx, model);
            reclet.submit((CoreBaseInfo)receiveletter);
        }
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IReceiveLetter reclet;
        ReceiveLetterInfo receiveletter;
        ReceiveRepayInfo info = (ReceiveRepayInfo)model;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterinfo = new FilterInfo();
        filterinfo.getFilterItems().add(new FilterItemInfo("number", (Object)info.getSrcBillNum(), CompareType.EQUALS));
        view.setFilter(filterinfo);
        ReceiveLetterCollection repay = ReceiveLetterFactory.getLocalInstance(ctx).getReceiveLetterCollection(view);
        ReceiveRepayInfo repayInfo = this.getReceiveRepayInfo(ctx, pk);
        if (repay != null && repay.size() > 0 && repay.get(0).getId() != null && (receiveletter = (reclet = ReceiveLetterFactory.getLocalInstance(ctx)).getReceiveLetterInfo((IObjectPK)new ObjectUuidPK(repay.get(0).getId()))) != null) {
            double value = info.getAmount().doubleValue() - (receiveletter.getBalance().doubleValue() + repayInfo.getAmount().doubleValue());
            if (value > 0.0) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"40_ReceiveRepayControllerBean", (Locale)ctx.getLocale())));
            }
            receiveletter.setBalance(new BigDecimal(Math.abs(value)));
            super._update(ctx, pk, model);
            reclet.submit((CoreBaseInfo)receiveletter);
        }
    }
}

