/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.app.ServerEnvironment;
import com.kingdee.eas.util.PropertiesUtil;
import java.io.File;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EcdsConfig {
    private static Logger logger = Logger.getLogger(EcdsConfig.class);
    private static EcdsConfig instance = new EcdsConfig();
    private Properties config = null;
    private Context ecdsCtx = null;
    private String ais = null;
    private boolean isOn = false;
    private boolean inTimeIsOn = false;
    private boolean inCommonIsOn = false;
    private boolean inEdrafIsOn = false;
    private static final String ecdsFile = "ecds.properties";
    private boolean SIGNATURE = false;
    private String remoteIP;
    private String userName;
    private String userId;
    private String solution = "eas";
    private Locale local = new Locale("L2");
    private int real_wait = 1;
    private int common_wait = 1;
    private String real_next = "";
    private String common_next = "";
    private String edraf_next = "";
    private int real_rec_count = 1;
    private int common_rec_count = 1;

    public boolean isSIGNATURE() {
        return this.SIGNATURE;
    }

    public static EcdsConfig getInstance() {
        return instance;
    }

    private EcdsConfig() {
        StringBuffer configFile = new StringBuffer();
        configFile.append(System.getProperty("eas.deploy")).append(File.separator).append(ecdsFile);
        String path = ServerEnvironment.getInstanceConfigPath() + File.separator + ecdsFile;
        this.config = PropertiesUtil.getProperties((String)path);
        if (this.config != null) {
            this.initConfig();
        }
    }

    private synchronized void initConfig() {
        this.isOn = Boolean.valueOf(this.config.getProperty("ON"));
        this.inTimeIsOn = Boolean.valueOf(this.config.getProperty("INTIME_ON"));
        this.inCommonIsOn = Boolean.valueOf(this.config.getProperty("COMMON_ON"));
        this.inEdrafIsOn = Boolean.valueOf(this.config.getProperty("EDRAF_ON"));
        this.SIGNATURE = Boolean.valueOf(this.config.getProperty("SIGNATURE"));
        this.remoteIP = this.config.getProperty("REMOTE_IP");
        this.ais = this.config.getProperty("AIS");
        this.userName = this.config.getProperty("USERNAME");
        this.userId = this.config.getProperty("USERID");
        this.solution = this.config.getProperty("SOLUTION");
        String localStr = this.config.getProperty("LOCAL");
        this.local = new Locale(localStr);
        this.ecdsCtx = new Context((IObjectPK)new ObjectUuidPK(this.userId), this.solution, this.ais, this.local);
        this.ecdsCtx.setUserName(this.userName);
        this.real_wait = Integer.parseInt(this.config.getProperty("REAL_WAIT"));
        this.common_wait = Integer.parseInt(this.config.getProperty("COMMON_WAIT"));
        this.real_next = String.valueOf(this.config.getProperty("REAL_NEXT"));
        this.common_next = String.valueOf(this.config.getProperty("COMMON_NEXT"));
        this.edraf_next = String.valueOf(this.config.getProperty("EDRAF_NEXT"));
        this.real_rec_count = Integer.parseInt(this.config.getProperty("REAL_REC_COUNT"));
        this.common_rec_count = Integer.parseInt(this.config.getProperty("COMMON_REC_COUNT"));
    }

    public boolean isInTimeIsOn() {
        return this.inTimeIsOn;
    }

    public boolean isInCommonIsOn() {
        return this.inCommonIsOn;
    }

    public boolean isInEdrafIsOn() {
        return this.inEdrafIsOn;
    }

    public Context getEcdsCtx() {
        if (this.ecdsCtx == null) {
            this.ecdsCtx = new Context((IObjectPK)new ObjectUuidPK(this.userId), this.solution, this.ais, this.local);
        }
        return this.ecdsCtx;
    }

    public String getAis() {
        return this.ais;
    }

    public boolean isOn() {
        return this.isOn;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSolution() {
        return this.solution;
    }

    public Locale getLocal() {
        return this.local;
    }

    public int getReal_wait() {
        return this.real_wait;
    }

    public int getCommon_wait() {
        return this.common_wait;
    }

    public String getReal_next() {
        return this.real_next;
    }

    public String getCommon_next() {
        return this.common_next;
    }

    public String getEdraf_next() {
        return this.edraf_next;
    }

    public int getReal_rec_count() {
        return this.real_rec_count;
    }

    public int getCommon_rec_count() {
        return this.common_rec_count;
    }

    public String getRemoteIP() {
        return this.remoteIP;
    }
}

