/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.ecore.AcceptRequestBillInfo;
import com.kingdee.eas.fm.ecore.AcceptanceRegisterBillInfo;
import com.kingdee.eas.fm.ecore.ActionCancelBillInfo;
import com.kingdee.eas.fm.ecore.AgainDiscountApplyBillInfo;
import com.kingdee.eas.fm.ecore.AnnulingSuspendingPaymentRegisterBillInfo;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.BanEndorsementMarkEnum;
import com.kingdee.eas.fm.ecore.BankSellingDraftsRequestInfo;
import com.kingdee.eas.fm.ecore.BizCancelBillInfo;
import com.kingdee.eas.fm.ecore.BizContractReplyBillCollection;
import com.kingdee.eas.fm.ecore.BizContractReplyBillFactory;
import com.kingdee.eas.fm.ecore.BizContractReplyBillInfo;
import com.kingdee.eas.fm.ecore.BizReceiveBillFactory;
import com.kingdee.eas.fm.ecore.BizReceiveBillInfo;
import com.kingdee.eas.fm.ecore.BizReplyBillInfo;
import com.kingdee.eas.fm.ecore.BusinessNotificationFactory;
import com.kingdee.eas.fm.ecore.BusinessNotificationInfo;
import com.kingdee.eas.fm.ecore.CertificateBindingRequestBillInfo;
import com.kingdee.eas.fm.ecore.CollateralizationRegisterBillInfo;
import com.kingdee.eas.fm.ecore.CollectionRegisterBillInfo;
import com.kingdee.eas.fm.ecore.ContractActionBillCollection;
import com.kingdee.eas.fm.ecore.ContractActionBillFactory;
import com.kingdee.eas.fm.ecore.ContractActionBillInfo;
import com.kingdee.eas.fm.ecore.ContractActionEnum;
import com.kingdee.eas.fm.ecore.ContractCancelBillInfo;
import com.kingdee.eas.fm.ecore.ContractMonthlyDetailsRequestInfo;
import com.kingdee.eas.fm.ecore.ContractOfferReqBillCollection;
import com.kingdee.eas.fm.ecore.ContractOfferReqBillFactory;
import com.kingdee.eas.fm.ecore.ContractOfferReqBillInfo;
import com.kingdee.eas.fm.ecore.ContractRescindReqBillInfo;
import com.kingdee.eas.fm.ecore.ContractStateEnum;
import com.kingdee.eas.fm.ecore.CtrctOfferXptNoticeBillInfo;
import com.kingdee.eas.fm.ecore.DiscountAgainInfo;
import com.kingdee.eas.fm.ecore.DiscountRegisterBillInfo;
import com.kingdee.eas.fm.ecore.DiscountRequestBillInfo;
import com.kingdee.eas.fm.ecore.DraftBizTypeEnum;
import com.kingdee.eas.fm.ecore.DraftCreditInfoQueryInfo;
import com.kingdee.eas.fm.ecore.DraftDrawingbackRegisterInfo;
import com.kingdee.eas.fm.ecore.DraftFreeFormatMessageRequestInfo;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.DraftRegisterBillInfo;
import com.kingdee.eas.fm.ecore.DraftReplyTypeEnum;
import com.kingdee.eas.fm.ecore.DraftRepurchasedRediscountWithCentralBankRequestInfo;
import com.kingdee.eas.fm.ecore.DraftTypeEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ECDSPaperActionStatusEnum;
import com.kingdee.eas.fm.ecore.ECoreCommandFacadeFactory;
import com.kingdee.eas.fm.ecore.ECoreExceptionTrackerFactory;
import com.kingdee.eas.fm.ecore.ECoreExceptionTrackerInfo;
import com.kingdee.eas.fm.ecore.ECoreExceptionTypeEnum;
import com.kingdee.eas.fm.ecore.ECoreLockEDraftFactory;
import com.kingdee.eas.fm.ecore.EMsgException;
import com.kingdee.eas.fm.ecore.EcdsException;
import com.kingdee.eas.fm.ecore.EleConOperationCheckInfo;
import com.kingdee.eas.fm.ecore.ElecContractBillCollection;
import com.kingdee.eas.fm.ecore.ElecContractBillFactory;
import com.kingdee.eas.fm.ecore.ElecContractBillInfo;
import com.kingdee.eas.fm.ecore.ElecDraftActionBillCollection;
import com.kingdee.eas.fm.ecore.ElecDraftActionBillFactory;
import com.kingdee.eas.fm.ecore.ElecDraftActionBillInfo;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.ElecDraftBillCollection;
import com.kingdee.eas.fm.ecore.ElecDraftBillEntryCollection;
import com.kingdee.eas.fm.ecore.ElecDraftBillEntryFactory;
import com.kingdee.eas.fm.ecore.ElecDraftBillEntryInfo;
import com.kingdee.eas.fm.ecore.ElecDraftBillFactory;
import com.kingdee.eas.fm.ecore.ElecDraftBillInfo;
import com.kingdee.eas.fm.ecore.EndorserRequestInfo;
import com.kingdee.eas.fm.ecore.ExamineInfo;
import com.kingdee.eas.fm.ecore.ExceptionNotificationBillInfo;
import com.kingdee.eas.fm.ecore.GuaranteeRequestBillInfo;
import com.kingdee.eas.fm.ecore.IApplyBillBase;
import com.kingdee.eas.fm.ecore.IBizContractReplyBill;
import com.kingdee.eas.fm.ecore.IElecDraftActionBill;
import com.kingdee.eas.fm.ecore.IElecDraftBill;
import com.kingdee.eas.fm.ecore.IElecDraftBillEntry;
import com.kingdee.eas.fm.ecore.IOperateServiceAgreement;
import com.kingdee.eas.fm.ecore.ImpawnUnchainApplyBillInfo;
import com.kingdee.eas.fm.ecore.MessageFactory;
import com.kingdee.eas.fm.ecore.MessageInfo;
import com.kingdee.eas.fm.ecore.MessageTypeEnum;
import com.kingdee.eas.fm.ecore.NotificationEnum;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementCollection;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementFactory;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.OverdueCuePayInfo;
import com.kingdee.eas.fm.ecore.PaperDraftActionBillCollection;
import com.kingdee.eas.fm.ecore.PaperDraftActionBillFactory;
import com.kingdee.eas.fm.ecore.PaperDraftActionBillInfo;
import com.kingdee.eas.fm.ecore.PaymentRefusedRegisterBillInfo;
import com.kingdee.eas.fm.ecore.PledgeReqBillInfo;
import com.kingdee.eas.fm.ecore.PromptPaymentReqInfo;
import com.kingdee.eas.fm.ecore.QuotingRequestBillInfo;
import com.kingdee.eas.fm.ecore.RecourseAgreementRequestBillInfo;
import com.kingdee.eas.fm.ecore.RecourseNotificationBillInfo;
import com.kingdee.eas.fm.ecore.RediscountWithCentralBankRegisterBillInfo;
import com.kingdee.eas.fm.ecore.RediscountWithCommBankRegisterBillInfo;
import com.kingdee.eas.fm.ecore.RegisterInformationQueryBillInfo;
import com.kingdee.eas.fm.ecore.RepurchaseDiscountRedeemReqInfo;
import com.kingdee.eas.fm.ecore.RepurchaseDiscountTurnRedeemReqInfo;
import com.kingdee.eas.fm.ecore.RepurchasedCollRegisterBillInfo;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.RoleEnum;
import com.kingdee.eas.fm.ecore.SettlementRegisterBillInfo;
import com.kingdee.eas.fm.ecore.SuspendingPaymentRegisterBillInfo;
import com.kingdee.eas.fm.ecore.SystemActionBillFactory;
import com.kingdee.eas.fm.ecore.SystemActionBillInfo;
import com.kingdee.eas.fm.ecore.SystemActionStatusEnum;
import com.kingdee.eas.fm.ecore.SystemStatusCollection;
import com.kingdee.eas.fm.ecore.SystemStatusFactory;
import com.kingdee.eas.fm.ecore.SystemStatusInfo;
import com.kingdee.eas.fm.ecore.SystemTypeEnum;
import com.kingdee.eas.fm.ecore.TipsTicketCollectorBillInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftAcceptanceRegister;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftAnnulingSuspendingPaymentRegister;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftCancellationRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftCollateralizationRegister;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftCollectionRegister;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftCommonSignUp;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftCommonStatus;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftCommonTransmission;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftDiscountRegister;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftDrawingbackRegister;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftExceptionNotification;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftPaymentRefusedRegister;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRecourseAgreementRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRediscountWithCentralBankRegister;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRediscountWithCommercialBankRegister;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRegisterConfirmation;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRepurchasedCollateralizationRegister;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftSettlementRegister;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftSettlementResultNotification;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftSuspendingPaymentRegister;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.DocumentCommercialDraft;
import com.kingdee.eas.fm.ecore.app.util.DateUtil;
import com.kingdee.eas.fm.ecore.app.util.EcdsSerNumber;
import com.kingdee.eas.fm.ecore.util.FMECDSDbUtil;
import com.kingdee.eas.fm.ecore.util.FMTab;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ECDSCommon {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon");
    public static final String[] INSULATE = new String[]{"101", "102", "103", "104", "105", "106", "107", "108", "109", "110", "111", "076", "078", "221", "223", "065"};
    private static Map MSG_INFO = new HashMap();
    private static String actionOql = "select * from T_ECR_ElecDraftActionBill where  FDraftNumber=? order by FcreateTime desc";
    public static final String INTIME = "intime";
    public static final String COMMON = "common";
    public static final String SEND_CHECK_ERROR = EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"21_ECDSCommon");
    public static final String PART_CHECK_ERROR = EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"22_ECDSCommon");
    public static final String COMMON_SWITCH_TITLE = EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"23_ECDSCommon");
    public static final String INTIME_SWITCH_TITLE = EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"24_ECDSCommon");
    public static final String EDRAF_SWITCH_TITLE = EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"26_ECDSCommon");
    public static final String COMMON_SWITCH_NAME = "COMMON_SWITCH_NAME";
    public static final String INTIME_SWITCH_NAME = "INTIME_SWITCH_NAME";
    public static final String EDRAF_SWITCH_NAME = "EDRAF_SWITCH_NAME";
    public static Date COMMON_SWITCH_TIME = null;
    public static Date INTIME_SWITCH_TIME = null;
    public static Date EDRAF_SWITCH_TIME = null;

    public static synchronized void setCOMMON_SWITCH_TIME() {
        COMMON_SWITCH_TIME = new Date();
    }

    public static synchronized void setINTIME_SWITCH_TIME() {
        INTIME_SWITCH_TIME = new Date();
    }

    public static synchronized void setEDRAF_SWITCH_TIME() {
        EDRAF_SWITCH_TIME = new Date();
    }

    public static String findMsgIdTypeByMsgNum(String msgNum) {
        for (Map.Entry entry : MSG_INFO.entrySet()) {
            String key = String.valueOf(entry.getKey());
            String val = String.valueOf(entry.getValue());
            if (msgNum.equals(val.split(",")[0])) {
                return val.split(",")[3];
            }
            if (!msgNum.equals(key)) continue;
            return val;
        }
        return "4";
    }

    public static String findBOSTypeByMsgNum(String msgNum) {
        for (Map.Entry entry : MSG_INFO.entrySet()) {
            String key = String.valueOf(entry.getKey());
            String val = String.valueOf(entry.getValue());
            if (!msgNum.equals(val.split(",")[0])) continue;
            return key;
        }
        return null;
    }

    public static String findMsgIdTypeByMsgId(String msgId) {
        int n = Integer.parseInt(msgId.substring(20));
        if (n < 50000000) {
            return "1";
        }
        if (n < 80000000) {
            return "2";
        }
        if (n < 90000000) {
            return "3";
        }
        return "4";
    }

    public static String findMsgTypeByBosType(String bosType) {
        return String.valueOf(MSG_INFO.get(bosType)).split(",")[0];
    }

    public static String findMqTypeByBosType(String bosType) {
        return String.valueOf(MSG_INFO.get(bosType)).split(",")[1];
    }

    public static boolean findHasPtcptSgntr(String bosType) {
        String t = String.valueOf(MSG_INFO.get(bosType)).split(",")[2];
        return "1".equals(t);
    }

    public static Date getDateByStr(String str) throws BOSException {
        String y = str.split("T")[0];
        String d = str.split("T")[1];
        String r = y + " " + d;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = df.parse(r);
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException(e.getMessage());
        }
        return date;
    }

    public static Time getTimeByStr(String str) throws BOSException {
        String y = str.split("T")[0];
        String d = str.split("T")[1];
        String r = y + " " + d;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = df.parse(r);
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException(e.getMessage());
        }
        Time t = new Time(date.getTime());
        return t;
    }

    public static Timestamp getTimestampByStr(String str) throws BOSException {
        String y = str.split("T")[0];
        String d = str.split("T")[1];
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String r = y + " " + d;
        Date date = new Date();
        try {
            date = df.parse(r);
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException(e.getMessage());
        }
        String time = df.format(date);
        Timestamp ts = Timestamp.valueOf(time);
        return ts;
    }

    public static String getMessTimeByTimestamp(Timestamp timestamp) {
        SimpleDateFormat sy = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sh = new SimpleDateFormat("HH:mm:ss");
        String creDtTm = sy.format(timestamp) + "T" + sh.format(timestamp);
        return creDtTm;
    }

    public static String getStrByDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = df.format(date);
        return time;
    }

    public static String getHeadId(String actorBank) {
        return actorBank + String.valueOf(EcdsSerNumber.getPK());
    }

    public static String getStrLength(String xml) {
        int position = String.valueOf(xml.getBytes().length).length();
        String ret = "";
        for (int i = 0; i < 8 - position; ++i) {
            ret = ret + "0";
        }
        return ret + String.valueOf(xml.getBytes().length);
    }

    public static void insertElecDraftActionBill(Context ctx, KMsg kmsg, String draftNumber, String holderOrgCode, String bizRecordBillID, ECDSBillStatusEnum communicatedDraftStatus, ElecDraftActionEnum actionType, DraftMessageEnum draftMessage, String communicateRemark) throws BOSException, EASBizException {
        DocumentCommercialDraft draft = kmsg.getDocumentCommercialDraft();
        ElecDraftActionBillInfo actionBillInfo = new ElecDraftActionBillInfo();
        if (holderOrgCode == null || "".equals(holderOrgCode)) {
            throw new EMsgException(EcdsException.HOLDERORGCODEERR);
        }
        actionBillInfo.setMessageID(kmsg.getDocumentCommercialDraft().getMsgId().getId());
        actionBillInfo.setMessageTime(ECDSCommon.getTimestampByStr(kmsg.getDocumentCommercialDraft().getMsgId().getCreDtTm()));
        if (draftMessage.equals((Object)DraftMessageEnum.M033)) {
            CommercialDraftCommonStatus cu = (CommercialDraftCommonStatus)draft;
            actionBillInfo.setOriMessageID(cu.getOrgnlMsgId().getId());
            actionBillInfo.setOriMessageTime(ECDSCommon.getTimestampByStr(cu.getOrgnlMsgId().getCreDtTm()));
        } else if (draftMessage.equals((Object)DraftMessageEnum.M031)) {
            CommercialDraftCommonSignUp stats = (CommercialDraftCommonSignUp)draft;
            actionBillInfo.setOriMessageID(stats.getOrgnlMsgId().getId());
            actionBillInfo.setMessageTime(ECDSCommon.getTimestampByStr(stats.getOrgnlMsgId().getCreDtTm()));
        } else if (draftMessage.equals((Object)DraftMessageEnum.M005)) {
            CommercialDraftRegisterConfirmation config = (CommercialDraftRegisterConfirmation)draft;
            actionBillInfo.setOriMessageID(config.getOrgnlMsgId().getId());
            actionBillInfo.setMessageTime(ECDSCommon.getTimestampByStr(config.getOrgnlMsgId().getCreDtTm()));
        } else if (draftMessage.equals((Object)DraftMessageEnum.M023)) {
            CommercialDraftRecourseAgreementRequest seagree = (CommercialDraftRecourseAgreementRequest)draft;
            actionBillInfo.setOriMessageID(seagree.getOrgnlMsgId().getId());
            actionBillInfo.setMessageTime(ECDSCommon.getTimestampByStr(seagree.getOrgnlMsgId().getCreDtTm()));
        } else if (draftMessage.equals((Object)DraftMessageEnum.M032)) {
            CommercialDraftCancellationRequest cance = (CommercialDraftCancellationRequest)draft;
            actionBillInfo.setOriMessageID(cance.getOrgnlMsgId().getId());
            actionBillInfo.setMessageTime(ECDSCommon.getTimestampByStr(cance.getOrgnlMsgId().getCreDtTm()));
        } else if (draftMessage.equals((Object)DraftMessageEnum.M035)) {
            CommercialDraftExceptionNotification exception = (CommercialDraftExceptionNotification)draft;
            actionBillInfo.setOriMessageID(exception.getOrgnlMsgId().getId());
            actionBillInfo.setMessageTime(ECDSCommon.getTimestampByStr(exception.getOrgnlMsgId().getCreDtTm()));
        } else if (draftMessage.equals((Object)DraftMessageEnum.M036)) {
            CommercialDraftSettlementResultNotification settlement = (CommercialDraftSettlementResultNotification)draft;
            actionBillInfo.setOriMessageID(settlement.getOrgnlMsgId().getId());
            actionBillInfo.setMessageTime(ECDSCommon.getTimestampByStr(settlement.getOrgnlMsgId().getCreDtTm()));
        }
        actionBillInfo.setDraftNumber(draftNumber);
        actionBillInfo.setHolderOrgCode(holderOrgCode);
        actionBillInfo.setBizRecordBillID(bizRecordBillID);
        actionBillInfo.setCommunicatedDraftStatus(communicatedDraftStatus);
        actionBillInfo.setActionType(actionType);
        actionBillInfo.setDraftMessage(draftMessage);
        actionBillInfo.setCommunicateRemark(communicateRemark);
        ElecDraftActionBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)actionBillInfo);
    }

    public static ElecDraftBillEntryInfo insertElecDraftBillEntry(Context ctx, ElecDraftBillEntryInfo elecDraftBillEntryInfo) throws BOSException, EASBizException {
        IElecDraftBillEntry ibill = ElecDraftBillEntryFactory.getLocalInstance(ctx);
        String draftNumber = elecDraftBillEntryInfo.getDraftNumber();
        DraftBizTypeEnum draftBizType = elecDraftBillEntryInfo.getDraftBizType();
        String formerOrgCode = elecDraftBillEntryInfo.getFormerOrgCode();
        String laterOrgCode = elecDraftBillEntryInfo.getLaterOrgCode();
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)draftNumber));
        fi.getFilterItems().add(new FilterItemInfo("draftBizType", (Object)draftBizType));
        fi.getFilterItems().add(new FilterItemInfo("formerOrgCode", (Object)formerOrgCode));
        fi.getFilterItems().add(new FilterItemInfo("laterOrgCode", (Object)laterOrgCode));
        viewinfo.setFilter(fi);
        ElecDraftBillEntryCollection eColl = ibill.getElecDraftBillEntryCollection(viewinfo);
        IObjectPK pk = ibill.addnew(elecDraftBillEntryInfo);
        return elecDraftBillEntryInfo;
    }

    public static boolean hasEntryWithSameCreateMessageID(Context ctx, String createMessageID) throws BOSException, EASBizException {
        IElecDraftBillEntry ibill = ElecDraftBillEntryFactory.getLocalInstance(ctx);
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("createMessageID", (Object)createMessageID));
        viewinfo.setFilter(fi);
        ElecDraftBillEntryCollection eColl = ibill.getElecDraftBillEntryCollection(viewinfo);
        return eColl.size() > 0;
    }

    public static int findbyElecDraftBillEntryInfoid(Context ctx, String iNdb) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)iNdb));
        SorterItemInfo sortInfo = new SorterItemInfo("seq");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        ElecDraftBillEntryInfo info = ElecDraftBillEntryFactory.getLocalInstance(ctx).getElecDraftBillEntryCollection(viewinfo).get(0);
        int temp = info != null ? info.getSeq() : 0;
        return temp;
    }

    public static ElecDraftActionBillInfo findActionInfoBillByMsgID(Context ctx, String msgId) throws BOSException, EASBizException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("messageID", (Object)msgId.toString()));
        SorterItemInfo sortInfo = new SorterItemInfo("createtime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        ElecDraftActionBillCollection ec = ElecDraftActionBillFactory.getLocalInstance(ctx).getElecDraftActionBillCollection(viewinfo);
        if (ec.size() != 0) {
            return ec.get(0);
        }
        return null;
    }

    public static ElecDraftActionBillInfo findActionInfoBillByMsgID(Context ctx, String msgId, ElecDraftActionEnum actionType) throws BOSException, EASBizException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("messageID", (Object)msgId));
        fi.getFilterItems().add(new FilterItemInfo("actionType", (Object)new Integer(actionType.getValue())));
        SorterItemInfo sortInfo = new SorterItemInfo("createtime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setFilter(fi);
        ElecDraftActionBillCollection ec = ElecDraftActionBillFactory.getLocalInstance(ctx).getElecDraftActionBillCollection(viewinfo);
        if (ec.size() != 0) {
            return ec.get(0);
        }
        return null;
    }

    public static ElecDraftActionBillInfo findActionInfoBillByMsgID(Context ctx, String msgId, DraftMessageEnum msgType) throws BOSException, EASBizException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (msgId != null) {
            fi.getFilterItems().add(new FilterItemInfo("messageID", (Object)msgId));
        }
        fi.getFilterItems().add(new FilterItemInfo("draftMessage", (Object)msgType));
        SorterItemCollection sortCol = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        ElecDraftActionBillCollection ec = ElecDraftActionBillFactory.getLocalInstance(ctx).getElecDraftActionBillCollection(viewinfo);
        if (ec.size() != 0) {
            return ec.get(0);
        }
        return null;
    }

    public static ElecDraftActionBillInfo findActionInfoBillByMsgID(Context ctx, String msgId, DraftMessageEnum msgType, ElecDraftActionEnum actionenum) throws BOSException, EASBizException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("messageID", (Object)msgId));
        fi.getFilterItems().add(new FilterItemInfo("draftMessage", (Object)msgType));
        fi.getFilterItems().add(new FilterItemInfo("actionType", (Object)actionenum));
        viewinfo.setFilter(fi);
        ElecDraftActionBillCollection ec = ElecDraftActionBillFactory.getLocalInstance(ctx).getElecDraftActionBillCollection(viewinfo);
        if (ec.size() != 0) {
            return ec.get(0);
        }
        return null;
    }

    public static ElecDraftActionBillInfo findCommonStatusByMsgID(Context ctx, String msgId) throws BOSException, EASBizException {
        EntityViewInfo v1 = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.appendFilterItem("messageID", (Object)msgId);
        fi.appendFilterItem("actionType", (Object)new Integer(0));
        fi.appendFilterItem("actionType", (Object)new Integer(2));
        fi.appendFilterItem("actionType", (Object)new Integer(1));
        fi.appendFilterItem("actionType", (Object)new Integer(12));
        fi.setMaskString("#0 and (#1 or #2 or #3 or #4)");
        SorterItemInfo sortInfo = new SorterItemInfo("createtime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        v1.setFilter(fi);
        v1.setSorter(sortCol);
        ElecDraftActionBillCollection ec = ElecDraftActionBillFactory.getLocalInstance(ctx).getElecDraftActionBillCollection(v1);
        if (ec.size() != 0) {
            return ec.get(0);
        }
        return null;
    }

    public static void updateBizInfo(Context ctx, ApplyBillStatusEnum applyBillStatusEnum, String rmrk, ElecDraftActionBillInfo ainfo) throws EASBizException, BOSException {
        if (ainfo == null) {
            return;
        }
        ECDSCommon.updateBizInfoInner(ctx, applyBillStatusEnum, rmrk, ainfo);
    }

    public static void updateBizInfo(Context ctx, String orgnlMsgId, ApplyBillStatusEnum applyBillStatusEnum, String rmrk, String msgType) throws EASBizException, BOSException {
        ElecDraftActionBillInfo ainfo = ECDSCommon.findActionInfoBillByMsgID(ctx, orgnlMsgId, DraftMessageEnum.getEnum("M" + msgType));
        if (ainfo == null) {
            return;
        }
        ECDSCommon.updateBizInfoInner(ctx, applyBillStatusEnum, rmrk, ainfo);
    }

    private static void updateBizInfoInner(Context ctx, ApplyBillStatusEnum applyBillStatusEnum, String rmrk, ElecDraftActionBillInfo ainfo) throws BOSException, EASBizException {
        String bizRecordBillID = ainfo.getBizRecordBillID();
        if (bizRecordBillID == null) {
            return;
        }
        BOSUuid uuid = BOSUuid.read((String)bizRecordBillID);
        IApplyBillBase ib = (IApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(uuid.getType());
        ObjectUuidPK pk = null;
        pk = new ObjectUuidPK(BOSUuid.read((String)bizRecordBillID));
        ApplyBillBaseInfo info = ib.getApplyBillBaseInfo((IObjectPK)pk);
        if (info != null) {
            info.setIsApplySuccess(applyBillStatusEnum);
            info.setDescription(rmrk);
            ib.update((IObjectPK)pk, (CoreBaseInfo)info);
        }
    }

    public static ContractActionBillInfo findContracttActionBillByMsgID(Context ctx, String msgId) throws BOSException, EASBizException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("messageID", (Object)msgId));
        viewinfo.setFilter(fi);
        ContractActionBillCollection cc = ContractActionBillFactory.getLocalInstance(ctx).getContractActionBillCollection(viewinfo);
        if (cc.size() != 0) {
            return cc.get(0);
        }
        return null;
    }

    public static ElecDraftBillInfo findElecDraftBillInfoByIndb(Context ctx, String IdNb) throws BOSException, EASBizException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        viewinfo.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)IdNb));
        viewinfo.setFilter(fi);
        ElecDraftBillCollection ec = ElecDraftBillFactory.getLocalInstance(ctx).getElecDraftBillCollection(viewinfo);
        if (ec.size() != 0) {
            return ec.get(0);
        }
        return null;
    }

    public static int findElecDraftBillInfoByIndbSize(Context ctx, String IdNb) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        viewinfo.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)IdNb));
        viewinfo.setFilter(fi);
        IElecDraftBill idb = ElecDraftBillFactory.getLocalInstance(ctx);
        return idb.getElecDraftBillCollection(viewinfo).size();
    }

    public static String findAccot(String accpid, Context ctx) throws BOSException {
        EntityViewInfo v1 = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)accpid, CompareType.EQUALS));
        v1.getSelector().add(new SelectorItemInfo("*"));
        v1.setFilter(fi);
        IAccountBank iaccount = AccountBankFactory.getLocalInstance((Context)ctx);
        AccountBankCollection iColl = iaccount.getAccountBankCollection(v1);
        if (iColl.size() != 0) {
            return iColl.get(0).getId().toString();
        }
        return null;
    }

    public static OperateServiceAgreementInfo findbyComid(String accpid, String acctSerger, Context ctx, String comid) throws EASBizException, BOSException {
        EntityViewInfo v1 = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bizGatherNumber", (Object)accpid, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("bizOrgNumber", (Object)comid, CompareType.EQUALS));
        v1.setFilter(fi);
        IOperateServiceAgreement Ioper = OperateServiceAgreementFactory.getLocalInstance(ctx);
        OperateServiceAgreementInfo info = Ioper.getOperateServiceAgreementCollection(v1).get(0);
        return info;
    }

    public static IObjectPK inserBizReceiveBill(Context ctx, ElecDraftBillInfo billInfo, String receiveinOrgCode, String messgId, String messageTime, String applyBilled, DraftReplyTypeEnum replyFy) throws EASBizException, BOSException {
        BizReceiveBillInfo info = new BizReceiveBillInfo();
        info.setDraftBill(billInfo);
        info.setApplyBillID(applyBilled);
        info.setIsReplied(false);
        info.setReplyType(replyFy);
        info.setMessageID(messgId);
        info.setMessageTime(ECDSCommon.getTimestampByStr(messageTime));
        info.setReceiverOrgCode(receiveinOrgCode);
        IObjectPK pk = BizReceiveBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
        return pk;
    }

    public static void updateBillHolderOrgCode(Context ctx, String nid, String holderOrgCode, String holderAccount, String holderBank) throws BOSException, EASBizException {
        ElecDraftBillInfo draftBillInfo = ECDSCommon.findElecDraftBillInfoByIndb(ctx, nid);
        draftBillInfo.setHolderOrgCode(holderOrgCode);
        draftBillInfo.setHolderBank(holderBank);
        draftBillInfo.setHolderAccount(holderAccount);
        ObjectUuidPK pk = null;
        pk = new ObjectUuidPK(BOSUuid.read((String)draftBillInfo.getId().toString()));
        ElecDraftBillFactory.getLocalInstance(ctx).update((IObjectPK)pk, (CoreBaseInfo)draftBillInfo);
    }

    public static void updateBillTypeID(ECDSBillStatusEnum statusEnum, String nid, Context ctx) throws BOSException, EASBizException {
        ElecDraftBillInfo draftBillInfo = ECDSCommon.findElecDraftBillInfoByIndb(ctx, nid);
        draftBillInfo.setDraftECDSStatus(statusEnum);
        ElecDraftBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectStringPK(draftBillInfo.getId().toString()), (CoreBaseInfo)draftBillInfo);
    }

    public static ElecDraftBillInfo findElecDraftBillInfoById(Context ctx, String id) throws EASBizException, BOSException {
        ElecDraftBillInfo info = ElecDraftBillFactory.getLocalInstance(ctx).getElecDraftBillInfo((IObjectPK)new ObjectStringPK(id));
        return info;
    }

    public static void updateBillType(ECDSBillStatusEnum statusEnum, ElecDraftBillInfo draftBillInfo, Context ctx) throws BOSException, EASBizException {
        ElecDraftBillInfo binfo = ECDSCommon.findElecDraftBillInfoByIndb(ctx, draftBillInfo.getDraftNumber());
        ObjectUuidPK pk = null;
        pk = new ObjectUuidPK(BOSUuid.read((String)binfo.getId().toString()));
        binfo.setDraftECDSStatus(statusEnum);
        ElecDraftBillFactory.getLocalInstance(ctx).update((IObjectPK)pk, (CoreBaseInfo)binfo);
    }

    public static void updateBillType(ElecDraftBillInfo billInfo, Context ctx) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("DraftECDSStatus"));
        ElecDraftBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)billInfo, sic);
    }

    public static ElecDraftActionBillInfo findAllElecDraftActionBill(String idNb, Context ctx) throws BOSException, EASBizException {
        EntityViewInfo v1 = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("DraftNumber", (Object)idNb, CompareType.EQUALS));
        v1.getSelector().add(new SelectorItemInfo("*"));
        SorterItemInfo sortInfo = new SorterItemInfo("createtime");
        sortInfo.setSortType(SortType.DESCEND);
        v1.getSorter().add(sortInfo);
        v1.setFilter(fi);
        IElecDraftActionBill iElec = ElecDraftActionBillFactory.getLocalInstance(ctx);
        ElecDraftActionBillCollection eColl = iElec.getElecDraftActionBillCollection(v1);
        return eColl.get(0);
    }

    public static String findMessgNode(String msgid, String startnode, String endnode, Context ctx) throws EASBizException, BOSException {
        MessageInfo info = MessageFactory.getLocalInstance(ctx).getMessageInfo("select * where msgNumber ='" + msgid + "'");
        String message = info.getMessage().toString();
        int start = message.indexOf(startnode);
        int end = message.indexOf(endnode);
        return null;
    }

    public static int findActionType(String idNb, Context ctx) throws BOSException {
        Object[] idNbs = new Object[]{idNb};
        IRowSet rsetaction = null;
        rsetaction = FMECDSDbUtil.executeQuery(ctx, actionOql, idNbs, new FMTab[]{FMTab.T_ECR_ELECDRAFTBILLARR});
        try {
            if (rsetaction.next()) {
                return Integer.parseInt(rsetaction.getString("FActionType"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return 0;
    }

    public static String findCommunicatedDraftStatus(String idNb, Context ctx) throws BOSException {
        Object[] idNbs = new Object[]{idNb};
        IRowSet rsetaction = null;
        rsetaction = FMECDSDbUtil.executeQuery(ctx, actionOql, idNbs, new FMTab[]{FMTab.T_ECR_ELECDRAFTACTIONBILL});
        try {
            if (rsetaction.next()) {
                return rsetaction.getString("FCommunicatedDraftStatus");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return null;
    }

    public static void insertContracttAction(Context ctx, KMsg kmsg, String contractNumber, String holderOrgCode, String bizRecordBillID, ContractStateEnum communicatedContractStatus, ContractActionEnum actionType, DraftMessageEnum draftMessage) throws BOSException, EASBizException {
        ContractActionBillInfo actionBillInfo = new ContractActionBillInfo();
        actionBillInfo.setMessageID(kmsg.getDocumentCommercialDraft().getMsgId().getId());
        actionBillInfo.setMessageTime(ECDSCommon.getTimestampByStr(kmsg.getDocumentCommercialDraft().getMsgId().getCreDtTm()));
        actionBillInfo.setContractNumber(contractNumber);
        actionBillInfo.setHolderOrgCode(holderOrgCode);
        actionBillInfo.setBizRecordBillID(bizRecordBillID);
        actionBillInfo.setCommunicatedContracttStatus(communicatedContractStatus);
        actionBillInfo.setActionType(actionType);
        actionBillInfo.setDraftMessage(draftMessage);
        ContractActionBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)actionBillInfo);
    }

    public static void insertSystemAction(Context ctx, KMsg kmsg, String OriMessageID, Timestamp OriMessageTime, String holderOrgCode, String bizRecordBillID, SystemActionStatusEnum actionType, String prcCd, DraftMessageEnum draftMessage) throws BOSException, EASBizException {
        SystemActionBillInfo actionBillInfo = new SystemActionBillInfo();
        actionBillInfo.setMessageID(kmsg.getDocumentCommercialDraft().getMsgId().getId());
        actionBillInfo.setMessageTime(ECDSCommon.getTimestampByStr(kmsg.getDocumentCommercialDraft().getMsgId().getCreDtTm()));
        actionBillInfo.setOriMessageID(OriMessageID);
        actionBillInfo.setOriMessageTime(OriMessageTime);
        actionBillInfo.setBizRecordBillID(bizRecordBillID);
        actionBillInfo.setActionType(actionType);
        actionBillInfo.setPrcCd(prcCd);
        actionBillInfo.setDraftMessage(draftMessage);
        actionBillInfo.setActionTakerOrgCode(holderOrgCode);
        SystemActionBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)actionBillInfo);
    }

    public static boolean isExistenceContractt(Context ctx, String number) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("conECDSNumber", (Object)number));
        viewinfo.setFilter(fi);
        ElecContractBillCollection ec = ElecContractBillFactory.getLocalInstance(ctx).getElecContractBillCollection(viewinfo);
        return ec.size() != 0;
    }

    public static boolean isBizContractReplyBill(Context ctx, String oriMessageID) throws BOSException {
        boolean isExistence = false;
        String oql = "select * where oriMessageID = '" + oriMessageID + "'";
        IBizContractReplyBill iBizContractReplyBill = BizContractReplyBillFactory.getLocalInstance(ctx);
        BizContractReplyBillCollection bizContractReplyBillCollection = iBizContractReplyBill.getBizContractReplyBillCollection(oql);
        if (null != bizContractReplyBillCollection && bizContractReplyBillCollection.size() != 0) {
            isExistence = true;
        }
        return isExistence;
    }

    public static ContractOfferReqBillInfo findElectronContracttOffer(Context ctx, String messageId) throws EASBizException, BOSException {
        ContractActionBillInfo contracttinfo = ECDSCommon.findContracttActionBill(ctx, messageId);
        if (contracttinfo != null) {
            EntityViewInfo viewinfo = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("conECDSNumber", (Object)contracttinfo.getContractNumber()));
            viewinfo.setFilter(fi);
            ContractOfferReqBillCollection ec = ContractOfferReqBillFactory.getLocalInstance(ctx).getContractOfferReqBillCollection(viewinfo);
            if (ec.size() == 0) {
                return null;
            }
            return ec.get(0);
        }
        return null;
    }

    public static ContractActionBillInfo findContracttActionBill(Context ctx, String messageId) throws EASBizException, BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("messageID", (Object)messageId));
        viewinfo.setFilter(fi);
        ContractActionBillCollection cc = ContractActionBillFactory.getLocalInstance(ctx).getContractActionBillCollection(viewinfo);
        if (cc.size() != 0) {
            return cc.get(0);
        }
        return null;
    }

    public static boolean IsElecContractBill(Context ctx, String contractNumber) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("contractNumber", (Object)contractNumber));
        viewinfo.setFilter(fi);
        ElecContractBillCollection cc = ElecContractBillFactory.getLocalInstance(ctx).getElecContractBillCollection(viewinfo);
        return cc.size() != 0;
    }

    public static ContractActionBillInfo findContracttActionBill(Context ctx, String messageId, ElecDraftActionEnum elecDraftActionEnum) throws EASBizException, BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("messageID", (Object)messageId));
        fi.getFilterItems().add(new FilterItemInfo("actionType", (Object)elecDraftActionEnum));
        viewinfo.setFilter(fi);
        ContractActionBillCollection cc = ContractActionBillFactory.getLocalInstance(ctx).getContractActionBillCollection(viewinfo);
        if (cc.size() != 0) {
            return cc.get(0);
        }
        return null;
    }

    public static void updateElectronContracttOfferType(Context ctx, String number, ContractStateEnum statusEnum) throws BOSException, EASBizException {
        ElecContractBillInfo eBillInfo = ECDSCommon.findElectronContracttOfferInfo(ctx, number);
        if (eBillInfo != null) {
            eBillInfo.setContractStatus(statusEnum);
            ObjectUuidPK pk = null;
            pk = new ObjectUuidPK(BOSUuid.read((String)eBillInfo.getId().toString()));
            ElecContractBillFactory.getLocalInstance(ctx).update((IObjectPK)pk, (CoreBaseInfo)eBillInfo);
        }
    }

    public static ElecContractBillInfo findElectronContracttOfferInfo(Context ctx, String IdNb) throws BOSException {
        if (null == IdNb) {
            return null;
        }
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("contractNumber", (Object)IdNb));
        viewinfo.setFilter(fi);
        SorterItemCollection sortCol = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        ElecContractBillCollection ec = ElecContractBillFactory.getLocalInstance(ctx).getElecContractBillCollection(viewinfo);
        if (ec.size() != 0) {
            return ec.get(0);
        }
        return null;
    }

    public static ContractStateEnum findstatContractStateEnum(Context ctx, String icdb, String icdbc) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("contractNumber", (Object)icdb));
        fi.getFilterItems().add(new FilterItemInfo("holderOrgCode", (Object)icdb));
        viewinfo.setFilter(fi);
        SorterItemCollection sortCol = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        ContractActionBillCollection eColl = ContractActionBillFactory.getLocalInstance(ctx).getContractActionBillCollection(viewinfo);
        if (eColl.size() != 0) {
            return eColl.get(0).getCommunicatedContracttStatus();
        }
        return null;
    }

    public static boolean isExistElecDraftBill(Context ctx, String idNb) throws EASBizException, BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)idNb));
        viewinfo.setFilter(fi);
        ElecDraftBillCollection eColl = ElecDraftBillFactory.getLocalInstance(ctx).getElecDraftBillCollection(viewinfo);
        return eColl.size() == 0;
    }

    public static void insertPaperDraftActionBill(Context ctx, KMsg kmsg, String draftNumber, String bizRecordBillID, ECDSPaperActionStatusEnum actionType, String prcCd, DraftMessageEnum num, Timestamp oriMessageTime, String oriMessageID, String registerAcctSvcr, DraftTypeEnum draftType, String accptrAcctSvcr, Date isseDt, Date dueDt, BigDecimal isseAmt) throws BOSException, EASBizException {
        PaperDraftActionBillInfo pinfo = new PaperDraftActionBillInfo();
        pinfo.setMessageID(kmsg.getDocumentCommercialDraft().getMsgId().getId());
        pinfo.setMessageTime(ECDSCommon.getTimestampByStr(kmsg.getDocumentCommercialDraft().getMsgId().getCreDtTm()));
        pinfo.setDraftNumber(draftNumber);
        pinfo.setBizRecordBillID(bizRecordBillID);
        String remark = null;
        DocumentCommercialDraft documentCommercialDraft = kmsg.getDocumentCommercialDraft();
        if (documentCommercialDraft instanceof CommercialDraftAcceptanceRegister) {
            remark = ((CommercialDraftAcceptanceRegister)documentCommercialDraft).getAddtlInf().getRmrk();
        } else if (documentCommercialDraft instanceof CommercialDraftDrawingbackRegister) {
            remark = ((CommercialDraftDrawingbackRegister)documentCommercialDraft).getAddtlInf().getRmrk();
        } else if (documentCommercialDraft instanceof CommercialDraftDiscountRegister) {
            remark = ((CommercialDraftDiscountRegister)documentCommercialDraft).getAddtlInf().getRmrk();
        } else if (documentCommercialDraft instanceof CommercialDraftRediscountWithCommercialBankRegister) {
            remark = ((CommercialDraftRediscountWithCommercialBankRegister)documentCommercialDraft).getAddtlInf().getRmrk();
        } else if (documentCommercialDraft instanceof CommercialDraftRediscountWithCentralBankRegister) {
            remark = ((CommercialDraftRediscountWithCentralBankRegister)documentCommercialDraft).getAddtlInf().getRmrk();
        } else if (documentCommercialDraft instanceof CommercialDraftCollateralizationRegister) {
            remark = ((CommercialDraftCollateralizationRegister)documentCommercialDraft).getAddtlInf().getRmrk();
        } else if (documentCommercialDraft instanceof CommercialDraftRepurchasedCollateralizationRegister) {
            remark = ((CommercialDraftRepurchasedCollateralizationRegister)documentCommercialDraft).getAddtlInf().getRmrk();
        } else if (documentCommercialDraft instanceof CommercialDraftCollectionRegister) {
            remark = ((CommercialDraftCollectionRegister)documentCommercialDraft).getAddtlInf().getRmrk();
        } else if (documentCommercialDraft instanceof CommercialDraftSettlementRegister) {
            remark = ((CommercialDraftSettlementRegister)documentCommercialDraft).getAddtlInf().getRmrk();
        } else if (documentCommercialDraft instanceof CommercialDraftPaymentRefusedRegister) {
            remark = ((CommercialDraftPaymentRefusedRegister)documentCommercialDraft).getAddtlInf().getRmrk();
        } else if (documentCommercialDraft instanceof CommercialDraftSuspendingPaymentRegister) {
            remark = ((CommercialDraftSuspendingPaymentRegister)documentCommercialDraft).getAddtlInf().getRmrk();
        } else if (documentCommercialDraft instanceof CommercialDraftAnnulingSuspendingPaymentRegister) {
            remark = ((CommercialDraftAnnulingSuspendingPaymentRegister)documentCommercialDraft).getAddtlInf().getRmrk();
        }
        if (remark != null) {
            if (remark.equals(ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"PaperDraft_Modify_Remark", (Locale)ctx.getLocale()))) {
                actionType = ECDSPaperActionStatusEnum.SendModify;
            } else if (remark.equals(ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"PaperDraft_Invalid_Remark", (Locale)ctx.getLocale()))) {
                actionType = ECDSPaperActionStatusEnum.SendInvaild;
            }
        }
        pinfo.setActionType(actionType);
        pinfo.setPrcCd(prcCd);
        pinfo.setDraftMessage(num);
        pinfo.setOriMessageID(oriMessageID);
        pinfo.setOriMessageTime(oriMessageTime);
        pinfo.setRegisterAcctSvcr(registerAcctSvcr);
        pinfo.setDraftType(draftType);
        pinfo.setAccptrAcctSvcr(accptrAcctSvcr);
        pinfo.setIsseDt(isseDt);
        pinfo.setDueDt(dueDt);
        pinfo.setIsseAmt(isseAmt);
        PaperDraftActionBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)pinfo);
    }

    public static PaperDraftActionBillInfo findPaperDraftActionBill(Context ctx, String messageId) throws EASBizException, BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("messageId", (Object)messageId));
        viewinfo.setFilter(fi);
        PaperDraftActionBillCollection pc = PaperDraftActionBillFactory.getLocalInstance(ctx).getPaperDraftActionBillCollection(viewinfo);
        if (pc.size() != 0) {
            return pc.get(0);
        }
        return null;
    }

    public static PaperDraftActionBillInfo findPaperDraftActionBillInfoByiD(Context ctx, String rid) throws EASBizException, BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("messageID", (Object)rid));
        viewinfo.setFilter(fi);
        PaperDraftActionBillCollection pc = PaperDraftActionBillFactory.getLocalInstance(ctx).getPaperDraftActionBillCollection(viewinfo);
        if (pc.size() != 0) {
            return pc.get(0);
        }
        return null;
    }

    public static PaperDraftActionBillInfo findPaperDraftActionBillInfoByiD(Context ctx, String rid, boolean flage) throws EASBizException, BOSException {
        EntityViewInfo v1 = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.appendFilterItem("messageID", (Object)rid);
        fi.appendFilterItem("actionType", (Object)ECDSPaperActionStatusEnum.SEND);
        fi.appendFilterItem("actionType", (Object)ECDSPaperActionStatusEnum.SendModify);
        fi.setMaskString("#0 and (#1 or #2)");
        v1.setFilter(fi);
        PaperDraftActionBillCollection pc = PaperDraftActionBillFactory.getLocalInstance(ctx).getPaperDraftActionBillCollection(v1);
        if (pc.size() != 0) {
            return pc.get(0);
        }
        return null;
    }

    public static OperateServiceAgreementInfo checkOperateServiceAgreement(Context ctx, String bizOrgNumber, String actorBank, String acctId) throws BOSException {
        EntityViewInfo v1 = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        v1.setSelector(sic);
        FilterInfo fi = new FilterInfo();
        fi.appendFilterItem("bizOrgNumber", (Object)bizOrgNumber);
        fi.appendFilterItem("bizPayNumber", (Object)acctId);
        fi.appendFilterItem("bizGatherNumber", (Object)acctId);
        fi.appendFilterItem("actorBank", (Object)actorBank);
        fi.appendFilterItem("enable", (Object)new Boolean(true));
        fi.setMaskString("#0 and (#1 or #2) and #3 and #4 ");
        v1.setFilter(fi);
        OperateServiceAgreementCollection oc = OperateServiceAgreementFactory.getLocalInstance(ctx).getOperateServiceAgreementCollection(v1);
        if (oc.size() == 0) {
            return null;
        }
        return oc.get(0);
    }

    public static BEBankInfo checkBEBank(Context ctx, String number) throws BOSException {
        EntityViewInfo v1 = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.appendFilterItem("number", (Object)number);
        v1.setFilter(fi);
        BEBankCollection bc = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(v1);
        if (bc.size() == 0) {
            return null;
        }
        return bc.get(0);
    }

    public static ElecDraftBillInfo addElecDraftBillInfo(ElecDraftBillInfo billInfo, CommercialDraftCommonTransmission cc, Context ctx, String hodorg, String hodAcct, String HodNumber) throws EASBizException, BOSException {
        billInfo = new ElecDraftBillInfo();
        billInfo.setDraftNumber(cc.getComrclDrft().getIdNb());
        billInfo.setDraftType(DraftTypeEnum.getEnum(cc.getComrclDrft().getTp()));
        billInfo.setDraftAmount(new BigDecimal(cc.getComrclDrft().getIsseAmt()));
        billInfo.setDueDate(DateUtil.parseDate(cc.getComrclDrft().getDueDt()));
        billInfo.setBanEndorsement(BanEndorsementMarkEnum.getEnum(cc.getComrclDrft().getBanEndrsmtMk()));
        billInfo.setRemark(cc.getComrclDrft().getRmrk());
        billInfo.setIssueDate(DateUtil.parseDate(cc.getComrclDrft().getIsseDt()));
        billInfo.setDrawerRole(RoleEnum.getEnum(cc.getComrclDrft().getDrwr().getRole()));
        billInfo.setDrawerName(cc.getComrclDrft().getDrwr().getNm());
        billInfo.setDrawerOrgCode(cc.getComrclDrft().getDrwr().getCmonId());
        billInfo.setDrawerAccount(cc.getComrclDrft().getDrwr().getAcct().getId());
        billInfo.setDrawerBank(cc.getComrclDrft().getDrwr().getAcct().getAcctSvcr());
        billInfo.setDrawerCreditRat(cc.getComrclDrft().getDrwr().getCdtRatgs());
        billInfo.setDrawerCdtRater(cc.getComrclDrft().getDrwr().getCdtRatgAgcy());
        billInfo.setBanEndorsement(BanEndorsementMarkEnum.getEnum(cc.getComrclDrft().getBanEndrsmtMk()));
        billInfo.setAcceptorName(cc.getComrclDrft().getAccptr().getNm());
        billInfo.setAcceptorBank(cc.getComrclDrft().getAccptr().getAcct().getAcctSvcr());
        billInfo.setAcceptorAccount(cc.getComrclDrft().getAccptr().getAcct().getId());
        if (cc.getComrclDrft().getDrwr().getCdtRatgDueDt() != null) {
            billInfo.setDrawerRtDueDate(DateUtil.parseDate(cc.getComrclDrft().getDrwr().getCdtRatgDueDt()));
        }
        billInfo.setPayeeAccount(cc.getComrclDrft().getPyee().getAcct().getId());
        billInfo.setPayeeBank(cc.getComrclDrft().getPyee().getAcct().getAcctSvcr());
        billInfo.setPayeeName(cc.getComrclDrft().getPyee().getNm());
        billInfo.setHolderAccount(hodAcct);
        billInfo.setHolderBank(HodNumber);
        billInfo.setHolderOrgCode(hodorg);
        ElecDraftBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)billInfo);
        return billInfo;
    }

    public static SystemStatusInfo getSysStsByMaxId(Context ctx) throws EASBizException, BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        SorterItemCollection sortCol = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        SystemStatusCollection ss = SystemStatusFactory.getLocalInstance(ctx).getSystemStatusCollection(viewinfo);
        if (ss.size() == 0) {
            return null;
        }
        return ss.get(0);
    }

    public static ElecDraftBillEntryCollection findElecDraftBillEntryList(Context ctx, String draftNumber) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)draftNumber));
        SorterItemCollection sortCol = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("seq");
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        ElecDraftBillEntryCollection ec = ElecDraftBillEntryFactory.getLocalInstance(ctx).getElecDraftBillEntryCollection(viewinfo);
        return ec;
    }

    public static ECDSBillStatusEnum findElecDraftBillState(Context ctx, String holderOrgCode, String draftNumber) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("holderOrgCode", (Object)holderOrgCode));
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)draftNumber));
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        ElecDraftActionBillCollection ec = ElecDraftActionBillFactory.getLocalInstance(ctx).getElecDraftActionBillCollection(viewinfo);
        if (ec.size() != 0) {
            return ec.get(0).getCommunicatedDraftStatus();
        }
        return null;
    }

    public static ECDSBillStatusEnum findBydraftNumberBillState(Context ctx, String draftNumber) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)draftNumber));
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        ElecDraftActionBillCollection ec = ElecDraftActionBillFactory.getLocalInstance(ctx).getElecDraftActionBillCollection(viewinfo);
        if (ec.size() != 0) {
            return ec.get(0).getCommunicatedDraftStatus();
        }
        return null;
    }

    public static ECDSBillStatusEnum findElecDraftBillState(Context ctx, String holderOrgCode, String draftNumber, DraftMessageEnum messEnum) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("holderOrgCode", (Object)holderOrgCode));
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)draftNumber));
        fi.getFilterItems().add(new FilterItemInfo("draftMessage", (Object)"M034"));
        fi.getFilterItems().add(new FilterItemInfo("draftMessage", (Object)"M023"));
        fi.setMaskString("( #0 and #1)  and (#2 or #3)");
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        ElecDraftActionBillCollection ec = ElecDraftActionBillFactory.getLocalInstance(ctx).getElecDraftActionBillCollection(viewinfo);
        if (ec.size() != 0) {
            return ec.get(0).getCommunicatedDraftStatus();
        }
        return null;
    }

    public static ElecDraftActionBillCollection findElecDraftActionBill(Context ctx, String draftNumber) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)draftNumber));
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        ElecDraftActionBillCollection ec = ElecDraftActionBillFactory.getLocalInstance(ctx).getElecDraftActionBillCollection(viewinfo);
        return ec;
    }

    public static ElecDraftActionBillInfo findElecDraftActionBill(Context ctx, String holderOrgCode, String draftNumber, DraftMessageEnum messEnum) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)draftNumber));
        fi.getFilterItems().add(new FilterItemInfo("draftMessage", (Object)messEnum));
        if (holderOrgCode != null) {
            fi.getFilterItems().add(new FilterItemInfo("holderOrgCode", (Object)holderOrgCode));
        }
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        ElecDraftActionBillCollection ec = ElecDraftActionBillFactory.getLocalInstance(ctx).getElecDraftActionBillCollection(viewinfo);
        if (ec.size() != 0) {
            return ec.get(0);
        }
        return null;
    }

    public static ElecDraftActionBillCollection findElecDraftActionBill(Context ctx, String draftNumber, ElecDraftActionEnum actiomEnnum) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)draftNumber));
        fi.getFilterItems().add(new FilterItemInfo("actionType", (Object)actiomEnnum));
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        ElecDraftActionBillCollection ec = ElecDraftActionBillFactory.getLocalInstance(ctx).getElecDraftActionBillCollection(viewinfo);
        return ec;
    }

    public static boolean findElecDraftActionBillByBillState(Context ctx, String draftNumber, String holderOrgCode, ECDSBillStatusEnum stateenum) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)draftNumber));
        fi.getFilterItems().add(new FilterItemInfo("communicatedDraftStatus", (Object)stateenum));
        fi.getFilterItems().add(new FilterItemInfo("holderOrgCode", (Object)holderOrgCode));
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        ElecDraftActionBillCollection ec = ElecDraftActionBillFactory.getLocalInstance(ctx).getElecDraftActionBillCollection(viewinfo);
        return ec.size() != 0;
    }

    public static ElecDraftBillEntryInfo findElecDraftBillEntry(Context ctx, String draftNumber, String holderOrgCode, DraftBizTypeEnum stateenum, boolean singe) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)draftNumber));
        fi.getFilterItems().add(new FilterItemInfo("draftBizType", (Object)stateenum));
        if (!singe) {
            fi.getFilterItems().add(new FilterItemInfo("formerOrgCode", (Object)holderOrgCode));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("laterOrgCode", (Object)holderOrgCode));
        }
        SorterItemInfo sortInfo = new SorterItemInfo("draftSignInDate");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        ElecDraftBillEntryInfo info = ElecDraftBillEntryFactory.getLocalInstance(ctx).getElecDraftBillEntryCollection(viewinfo).get(0);
        return info;
    }

    public static ECDSBillStatusEnum findElecDraftActoibBillByTime(Context ctx, String draftNumber, String holderOrgCode, ElecDraftActionEnum actionEnum, DraftMessageEnum draftMessage) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)draftNumber));
        fi.getFilterItems().add(new FilterItemInfo("holderOrgCode", (Object)holderOrgCode));
        if (draftMessage != null) {
            fi.getFilterItems().add(new FilterItemInfo("draftMessage", (Object)draftMessage));
        } else if (actionEnum != null) {
            fi.getFilterItems().add(new FilterItemInfo("actionType", (Object)actionEnum));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("actionType", (Object)ElecDraftActionEnum.SEND));
        }
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        ElecDraftActionBillCollection eColl = ElecDraftActionBillFactory.getLocalInstance(ctx).getElecDraftActionBillCollection(viewinfo);
        int temp = 0;
        if (eColl.size() > 1) {
            for (int i = 0; i < eColl.size(); ++i) {
                ElecDraftActionBillInfo actionInfo = eColl.get(i);
                if ((actionInfo.getDraftMessage() != DraftMessageEnum.M031 || actionInfo.getActionType() != ElecDraftActionEnum.RECEIVE_REPLY_SIGN) && !actionInfo.getDraftMessage().equals((Object)DraftMessageEnum.M040)) continue;
                temp = i + 1;
                break;
            }
            if (temp != 0) {
                return eColl.get(temp).getCommunicatedDraftStatus();
            }
            return null;
        }
        return null;
    }

    public static void insertECoreExceptionTracker(Context ctx, String bizCode, String senderOrgNumber, String draftNumber, boolean isReceived, String number, RequestTypeEnum cmdCode, ECoreExceptionTypeEnum eType, String eCause, String eMsg, String MessageID, String lockedID) throws EASBizException, BOSException {
        ECoreExceptionTrackerInfo info = new ECoreExceptionTrackerInfo();
        info.setBizCode(ECDSCommon.trimString(bizCode, 18));
        info.setSenderOrgNumber(ECDSCommon.trimString(senderOrgNumber, 10));
        info.setDraftNumber(ECDSCommon.trimString(draftNumber, 30));
        info.setDirection(isReceived);
        info.setNumber(ECDSCommon.trimString(number, 3));
        if (cmdCode != null) {
            info.setCmdCode(cmdCode);
        }
        if (eType != null) {
            info.setEType(eType);
        }
        info.setECause(ECDSCommon.trimString(eCause, 200));
        info.setEMsg(ECDSCommon.trimString(eMsg, 200));
        info.setMessageID(ECDSCommon.trimString(MessageID, 44));
        info.setLockedID(ECDSCommon.trimString(lockedID, 44));
        ECoreExceptionTrackerFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
    }

    public static String trimString(String str, int length) {
        if (str == null || str.length() <= length) {
            return str;
        }
        return str.substring(0, length);
    }

    public static synchronized IObjectPK storeMsg(Context ctx, String xmlStr) throws EASBizException, BOSException {
        IObjectPK pk = null;
        String id = ECDSCommon.findMsgNumByXML(xmlStr);
        try {
            String msgNum = ECDSCommon.findMsgTypeByXML(xmlStr);
            pk = ECoreCommandFacadeFactory.getLocalInstance(ctx).saveMsgBak(msgNum, xmlStr, MessageTypeEnum.recMsg, id);
        }
        catch (Exception e) {
            logger.error((Object)e);
            ECoreCommandFacadeFactory.getLocalInstance(ctx).insertECoreExceptionTracker(null, "MBFE", null, true, id, null, ECoreExceptionTypeEnum.REC_STOREMSG, e.getCause().toString(), e.getMessage(), null, null);
        }
        return pk;
    }

    public static String findMsgTypeByXML(String xml) {
        return xml.substring(87, 90);
    }

    public static String findMsgNumByXML(String xml) {
        int start = xml.indexOf("<Id>");
        int end = xml.indexOf("</Id>");
        return xml.substring(start + 4, end);
    }

    public static String findMsgTimeByXML(String xml) {
        int start = xml.indexOf("<CreDtTm>");
        int end = xml.indexOf("</CreDtTm>");
        return xml.substring(start + 9, end);
    }

    public static String findMsgOrgnlMsgId(String xml) {
        int astart = xml.indexOf("<OrgnlMsgId>");
        int aend = xml.indexOf("</OrgnlMsgId>");
        String allStr = xml.substring(astart + 12, aend);
        return ECDSCommon.findMsgNumByXML(allStr);
    }

    public static String findDraftNumByXML(Context ctx, String xml, String msgNum) throws EASBizException, BOSException {
        ElecDraftActionBillInfo actionInfo;
        String rid;
        String msgIdType;
        if ("005".equals(msgNum) || "034".equals(msgNum) || "036".equals(msgNum) || "040".equals(msgNum) || "041".equals(msgNum) || "043".equals(msgNum) || "023".equals(msgNum) || "031".equals(msgNum) || "032".equals(msgNum) || "035".equals(msgNum)) {
            int start = xml.indexOf("<IdNb>");
            int end = xml.indexOf("</IdNb>");
            if (start == -1 || end == -1) {
                return null;
            }
            return xml.substring(start + 6, end);
        }
        if ("033".equals(msgNum.trim()) && "1".equals(msgIdType = ECDSCommon.findMsgIdTypeByMsgId(rid = ECDSCommon.findMsgOrgnlMsgId(xml))) && (actionInfo = ECDSCommon.findCommonStatusByMsgID(ctx, rid)) != null) {
            return actionInfo.getDraftNumber();
        }
        return null;
    }

    public static synchronized boolean isLocked(Context ctx, String draftNumber) throws EASBizException, BOSException {
        return ECoreLockEDraftFactory.getLocalInstance(ctx).exists("select id where draftNumber='" + draftNumber + "'");
    }

    public static ElecDraftBillEntryInfo isElecDraftBillEntryInfo(Context ctx, String idNd, DraftBizTypeEnum typeEnum, String formerOrgCode, String laterOrgCode) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)idNd));
        fi.getFilterItems().add(new FilterItemInfo("draftBizType", (Object)typeEnum));
        fi.getFilterItems().add(new FilterItemInfo("formerOrgCode", (Object)formerOrgCode));
        fi.getFilterItems().add(new FilterItemInfo("laterOrgCode", (Object)laterOrgCode));
        viewinfo.setFilter(fi);
        ElecDraftBillEntryCollection eColl = ElecDraftBillEntryFactory.getLocalInstance(ctx).getElecDraftBillEntryCollection(viewinfo);
        if (eColl.size() != 0) {
            return eColl.get(0);
        }
        return null;
    }

    public static void InsertBusinessNotificationInfo(Context ctx, String bizSerialNumber, String messageId, String idNd, ElecDraftActionEnum actionType, String communicateResult, String holderOrgCode, ECDSBillStatusEnum communicatedDraftStatus, NotificationEnum notificationEnum, SystemTypeEnum typeEnum, Timestamp messtime) throws EASBizException, BOSException {
        BusinessNotificationInfo businessInfo = new BusinessNotificationInfo();
        businessInfo.setDraftNumber(idNd);
        if (idNd != null) {
            ElecDraftBillInfo draftInfo = ECDSCommon.findElecDraftBillInfoByIndb(ctx, idNd);
            businessInfo.setDraftAmount(draftInfo.getDraftAmount().setScale(2));
        }
        businessInfo.setCommunicatedDraftStatus(communicatedDraftStatus);
        businessInfo.setHolderOrgCode(holderOrgCode);
        businessInfo.setCommunicateResult(communicateResult);
        businessInfo.setNotificationType(notificationEnum);
        businessInfo.setMessageID(messageId);
        businessInfo.setActionType(actionType);
        businessInfo.setBizSerialNumber(bizSerialNumber);
        businessInfo.setSystemType(typeEnum);
        businessInfo.setISendClient(false);
        businessInfo.setMessageTime(messtime);
        businessInfo.setIsHandleError(false);
        BusinessNotificationFactory.getLocalInstance(ctx).addnew(businessInfo);
    }

    public static void InsertBusinessNotificationInfoPager(Context ctx, String bizSerialNumber, String messageId, String idNd, ElecDraftActionEnum actionType, String communicateResult, String holderOrgCode, ECDSPaperActionStatusEnum communicatedDraftStatus, NotificationEnum notificationEnum, SystemTypeEnum typeEnum, Timestamp messtime, BigDecimal draftAmount) throws EASBizException, BOSException {
        BusinessNotificationInfo businessInfo = new BusinessNotificationInfo();
        businessInfo.setDraftNumber(idNd);
        businessInfo.setDraftAmount(draftAmount.setScale(2));
        businessInfo.setHolderOrgCode(holderOrgCode);
        businessInfo.setCommunicateResult(communicateResult);
        businessInfo.setNotificationType(notificationEnum);
        businessInfo.setMessageID(messageId);
        businessInfo.setActionType(actionType);
        businessInfo.setBizSerialNumber(bizSerialNumber);
        businessInfo.setSystemType(typeEnum);
        businessInfo.setISendClient(false);
        businessInfo.setMessageTime(messtime);
        businessInfo.setIsHandleError(false);
        businessInfo.setPaperDraftStatus(communicatedDraftStatus);
        BusinessNotificationFactory.getLocalInstance(ctx).addnew(businessInfo);
    }

    static {
        MSG_INFO.put(new DraftRegisterBillInfo().getBOSType().toString(), "001,common,1,1");
        MSG_INFO.put(new AcceptRequestBillInfo().getBOSType().toString(), "002,common,1,1");
        MSG_INFO.put(new TipsTicketCollectorBillInfo().getBOSType().toString(), "003,common,1,1");
        MSG_INFO.put(new BizCancelBillInfo().getBOSType().toString(), "004,common,1,1");
        MSG_INFO.put(new ExceptionNotificationBillInfo().getBOSType().toString(), "035,common,1,1");
        MSG_INFO.put(new DraftRepurchasedRediscountWithCentralBankRequestInfo().getBOSType().toString(), "016,common,1,1");
        MSG_INFO.put(new ActionCancelBillInfo().getBOSType().toString(), "032,common,1,1");
        MSG_INFO.put(new DiscountRequestBillInfo().getBOSType().toString(), "011,common,1,1");
        MSG_INFO.put(new GuaranteeRequestBillInfo().getBOSType().toString(), "017,common,1,1");
        MSG_INFO.put(new RecourseAgreementRequestBillInfo().getBOSType().toString(), "023,common,1,1");
        MSG_INFO.put(new EndorserRequestInfo().getBOSType().toString(), "010,common,1,1");
        MSG_INFO.put(new RepurchaseDiscountRedeemReqInfo().getBOSType().toString(), "012,common,1,1");
        MSG_INFO.put(new ContractCancelBillInfo().getBOSType().toString(), "206,common,1,3");
        MSG_INFO.put(new ContractRescindReqBillInfo().getBOSType().toString(), "207,common,1,3");
        MSG_INFO.put(new ExamineInfo().getBOSType().toString(), "042,common,1,1");
        MSG_INFO.put(new CertificateBindingRequestBillInfo().getBOSType().toString(), "065,intime,1,4");
        MSG_INFO.put(new PromptPaymentReqInfo().getBOSType().toString(), "020,common,1,1");
        MSG_INFO.put(new BizReplyBillInfo().getBOSType().toString(), "031,common,1,1");
        MSG_INFO.put(new RecourseNotificationBillInfo().getBOSType().toString(), "022,common,1,1");
        MSG_INFO.put(new RepurchaseDiscountTurnRedeemReqInfo().getBOSType().toString(), "014,common,1,1");
        MSG_INFO.put(new AgainDiscountApplyBillInfo().getBOSType().toString(), "015,common,1,1");
        MSG_INFO.put(new DiscountAgainInfo().getBOSType().toString(), "013,common,1,1");
        MSG_INFO.put(new OverdueCuePayInfo().getBOSType().toString(), "021,common,1,1");
        MSG_INFO.put(new BankSellingDraftsRequestInfo().getBOSType().toString(), "025,common,1,1");
        MSG_INFO.put(new CollectionRegisterBillInfo().getBOSType().toString(), "107,intime,1,2");
        MSG_INFO.put(new AcceptanceRegisterBillInfo().getBOSType().toString(), "101,common,1,2");
        MSG_INFO.put(new DraftDrawingbackRegisterInfo().getBOSType().toString(), "125,common,1,2");
        MSG_INFO.put(new SettlementRegisterBillInfo().getBOSType().toString(), "108,common,1,2");
        MSG_INFO.put(new SuspendingPaymentRegisterBillInfo().getBOSType().toString(), "110,common,1,2");
        MSG_INFO.put(new PaymentRefusedRegisterBillInfo().getBOSType().toString(), "109,common,1,2");
        MSG_INFO.put(new DiscountRegisterBillInfo().getBOSType().toString(), "102,common,1,2");
        MSG_INFO.put(new RediscountWithCommBankRegisterBillInfo().getBOSType().toString(), "103,intime,1,2");
        MSG_INFO.put(new RediscountWithCentralBankRegisterBillInfo().getBOSType().toString(), "104,intime,1,2");
        MSG_INFO.put(new CollateralizationRegisterBillInfo().getBOSType().toString(), "105,intime,1,2");
        MSG_INFO.put(new RepurchasedCollRegisterBillInfo().getBOSType().toString(), "106,intime,1,2");
        MSG_INFO.put(new AnnulingSuspendingPaymentRegisterBillInfo().getBOSType().toString(), "111,intime,1,2");
        MSG_INFO.put(new RegisterInformationQueryBillInfo().getBOSType().toString(), "121,intime,1,2");
        MSG_INFO.put("F779877D", "058,intime,1,4");
        MSG_INFO.put(new DraftFreeFormatMessageRequestInfo().getBOSType().toString(), "039,intime,0,4");
        MSG_INFO.put(new DraftCreditInfoQueryInfo().getBOSType().toString(), "037,common,0,4");
        MSG_INFO.put(new PledgeReqBillInfo().getBOSType().toString(), "018,common,1,1");
        MSG_INFO.put(new ImpawnUnchainApplyBillInfo().getBOSType().toString(), "019,common,1,1");
        MSG_INFO.put("8315DB69", "124,intime,1,4");
        MSG_INFO.put(new EleConOperationCheckInfo().getBOSType().toString(), "221,common,0,4");
        MSG_INFO.put(new QuotingRequestBillInfo().getBOSType().toString(), "123,intime,0,4");
        MSG_INFO.put(new ContractMonthlyDetailsRequestInfo().getBOSType().toString(), "223,common,0,4");
        MSG_INFO.put(new CtrctOfferXptNoticeBillInfo().getBOSType().toString(), "204,common,1,3");
        MSG_INFO.put(new ContractOfferReqBillInfo().getBOSType().toString(), "201,common,1,3");
        MSG_INFO.put(new BizContractReplyBillInfo().getBOSType().toString(), "205,common,1,3");
        MSG_INFO.put("051", "4");
        MSG_INFO.put("078", "4");
        MSG_INFO.put("074", "4");
        MSG_INFO.put("035", "4");
        MSG_INFO.put("076", "1");
    }
}

