/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.util.BASE64Decoder;
import com.kingdee.eas.util.BASE64Encoder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class EcoreStringUtils {
    private static final Logger logger = CoreUIObject.getLogger(EcoreStringUtils.class);

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(String str1, String str2) {
        return str2 == null ? true : (str1 != null ? str1.equals(str2) : false);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str2 == null ? true : (str1 != null ? str1.equalsIgnoreCase(str2) : false);
    }

    public static String hash(byte[] unencodedPassword, String algorithm) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (Exception e) {
            return null;
        }
        md.reset();
        md.update(unencodedPassword);
        byte[] encodedPassword = md.digest();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < encodedPassword.length; ++i) {
            if ((encodedPassword[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(encodedPassword[i] & 0xFF, 16));
        }
        return buf.toString();
    }

    public static String hash(String password, String algorithm) {
        return EcoreStringUtils.hash(password.getBytes(), algorithm);
    }

    public static String base64Encode(String str) {
        return EcoreStringUtils.base64Encode(str.getBytes());
    }

    public static String base64Encode(byte[] str) {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encodeBuffer(str).trim();
    }

    public static byte[] base64Decode(String str) {
        BASE64Decoder dec = new BASE64Decoder();
        byte[] b = null;
        try {
            b = dec.decodeBuffer(str);
        }
        catch (IOException e) {
            logger.error((Object)e);
            return null;
        }
        return b;
    }

    public static String[] splitString(String data, int[] len) {
        if (data == null) {
            return null;
        }
        if (len == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String tmp1 = data;
        try {
            for (int i = 0; i < len.length; ++i) {
                if (tmp1.getBytes("UTF-8").length < len[i]) {
                    list.add(tmp1);
                    continue;
                }
                String tmp2 = "";
                if (tmp1.substring(0, 1).getBytes("UTF-8").length > len[i]) {
                    list.add("");
                    continue;
                }
                do {
                    tmp2 = tmp2 + tmp1.substring(0, 1);
                } while (!(tmp1 = tmp1.substring(1)).equals("") && (tmp2 + tmp1.substring(0, 1)).getBytes("UTF-8").length <= len[i]);
                list.add(tmp2);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e);
        }
        String[] ret = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = (String)list.get(i);
        }
        return ret;
    }

    public static String toHtml(String s) {
        if (s == null) {
            return s;
        }
        s = EcoreStringUtils.strReplace(s, "&", "&amp;");
        s = EcoreStringUtils.strReplace(s, "<", "&lt;");
        s = EcoreStringUtils.strReplace(s, ">", "&gt;");
        s = EcoreStringUtils.strReplace(s, "\r", "");
        s = EcoreStringUtils.strReplace(s, "\n", "<br>\n");
        s = EcoreStringUtils.strReplace(s, "\"", "&quot;");
        return s;
    }

    public static String toHtmlText(String s) {
        int i;
        if (s == null) {
            return s;
        }
        s = EcoreStringUtils.strReplace(s, "&", "&amp;");
        s = EcoreStringUtils.strReplace(s, "<", "&lt;");
        s = EcoreStringUtils.strReplace(s, ">", "&gt;");
        s = EcoreStringUtils.strReplace(s, "\r", "");
        s = EcoreStringUtils.strReplace(s, "\n\u3000\u3000", "\n");
        for (i = 0; i < 4; ++i) {
            s = EcoreStringUtils.strReplace(s, "\n ", "\n");
        }
        for (i = 0; i < 2; ++i) {
            s = EcoreStringUtils.strReplace(s, "\n\n", "\n");
        }
        s = EcoreStringUtils.strReplace(s, "\n", "\n<p>\u3000\u3000");
        s = "\u3000\u3000" + s;
        return s;
    }

    public static String toText(String s) {
        if (s == null) {
            return s;
        }
        s = EcoreStringUtils.strReplace(s, "\r", "");
        s = EcoreStringUtils.strReplace(s, "<br>\n", "\n");
        return s;
    }

    public static int strToInt(String s) {
        if (s == null) {
            return 0;
        }
        try {
            return Integer.parseInt(s.trim());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static long strToLong(String s) {
        if (s == null) {
            return 0L;
        }
        try {
            return Long.parseLong(s.trim());
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static long[] strsToLongs(String[] s) {
        if (s == null) {
            return null;
        }
        long[] ret = new long[s.length];
        for (int i = 0; i < s.length; ++i) {
            ret[i] = EcoreStringUtils.strToLong(s[i]);
        }
        return ret;
    }

    public static int[] strsToInts(String[] s) {
        if (s == null) {
            return null;
        }
        int[] ret = new int[s.length];
        for (int i = 0; i < s.length; ++i) {
            ret[i] = EcoreStringUtils.strToInt(s[i]);
        }
        return ret;
    }

    public static double strToDouble(String s) {
        if (s == null) {
            return 0.0;
        }
        String temp = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.substring(i, i + 1).equals(",")) continue;
            temp = temp + s.substring(i, i + 1);
        }
        s = temp;
        try {
            return Double.parseDouble(s.trim());
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public static String strReplace(String sBody, String sFrom, String sTo) {
        int i = 0;
        int j = sFrom.length();
        int k = sTo.length();
        while (sBody.indexOf(sFrom, i) != -1) {
            i = sBody.indexOf(sFrom, i);
            sBody = sBody.substring(0, i) + sTo + sBody.substring(i + j);
            i += k;
        }
        return sBody;
    }

    public static byte[] encrypt(byte[] plainText, byte[] passwd, String algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec key = new SecretKeySpec(passwd, algorithm);
        Cipher c1 = Cipher.getInstance(algorithm);
        c1.init(1, key);
        byte[] cipherByte = c1.doFinal(plainText);
        return cipherByte;
    }

    public static byte[] decrypt(byte[] cipherText, byte[] passwd, String algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec key = new SecretKeySpec(passwd, algorithm);
        Cipher c1 = Cipher.getInstance(algorithm);
        c1.init(2, key);
        byte[] clearByte = c1.doFinal(cipherText);
        return clearByte;
    }

    public static void main(String[] args) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
    }
}

