/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ecore.AcceptRequestBillFactory;
import com.kingdee.eas.fm.ecore.AcceptRequestBillInfo;
import com.kingdee.eas.fm.ecore.AgainDiscountApplyBillFactory;
import com.kingdee.eas.fm.ecore.AgainDiscountApplyBillInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.BanEndorsementMarkEnum;
import com.kingdee.eas.fm.ecore.BankSellingDraftsRequestFactory;
import com.kingdee.eas.fm.ecore.BankSellingDraftsRequestInfo;
import com.kingdee.eas.fm.ecore.DiscountAgainFactory;
import com.kingdee.eas.fm.ecore.DiscountAgainInfo;
import com.kingdee.eas.fm.ecore.DiscountRequestBillFactory;
import com.kingdee.eas.fm.ecore.DiscountRequestBillInfo;
import com.kingdee.eas.fm.ecore.DiscountTypeEnum;
import com.kingdee.eas.fm.ecore.DraftRepurchasedRediscountWithCentralBankRequestFactory;
import com.kingdee.eas.fm.ecore.DraftRepurchasedRediscountWithCentralBankRequestInfo;
import com.kingdee.eas.fm.ecore.ElecDraftBillInfo;
import com.kingdee.eas.fm.ecore.EndorserRequestFactory;
import com.kingdee.eas.fm.ecore.EndorserRequestInfo;
import com.kingdee.eas.fm.ecore.GuaranteeRequestBillFactory;
import com.kingdee.eas.fm.ecore.GuaranteeRequestBillInfo;
import com.kingdee.eas.fm.ecore.ImpawnUnchainApplyBillFactory;
import com.kingdee.eas.fm.ecore.ImpawnUnchainApplyBillInfo;
import com.kingdee.eas.fm.ecore.OverdueCuePayFactory;
import com.kingdee.eas.fm.ecore.OverdueCuePayInfo;
import com.kingdee.eas.fm.ecore.PledgeReqBillFactory;
import com.kingdee.eas.fm.ecore.PledgeReqBillInfo;
import com.kingdee.eas.fm.ecore.PromptPaymentReqFactory;
import com.kingdee.eas.fm.ecore.PromptPaymentReqInfo;
import com.kingdee.eas.fm.ecore.ProxyPropositionEnum;
import com.kingdee.eas.fm.ecore.RecourseAgreementRequestBillFactory;
import com.kingdee.eas.fm.ecore.RecourseAgreementRequestBillInfo;
import com.kingdee.eas.fm.ecore.RecourseNotificationBillFactory;
import com.kingdee.eas.fm.ecore.RecourseNotificationBillInfo;
import com.kingdee.eas.fm.ecore.RecourseReasonEnum;
import com.kingdee.eas.fm.ecore.RecourseTypeEnum;
import com.kingdee.eas.fm.ecore.RepurchaseDiscountRedeemReqFactory;
import com.kingdee.eas.fm.ecore.RepurchaseDiscountRedeemReqInfo;
import com.kingdee.eas.fm.ecore.RepurchaseDiscountTurnRedeemReqFactory;
import com.kingdee.eas.fm.ecore.RepurchaseDiscountTurnRedeemReqInfo;
import com.kingdee.eas.fm.ecore.RoleEnum;
import com.kingdee.eas.fm.ecore.SettlementMarkEnum;
import com.kingdee.eas.fm.ecore.TipsTicketCollectorBillFactory;
import com.kingdee.eas.fm.ecore.TipsTicketCollectorBillInfo;
import com.kingdee.eas.fm.ecore.UnconditionalPaymentEnum;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftAcceptanceRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftCentralBankSellingDraftsRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftCollateralizationRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftCommonTransmission;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftDiscountRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftEndorsementRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftGuaranteeRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftIssuanceRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftOverduePresentationRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftPresentationRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRecourseAgreementRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRecourseNotification;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRediscountWithCentralBankRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRediscountWithCommercialBankRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRepurchasedCollateralizationRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRepurchasedDiscountRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRepurchasedRediscountWithCentralBankRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRepurchasedRediscountWithCommercialBankRequest;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.util.DateUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import org.apache.log4j.Logger;

public class AddRequestBill {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ecore.app.ecds.impl.AddRequestBill");

    public TipsTicketCollectorBillInfo addIssuanceRequest(Context ctx, CommercialDraftIssuanceRequest cr, ElecDraftBillInfo billInfo) throws EASBizException, BOSException {
        TipsTicketCollectorBillInfo tipifo = new TipsTicketCollectorBillInfo();
        tipifo.setDrawerElecSign(cr.getDrwr().getElctrncSgntr());
        tipifo.setDrawerRole(RoleEnum.getEnum(cr.getDrwr().getRole()));
        tipifo.setDrawerAccount(cr.getDrwr().getAcct().getId());
        if (cr.getIssnc() != null) {
            tipifo.setDraftRemark(cr.getIssnc().getRmrkByPropsr());
        }
        if (cr.getDrwr().getAgcy() != null) {
            tipifo.setDrawerCarryBank(cr.getDrwr().getAgcy().getAcct().getId());
        }
        tipifo.setDrawerBank(cr.getDrwr().getAcct().getAcctSvcr());
        tipifo.setDraftOrgCode(cr.getDrwr().getCmonId());
        tipifo.setDraftNumber(cr.getComrclDrft().getIdNb());
        tipifo.setDraftAmount(new BigDecimal(cr.getComrclDrft().getIsseAmt()));
        tipifo.setBizPromoterOrgCode(cr.getDrwr().getCmonId());
        tipifo.setIsApplySuccess(ApplyBillStatusEnum.RECEIVE_034_APPLY);
        tipifo.setIsSend(false);
        TipsTicketCollectorBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)tipifo);
        return tipifo;
    }

    public AcceptRequestBillInfo addAcceptanceRequest(Context ctx, CommercialDraftAcceptanceRequest cr, ElecDraftBillInfo billInfo, CommercialDraftCommonTransmission cc) throws EASBizException, BOSException {
        AcceptRequestBillInfo acceptinfo = new AcceptRequestBillInfo();
        acceptinfo.setDraftAmount(new BigDecimal(cr.getComrclDrft().getIsseAmt()).setScale(2));
        acceptinfo.setUcondlConsgnmtMrk(UnconditionalPaymentEnum.getEnum(cr.getAccptnc().getUcondlConsgnmtMrk()));
        if (cr.getAccptnc().getTxlCtrctNb() != null) {
            acceptinfo.setContractNumber(cr.getAccptnc().getTxlCtrctNb());
        }
        acceptinfo.setDrawerElecSign(cr.getAccptnc().getRmrkByPropsr());
        if (cr.getAccptnc().getInvcNb() != null) {
            acceptinfo.setInvoiceNumber(cr.getAccptnc().getInvcNb());
        }
        if (cr.getAccptnc().getBtchNb() != null) {
            acceptinfo.setBtchNumber(cr.getAccptnc().getBtchNb());
        }
        acceptinfo.setDrawerNumber(cr.getComrclDrft().getIdNb());
        acceptinfo.setDrawerRole(RoleEnum.getEnum(cr.getDrwr().getRole()));
        acceptinfo.setDrawerOrgCode(cr.getDrwr().getCmonId());
        acceptinfo.setDrawerAccount(cr.getDrwr().getAcct().getId());
        acceptinfo.setDrawerBank(cr.getDrwr().getAcct().getAcctSvcr());
        if (cc.getAccptr() != null) {
            acceptinfo.setAcceptorCdtRater(cc.getAccptr().getCdtRatgAgcy());
            acceptinfo.setAcceptorCreditRat(cc.getAccptr().getCdtRatgs());
            if (cc.getAccptr().getCdtRatgDueDt() != null) {
                acceptinfo.setAcceptorRtDueDate(DateUtil.parseDate(cc.getAccptr().getCdtRatgDueDt()));
            }
        }
        if (cr.getDrwr().getAgcy() != null) {
            acceptinfo.setDrawerCarryBank(cr.getDrwr().getAgcy().getAcct().getId());
        }
        acceptinfo.setRmrkByPropsr(cr.getAccptnc().getRmrkByPropsr());
        acceptinfo.setBizPromoterOrgCode(cr.getDrwr().getCmonId());
        acceptinfo.setIsApplySuccess(ApplyBillStatusEnum.RECEIVE_034_APPLY);
        acceptinfo.setIsSend(false);
        AcceptRequestBillFactory.getLocalInstance(ctx).addnew(acceptinfo);
        return acceptinfo;
    }

    public EndorserRequestInfo addEndorsementRequest(Context ctx, CommercialDraftEndorsementRequest cr, ElecDraftBillInfo billInfo) throws EASBizException, BOSException {
        EndorserRequestInfo endinfo = new EndorserRequestInfo();
        endinfo.setBillNumber(cr.getComrclDrft().getIdNb());
        endinfo.setBillAmount(new BigDecimal(cr.getComrclDrft().getIsseAmt()));
        endinfo.setBanEndorsement(BanEndorsementMarkEnum.getEnum(cr.getEndrsmt().getBanEndrsmtMk()));
        endinfo.setEndorserRole(RoleEnum.getEnum(cr.getEndrsr().getRole()));
        endinfo.setEndorserName(cr.getEndrsr().getNm());
        endinfo.setEndorserOrgCode(cr.getEndrsr().getCmonId());
        endinfo.setEndorserAccount(cr.getEndrsr().getAcct().getId());
        endinfo.setEndorserBank(cr.getEndrsee().getAcct().getAcctSvcr());
        if (cr.getEndrsr().getAgcy() != null) {
            endinfo.setEndorserAgcyBank(cr.getEndrsr().getAgcy().getAcct().getAcctSvcr());
        }
        if (cr.getEndrsmt().getRmrkByPropsr() != null) {
            endinfo.setRemark(cr.getEndrsmt().getRmrkByPropsr());
        }
        endinfo.setBizDate(DateUtil.parseDate(cr.getEndrsmt().getDt()));
        endinfo.setByEndorserName(cr.getEndrsee().getNm());
        endinfo.setByEndorserAccount(cr.getEndrsee().getAcct().getId());
        endinfo.setByEndorserBank(cr.getEndrsee().getAcct().getAcctSvcr());
        endinfo.setEndorserRemark(cr.getEndrsr().getElctrncSgntr());
        endinfo.setIsSend(false);
        endinfo.setBizPromoterOrgCode(cr.getEndrsr().getCmonId());
        endinfo.setIsApplySuccess(ApplyBillStatusEnum.RECEIVE_034_APPLY);
        EndorserRequestFactory.getLocalInstance(ctx).addnew(endinfo);
        return endinfo;
    }

    public DiscountRequestBillInfo addDiscountRequest(Context ctx, CommercialDraftDiscountRequest cr, ElecDraftBillInfo billInfo) throws EASBizException, BOSException {
        DiscountRequestBillInfo di = new DiscountRequestBillInfo();
        di.setBillNumber(cr.getComrclDrft().getIdNb());
        di.setBillAmount(new BigDecimal(cr.getComrclDrft().getIsseAmt()));
        di.setDiscountType(DiscountTypeEnum.getEnum(cr.getDscnt().getRpdMk()));
        di.setRequestDate(DateUtil.parseDate(cr.getDscnt().getDt()));
        di.setRate(cr.getDscnt().getIntrstRate());
        di.setPayfor(new BigDecimal(cr.getDscnt().getAmt()));
        di.setAssignmentMark(BanEndorsementMarkEnum.getEnum(cr.getDscnt().getBanEndrsmtMk()));
        di.setBalanceMark(SettlementMarkEnum.getEnum(cr.getDscnt().getSttlmMk()));
        di.setDiscounterRemark(cr.getDscnt().getRmrkByPropsr());
        if (cr.getDscnt().getRpdOpenDt() != null) {
            di.setBackOpenDate(DateUtil.parseDate(cr.getDscnt().getRpdOpenDt()));
        }
        if (cr.getDscnt().getRpdDueDt() != null) {
            di.setBackCloseDate(DateUtil.parseDate(cr.getDscnt().getRpdDueDt()));
        }
        di.setBackRate(cr.getDscnt().getRpdIntrstRate());
        if (cr.getDscnt().getRpdAmt() != null) {
            di.setBackMoney(new BigDecimal(cr.getDscnt().getRpdAmt()));
        }
        if (cr.getDscnt().getTxlCtrctNb() != null) {
            di.setTxCtrctNb(cr.getDscnt().getTxlCtrctNb());
        }
        if (cr.getDscnt().getInvcNb() != null) {
            di.setInvcNb(cr.getDscnt().getInvcNb());
        }
        if (cr.getDscnt().getBtchNb() != null) {
            di.setBtchNb(new BigDecimal(cr.getDscnt().getBtchNb()));
        }
        di.setDiscounterRemark(cr.getDscnt().getRmrkByPropsr());
        di.setDiscounterAccount(cr.getDscntPropsr().getAcct().getId());
        di.setAccountId(cr.getAOAccnInf().getId());
        di.setBankId(cr.getAOAccnInf().getAcctSvcr());
        di.setDiscounterType(RoleEnum.getEnum(cr.getDscntPropsr().getRole()));
        di.setDiscounterName(cr.getDscntPropsr().getNm());
        di.setGroupId(cr.getDscntPropsr().getCmonId());
        di.setDiscounterSgin(cr.getDscntPropsr().getElctrncSgntr());
        di.setDiscounterBank(cr.getDscntPropsr().getAcct().getAcctSvcr());
        if (cr.getDscntPropsr().getAgcy() != null) {
            di.setDiscounterBankBak(cr.getDscntPropsr().getAgcy().getAcct().getAcctSvcr());
        }
        di.setByDiscounterName(cr.getDscntBk().getNm());
        di.setByDiscounterAccount(cr.getDscntBk().getAcct().getId());
        di.setByDiscounterBank(cr.getDscntBk().getAcct().getAcctSvcr());
        di.setIsSend(false);
        di.setBizPromoterOrgCode(cr.getDscntPropsr().getCmonId());
        di.setIsApplySuccess(ApplyBillStatusEnum.RECEIVE_034_APPLY);
        DiscountRequestBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)di);
        return di;
    }

    public RepurchaseDiscountRedeemReqInfo AddRepurchasedDiscountRequest(Context ctx, CommercialDraftRepurchasedDiscountRequest cr, ElecDraftBillInfo billInfo) throws EASBizException, BOSException {
        RepurchaseDiscountRedeemReqInfo di = new RepurchaseDiscountRedeemReqInfo();
        di.setDraftNumber(cr.getComrclDrft().getIdNb());
        di.setDraftAmount(new BigDecimal(cr.getComrclDrft().getIsseAmt()));
        di.setRedeemInterRate(cr.getRpdDscnt().getIntrstRate());
        di.setRedeemPaidAmt(cr.getRpdDscnt().getAmt());
        di.setReqDate(DateUtil.parseDate(cr.getRpdDscnt().getDt()));
        di.setBanEndorsement(BanEndorsementMarkEnum.getEnum(String.valueOf(cr.getRpdDscnt().getBanEndrsmtMk())));
        di.setSettlementMark(SettlementMarkEnum.getEnum(String.valueOf(cr.getRpdDscnt().getSttlmMk())));
        di.setDrawerRole(RoleEnum.getEnum(cr.getDscntBk().getRole()));
        di.setDrawerOrgCode(cr.getDscntBk().getCmonId());
        di.setDrawerElecSign(cr.getDscntBk().getAcct().getId());
        di.setDrawerAccount(cr.getDscntBk().getAcct().getId());
        di.setDrawerBank(cr.getDscntBk().getAcct().getAcctSvcr());
        di.setRemark(cr.getRpdDscnt().getRmrkByPropsr());
        if (cr.getRpdDscnt().getBtchNb() != null) {
            di.setBatch(cr.getRpdDscnt().getBtchNb());
        }
        di.setIsSend(false);
        di.setBizPromoterOrgCode(cr.getDscntBk().getCmonId());
        di.setIsApplySuccess(ApplyBillStatusEnum.RECEIVE_034_APPLY);
        RepurchaseDiscountRedeemReqFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)di);
        return di;
    }

    public DiscountAgainInfo addRediscountWithCommercialBankRequest(Context ctx, CommercialDraftRediscountWithCommercialBankRequest cr, ElecDraftBillInfo billInfo) throws EASBizException, BOSException {
        DiscountAgainInfo di = new DiscountAgainInfo();
        di.setBillNumber(cr.getComrclDrft().getIdNb());
        di.setBillAmount(new BigDecimal(cr.getComrclDrft().getIsseAmt()));
        di.setDiscountType(DiscountTypeEnum.getEnum(cr.getRdscntWthComrclBk().getRpdMk()));
        di.setRequestDate(DateUtil.parseDate(cr.getRdscntWthComrclBk().getDt()));
        di.setRate(cr.getRdscntWthComrclBk().getIntrstRate());
        di.setPayfor(new BigDecimal(cr.getRdscntWthComrclBk().getAmt()));
        di.setAssignmentMark(BanEndorsementMarkEnum.getEnum(cr.getRdscntWthComrclBk().getBanEndrsmtMk()));
        di.setBalanceMark(SettlementMarkEnum.getEnum(cr.getRdscntWthComrclBk().getSttlmMk()));
        if (cr.getRdscntWthComrclBk().getRpdOpenDt() != null) {
            di.setBackOpenDate(DateUtil.parseDate(cr.getRdscntWthComrclBk().getRpdOpenDt()));
        }
        if (cr.getRdscntWthComrclBk().getRpdDueDt() != null) {
            di.setBackCloseDate(DateUtil.parseDate(cr.getRdscntWthComrclBk().getRpdDueDt()));
        }
        di.setBackRate(cr.getRdscntWthComrclBk().getRpdIntrstRate());
        if (cr.getRdscntWthComrclBk().getRpdAmt() != null) {
            di.setBackMoney(new BigDecimal(cr.getRdscntWthComrclBk().getRpdAmt()));
        }
        if (cr.getRdscntWthComrclBk().getBtchNb() != null) {
            di.setBtchNb(new BigDecimal(cr.getRdscntWthComrclBk().getBtchNb()));
        }
        di.setDiscounterRemark(cr.getRdscntWthComrclBk().getRmrkByPropsr());
        di.setDiscounterAccount(cr.getRqstngBkOfRdscntWthComrclBk().getAcct().getId());
        di.setDiscounterType(RoleEnum.getEnum(cr.getRqstngBkOfRdscntWthComrclBk().getRole()));
        di.setDiscounterName(cr.getRqstngBkOfRdscntWthComrclBk().getNm());
        di.setGroupId(cr.getRqstngBkOfRdscntWthComrclBk().getCmonId());
        di.setDiscounterSgin(cr.getRqstngBkOfRdscntWthComrclBk().getElctrncSgntr());
        di.setDiscounterBank(cr.getRqstngBkOfRdscntWthComrclBk().getAcct().getAcctSvcr());
        di.setByDiscounterName(cr.getRcvgBkOfRdscntWthComrclBk().getNm());
        di.setByDiscounterAccount(cr.getRcvgBkOfRdscntWthComrclBk().getAcct().getId());
        di.setByDiscounterBank(cr.getRcvgBkOfRdscntWthComrclBk().getAcct().getAcctSvcr());
        di.setIsSend(false);
        di.setBizPromoterOrgCode(cr.getRqstngBkOfRdscntWthComrclBk().getCmonId());
        di.setIsApplySuccess(ApplyBillStatusEnum.RECEIVE_034_APPLY);
        DiscountAgainFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)di);
        return di;
    }

    public RepurchaseDiscountTurnRedeemReqInfo addRepurchasedRediscountWithCommercialBankRequest(Context ctx, CommercialDraftRepurchasedRediscountWithCommercialBankRequest cr, ElecDraftBillInfo billInfo) throws EASBizException, BOSException {
        RepurchaseDiscountTurnRedeemReqInfo di = new RepurchaseDiscountTurnRedeemReqInfo();
        di.setDraftNumber(cr.getComrclDrft().getIdNb());
        di.setDraftAmount(new BigDecimal(cr.getComrclDrft().getIsseAmt()));
        di.setReqDate(DateUtil.parseDate(cr.getRpdRdscntWthComrclBk().getDt()));
        di.setRedeemInterRate(cr.getRpdRdscntWthComrclBk().getIntrstRate());
        di.setRedeemPaidAmt(new BigDecimal(cr.getRpdRdscntWthComrclBk().getAmt()));
        di.setBanEndorsement(BanEndorsementMarkEnum.getEnum(String.valueOf(cr.getRpdRdscntWthComrclBk().getBanEndrsmtMk())));
        di.setSettlementMark(SettlementMarkEnum.getEnum(String.valueOf(cr.getRpdRdscntWthComrclBk().getSttlmMk())));
        di.setRemark(cr.getRpdRdscntWthComrclBk().getRmrkBypRopsr());
        di.setDrawerRole(RoleEnum.getEnum(cr.getOrgnlRcvgBkOfRdscntWthComrclBk().getRole()));
        di.setDrawerOrgCode(cr.getOrgnlRcvgBkOfRdscntWthComrclBk().getCmonId());
        di.setDrawerElecSign(cr.getOrgnlRcvgBkOfRdscntWthComrclBk().getAcct().getId());
        di.setDrawerAccount(cr.getOrgnlRcvgBkOfRdscntWthComrclBk().getAcct().getId());
        di.setDrawerBank(cr.getOrgnlRcvgBkOfRdscntWthComrclBk().getAcct().getAcctSvcr());
        di.setIsSend(false);
        di.setBizPromoterOrgCode(cr.getOrgnlRcvgBkOfRdscntWthComrclBk().getCmonId());
        di.setIsApplySuccess(ApplyBillStatusEnum.RECEIVE_034_APPLY);
        RepurchaseDiscountTurnRedeemReqFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)di);
        return di;
    }

    public AgainDiscountApplyBillInfo addRediscountWithCentralBankRequest(Context ctx, CommercialDraftRediscountWithCentralBankRequest cr, ElecDraftBillInfo billInfo) throws EASBizException, BOSException {
        AgainDiscountApplyBillInfo agininfo = new AgainDiscountApplyBillInfo();
        agininfo.setAgainDiscountType(DiscountTypeEnum.getEnum(cr.getRdscntWthCntrlBk().getRpdMk()));
        agininfo.setAgainDiscountApplyDate(DateUtil.parseDate(cr.getRdscntWthCntrlBk().getDt()));
        agininfo.setAgainDiscountRate(cr.getRdscntWthCntrlBk().getIntrstRate());
        agininfo.setFactAmount(new BigDecimal(cr.getRdscntWthCntrlBk().getAmt()));
        agininfo.setBanEndorsement(BanEndorsementMarkEnum.getEnum(cr.getRdscntWthCntrlBk().getBanEndrsmtMk()));
        agininfo.setSettlementOnline(SettlementMarkEnum.getEnum(cr.getRdscntWthCntrlBk().getSttlmMk()));
        if (cr.getRdscntWthCntrlBk().getRpdOpenDt() != null) {
            agininfo.setRedeemStartDate(DateUtil.parseDate(cr.getRdscntWthCntrlBk().getRpdOpenDt()));
        }
        if (cr.getRdscntWthCntrlBk().getRpdDueDt() != null) {
            agininfo.setRedeemEndDate(DateUtil.parseDate(cr.getRdscntWthCntrlBk().getRpdDueDt()));
        }
        if (cr.getRdscntWthCntrlBk().getRpdIntrstRate() != null) {
            agininfo.setRedeemRate(cr.getRdscntWthCntrlBk().getRpdIntrstRate());
        }
        if (cr.getRdscntWthCntrlBk().getRpdAmt() != null) {
            agininfo.setRedeemAmount(new BigDecimal(cr.getRdscntWthCntrlBk().getRpdAmt()));
        }
        if (cr.getRdscntWthCntrlBk().getBtchNb() != null) {
            agininfo.setBatchNumber(cr.getRdscntWthCntrlBk().getBtchNb());
        }
        if (cr.getRdscntWthCntrlBk().getRmrkByPropsr() != null) {
            agininfo.setDrawerRemark(cr.getRdscntWthCntrlBk().getRmrkByPropsr());
        }
        agininfo.setDrawerRole(RoleEnum.getEnum(cr.getRqstngBkOfRdscntWthCntrlBk().getRole()));
        agininfo.setDrawerOrgCode(cr.getRqstngBkOfRdscntWthCntrlBk().getCmonId());
        agininfo.setElectricSign(cr.getRqstngBkOfRdscntWthCntrlBk().getElctrncSgntr());
        agininfo.setDrawerName(cr.getRqstngBkOfRdscntWthCntrlBk().getNm());
        agininfo.setDiscountInAccount(cr.getRdscntWthCntrlBkSys().getAcct().getId());
        agininfo.setDiscountInBank(cr.getRdscntWthCntrlBkSys().getAcct().getAcctSvcr());
        agininfo.setDiscountInName(cr.getRdscntWthCntrlBkSys().getNm());
        agininfo.setDraftNumber(cr.getComrclDrft().getIdNb());
        agininfo.setDraftAmount(new BigDecimal(cr.getComrclDrft().getIsseAmt()));
        agininfo.setIsSend(false);
        agininfo.setBizPromoterOrgCode(cr.getRqstngBkOfRdscntWthCntrlBk().getCmonId());
        agininfo.setIsApplySuccess(ApplyBillStatusEnum.RECEIVE_034_APPLY);
        AgainDiscountApplyBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)agininfo);
        return agininfo;
    }

    public DraftRepurchasedRediscountWithCentralBankRequestInfo addDraftRepurchasedRediscountWithCentralBankRequest(Context ctx, CommercialDraftRepurchasedRediscountWithCentralBankRequest cr, ElecDraftBillInfo billInfo) throws EASBizException, BOSException {
        DraftRepurchasedRediscountWithCentralBankRequestInfo draftinfo = new DraftRepurchasedRediscountWithCentralBankRequestInfo();
        draftinfo.setDraftNumber(cr.getComrclDrft().getIdNb());
        draftinfo.setDraftAmount(new BigDecimal(cr.getComrclDrft().getIsseAmt()));
        draftinfo.setDiscountDate(DateUtil.parseDate(cr.getRpdRdscntWthCntrlBk().getDt()));
        draftinfo.setDiscountAmount(new BigDecimal(cr.getRpdRdscntWthCntrlBk().getAmt()));
        draftinfo.setDiscountRate(new BigDecimal(cr.getRpdRdscntWthCntrlBk().getIntrstRate()));
        draftinfo.setDiscountBanEndrsmtMk(BanEndorsementMarkEnum.getEnum(cr.getRpdRdscntWthCntrlBk().getBanEndrsmtMk()));
        draftinfo.setDiscountSttlmMk(SettlementMarkEnum.getEnum(cr.getRpdRdscntWthCntrlBk().getSttlmMk()));
        draftinfo.setDiscountRmrkByPropsr(cr.getRpdRdscntWthCntrlBk().getRmrkByPropsr());
        if (cr.getRpdRdscntWthCntrlBk().getBtchNb() != null) {
            draftinfo.setDiscountBatch(cr.getRpdRdscntWthCntrlBk().getBtchNb());
        }
        draftinfo.setDiscountRmrkByPropsr(cr.getRpdRdscntWthCntrlBk().getRmrkByPropsr());
        draftinfo.setRdscntType(RoleEnum.getEnum(cr.getRdscntWthCntrlBkSys().getRole()));
        draftinfo.setRdscntElctrncSgntr(cr.getRdscntWthCntrlBkSys().getElctrncSgntr());
        draftinfo.setRdscntOrgCode(cr.getRdscntWthCntrlBkSys().getCmonId());
        draftinfo.setRdscntElctrncSgntr(cr.getRdscntWthCntrlBkSys().getElctrncSgntr());
        draftinfo.setRdscntAccount(cr.getRdscntWthCntrlBkSys().getAcct().getId());
        draftinfo.setRdscntBank(cr.getRdscntWthCntrlBkSys().getAcct().getAcctSvcr());
        draftinfo.setIsSend(false);
        draftinfo.setBizPromoterOrgCode(cr.getRdscntWthCntrlBkSys().getCmonId());
        draftinfo.setIsApplySuccess(ApplyBillStatusEnum.RECEIVE_034_APPLY);
        DraftRepurchasedRediscountWithCentralBankRequestFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)draftinfo);
        return draftinfo;
    }

    public GuaranteeRequestBillInfo addGuaranteeRequest(Context ctx, CommercialDraftGuaranteeRequest cr, ElecDraftBillInfo billInfo) throws EASBizException, BOSException {
        GuaranteeRequestBillInfo gruarantinfo = new GuaranteeRequestBillInfo();
        gruarantinfo.setDraftNumber(cr.getComrclDrft().getIdNb());
        gruarantinfo.setDraftAmount(new BigDecimal(cr.getComrclDrft().getIsseAmt()));
        gruarantinfo.setApplyDate(DateUtil.parseDate(cr.getGuarntee().getDt()));
        gruarantinfo.setWarranteeRemark(cr.getGuarntee().getRmrkByPropsr());
        if (cr.getGuarntee().getBtchNb() != null) {
            gruarantinfo.setBatchNumber(cr.getGuarntee().getBtchNb());
        }
        if (cr.getGuarntee().getRmrkByPropsr() != null) {
            gruarantinfo.setWarranteeRemark(cr.getGuarntee().getRmrkByPropsr());
        }
        gruarantinfo.setWarranteeRole(RoleEnum.getEnum(cr.getWarntee().getRole()));
        gruarantinfo.setWarranteeName(cr.getWarntee().getNm());
        gruarantinfo.setWarranteeOrgCode(cr.getWarntee().getCmonId());
        gruarantinfo.setWarranteeElecSign(cr.getWarntee().getElctrncSgntr());
        gruarantinfo.setWarranteeBank(cr.getWarntee().getAcct().getAcctSvcr());
        gruarantinfo.setWarranteeAccount(cr.getWarntee().getAcct().getId());
        gruarantinfo.setGuarantorAccount(cr.getGuarntr().getAcct().getId());
        gruarantinfo.setGuarantorBank(cr.getGuarntr().getAcct().getAcctSvcr());
        gruarantinfo.setGuarantorName(cr.getGuarntr().getNm());
        gruarantinfo.setIsSend(false);
        gruarantinfo.setBizPromoterOrgCode(cr.getWarntee().getCmonId());
        gruarantinfo.setIsApplySuccess(ApplyBillStatusEnum.RECEIVE_034_APPLY);
        GuaranteeRequestBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)gruarantinfo);
        return gruarantinfo;
    }

    public PledgeReqBillInfo addCollateralizationRequest(Context ctx, CommercialDraftCollateralizationRequest cr, ElecDraftBillInfo billInfo) throws EASBizException, BOSException {
        PledgeReqBillInfo pleinfo = new PledgeReqBillInfo();
        pleinfo.setDraftNumber(cr.getComrclDrft().getIdNb());
        pleinfo.setDraftAmount(new BigDecimal(cr.getComrclDrft().getIsseAmt()).setScale(2));
        pleinfo.setIssueDate(DateUtil.parseDate(cr.getCollztn().getDt()));
        if (cr.getCollztn().getBtchNb() != null) {
            pleinfo.setBatchNum(cr.getCollztn().getBtchNb());
        }
        pleinfo.setRemark(cr.getCollztn().getRmrkByPropsr());
        pleinfo.setDrawerRole(RoleEnum.getEnum(cr.getCollztnPropsr().getRole()));
        pleinfo.setDrawerOrgCode(cr.getCollztnPropsr().getCmonId());
        pleinfo.setDrawerName(cr.getCollztnPropsr().getNm());
        pleinfo.setDrawerAccount(cr.getCollztnPropsr().getAcct().getId());
        pleinfo.setDrawerBank(cr.getCollztnPropsr().getAcct().getAcctSvcr());
        pleinfo.setDrawerElecSign(cr.getCollztnPropsr().getElctrncSgntr());
        pleinfo.setPledgeName(cr.getCollztnBk().getNm());
        pleinfo.setPledgeBank(cr.getCollztnBk().getAcct().getAcctSvcr());
        pleinfo.setPledgeAccepBank(null);
        pleinfo.setPledgeAccount(cr.getCollztnBk().getAcct().getId());
        pleinfo.setIsSend(false);
        pleinfo.setBizPromoterOrgCode(cr.getCollztnPropsr().getCmonId());
        pleinfo.setIsApplySuccess(ApplyBillStatusEnum.RECEIVE_034_APPLY);
        PledgeReqBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)pleinfo);
        return pleinfo;
    }

    public ImpawnUnchainApplyBillInfo addDraftRepurchasedCollateralizationRequest(Context ctx, CommercialDraftRepurchasedCollateralizationRequest cr, ElecDraftBillInfo billInfo) throws EASBizException, BOSException {
        ImpawnUnchainApplyBillInfo impinfo = new ImpawnUnchainApplyBillInfo();
        impinfo.setDraftNumber(cr.getComrclDrft().getIdNb());
        impinfo.setDraftAmount(new BigDecimal(cr.getComrclDrft().getIsseAmt()));
        impinfo.setImpawnUnchainDate(DateUtil.parseDate(cr.getRpdCollztn().getDt()));
        if (cr.getRpdCollztn().getBtchNb() != null) {
            impinfo.setBatchNumber(cr.getRpdCollztn().getBtchNb());
        }
        if (cr.getRpdCollztn().getRmrkByPropsr() != null) {
            impinfo.setPawneeRemark(cr.getRpdCollztn().getRmrkByPropsr());
        }
        impinfo.setPawneeRemark(cr.getRpdCollztn().getRmrkByPropsr());
        impinfo.setImpawnType(RoleEnum.getEnum(cr.getCollztnBk().getRole()));
        impinfo.setImpawnName(ECDSCommon.findbyComid(cr.getCollztnBk().getAcct().getId(), null, ctx, cr.getCollztnBk().getCmonId()).getOrgUnitName());
        impinfo.setImpawnOrgCode(cr.getCollztnBk().getCmonId());
        impinfo.setImpawnAccount(cr.getCollztnBk().getAcct().getId());
        impinfo.setElectricSign(cr.getCollztnBk().getElctrncSgntr());
        impinfo.setImpawnBank(cr.getCollztnBk().getAcct().getAcctSvcr());
        impinfo.setIsSend(false);
        impinfo.setBizPromoterOrgCode(cr.getCollztnBk().getCmonId());
        impinfo.setIsApplySuccess(ApplyBillStatusEnum.RECEIVE_034_APPLY);
        ImpawnUnchainApplyBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)impinfo);
        return impinfo;
    }

    public PromptPaymentReqInfo addPresentationRequest(Context ctx, CommercialDraftPresentationRequest cr, ElecDraftBillInfo billInfo) throws EASBizException, BOSException {
        PromptPaymentReqInfo proinfo = new PromptPaymentReqInfo();
        proinfo.setRemark(cr.getPrsnttn().getRmrkByPropsr());
        proinfo.setPaymentDate(DateUtil.parseDate(cr.getPrsnttn().getApplDt()));
        proinfo.setPaymentAmount(new BigDecimal(cr.getPrsnttn().getAmt()));
        proinfo.setSettlementMark(SettlementMarkEnum.getEnum(cr.getPrsnttn().getSttlmMk()));
        proinfo.setProxyPropositio(ProxyPropositionEnum.getEnum(cr.getPrsnttn().getPrxyPropstn()));
        if (cr.getPrsnttn().getRmrkByPropsr() != null) {
            proinfo.setDraweeRemark(cr.getPrsnttn().getRmrkByPropsr());
        }
        proinfo.setDraftAmount(new BigDecimal(cr.getComrclDrft().getIsseAmt()));
        proinfo.setDraftNumber(cr.getComrclDrft().getIdNb());
        proinfo.setRoleType(RoleEnum.getEnum(cr.getDrftHldr().getRole()));
        proinfo.setReloAccount(cr.getDrftHldr().getAcct().getId());
        proinfo.setReloBank(cr.getDrftHldr().getAcct().getAcctSvcr());
        proinfo.setRoleName(cr.getDrftHldr().getNm());
        proinfo.setOrgCode(cr.getDrftHldr().getCmonId());
        proinfo.setIsSend(false);
        proinfo.setBizPromoterOrgCode(cr.getDrftHldr().getCmonId());
        proinfo.setIsApplySuccess(ApplyBillStatusEnum.RECEIVE_034_APPLY);
        PromptPaymentReqFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)proinfo);
        return proinfo;
    }

    public OverdueCuePayInfo addOverduePresentationRequest(Context ctx, CommercialDraftOverduePresentationRequest cr, ElecDraftBillInfo billInfo) throws EASBizException, BOSException {
        OverdueCuePayInfo info = new OverdueCuePayInfo();
        info.setDraftNumber(cr.getComrclDrft().getIdNb());
        info.setDraftAmount(new BigDecimal(cr.getComrclDrft().getIsseAmt()));
        info.setOverdueDate(DateUtil.parseDate(cr.getOvrduePrsnttn().getApplDt()));
        info.setOverdueAmount(new BigDecimal(cr.getOvrduePrsnttn().getAmt()));
        info.setOverdueReason(cr.getOvrduePrsnttn().getRsn());
        info.setDrawerRole(RoleEnum.getEnum(cr.getDrftHldr().getRole()));
        info.setPayerRemark(cr.getOvrduePrsnttn().getRmrkByPropsr());
        info.setOverdueReason(cr.getOvrduePrsnttn().getDshnrRsn());
        if (cr.getOvrduePrsnttn().getDt() != null) {
            info.setOverdueDate(DateUtil.parseDate(cr.getOvrduePrsnttn().getDt()));
        }
        info.setElectricSign(cr.getDrftHldr().getElctrncSgntr());
        info.setDrawerName(cr.getDrftHldr().getNm());
        info.setDrawerOrgCode(cr.getDrftHldr().getCmonId());
        info.setDrawerAccount(cr.getDrftHldr().getAcct().getId());
        info.setDrawerBank(cr.getDrftHldr().getAcct().getAcctSvcr());
        info.setElectricSign(cr.getDrftHldr().getElctrncSgntr());
        info.setSettlementOnline(SettlementMarkEnum.getEnum(cr.getOvrduePrsnttn().getSttlmMk()));
        info.setIsSend(false);
        info.setBizPromoterOrgCode(cr.getDrftHldr().getCmonId());
        info.setIsApplySuccess(ApplyBillStatusEnum.RECEIVE_034_APPLY);
        IObjectPK pk = OverdueCuePayFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
        String sql = "update T_ECR_OverdueCuePay set FOverdueReason=?,FPayerRemark=? where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{cr.getOvrduePrsnttn().getRsn(), cr.getOvrduePrsnttn().getRmrkByPropsr(), pk.toString()});
        return info;
    }

    public RecourseNotificationBillInfo addRecourseNotification(Context ctx, CommercialDraftRecourseNotification cr) throws BOSException, EASBizException {
        RecourseNotificationBillInfo info = new RecourseNotificationBillInfo();
        info.setRecoursElecSign(cr.getRcrsr().getElctrncSgntr());
        info.setRecourseType(RecourseTypeEnum.getEnum(cr.getRcrs().getTp()));
        info.setRecourseData(DateUtil.parseDate(cr.getRcrs().getApplDt()));
        info.setRecourseAccout(cr.getRcrs().getReqAmt());
        info.setRecourseCode(RecourseReasonEnum.getEnum(cr.getRcrs().getRcrsRsnCd()));
        info.setRecourseRemark(cr.getRcrs().getRcrsRmrk());
        info.setRecourseRole(RoleEnum.getEnum(cr.getRcrsr().getRole()));
        info.setRecourseName(cr.getRcrsr().getNm());
        info.setRecourseBizCode(cr.getRcrsr().getCmonId());
        info.setRecourseAccout(cr.getRcrsr().getAcct().getId());
        info.setRecourseBank(cr.getRcrsr().getAcct().getAcctSvcr());
        if (cr.getRcrsr().getAgcy() != null && cr.getRcrsr().getAgcy().getAcct().getAcctSvcr() != null) {
            info.setRecourseCarryBa(cr.getRcrsr().getAgcy().getAcct().getAcctSvcr());
        }
        info.setByRecName(cr.getRcvgPrsnOfRcrs().getNm());
        info.setByRecCode(cr.getRcvgPrsnOfRcrs().getCmonId());
        info.setByRecAccout(cr.getRcvgPrsnOfRcrs().getAcct().getId());
        info.setByRecBank(cr.getRcvgPrsnOfRcrs().getAcct().getAcctSvcr());
        if (cr.getRcvgPrsnOfRcrs().getAgcy() != null && cr.getRcvgPrsnOfRcrs().getAgcy().getAcct().getAcctSvcr() != null) {
            info.setByRecCarryBank(cr.getRcvgPrsnOfRcrs().getAgcy().getAcct().getAcctSvcr());
        }
        info.setDraftNumber(cr.getComrclDrft().getIdNb());
        info.setDraftAmount(new BigDecimal(cr.getComrclDrft().getIsseAmt()));
        info.setIsSend(false);
        info.setBizPromoterOrgCode(cr.getRcrsr().getCmonId());
        info.setIsApplySuccess(ApplyBillStatusEnum.RECEIVE_034_APPLY);
        info.setRecourseAmount(new BigDecimal(cr.getRcrs().getReqAmt()));
        RecourseNotificationBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
        return info;
    }

    public RecourseAgreementRequestBillInfo addRecourseAgreementRequest(Context ctx, CommercialDraftRecourseAgreementRequest commAgreement) throws BOSException, EASBizException {
        RecourseAgreementRequestBillInfo info = new RecourseAgreementRequestBillInfo();
        String idNb = commAgreement.getComrclDrft().getIdNb();
        info.setOrgMessageId(commAgreement.getOrgnlMsgId().getId());
        info.setOrgMessageTime(ECDSCommon.getTimestampByStr(commAgreement.getOrgnlMsgId().getCreDtTm()));
        info.setDraftNumber(idNb);
        info.setDraftAmount(new BigDecimal(commAgreement.getComrclDrft().getIsseAmt()));
        try {
            info.setAgreeDate(DateTimeUtils.parseDate((String)commAgreement.getRcrs().getDt()));
        }
        catch (ParseException e) {
            throw new BOSException(e.getMessage());
        }
        info.setAgreeAmount(new BigDecimal(commAgreement.getRcrs().getAmt()));
        info.setAgreeRemark(commAgreement.getRcrs().getRcrsAgrmtRmrk());
        info.setAgreemanType(RoleEnum.getEnum(commAgreement.getRcvgPrsnOfRcrs().getRole()));
        info.setAgreemanName(commAgreement.getRcvgPrsnOfRcrs().getNm());
        info.setGroupId(commAgreement.getRcvgPrsnOfRcrs().getCmonId());
        info.setAgreemanSgin(commAgreement.getRcvgPrsnOfRcrs().getElctrncSgntr());
        info.setAgreemanAccount(commAgreement.getRcvgPrsnOfRcrs().getAcct().getId());
        info.setAgreemanBank(commAgreement.getRcvgPrsnOfRcrs().getAcct().getAcctSvcr());
        info.setDraftNumber(commAgreement.getComrclDrft().getIdNb());
        info.setDraftAmount(new BigDecimal(commAgreement.getComrclDrft().getIsseAmt()));
        if (commAgreement.getRcvgPrsnOfRcrs().getAgcy() != null) {
            info.setAgreemanBankBak(commAgreement.getRcvgPrsnOfRcrs().getAgcy().getAcct().getAcctSvcr());
        }
        info.setShowMark("02");
        info.setIsSend(false);
        info.setBizPromoterOrgCode(commAgreement.getRcvgPrsnOfRcrs().getCmonId());
        info.setIsApplySuccess(ApplyBillStatusEnum.RECEIVE_034_APPLY);
        RecourseAgreementRequestBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
        return info;
    }

    public BankSellingDraftsRequestInfo addBankSellingDraftsRequest(Context ctx, CommercialDraftCentralBankSellingDraftsRequest cr, ElecDraftBillInfo billInfo) throws EASBizException, BOSException {
        BankSellingDraftsRequestInfo baninfo = new BankSellingDraftsRequestInfo();
        baninfo.setDrafNumber(cr.getComrclDrft().getIdNb());
        baninfo.setDraftAmount(new BigDecimal(cr.getComrclDrft().getIsseAmt()));
        baninfo.setReqDate(DateUtil.parseDate(cr.getCntrlBkSellgDrfts().getDt()));
        baninfo.setInterestRate(new BigDecimal(cr.getCntrlBkSellgDrfts().getIntrstRate()));
        baninfo.setAmount(new BigDecimal(cr.getCntrlBkSellgDrfts().getAmt()));
        baninfo.setBanEndorsement(BanEndorsementMarkEnum.getEnum(cr.getCntrlBkSellgDrfts().getBanEndrsmtMk()));
        baninfo.setSettlementMark(SettlementMarkEnum.getEnum(cr.getCntrlBkSellgDrfts().getSttlmMk()));
        if (cr.getCntrlBkSellgDrfts().getBtchNb() != null) {
            baninfo.setBatch(cr.getCntrlBkSellgDrfts().getBtchNb());
        }
        baninfo.setRemark(cr.getCntrlBkSellgDrfts().getRmrkByPropsr());
        baninfo.setSalerType(RoleEnum.getEnum(cr.getSellrInf().getRole()));
        baninfo.setSalerOrgCode(cr.getSellrInf().getCmonId());
        baninfo.setSalerName(cr.getSellrInf().getNm());
        baninfo.setSalerAccount(cr.getSellrInf().getAcct().getId());
        baninfo.setSalerBank(cr.getSellrInf().getAcct().getAcctSvcr());
        baninfo.setBuyerName(cr.getBuyrInf().getNm());
        baninfo.setBuyerBank(cr.getBuyrInf().getAcct().getAcctSvcr());
        baninfo.setBuyerAccount(cr.getBuyrInf().getAcct().getId());
        baninfo.setIsSend(false);
        baninfo.setBizPromoterOrgCode(cr.getSellrInf().getCmonId());
        baninfo.setIsApplySuccess(ApplyBillStatusEnum.RECEIVE_034_APPLY);
        BankSellingDraftsRequestFactory.getLocalInstance(ctx).addnew(baninfo);
        return baninfo;
    }
}

