/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ecore.BanEndorsementMarkEnum;
import com.kingdee.eas.fm.ecore.BankSellingDraftsRequestFactory;
import com.kingdee.eas.fm.ecore.BankSellingDraftsRequestInfo;
import com.kingdee.eas.fm.ecore.RoleEnum;
import com.kingdee.eas.fm.ecore.SettlementMarkEnum;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.KMsgHead;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftCentralBankSellingDraftsRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.DocumentCommercialDraft;
import com.kingdee.eas.fm.ecore.app.ecds.IMsgReceiveCallBack;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class CallBackCommercialDraftCentralBankSellingDraftsRequest
implements IMsgReceiveCallBack {
    @Override
    public void parseRecMsg(Context ctx, String msgNum, KMsg kmsg, KMsgHead kmsgHead) throws EASBizException, BOSException {
        DocumentCommercialDraft dm = kmsg.getDocumentCommercialDraft();
        CommercialDraftCentralBankSellingDraftsRequest commercialDraftCentralBankSellingDraftsRequest = (CommercialDraftCentralBankSellingDraftsRequest)dm;
        this.CommercialDraftAccess(commercialDraftCentralBankSellingDraftsRequest, ctx);
    }

    public void CommercialDraftAccess(CommercialDraftCentralBankSellingDraftsRequest req, Context ctx) throws BOSException, EASBizException {
        BankSellingDraftsRequestInfo info = new BankSellingDraftsRequestInfo();
        info.setDrafNumber(req.getComrclDrft().getIdNb());
        info.setDraftAmount(new BigDecimal(req.getComrclDrft().getIsseAmt()));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            info.setReqDate(format.parse(req.getCntrlBkSellgDrfts().getDt()));
        }
        catch (ParseException e) {
            throw new EASBizException(null);
        }
        info.setInterestRate(new BigDecimal(req.getCntrlBkSellgDrfts().getIntrstRate()));
        info.setAmount(new BigDecimal(req.getCntrlBkSellgDrfts().getAmt()));
        info.setBanEndorsement(BanEndorsementMarkEnum.getEnum(req.getCntrlBkSellgDrfts().getBanEndrsmtMk()));
        info.setSettlementMark(SettlementMarkEnum.getEnum(req.getCntrlBkSellgDrfts().getSttlmMk()));
        if (req.getCntrlBkSellgDrfts().getBtchNb() != null) {
            info.setBatch(req.getCntrlBkSellgDrfts().getBtchNb());
        }
        if (req.getCntrlBkSellgDrfts().getRmrkByPropsr() != null) {
            info.setRemark(req.getCntrlBkSellgDrfts().getRmrkByPropsr());
        }
        info.setSalerType(RoleEnum.getEnum(req.getSellrInf().getRole()));
        info.setSalerName(req.getSellrInf().getNm());
        info.setSalerOrgCode(req.getSellrInf().getCmonId());
        info.setSalerUnderWrite(req.getSellrInf().getElctrncSgntr());
        info.setSalerAccount(req.getSellrInf().getAcct().getId());
        info.setSalerBank(req.getSellrInf().getAcct().getAcctSvcr());
        if (req.getSellrInf().getAgcy() != null) {
            info.setSalerAgcyBank(req.getSellrInf().getAgcy().getAcct().getAcctSvcr());
        }
        info.setBuyerName(req.getBuyrInf().getNm());
        info.setBuyerAccount(req.getBuyrInf().getAcct().getId());
        info.setBuyerBank(req.getBuyrInf().getAcct().getAcctSvcr());
        BankSellingDraftsRequestFactory.getLocalInstance(ctx).addnew(info);
    }
}

