/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.ecore.ActorTypeEnum;
import com.kingdee.eas.fm.ecore.AssBankDataFactory;
import com.kingdee.eas.fm.ecore.AssBankDataInfo;
import com.kingdee.eas.fm.ecore.CertBindStateEnum;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.HandlingStateEnum;
import com.kingdee.eas.fm.ecore.HasCarryBankEnum;
import com.kingdee.eas.fm.ecore.LastUpdateTypeEnum;
import com.kingdee.eas.fm.ecore.SystemActionStatusEnum;
import com.kingdee.eas.fm.ecore.SystemStatusInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.KMsgHead;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftBankInformationNotification;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.DocumentCommercialDraft;
import com.kingdee.eas.fm.ecore.app.bean.node.AddedInf;
import com.kingdee.eas.fm.ecore.app.bean.node.AltrdInf;
import com.kingdee.eas.fm.ecore.app.bean.node.BkInfElmt;
import com.kingdee.eas.fm.ecore.app.bean.node.DeltdInf;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.IMsgReceiveCallBack;
import com.kingdee.eas.fm.ecore.app.util.DateUtil;
import com.kingdee.eas.fm.ecore.util.FmEcrUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CallbackCommercialDraftBankInformationNotification
implements IMsgReceiveCallBack {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ecore.app.ecds.impl.CallbackCommercialDraftBankInformationNotification");

    @Override
    public void parseRecMsg(Context ctx, String msgNum, KMsg kmsg, KMsgHead kmsgHead) throws EASBizException, BOSException {
        DocumentCommercialDraft dm = kmsg.getDocumentCommercialDraft();
        CommercialDraftBankInformationNotification cf = (CommercialDraftBankInformationNotification)dm;
        Date curSysDate = new Date();
        SystemStatusInfo sinfo = ECDSCommon.getSysStsByMaxId(ctx);
        if (sinfo != null) {
            curSysDate = sinfo.getCurSysDate();
        }
        List listbkinfelmt = cf.getBkInfElmt();
        for (int i = 0; i < listbkinfelmt.size(); ++i) {
            BkInfElmt be = (BkInfElmt)listbkinfelmt.get(i);
            if (be.getBkInf().getAddedInf() != null) {
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"33_CallbackCommercialDraftBankInformationNotification", (Locale)ctx.getLocale()));
                this.addBank(be, curSysDate, ctx, kmsg);
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"34_CallbackCommercialDraftBankInformationNotification", (Locale)ctx.getLocale()));
                continue;
            }
            if (be.getBkInf().getAltrdInf() != null) {
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"35_CallbackCommercialDraftBankInformationNotification", (Locale)ctx.getLocale()));
                this.changeBank(be, ctx, kmsg);
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"36_CallbackCommercialDraftBankInformationNotification", (Locale)ctx.getLocale()));
                continue;
            }
            if (be.getBkInf().getDeltdInf() == null) continue;
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"37_CallbackCommercialDraftBankInformationNotification", (Locale)ctx.getLocale()));
            this.delBank(be, ctx, kmsg);
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"38_CallbackCommercialDraftBankInformationNotification", (Locale)ctx.getLocale()));
        }
        FmEcrUtil.checkBankDate(ctx);
    }

    public void addBank(BkInfElmt be, Date curSysDate, Context ctx, KMsg kmsg) throws BOSException, EASBizException {
        AddedInf addinf = be.getBkInf().getAddedInf();
        String acctSvcr = be.getOrg().getAcct().getAcctSvcr();
        BEBankCollection bc = this.findBebankByAcctSvcr(ctx, acctSvcr);
        if (bc.size() != 0) {
            BEBankInfo binfo = bc.get(0);
            String fctvDt = addinf.getFctvDt();
            binfo.setCreateDate(DateUtil.parseDate(fctvDt));
            Date fctvDtDate = DateUtil.parseDate(fctvDt);
            if (fctvDtDate.after(curSysDate)) {
                // empty if block
            }
            binfo.setLastUpdateType(LastUpdateTypeEnum.CHANGE);
            ObjectUuidPK pk = null;
            pk = new ObjectUuidPK(BOSUuid.read((String)binfo.getId().toString()));
            BEBankFactory.getLocalInstance((Context)ctx).update((IObjectPK)pk, (CoreBaseInfo)binfo);
            ECDSCommon.insertSystemAction(ctx, kmsg, null, null, null, String.valueOf(binfo.getId()), SystemActionStatusEnum.RECEIVE_SYSTEM_NOTICE, null, DraftMessageEnum.M059);
        } else {
            BEBankInfo binfo = new BEBankInfo();
            binfo.setNumber(acctSvcr);
            binfo.setName(addinf.getFullNm());
            binfo.setSimpleName(addinf.getShrtNm());
            binfo.setParentActor(addinf.getDrct());
            binfo.setActorType(ActorTypeEnum.getEnum((String)addinf.getCtgy()));
            binfo.setBankCode(addinf.getClss());
            binfo.setNodeNumber(addinf.getNdCd());
            binfo.setBankParentActor(addinf.getSprrLst());
            binfo.setECDCode(addinf.getpBCBk());
            binfo.setCityCode(addinf.getCityCd());
            binfo.setCertBindState(CertBindStateEnum.UNBOUND);
            binfo.setHasCarryBank(HasCarryBankEnum.NON);
            String fctvDt = addinf.getFctvDt();
            Date fctvDtDate = DateUtil.parseDate(fctvDt);
            if (fctvDtDate.after(curSysDate)) {
                // empty if block
            }
            binfo.setCreateDate(DateUtil.parseDate(addinf.getFctvDt()));
            binfo.setHasCarryBank(HasCarryBankEnum.NON);
            binfo.setLastUpdateType(LastUpdateTypeEnum.NEW);
            binfo.setRecordUpdate("1");
            BEBankFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)binfo);
            ECDSCommon.insertSystemAction(ctx, kmsg, null, null, null, String.valueOf(binfo.getId()), SystemActionStatusEnum.RECEIVE_SYSTEM_NOTICE, null, DraftMessageEnum.M059);
        }
    }

    public void changeBank(BkInfElmt be, Context ctx, KMsg kmsg) throws BOSException, EASBizException {
        AltrdInf ainfo = be.getBkInf().getAltrdInf();
        AssBankDataInfo abankdata = new AssBankDataInfo();
        String acctSvcr = be.getOrg().getAcct().getAcctSvcr();
        abankdata.setBankNumber(acctSvcr);
        abankdata.setActorType(ActorTypeEnum.getEnum((String)ainfo.getCtgy().toString()));
        abankdata.setBankCode(ainfo.getClss());
        abankdata.setParentActor(ainfo.getDrct());
        abankdata.setBankParentActor(ainfo.getSprrLst());
        abankdata.setECDCode(ainfo.getPbcbk());
        abankdata.setCityCode(ainfo.getCityCd());
        abankdata.setActorName(ainfo.getFullNm());
        abankdata.setActorSimpleName(ainfo.getShrtNm());
        abankdata.setAdress(ainfo.getAdr());
        abankdata.setPost(ainfo.getZpCd());
        abankdata.setTelphone(ainfo.getPbcbk());
        abankdata.setCreateDate(ainfo.getFctvDt().toString());
        abankdata.setUpdateTime(DateUtil.getDateTimeStr(new Date()));
        abankdata.setState(HandlingStateEnum.NOT_UPDATE);
        abankdata.setUpdatePeriod("0");
        AssBankDataFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)abankdata);
        ECDSCommon.insertSystemAction(ctx, kmsg, null, null, null, String.valueOf(abankdata.getId()), SystemActionStatusEnum.RECEIVE_SYSTEM_NOTICE, null, DraftMessageEnum.M059);
    }

    public void delBank(BkInfElmt be, Context ctx, KMsg kmsg) throws BOSException, EASBizException {
        DeltdInf deltdInf = be.getBkInf().getDeltdInf();
        BEBankCollection bc = this.findBebankByAcctSvcr(ctx, be.getOrg().getAcct().getAcctSvcr());
        if (bc.size() != 0) {
            BEBankInfo binfo = bc.get(0);
            binfo.setCreateDate(DateUtil.parseDate(deltdInf.getXpryDt()));
            ObjectUuidPK pk = null;
            pk = new ObjectUuidPK(BOSUuid.read((String)binfo.getId().toString()));
            BEBankFactory.getLocalInstance((Context)ctx).update((IObjectPK)pk, (CoreBaseInfo)binfo);
            ECDSCommon.insertSystemAction(ctx, kmsg, null, null, null, String.valueOf(binfo.getId()), SystemActionStatusEnum.RECEIVE_SYSTEM_NOTICE, null, DraftMessageEnum.M059);
        }
    }

    private BEBankCollection findBebankByAcctSvcr(Context ctx, String acctSvcr) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)acctSvcr));
        SorterItemInfo sortInfo = new SorterItemInfo("createtime");
        sortInfo.setSortType(SortType.DESCEND);
        viewinfo.setFilter(fi);
        BEBankCollection bc = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(viewinfo);
        return bc;
    }
}

