/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ecore.ContractActionEnum;
import com.kingdee.eas.fm.ecore.ContractRescindReqBillFactory;
import com.kingdee.eas.fm.ecore.ContractRescindReqBillInfo;
import com.kingdee.eas.fm.ecore.ContractStateEnum;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ElecContractBillInfo;
import com.kingdee.eas.fm.ecore.RescissionMarkerEnum;
import com.kingdee.eas.fm.ecore.RescissionReasonEnum;
import com.kingdee.eas.fm.ecore.RoleEnum;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.KMsgHead;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.ContractRescissionRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.DocumentCommercialDraft;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSContractUtil;
import com.kingdee.eas.fm.ecore.app.ecds.IMsgReceiveCallBack;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.text.ParseException;

public class CallbackContractRescissionRequest
implements IMsgReceiveCallBack {
    @Override
    public void parseRecMsg(Context ctx, String msgNum, KMsg kmsg, KMsgHead kmsgHead) throws EASBizException, BOSException {
        ContractStateEnum stateEnum;
        DocumentCommercialDraft draft = kmsg.getDocumentCommercialDraft();
        ContractRescissionRequest di = (ContractRescissionRequest)draft;
        String contractNumber = di.getCtrct().getCtrctNb();
        ElecContractBillInfo contractInfo = ECDSContractUtil.findElecContractInfo(ctx, contractNumber);
        ContractRescindReqBillInfo rescindInfo = new ContractRescindReqBillInfo();
        rescindInfo.setMessageID(di.getMsgId().getId());
        rescindInfo.setMessageTime(ECDSCommon.getTimestampByStr(di.getMsgId().getCreDtTm()));
        rescindInfo.setCtrctNumber(di.getCtrct().getCtrctNb());
        try {
            rescindInfo.setCtrctDate(DateTimeUtils.parseDate((String)di.getCtrct().getDt()));
        }
        catch (ParseException e) {
            throw new BOSException(e.getMessage());
        }
        rescindInfo.setRscisnMrkr(RescissionMarkerEnum.getEnum(di.getCtrct().getRscisnMrkr()));
        if (di.getCtrct().getRscisnRsnCd() != null) {
            rescindInfo.setRscisnRsnCd(RescissionReasonEnum.getEnum(di.getCtrct().getRscisnRsnCd()));
        }
        rescindInfo.setRscisnRsnRmrk(di.getCtrct().getRscisnRsnRmrk());
        rescindInfo.setRscisnPropsrRole(RoleEnum.getEnum(di.getRscisnPropsr().getRole()));
        rescindInfo.setRscisnPropsrOrgCode(di.getRscisnPropsr().getCmonId());
        rescindInfo.setElctrncSgntr(di.getRscisnPropsr().getElctrncSgntr());
        rescindInfo.setRscisnPropsrAcount(di.getRscisnPropsr().getAcct().getId());
        rescindInfo.setRscisnPropsrBank(di.getRscisnPropsr().getAcct().getAcctSvcr());
        if (di.getRscisnPropsr().getAgcy() != null) {
            rescindInfo.setRscisnPropsrBankBak(di.getRscisnPropsr().getAgcy().getAcct().getAcctSvcr());
        }
        rescindInfo.setRscisnMrkr(RescissionMarkerEnum.getEnum(di.getCtrct().getRscisnMrkr()));
        rescindInfo.setIsSend(false);
        rescindInfo.setIsCancel(false);
        rescindInfo.setIsBack(false);
        rescindInfo.setIsReplied(false);
        String receiveOrgCode = null;
        receiveOrgCode = contractInfo.getOfferOrgCode().equals(rescindInfo.getBizPromoterOrgCode()) ? contractInfo.getOffeeOrgCode() : contractInfo.getOfferOrgCode();
        rescindInfo.setBizPromoterOrgCode(receiveOrgCode);
        IObjectPK bizpk = ContractRescindReqBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)rescindInfo);
        DraftMessageEnum draftEnum = null;
        if (rescindInfo.getRscisnMrkr() == RescissionMarkerEnum.RM02) {
            ECDSContractUtil.updateElecContractWithRescissionInfo(ctx, contractNumber, rescindInfo);
            draftEnum = DraftMessageEnum.M207_TZ;
            stateEnum = ContractStateEnum.YW03;
        } else {
            draftEnum = DraftMessageEnum.M207_XS;
            stateEnum = ContractStateEnum.YW02;
        }
        ECDSCommon.insertContracttAction(ctx, kmsg, contractNumber, receiveOrgCode, bizpk.toString(), stateEnum, ContractActionEnum.RECEIVE, draftEnum);
    }
}

