/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.ElecDraftBillEntryFactory;
import com.kingdee.eas.fm.ecore.ElecDraftBillEntryInfo;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.RepurchaseDiscountRedeemReqInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRepurchasedDiscountRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.Agcy;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.DscntBk;
import com.kingdee.eas.fm.ecore.app.bean.node.RpdDscnt;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.fm.ecore.app.util.DateUtil;
import com.kingdee.eas.framework.BillBaseInfo;

public class SendCommercialDraftRepurchasedDiscountRequest
implements ISendHandler {
    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        CommercialDraftRepurchasedDiscountRequest cr = (CommercialDraftRepurchasedDiscountRequest)kmsg.getDocumentCommercialDraft();
        RepurchaseDiscountRedeemReqInfo info = (RepurchaseDiscountRedeemReqInfo)billBaseInfo;
        ECDSBillStatusEnum stateEnum = ECDSCommon.findElecDraftBillState(ctx, info.getDrawerOrgCode(), info.getDraftNumber());
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, cr.getComrclDrft().getIdNb(), cr.getDscntBk().getCmonId(), billBaseInfo.getId().toString(), stateEnum, ElecDraftActionEnum.SEND, DraftMessageEnum.M012, null);
    }

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        KMsg kMsg = new KMsg();
        RepurchaseDiscountRedeemReqInfo di = (RepurchaseDiscountRedeemReqInfo)billBaseInfo;
        ComrclDrft comrclDrft = new ComrclDrft();
        comrclDrft.setIdNb(di.getDraftNumber());
        comrclDrft.setIsseAmt(String.valueOf(di.getDraftAmount().setScale(2, 4)));
        RpdDscnt rpdDscnt = new RpdDscnt();
        rpdDscnt.setDt(DateUtil.getDateStr(di.getReqDate()));
        rpdDscnt.setIntrstRate(di.getRedeemInterRate().setScale(6, 4));
        rpdDscnt.setAmt(di.getRedeemPaidAmt().setScale(2, 4));
        rpdDscnt.setBanEndrsmtMk(di.getBanEndorsement().getValue());
        rpdDscnt.setSttlmMk(di.getSettlementMark().getValue());
        rpdDscnt.setBtchNb(di.getBatch());
        if (!FMHelper.isEmpty((String)di.getRemark())) {
            rpdDscnt.setRmrkByPropsr(di.getRemark());
        } else {
            rpdDscnt.setRmrkByPropsr(null);
        }
        DscntBk dscntBk = new DscntBk();
        dscntBk.setCmonId(di.getDrawerOrgCode());
        dscntBk.setElctrncSgntr(di.getDrawerElecSign());
        Acct acct = new Acct();
        acct.setId(di.getDrawerAccount());
        acct.setAcctSvcr(di.getDrawerBank());
        dscntBk.setAcct(acct);
        Agcy agcy = new Agcy();
        Acct acct2 = new Acct();
        if (!FMHelper.isEmpty((String)di.getDrawerAccepBank())) {
            acct2.setAcctSvcr(di.getDrawerAccepBank());
        } else {
            acct2.setAcctSvcr(null);
        }
        agcy.setAcct(acct2);
        dscntBk.setAgcy(agcy);
        CommercialDraftRepurchasedDiscountRequest cr = new CommercialDraftRepurchasedDiscountRequest();
        cr.setComrclDrft(comrclDrft);
        cr.setRpdDscnt(rpdDscnt);
        cr.setDscntBk(dscntBk);
        kMsg.setDocumentCommercialDraft(cr);
        return kMsg;
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        RepurchaseDiscountRedeemReqInfo eactinfo = (RepurchaseDiscountRedeemReqInfo)billBaseInfo;
        ElecDraftBillEntryInfo eleifo = ElecDraftBillEntryFactory.getLocalInstance(ctx).getElecDraftBillEntryCollection("select * where draftNumber ='" + eactinfo.getDraftNumber() + "' and draftBizType='" + 3 + "' order by draftSignInDate desc").get(0);
        return eleifo.getFormerBank();
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        RepurchaseDiscountRedeemReqInfo eactinfo = (RepurchaseDiscountRedeemReqInfo)billBaseInfo;
        return eactinfo.getDrawerBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        RepurchaseDiscountRedeemReqInfo eactinfo = (RepurchaseDiscountRedeemReqInfo)billBaseInfo;
        return eactinfo.getDraftNumber();
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String acctId;
        String actorBank;
        RepurchaseDiscountRedeemReqInfo di = (RepurchaseDiscountRedeemReqInfo)billBaseInfo;
        CommercialDraftRepurchasedDiscountRequest ct = (CommercialDraftRepurchasedDiscountRequest)kmsg.getDocumentCommercialDraft();
        String bizOrgNumber = ct.getDscntBk().getCmonId();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = ct.getDscntBk().getAcct().getAcctSvcr(), acctId = ct.getDscntBk().getAcct().getId());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getDscntBk().setRole(oinfo.getOrgUnitRoleType().getValue());
        di.setDrawerRole(oinfo.getOrgUnitRoleType());
    }
}

