/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.EndorserRequestInfo;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftEndorsementRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.Endrsee;
import com.kingdee.eas.fm.ecore.app.bean.node.Endrsmt;
import com.kingdee.eas.fm.ecore.app.bean.node.Endrsr;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.fm.ecore.app.util.DateUtil;
import com.kingdee.eas.fm.ecore.app.util.EcdsSerNumber;
import com.kingdee.eas.framework.BillBaseInfo;

public class SendDraftEndorsementRequest
implements ISendHandler {
    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        CommercialDraftEndorsementRequest cr = (CommercialDraftEndorsementRequest)kmsg.getDocumentCommercialDraft();
        EndorserRequestInfo info = (EndorserRequestInfo)billBaseInfo;
        ECDSBillStatusEnum stateEnum = ECDSCommon.findElecDraftBillState(ctx, cr.getEndrsr().getCmonId(), cr.getComrclDrft().getIdNb());
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, cr.getComrclDrft().getIdNb(), cr.getEndrsr().getCmonId(), info.getId().toString(), stateEnum, ElecDraftActionEnum.SEND, DraftMessageEnum.M010, null);
    }

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        EndorserRequestInfo di = (EndorserRequestInfo)billBaseInfo;
        KMsg kMsg = new KMsg();
        ComrclDrft comrclDrft = new ComrclDrft();
        comrclDrft.setIdNb(String.valueOf(di.getBillNumber()));
        comrclDrft.setIsseAmt(String.valueOf(di.getBillAmount().setScale(2, 4)));
        comrclDrft.setBanEndrsmtMk(di.getBanEndorsement().getValue());
        Endrsmt endrsmt = new Endrsmt();
        endrsmt.setDt(DateUtil.getDateStr(di.getBizDate()));
        endrsmt.setBanEndrsmtMk(di.getBanEndorsement().getValue());
        if (!FMHelper.isEmpty((String)di.getRemark())) {
            endrsmt.setRmrkByPropsr(di.getRemark());
        } else {
            endrsmt.setRmrkByPropsr(null);
        }
        Endrsr endrsr = new Endrsr();
        endrsr.setRole(di.getEndorserRole().getValue());
        endrsr.setNm(di.getEndorserName());
        endrsr.setCmonId(di.getEndorserOrgCode());
        endrsr.setElctrncSgntr(String.valueOf(EcdsSerNumber.getPK()));
        Acct acct = new Acct();
        acct.setId(di.getEndorserAccount());
        acct.setAcctSvcr(di.getEndorserBank());
        endrsr.setAcct(acct);
        Endrsee endrsee = new Endrsee();
        endrsee.setNm(di.getByEndorserName());
        Acct endacct = new Acct();
        endacct.setId(di.getByEndorserAccount());
        endacct.setAcctSvcr(di.getByEndorserBank());
        endrsee.setAcct(endacct);
        CommercialDraftEndorsementRequest commercialDraftEndorsementRequest = new CommercialDraftEndorsementRequest();
        commercialDraftEndorsementRequest.setComrclDrft(comrclDrft);
        commercialDraftEndorsementRequest.setEndrsmt(endrsmt);
        commercialDraftEndorsementRequest.setEndrsr(endrsr);
        commercialDraftEndorsementRequest.setEndrsee(endrsee);
        kMsg.setDocumentCommercialDraft(commercialDraftEndorsementRequest);
        return kMsg;
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        EndorserRequestInfo eactinfo = (EndorserRequestInfo)billBaseInfo;
        return eactinfo.getByEndorserBank();
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        EndorserRequestInfo eactinfo = (EndorserRequestInfo)billBaseInfo;
        return eactinfo.getEndorserBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        EndorserRequestInfo eactinfo = (EndorserRequestInfo)billBaseInfo;
        return eactinfo.getBillNumber();
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String acctId;
        String actorBank;
        EndorserRequestInfo di = (EndorserRequestInfo)billBaseInfo;
        CommercialDraftEndorsementRequest ct = (CommercialDraftEndorsementRequest)kmsg.getDocumentCommercialDraft();
        String bizOrgNumber = ct.getEndrsr().getCmonId();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = ct.getEndrsr().getAcct().getAcctSvcr(), acctId = ct.getEndrsr().getAcct().getId());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getEndrsr().setRole(oinfo.getOrgUnitRoleType().getValue());
        di.setEndorserRole(oinfo.getOrgUnitRoleType());
        String cnumber = ct.getEndrsee().getAcct().getAcctSvcr();
        BEBankInfo cbi = ECDSCommon.checkBEBank(ctx, cnumber);
        if (cbi == null) {
            throw new BOSException(ECDSCommon.PART_CHECK_ERROR);
        }
    }
}

