/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionBillInfo;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.RecourseAgreementRequestBillInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRecourseAgreementRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.Agcy;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.OrgnlMsgId;
import com.kingdee.eas.fm.ecore.app.bean.node.Rcrs;
import com.kingdee.eas.fm.ecore.app.bean.node.RcvgPrsnOfRcrs;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.fm.ecore.app.util.DateUtil;
import com.kingdee.eas.framework.BillBaseInfo;

public class SendDraftRecourseAgreementRequest
implements ISendHandler {
    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        RecourseAgreementRequestBillInfo info = (RecourseAgreementRequestBillInfo)billBaseInfo;
        CommercialDraftRecourseAgreementRequest cd = (CommercialDraftRecourseAgreementRequest)kmsg.getDocumentCommercialDraft();
        String idNb = cd.getComrclDrft().getIdNb();
        String holderOrgCode = cd.getRcvgPrsnOfRcrs().getCmonId();
        ECDSBillStatusEnum eenum = ECDSCommon.findElecDraftBillState(ctx, holderOrgCode, idNb);
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, idNb, holderOrgCode, info.getId().toString(), eenum, ElecDraftActionEnum.SEND, DraftMessageEnum.M023, null);
    }

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        RecourseAgreementRequestBillInfo info = (RecourseAgreementRequestBillInfo)billBaseInfo;
        KMsg kMsg = new KMsg();
        CommercialDraftRecourseAgreementRequest commercialDraft = new CommercialDraftRecourseAgreementRequest();
        OrgnlMsgId orgnlMsgId = new OrgnlMsgId();
        orgnlMsgId.setId(info.getOrgMessageId());
        if (info.getOrgMessageTime() != null) {
            orgnlMsgId.setCreDtTm(ECDSCommon.getMessTimeByTimestamp(info.getOrgMessageTime()));
        }
        ComrclDrft comrclDrft = new ComrclDrft();
        comrclDrft.setIdNb(info.getDraftNumber());
        comrclDrft.setIsseAmt(info.getDraftAmount().setScale(2).toString());
        Rcrs rcrs = new Rcrs();
        rcrs.setDt(DateUtil.getDateStr(info.getAgreeDate()));
        rcrs.setAmt(info.getAgreeAmount().setScale(2).toString());
        if (!FMHelper.isEmpty((String)info.getAgreeRemark())) {
            rcrs.setRcrsAgrmtRmrk(info.getAgreeRemark());
        } else {
            rcrs.setRcrsAgrmtRmrk(null);
        }
        Acct acct = new Acct();
        acct.setId(info.getAgreemanAccount());
        acct.setAcctSvcr(info.getAgreemanBank());
        Agcy agcy = new Agcy();
        Acct child_acct = new Acct();
        child_acct.setAcctSvcr(info.getAgreemanBankBak());
        agcy.setAcct(child_acct);
        RcvgPrsnOfRcrs rcvgPrsnOfRcrs = new RcvgPrsnOfRcrs();
        rcvgPrsnOfRcrs.setRole(info.getAgreemanType().getValue().toString());
        rcvgPrsnOfRcrs.setNm(info.getAgreemanName());
        rcvgPrsnOfRcrs.setCmonId(info.getGroupId());
        rcvgPrsnOfRcrs.setElctrncSgntr(info.getAgreemanSgin());
        rcvgPrsnOfRcrs.setAcct(acct);
        rcvgPrsnOfRcrs.setAgcy(agcy);
        commercialDraft.setOrgnlMsgId(orgnlMsgId);
        commercialDraft.setComrclDrft(comrclDrft);
        commercialDraft.setRcrs(rcrs);
        commercialDraft.setRcvgPrsnOfRcrs(rcvgPrsnOfRcrs);
        kMsg.setDocumentCommercialDraft(commercialDraft);
        return kMsg;
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        RecourseAgreementRequestBillInfo info = (RecourseAgreementRequestBillInfo)billBaseInfo;
        ElecDraftActionBillInfo actionbak = ECDSCommon.findAllElecDraftActionBill(info.getDraftNumber(), ctx);
        String bizid = actionbak.getBizRecordBillID();
        return info.getAgreemanBank();
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        RecourseAgreementRequestBillInfo info = (RecourseAgreementRequestBillInfo)billBaseInfo;
        return info.getAgreemanBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String acctId;
        String actorBank;
        RecourseAgreementRequestBillInfo info = (RecourseAgreementRequestBillInfo)billBaseInfo;
        CommercialDraftRecourseAgreementRequest ct = (CommercialDraftRecourseAgreementRequest)kmsg.getDocumentCommercialDraft();
        String bizOrgNumber = ct.getRcvgPrsnOfRcrs().getCmonId();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = ct.getRcvgPrsnOfRcrs().getAcct().getAcctSvcr(), acctId = ct.getRcvgPrsnOfRcrs().getAcct().getId());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getRcvgPrsnOfRcrs().setRole(oinfo.getOrgUnitRoleType().getValue());
        info.setAgreemanType(oinfo.getOrgUnitRoleType());
    }
}

