/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.RecourseNotificationBillInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRecourseNotification;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.Agcy;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.Rcrs;
import com.kingdee.eas.fm.ecore.app.bean.node.Rcrsr;
import com.kingdee.eas.fm.ecore.app.bean.node.RcvgPrsnOfRcrs;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.fm.ecore.app.util.DateUtil;
import com.kingdee.eas.framework.BillBaseInfo;

public class SendDraftRecourseNotificationRequest
implements ISendHandler {
    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        RecourseNotificationBillInfo di = (RecourseNotificationBillInfo)billBaseInfo;
        ECDSBillStatusEnum stateEnum = ECDSCommon.findElecDraftBillState(ctx, di.getRecourseBizCode(), di.getDraftNumber());
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, di.getDraftNumber(), di.getRecourseBizCode(), di.getId().toString(), stateEnum, ElecDraftActionEnum.SEND, DraftMessageEnum.M022, null);
    }

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        KMsg kMsg = new KMsg();
        RecourseNotificationBillInfo di = (RecourseNotificationBillInfo)billBaseInfo;
        ComrclDrft comrclDrft = new ComrclDrft();
        comrclDrft.setIdNb(di.getDraftNumber());
        comrclDrft.setIsseAmt(String.valueOf(di.getDraftAmount().setScale(2, 4)));
        Rcrs rcrs = new Rcrs();
        rcrs.setTp(di.getRecourseType().getValue());
        rcrs.setApplDt(DateUtil.getDateStr(di.getRecourseData()));
        rcrs.setReqAmt(String.valueOf(di.getRecourseAmount().setScale(2, 4)));
        rcrs.setRcrsRsnCd(di.getRecourseCode().getValue());
        if (!FMHelper.isEmpty((String)di.getRecourseRemark())) {
            rcrs.setRcrsRmrk(di.getRecourseRemark());
        } else {
            rcrs.setRcrsRmrk(null);
        }
        Rcrsr rcrsr = new Rcrsr();
        rcrsr.setNm(di.getRecourseName());
        rcrsr.setCmonId(di.getRecourseBizCode());
        rcrsr.setElctrncSgntr(di.getRecoursElecSign());
        Acct acct = new Acct();
        acct.setId(di.getRecourseAccout());
        acct.setAcctSvcr(di.getRecourseBank());
        Agcy agcy = new Agcy();
        Acct acct2 = new Acct();
        acct2.setAcctSvcr(di.getRecourseCarryBa());
        agcy.setAcct(acct2);
        rcrsr.setAcct(acct);
        rcrsr.setAgcy(agcy);
        RcvgPrsnOfRcrs rcvgPrsnOfRcrs = new RcvgPrsnOfRcrs();
        rcvgPrsnOfRcrs.setNm(di.getByRecName());
        rcvgPrsnOfRcrs.setCmonId(di.getByRecCode());
        Acct r_acct = new Acct();
        r_acct.setId(di.getByRecAccout());
        r_acct.setAcctSvcr(di.getByRecBank());
        Agcy r_agcy = new Agcy();
        Acct r_acct2 = new Acct();
        r_acct2.setAcctSvcr(di.getByRecCarryBank());
        r_agcy.setAcct(r_acct2);
        rcvgPrsnOfRcrs.setAcct(r_acct);
        rcvgPrsnOfRcrs.setAgcy(r_agcy);
        CommercialDraftRecourseNotification cd = new CommercialDraftRecourseNotification();
        cd.setComrclDrft(comrclDrft);
        cd.setRcrs(rcrs);
        cd.setRcrsr(rcrsr);
        cd.setRcvgPrsnOfRcrs(rcvgPrsnOfRcrs);
        kMsg.setDocumentCommercialDraft(cd);
        return kMsg;
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        RecourseNotificationBillInfo di = (RecourseNotificationBillInfo)billBaseInfo;
        return di.getByRecBank();
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        RecourseNotificationBillInfo di = (RecourseNotificationBillInfo)billBaseInfo;
        return di.getRecourseBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        RecourseNotificationBillInfo di = (RecourseNotificationBillInfo)billBaseInfo;
        return di.getDraftNumber();
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String acctId;
        String actorBank;
        RecourseNotificationBillInfo di = (RecourseNotificationBillInfo)billBaseInfo;
        CommercialDraftRecourseNotification ct = (CommercialDraftRecourseNotification)kmsg.getDocumentCommercialDraft();
        String bizOrgNumber = di.getRecourseBizCode();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = di.getRecourseBank(), acctId = di.getRecourseAccout());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getRcrsr().setRole(oinfo.getOrgUnitRoleType().getValue());
        di.setRecourseRole(oinfo.getOrgUnitRoleType());
    }
}

