/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.DiscountAgainInfo;
import com.kingdee.eas.fm.ecore.DiscountTypeEnum;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRediscountWithCommercialBankRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.Agcy;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.RcvgBkOfRdscntWthComrclBk;
import com.kingdee.eas.fm.ecore.app.bean.node.RdscntWthComrclBk;
import com.kingdee.eas.fm.ecore.app.bean.node.RqstngBkOfRdscntWthComrclBk;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.framework.BillBaseInfo;

public class SendDraftRediscountWithCommercialBankRequest
implements ISendHandler {
    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        DiscountAgainInfo entityInfo = (DiscountAgainInfo)billBaseInfo;
        CommercialDraftRediscountWithCommercialBankRequest di = (CommercialDraftRediscountWithCommercialBankRequest)kmsg.getDocumentCommercialDraft();
        String idNb = entityInfo.getBillNumber();
        String holderOrgCode = di.getRqstngBkOfRdscntWthComrclBk().getCmonId();
        ECDSBillStatusEnum eenum = ECDSCommon.findElecDraftBillState(ctx, holderOrgCode, idNb);
        DraftMessageEnum messageTypeEnum = entityInfo.getDiscountType() == DiscountTypeEnum.RM00 ? DraftMessageEnum.M013_MAIDUAN : DraftMessageEnum.M013_HUIGOU;
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, idNb, holderOrgCode, entityInfo.getId().toString(), eenum, ElecDraftActionEnum.SEND, messageTypeEnum, null);
    }

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        KMsg kMsg = new KMsg();
        DiscountAgainInfo entityInfo = (DiscountAgainInfo)billBaseInfo;
        CommercialDraftRediscountWithCommercialBankRequest di = new CommercialDraftRediscountWithCommercialBankRequest();
        RdscntWthComrclBk rb = new RdscntWthComrclBk();
        rb.setAmt(entityInfo.getPayfor().toString());
        rb.setBanEndrsmtMk(entityInfo.getAssignmentMark().getValue());
        if (entityInfo.getBtchNb() != null) {
            rb.setBtchNb(String.valueOf(entityInfo.getBtchNb().setScale(0, 4)));
        }
        rb.setDt(entityInfo.getRequestDate().toString());
        rb.setIntrstRate(entityInfo.getRate().setScale(6, 4));
        if (FMHelper.isEmpty((String)entityInfo.getDiscounterRemark()) && entityInfo.getDiscounterRemark().length() != 0) {
            rb.setRmrkByPropsr(entityInfo.getDiscounterRemark());
        } else {
            rb.setRmrkByPropsr(null);
        }
        if (entityInfo.getBackMoney() != null) {
            rb.setRpdAmt(String.valueOf(entityInfo.getBackMoney().setScale(2, 4)));
        }
        if (entityInfo.getBackCloseDate() != null) {
            rb.setRpdDueDt(entityInfo.getBackCloseDate().toString());
        }
        if (entityInfo.getBackRate() != null) {
            rb.setRpdIntrstRate(entityInfo.getBackRate().setScale(6, 4));
        }
        rb.setRpdMk(entityInfo.getDiscountType().getValue());
        if (entityInfo.getBackOpenDate() != null) {
            rb.setRpdOpenDt(entityInfo.getBackOpenDate().toString());
        }
        rb.setSttlmMk(entityInfo.getBalanceMark().getValue());
        ComrclDrft cd = new ComrclDrft();
        cd.setIdNb(entityInfo.getBillNumber());
        cd.setIsseAmt(String.valueOf(entityInfo.getBillAmount().setScale(2, 4)));
        RqstngBkOfRdscntWthComrclBk rq = new RqstngBkOfRdscntWthComrclBk();
        Acct rqAcct = new Acct();
        rqAcct.setId(entityInfo.getDiscounterAccount());
        rqAcct.setAcctSvcr(entityInfo.getDiscounterBank());
        rq.setAcct(rqAcct);
        if (entityInfo.getDiscountBankBak() != null) {
            Agcy rqAgcy = new Agcy();
            Acct acct = new Acct();
            acct.setAcctSvcr(entityInfo.getDiscountBankBak());
            rqAgcy.setAcct(acct);
            rq.setAgcy(rqAgcy);
        }
        rq.setCmonId(entityInfo.getBizPromoterOrgCode());
        rq.setElctrncSgntr(entityInfo.getDiscounterSgin());
        rq.setNm(entityInfo.getDiscounterName());
        RcvgBkOfRdscntWthComrclBk rc = new RcvgBkOfRdscntWthComrclBk();
        Acct rcAcct = new Acct();
        rcAcct.setId(entityInfo.getByDiscounterAccount());
        rcAcct.setAcctSvcr(entityInfo.getByDiscounterBank());
        rc.setAcct(rcAcct);
        rc.setNm(entityInfo.getByDiscounterName());
        di.setComrclDrft(cd);
        di.setRcvgBkOfRdscntWthComrclBk(rc);
        di.setRdscntWthComrclBk(rb);
        di.setRqstngBkOfRdscntWthComrclBk(rq);
        kMsg.setDocumentCommercialDraft(di);
        return kMsg;
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        DiscountAgainInfo eactinfo = (DiscountAgainInfo)billBaseInfo;
        return eactinfo.getByDiscounterBank();
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        DiscountAgainInfo eactinfo = (DiscountAgainInfo)billBaseInfo;
        return eactinfo.getDiscounterBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        DiscountAgainInfo eactinfo = (DiscountAgainInfo)billBaseInfo;
        return eactinfo.getBillNumber();
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String acctId;
        String actorBank;
        CommercialDraftRediscountWithCommercialBankRequest ct = (CommercialDraftRediscountWithCommercialBankRequest)kmsg.getDocumentCommercialDraft();
        String bizOrgNumber = ct.getRqstngBkOfRdscntWthComrclBk().getCmonId();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = ct.getRqstngBkOfRdscntWthComrclBk().getAcct().getAcctSvcr(), acctId = ct.getRqstngBkOfRdscntWthComrclBk().getAcct().getId());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getRqstngBkOfRdscntWthComrclBk().setRole(oinfo.getOrgUnitRoleType().getValue());
    }
}

