/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.ElecDraftBillInfo;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.PromptPaymentReqInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftPresentationRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.DrftHldr;
import com.kingdee.eas.fm.ecore.app.bean.node.Prsnttn;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;

public class SendHandleDraftPresentationRequest
implements ISendHandler {
    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        CommercialDraftPresentationRequest cr = (CommercialDraftPresentationRequest)kmsg.getDocumentCommercialDraft();
        PromptPaymentReqInfo info = (PromptPaymentReqInfo)billBaseInfo;
        String idNb = cr.getComrclDrft().getIdNb();
        String holderOrgCode = cr.getDrftHldr().getCmonId();
        ECDSBillStatusEnum eenum = ECDSCommon.findElecDraftBillState(ctx, holderOrgCode, idNb);
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, cr.getComrclDrft().getIdNb(), cr.getDrftHldr().getCmonId(), info.getId().toString(), eenum, ElecDraftActionEnum.SEND, DraftMessageEnum.M020, null);
    }

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        KMsg kMsg = new KMsg();
        PromptPaymentReqInfo pi = (PromptPaymentReqInfo)billBaseInfo;
        ComrclDrft comrclDrft = new ComrclDrft();
        comrclDrft.setIdNb(pi.getDraftNumber());
        comrclDrft.setIsseAmt(String.valueOf(pi.getDraftAmount().setScale(2, 4)));
        Prsnttn pr = new Prsnttn();
        if (null != pi.getPaymentDate()) {
            pr.setApplDt(DateTimeUtils.formatDate((Date)pi.getPaymentDate()));
        }
        pr.setAmt(String.valueOf(pi.getPaymentAmount().setScale(2, 4)));
        pr.setSttlmMk(pi.getSettlementMark().getValue());
        pr.setPrxyPropstn(pi.getProxyPropositio().getValue());
        if (FMHelper.isEmpty((String)pi.getDraweeRemark())) {
            pr.setRmrkByPropsr(pi.getDraweeRemark());
        } else {
            pr.setRmrkByPropsr(null);
        }
        DrftHldr dr = new DrftHldr();
        if (pi.getRoleType() != null) {
            dr.setRole(pi.getRoleType().getValue());
        }
        dr.setNm(pi.getRoleName());
        dr.setCmonId(pi.getOrgCode());
        dr.setElctrncSgntr(pi.getRemark());
        Acct ac = new Acct();
        ac.setId(pi.getReloAccount());
        ac.setAcctSvcr(pi.getReloBank());
        dr.setAcct(ac);
        CommercialDraftPresentationRequest commercialDraftPresentationRequest = new CommercialDraftPresentationRequest();
        commercialDraftPresentationRequest.setComrclDrft(comrclDrft);
        commercialDraftPresentationRequest.setPrsnttn(pr);
        commercialDraftPresentationRequest.setDrftHldr(dr);
        kMsg.setDocumentCommercialDraft(commercialDraftPresentationRequest);
        return kMsg;
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        PromptPaymentReqInfo pi = (PromptPaymentReqInfo)billBaseInfo;
        ElecDraftBillInfo info = ECDSCommon.findElecDraftBillInfoByIndb(ctx, pi.getDraftNumber());
        return info.getAcceptorBank();
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        PromptPaymentReqInfo pi = (PromptPaymentReqInfo)billBaseInfo;
        return pi.getReloBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        PromptPaymentReqInfo pi = (PromptPaymentReqInfo)billBaseInfo;
        return pi.getDraftNumber();
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String acctId;
        String actorBank;
        PromptPaymentReqInfo pi = (PromptPaymentReqInfo)billBaseInfo;
        CommercialDraftPresentationRequest ct = (CommercialDraftPresentationRequest)kmsg.getDocumentCommercialDraft();
        String bizOrgNumber = ct.getDrftHldr().getCmonId();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = ct.getDrftHldr().getAcct().getAcctSvcr(), acctId = ct.getDrftHldr().getAcct().getId());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getDrftHldr().setRole(oinfo.getOrgUnitRoleType().getValue());
        pi.setRoleType(oinfo.getOrgUnitRoleType());
    }
}

