/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.ecore.AcceptRequestBillInfo;
import com.kingdee.eas.fm.ecore.ActionCancelBillInfo;
import com.kingdee.eas.fm.ecore.AgainDiscountApplyBillInfo;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.DiscountAgainInfo;
import com.kingdee.eas.fm.ecore.DiscountRequestBillInfo;
import com.kingdee.eas.fm.ecore.DraftBizTypeEnum;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionBillCollection;
import com.kingdee.eas.fm.ecore.ElecDraftActionBillFactory;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.ElecDraftBillEntryInfo;
import com.kingdee.eas.fm.ecore.ElecDraftBillInfo;
import com.kingdee.eas.fm.ecore.EndorserRequestInfo;
import com.kingdee.eas.fm.ecore.GuaranteeRequestBillInfo;
import com.kingdee.eas.fm.ecore.IApplyBillBase;
import com.kingdee.eas.fm.ecore.ImpawnUnchainApplyBillInfo;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.OverdueCuePayInfo;
import com.kingdee.eas.fm.ecore.PledgeReqBillInfo;
import com.kingdee.eas.fm.ecore.PromptPaymentReqInfo;
import com.kingdee.eas.fm.ecore.RecourseAgreementRequestBillInfo;
import com.kingdee.eas.fm.ecore.RecourseNotificationBillInfo;
import com.kingdee.eas.fm.ecore.RepurchaseDiscountRedeemReqInfo;
import com.kingdee.eas.fm.ecore.RepurchaseDiscountTurnRedeemReqInfo;
import com.kingdee.eas.fm.ecore.TipsTicketCollectorBillInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftCancellationRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.Agcy;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.CxlPropsr;
import com.kingdee.eas.fm.ecore.app.bean.node.OrgnlMsgId;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.framework.BillBaseInfo;
import java.math.BigDecimal;

public class SendHandlerCommercialDraftCancellationRequest
implements ISendHandler {
    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        CommercialDraftCancellationRequest cr = (CommercialDraftCancellationRequest)kmsg.getDocumentCommercialDraft();
        ActionCancelBillInfo canceInfo = (ActionCancelBillInfo)billBaseInfo;
        ECDSBillStatusEnum stateEnum = ECDSCommon.findElecDraftBillState(ctx, canceInfo.getCancelOrgCode(), canceInfo.getDraftNumber());
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, cr.getComrclDrft().getIdNb(), cr.getCxlPropsr().getCmonId(), canceInfo.getId().toString(), stateEnum, ElecDraftActionEnum.SEND_CANCEL, DraftMessageEnum.M032, null);
    }

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        ActionCancelBillInfo info = (ActionCancelBillInfo)billBaseInfo;
        OrgnlMsgId orgnlMsgId = new OrgnlMsgId();
        orgnlMsgId.setId(info.getOriMessageID());
        orgnlMsgId.setCreDtTm(ECDSCommon.getMessTimeByTimestamp(info.getOriMessageTime()));
        ComrclDrft comrclDrft = new ComrclDrft();
        comrclDrft.setIdNb(info.getDraftNumber().toString());
        comrclDrft.setIsseAmt(new BigDecimal(info.getDraftAmount().toString()).setScale(2).toString());
        CxlPropsr cxlPropsr = new CxlPropsr();
        if (info.getCancelRole() != null) {
            cxlPropsr.setRole(info.getCancelRole().getValue());
        }
        if (info.getCancelOrgCode() != null) {
            cxlPropsr.setCmonId(info.getCancelOrgCode());
        }
        Acct acct = new Acct();
        acct.setId(info.getCancelAccount());
        acct.setAcctSvcr(info.getCancelBank());
        cxlPropsr.setAcct(acct);
        if (info.getEletricSign().length() == 0) {
            cxlPropsr.setElctrncSgntr("0");
        } else {
            cxlPropsr.setElctrncSgntr(info.getEletricSign());
        }
        Agcy agcy = new Agcy();
        Acct acc = new Acct();
        acc.setAcctSvcr(info.getCancelAgcyBank());
        agcy.setAcct(acc);
        cxlPropsr.setAgcy(agcy);
        CommercialDraftCancellationRequest commercialDraftCancellationRequest = new CommercialDraftCancellationRequest();
        commercialDraftCancellationRequest.setOrgnlMsgId(orgnlMsgId);
        commercialDraftCancellationRequest.setCxlPropsr(cxlPropsr);
        commercialDraftCancellationRequest.setComrclDrft(comrclDrft);
        KMsg msg = new KMsg();
        msg.setDocumentCommercialDraft(commercialDraftCancellationRequest);
        return msg;
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        ActionCancelBillInfo canceInfo = (ActionCancelBillInfo)billBaseInfo;
        String ortMessageID = canceInfo.getOriMessageID();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.appendFilterItem("messageID", (Object)ortMessageID);
        filterInfo.appendFilterItem("actionType", (Object)ElecDraftActionEnum.SEND);
        filterInfo.getFilterItems().add(new FilterItemInfo("draftMessage", (Object)"M034", CompareType.NOTLIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("draftMessage", (Object)"M031", CompareType.NOTLIKE));
        SorterItemInfo sortInfo = new SorterItemInfo("createtime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        evi.setSorter(sortCol);
        evi.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bizRecordBillID");
        evi.setSelector(sic);
        String applyBillId = null;
        ElecDraftActionBillCollection elecDraftActionBill = ElecDraftActionBillFactory.getLocalInstance(ctx).getElecDraftActionBillCollection(evi);
        if (elecDraftActionBill.size() > 0) {
            applyBillId = elecDraftActionBill.get(0).getBizRecordBillID();
        }
        if (applyBillId != null) {
            BOSUuid uuid = BOSUuid.read(applyBillId);
            IApplyBillBase applyBillBase = (IApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(uuid.getType());
            ApplyBillBaseInfo info = applyBillBase.getApplyBillBaseInfo((IObjectPK)new ObjectStringPK(applyBillId));
            if (info instanceof AcceptRequestBillInfo) {
                ElecDraftBillInfo elecInfo = ECDSCommon.findElecDraftBillInfoByIndb(ctx, ((AcceptRequestBillInfo)info).getDrawerNumber());
                return elecInfo.getAcceptorBank();
            }
            if (info instanceof GuaranteeRequestBillInfo) {
                return ((GuaranteeRequestBillInfo)info).getGuarantorBank();
            }
            if (info instanceof TipsTicketCollectorBillInfo) {
                ElecDraftBillInfo elecInfo = ECDSCommon.findElecDraftBillInfoByIndb(ctx, ((TipsTicketCollectorBillInfo)info).getDraftNumber());
                return elecInfo.getPayeeBank();
            }
            if (info instanceof EndorserRequestInfo) {
                return ((EndorserRequestInfo)info).getByEndorserBank();
            }
            if (info instanceof DiscountRequestBillInfo) {
                return ((DiscountRequestBillInfo)info).getByDiscounterBank();
            }
            if (info instanceof RepurchaseDiscountRedeemReqInfo) {
                ElecDraftBillEntryInfo eInfo = ECDSCommon.findElecDraftBillEntry(ctx, canceInfo.getDraftNumber(), canceInfo.getCancelOrgCode(), DraftBizTypeEnum.TIEXIAN, true);
                return eInfo.getLaterBank();
            }
            if (info instanceof DiscountAgainInfo) {
                return ((DiscountAgainInfo)info).getByDiscounterBank();
            }
            if (info instanceof RepurchaseDiscountTurnRedeemReqInfo) {
                ElecDraftBillEntryInfo eInfo = ECDSCommon.findElecDraftBillEntry(ctx, canceInfo.getDraftNumber(), canceInfo.getCancelOrgCode(), DraftBizTypeEnum.ZHUANTIEXIAN, true);
                return eInfo.getFormerBank();
            }
            if (info instanceof AgainDiscountApplyBillInfo) {
                return ((AgainDiscountApplyBillInfo)info).getDiscountInBank();
            }
            if (info instanceof PledgeReqBillInfo) {
                return ((PledgeReqBillInfo)info).getPledgeBank();
            }
            if (info instanceof ImpawnUnchainApplyBillInfo) {
                ElecDraftBillEntryInfo eInfo = ECDSCommon.findElecDraftBillEntry(ctx, canceInfo.getDraftNumber(), canceInfo.getCancelOrgCode(), DraftBizTypeEnum.ZHIYA, true);
                return eInfo.getLaterBank();
            }
            if (info instanceof PromptPaymentReqInfo) {
                ElecDraftBillInfo elecInfo = ECDSCommon.findElecDraftBillInfoByIndb(ctx, ((PromptPaymentReqInfo)info).getDraftNumber());
                return elecInfo.getAcceptorBank();
            }
            if (info instanceof OverdueCuePayInfo) {
                ElecDraftBillInfo elecInfo = ECDSCommon.findElecDraftBillInfoByIndb(ctx, ((OverdueCuePayInfo)info).getDraftNumber());
                return elecInfo.getAcceptorBank();
            }
            if (info instanceof RecourseNotificationBillInfo) {
                return ((RecourseNotificationBillInfo)info).getRecourseBank();
            }
            if (info instanceof RecourseNotificationBillInfo) {
                ElecDraftBillEntryInfo eInfo = ECDSCommon.findElecDraftBillEntry(ctx, canceInfo.getDraftNumber(), canceInfo.getCancelOrgCode(), DraftBizTypeEnum.ZHUISUO, true);
                return eInfo.getLaterBank();
            }
            if (info instanceof RecourseAgreementRequestBillInfo) {
                RecourseAgreementRequestBillInfo recourInfo = (RecourseAgreementRequestBillInfo)info;
                return recourInfo.getAgreemanBank();
            }
        }
        return null;
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        ActionCancelBillInfo canceInfo = (ActionCancelBillInfo)billBaseInfo;
        return canceInfo.getCancelBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String acctId;
        String actorBank;
        CommercialDraftCancellationRequest ct = (CommercialDraftCancellationRequest)kmsg.getDocumentCommercialDraft();
        String bizOrgNumber = ct.getCxlPropsr().getCmonId();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = ct.getCxlPropsr().getAcct().getAcctSvcr(), acctId = ct.getCxlPropsr().getAcct().getId());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getCxlPropsr().setRole(oinfo.getOrgUnitRoleType().getValue());
    }
}

