/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.PledgeReqBillInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftCollateralizationRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.Agcy;
import com.kingdee.eas.fm.ecore.app.bean.node.Collztn;
import com.kingdee.eas.fm.ecore.app.bean.node.CollztnBk;
import com.kingdee.eas.fm.ecore.app.bean.node.CollztnPropsr;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.framework.BillBaseInfo;

public class SendHandlerCommercialDraftCollateralizationRequest
implements ISendHandler {
    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        CommercialDraftCollateralizationRequest cr = (CommercialDraftCollateralizationRequest)kmsg.getDocumentCommercialDraft();
        PledgeReqBillInfo info = (PledgeReqBillInfo)billBaseInfo;
        ECDSBillStatusEnum stateEnum = ECDSCommon.findElecDraftBillState(ctx, cr.getCollztnPropsr().getCmonId(), info.getDraftNumber());
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, cr.getComrclDrft().getIdNb(), cr.getCollztnPropsr().getCmonId(), billBaseInfo.getId().toString(), stateEnum, ElecDraftActionEnum.SEND, DraftMessageEnum.M018, null);
    }

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        PledgeReqBillInfo info = (PledgeReqBillInfo)billBaseInfo;
        ComrclDrft comrclDrft = new ComrclDrft();
        comrclDrft.setIdNb(info.getDraftNumber());
        comrclDrft.setIsseAmt(String.valueOf(info.getDraftAmount().setScale(2, 4)));
        Collztn collztn = new Collztn();
        collztn.setDt(info.getIssueDate().toString());
        if (FMHelper.isEmpty((String)info.getBatchNum())) {
            collztn.setBtchNb(null);
        } else {
            collztn.setBtchNb(info.getBatchNum());
        }
        if (FMHelper.isEmpty((String)info.getRemark())) {
            collztn.setRmrkByPropsr(null);
        } else {
            collztn.setRmrkByPropsr(info.getRemark());
        }
        CollztnPropsr collztnPropsr = new CollztnPropsr();
        collztnPropsr.setRole(null);
        collztnPropsr.setNm(info.getDrawerName());
        collztnPropsr.setCmonId(info.getDrawerOrgCode());
        if (info.getDrawerElecSign() != null && info.getDrawerElecSign().length() != 0) {
            collztnPropsr.setElctrncSgntr(info.getDrawerElecSign());
        } else {
            collztnPropsr.setElctrncSgntr("0");
        }
        Acct acct = new Acct();
        acct.setId(info.getDrawerAccount());
        acct.setAcctSvcr(info.getDrawerBank());
        Agcy agcy = new Agcy();
        Acct acc = new Acct();
        acc.setAcctSvcr(info.getPledgeAccepBank());
        agcy.setAcct(acc);
        collztnPropsr.setAgcy(agcy);
        collztnPropsr.setAcct(acct);
        CollztnBk collztnBk = new CollztnBk();
        collztnBk.setNm(info.getPledgeName());
        Acct acctt = new Acct();
        acctt.setId(info.getPledgeAccount());
        acctt.setAcctSvcr(info.getPledgeBank());
        collztnBk.setAcct(acctt);
        CommercialDraftCollateralizationRequest commercialDraftCollateralizationRequest = new CommercialDraftCollateralizationRequest();
        commercialDraftCollateralizationRequest.setComrclDrft(comrclDrft);
        commercialDraftCollateralizationRequest.setCollztnPropsr(collztnPropsr);
        commercialDraftCollateralizationRequest.setCollztnBk(collztnBk);
        commercialDraftCollateralizationRequest.setCollztn(collztn);
        KMsg msg = new KMsg();
        msg.setDocumentCommercialDraft(commercialDraftCollateralizationRequest);
        return msg;
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        PledgeReqBillInfo info = (PledgeReqBillInfo)billBaseInfo;
        return info.getPledgeBank();
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        PledgeReqBillInfo info = (PledgeReqBillInfo)billBaseInfo;
        return info.getDrawerBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        PledgeReqBillInfo info = (PledgeReqBillInfo)billBaseInfo;
        return info.getDraftNumber();
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String acctId;
        String actorBank;
        CommercialDraftCollateralizationRequest ct = (CommercialDraftCollateralizationRequest)kmsg.getDocumentCommercialDraft();
        String bizOrgNumber = ct.getCollztnPropsr().getCmonId();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = ct.getCollztnPropsr().getAcct().getAcctSvcr(), acctId = ct.getCollztnPropsr().getAcct().getId());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getCollztnPropsr().setRole(oinfo.getOrgUnitRoleType().getValue());
    }
}

