/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.ElecDraftBillEntryFactory;
import com.kingdee.eas.fm.ecore.ElecDraftBillEntryInfo;
import com.kingdee.eas.fm.ecore.ImpawnUnchainApplyBillInfo;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRepurchasedCollateralizationRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.Agcy;
import com.kingdee.eas.fm.ecore.app.bean.node.CollztnBk;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.RpdCollztn;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.framework.BillBaseInfo;

public class SendHandlerCommercialDraftRepurchasedCollateralizationRequest
implements ISendHandler {
    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        CommercialDraftRepurchasedCollateralizationRequest cr = (CommercialDraftRepurchasedCollateralizationRequest)kmsg.getDocumentCommercialDraft();
        String idNb = cr.getComrclDrft().getIdNb();
        String holderOrgCode = cr.getCollztnBk().getCmonId();
        ECDSBillStatusEnum eenum = ECDSCommon.findElecDraftBillState(ctx, holderOrgCode, idNb);
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, idNb, holderOrgCode, billBaseInfo.getId().toString(), eenum, ElecDraftActionEnum.SEND, DraftMessageEnum.M019, null);
    }

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        ImpawnUnchainApplyBillInfo info = (ImpawnUnchainApplyBillInfo)billBaseInfo;
        ComrclDrft comrclDrft = new ComrclDrft();
        comrclDrft.setIdNb(info.getDraftNumber().toString());
        comrclDrft.setIsseAmt(String.valueOf(info.getDraftAmount().setScale(2, 4)));
        RpdCollztn rpdCollztn = new RpdCollztn();
        rpdCollztn.setDt(info.getImpawnUnchainDate().toString());
        rpdCollztn.setBtchNb(info.getBatchNumber());
        if (!FMHelper.isEmpty((String)info.getPawneeRemark())) {
            rpdCollztn.setRmrkByPropsr(info.getPawneeRemark());
        } else {
            rpdCollztn.setRmrkByPropsr(null);
        }
        CollztnBk collztnBk = new CollztnBk();
        if (info.getImpawnType() != null) {
            collztnBk.setRole(info.getImpawnType().getValue());
        }
        collztnBk.setNm(info.getImpawnName());
        collztnBk.setCmonId(info.getImpawnOrgCode());
        collztnBk.setElctrncSgntr(info.getElectricSign());
        Acct acct = new Acct();
        acct.setId(info.getImpawnAccount());
        acct.setAcctSvcr(info.getImpawnBank());
        collztnBk.setAcct(acct);
        Agcy agcy = new Agcy();
        Acct acc = new Acct();
        acc.setAcctSvcr(info.getImpawnCarryBank());
        agcy.setAcct(acc);
        collztnBk.setAgcy(agcy);
        CommercialDraftRepurchasedCollateralizationRequest commercialDraftRepurchasedCollateralizationRequest = new CommercialDraftRepurchasedCollateralizationRequest();
        commercialDraftRepurchasedCollateralizationRequest.setCollztnBk(collztnBk);
        commercialDraftRepurchasedCollateralizationRequest.setComrclDrft(comrclDrft);
        commercialDraftRepurchasedCollateralizationRequest.setRpdCollztn(rpdCollztn);
        KMsg msg = new KMsg();
        msg.setDocumentCommercialDraft(commercialDraftRepurchasedCollateralizationRequest);
        return msg;
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        ImpawnUnchainApplyBillInfo info = (ImpawnUnchainApplyBillInfo)billBaseInfo;
        ElecDraftBillEntryInfo eleifo = ElecDraftBillEntryFactory.getLocalInstance(ctx).getElecDraftBillEntryCollection("select * from where draftNumber ='" + info.getDraftNumber() + "' and draftBizType=" + 11 + " laterOrgCode =" + info.getImpawnOrgCode() + " order by draftSignInDate desc").get(0);
        return eleifo.getFormerBank();
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        ImpawnUnchainApplyBillInfo info = (ImpawnUnchainApplyBillInfo)billBaseInfo;
        return info.getImpawnBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        ImpawnUnchainApplyBillInfo info = (ImpawnUnchainApplyBillInfo)billBaseInfo;
        return String.valueOf(info.getDraftNumber());
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String acctId;
        String actorBank;
        CommercialDraftRepurchasedCollateralizationRequest ct = (CommercialDraftRepurchasedCollateralizationRequest)kmsg.getDocumentCommercialDraft();
        String bizOrgNumber = ct.getCollztnBk().getCmonId();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = ct.getCollztnBk().getAcct().getAcctSvcr(), acctId = ct.getCollztnBk().getAcct().getId());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getCollztnBk().setRole(oinfo.getOrgUnitRoleType().getValue());
        ImpawnUnchainApplyBillInfo info = (ImpawnUnchainApplyBillInfo)billBaseInfo;
        info.setImpawnType(oinfo.getOrgUnitRoleType());
    }
}

