/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.DiscountRequestBillInfo;
import com.kingdee.eas.fm.ecore.DiscountTypeEnum;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftDiscountRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.AOAccnInf;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.Agcy;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.Dscnt;
import com.kingdee.eas.fm.ecore.app.bean.node.DscntBk;
import com.kingdee.eas.fm.ecore.app.bean.node.DscntPropsr;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.framework.BillBaseInfo;

public class SendHandlerDiscountRequest
implements ISendHandler {
    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        CommercialDraftDiscountRequest cr = (CommercialDraftDiscountRequest)kmsg.getDocumentCommercialDraft();
        DiscountRequestBillInfo info = (DiscountRequestBillInfo)billBaseInfo;
        String idNb = cr.getComrclDrft().getIdNb();
        String holderOrgCode = cr.getDscntPropsr().getCmonId();
        ECDSBillStatusEnum eenum = ECDSCommon.findElecDraftBillState(ctx, holderOrgCode, idNb);
        DraftMessageEnum messageTypeEnum = info.getDiscountType() == DiscountTypeEnum.RM00 ? DraftMessageEnum.M011_MAIDUAN : DraftMessageEnum.M011_HUIGOU;
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, idNb, holderOrgCode, info.getId().toString(), eenum, ElecDraftActionEnum.SEND, messageTypeEnum, null);
    }

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        DiscountRequestBillInfo di = (DiscountRequestBillInfo)billBaseInfo;
        KMsg kMsg = new KMsg();
        ComrclDrft comrclDrft = new ComrclDrft();
        comrclDrft.setIdNb(di.getBillNumber());
        comrclDrft.setIsseAmt(String.valueOf(di.getBillAmount().setScale(2)));
        Dscnt dscnt = new Dscnt();
        dscnt.setRpdMk(di.getDiscountType().getValue());
        dscnt.setDt(di.getRequestDate().toString());
        dscnt.setIntrstRate(di.getRate().setScale(6, 4));
        dscnt.setAmt(di.getPayfor().toString());
        if (di.getAssignmentMark() != null) {
            dscnt.setBanEndrsmtMk(di.getAssignmentMark().getValue());
        } else {
            dscnt.setBanEndrsmtMk("EM00");
        }
        dscnt.setSttlmMk(di.getBalanceMark().getValue());
        if (di.getBackOpenDate() != null) {
            dscnt.setRpdOpenDt(di.getBackOpenDate().toString());
        }
        if (di.getBackCloseDate() != null) {
            dscnt.setRpdDueDt(di.getBackCloseDate().toString());
        }
        if (di.getBackMoney() != null) {
            dscnt.setRpdIntrstRate(di.getBackRate().setScale(6, 4));
        }
        if (di.getBackRate() != null) {
            dscnt.setRpdAmt(di.getBackMoney().toString());
        }
        if (di.getTxCtrctNb() != null) {
            dscnt.setTxlCtrctNb(di.getTxCtrctNb());
        }
        if (di.getInvcNb() != null) {
            dscnt.setInvcNb(di.getInvcNb());
        }
        if (di.getBtchNb() != null) {
            dscnt.setBtchNb(di.getBtchNb().toString());
        }
        if (!FMHelper.isEmpty((String)di.getDiscounterRemark())) {
            dscnt.setRmrkByPropsr(di.getDiscounterRemark());
        } else {
            dscnt.setRmrkByPropsr(null);
        }
        AOAccnInf aoaInfo = new AOAccnInf();
        aoaInfo.setId(di.getAccountId());
        aoaInfo.setAcctSvcr(di.getBankId());
        DscntPropsr dscntPropsr = new DscntPropsr();
        if (di.getDiscounterType() != null) {
            dscntPropsr.setRole(di.getDiscounterType().getValue());
        }
        dscntPropsr.setNm(di.getDiscounterName());
        dscntPropsr.setCmonId(di.getGroupId());
        dscntPropsr.setElctrncSgntr(di.getDiscounterSgin());
        Acct endacct = new Acct();
        endacct.setId(di.getDiscounterAccount());
        endacct.setAcctSvcr(di.getDiscounterBank());
        dscntPropsr.setAcct(endacct);
        Agcy agcy = new Agcy();
        endacct = new Acct();
        endacct.setAcctSvcr(di.getDiscounterBankBak());
        dscntPropsr.setAgcy(agcy);
        DscntBk dscntBk = new DscntBk();
        dscntBk.setNm(di.getByDiscounterName());
        endacct = new Acct();
        endacct.setId(di.getByDiscounterAccount());
        endacct.setAcctSvcr(di.getByDiscounterBank());
        dscntBk.setAcct(endacct);
        CommercialDraftDiscountRequest commercialDraftDiscountRequest = new CommercialDraftDiscountRequest();
        commercialDraftDiscountRequest.setComrclDrft(comrclDrft);
        commercialDraftDiscountRequest.setAOAccnInf(aoaInfo);
        commercialDraftDiscountRequest.setDscnt(dscnt);
        commercialDraftDiscountRequest.setDscntPropsr(dscntPropsr);
        commercialDraftDiscountRequest.setDscntBk(dscntBk);
        kMsg.setDocumentCommercialDraft(commercialDraftDiscountRequest);
        return kMsg;
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        DiscountRequestBillInfo eactinfo = (DiscountRequestBillInfo)billBaseInfo;
        return eactinfo.getDiscounterBank();
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        DiscountRequestBillInfo eactinfo = (DiscountRequestBillInfo)billBaseInfo;
        return eactinfo.getDiscounterBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        DiscountRequestBillInfo eactinfo = (DiscountRequestBillInfo)billBaseInfo;
        return eactinfo.getBillNumber();
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String acctId;
        String actorBank;
        CommercialDraftDiscountRequest ct = (CommercialDraftDiscountRequest)kmsg.getDocumentCommercialDraft();
        String bizOrgNumber = ct.getDscntPropsr().getCmonId();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = ct.getDscntPropsr().getAcct().getAcctSvcr(), acctId = ct.getDscntPropsr().getAcct().getId());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getDscntPropsr().setRole(oinfo.getOrgUnitRoleType().getValue());
        String cnumber = ct.getDscntBk().getAcct().getAcctSvcr();
        BEBankInfo cbi = ECDSCommon.checkBEBank(ctx, cnumber);
        if (cbi == null) {
            throw new BOSException(ECDSCommon.PART_CHECK_ERROR);
        }
    }
}

