/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.GuaranteeRequestBillInfo;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.RoleEnum;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftGuaranteeRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.Agcy;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.Guarntee;
import com.kingdee.eas.fm.ecore.app.bean.node.Guarntr;
import com.kingdee.eas.fm.ecore.app.bean.node.Warntee;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.framework.BillBaseInfo;

public class SendHandlerGuaranteeRequest
implements ISendHandler {
    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        CommercialDraftGuaranteeRequest cr = (CommercialDraftGuaranteeRequest)kmsg.getDocumentCommercialDraft();
        GuaranteeRequestBillInfo entityInfo = (GuaranteeRequestBillInfo)billBaseInfo;
        String idNb = cr.getComrclDrft().getIdNb();
        String holderOrgCode = cr.getWarntee().getCmonId();
        ECDSBillStatusEnum eenum = ECDSCommon.findElecDraftBillState(ctx, holderOrgCode, idNb);
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, idNb, holderOrgCode, entityInfo.getId().toString(), eenum, ElecDraftActionEnum.SEND, DraftMessageEnum.M017, null);
    }

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        GuaranteeRequestBillInfo di = (GuaranteeRequestBillInfo)billBaseInfo;
        KMsg kMsg = new KMsg();
        ComrclDrft comrclDrft = new ComrclDrft();
        comrclDrft.setIdNb(di.getDraftNumber());
        comrclDrft.setIsseAmt(String.valueOf(di.getDraftAmount().setScale(2, 4)));
        Guarntee guarntee = new Guarntee();
        guarntee.setDt(di.getApplyDate().toString());
        guarntee.setBtchNb(di.getBatchNumber());
        if (!FMHelper.isEmpty((String)di.getWarranteeRemark())) {
            guarntee.setRmrkByPropsr(di.getWarranteeRemark());
        } else {
            guarntee.setRmrkByPropsr(null);
        }
        Warntee warntee = new Warntee();
        warntee.setRole(di.getWarranteeRole().getValue());
        warntee.setNm(di.getWarranteeName());
        warntee.setCmonId(di.getWarranteeOrgCode());
        if (di.getWarranteeElecSign() != null && di.getWarranteeElecSign().length() != 0) {
            warntee.setElctrncSgntr(di.getWarranteeElecSign());
        } else {
            warntee.setElctrncSgntr("AAAAAA");
        }
        Acct endacct = new Acct();
        endacct.setId(di.getWarranteeAccount());
        endacct.setAcctSvcr(di.getWarranteeBank());
        warntee.setAcct(endacct);
        Agcy agcy = new Agcy();
        endacct = new Acct();
        endacct.setAcctSvcr(di.getWarranteeAgcybank());
        warntee.setAgcy(agcy);
        Guarntr guarntr = new Guarntr();
        guarntr.setNm(di.getGuarantorName());
        endacct = new Acct();
        endacct.setId(di.getGuarantorAccount());
        endacct.setAcctSvcr(di.getGuarantorBank());
        guarntr.setAcct(endacct);
        CommercialDraftGuaranteeRequest commercialDraftGuaranteeRequest = new CommercialDraftGuaranteeRequest();
        commercialDraftGuaranteeRequest.setComrclDrft(comrclDrft);
        commercialDraftGuaranteeRequest.setGuarntee(guarntee);
        commercialDraftGuaranteeRequest.setWarntee(warntee);
        commercialDraftGuaranteeRequest.setGuarntr(guarntr);
        kMsg.setDocumentCommercialDraft(commercialDraftGuaranteeRequest);
        return kMsg;
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        GuaranteeRequestBillInfo eactinfo = (GuaranteeRequestBillInfo)billBaseInfo;
        return eactinfo.getGuarantorBank();
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        GuaranteeRequestBillInfo eactinfo = (GuaranteeRequestBillInfo)billBaseInfo;
        return eactinfo.getWarranteeBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        GuaranteeRequestBillInfo eactinfo = (GuaranteeRequestBillInfo)billBaseInfo;
        return eactinfo.getDraftNumber();
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String cnumber;
        BEBankInfo cbi;
        String acctId;
        String actorBank;
        GuaranteeRequestBillInfo di = (GuaranteeRequestBillInfo)billBaseInfo;
        CommercialDraftGuaranteeRequest ct = (CommercialDraftGuaranteeRequest)kmsg.getDocumentCommercialDraft();
        String bizOrgNumber = ct.getWarntee().getCmonId();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = ct.getWarntee().getAcct().getAcctSvcr(), acctId = ct.getWarntee().getAcct().getId());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getWarntee().setRole(oinfo.getOrgUnitRoleType().getValue());
        if (oinfo.getOrgUnitRoleType() == RoleEnum.RC00) {
            ct.getWarntee().setElctrncSgntr("0");
            di.setWarranteeElecSign(ct.getWarntee().getElctrncSgntr());
        }
        if ((cbi = ECDSCommon.checkBEBank(ctx, cnumber = ct.getGuarntr().getAcct().getAcctSvcr())) == null) {
            throw new BOSException(ECDSCommon.PART_CHECK_ERROR);
        }
    }
}

