/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.ElecDraftBillInfo;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.TipsTicketCollectorBillInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftIssuanceRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.Agcy;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.Drwr;
import com.kingdee.eas.fm.ecore.app.bean.node.Issnc;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.framework.BillBaseInfo;

public class SendHandlerIssuanceRequest
implements ISendHandler {
    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        TipsTicketCollectorBillInfo info = (TipsTicketCollectorBillInfo)billBaseInfo;
        KMsg ksmg = new KMsg();
        CommercialDraftIssuanceRequest cr = new CommercialDraftIssuanceRequest();
        ComrclDrft comrclDrft = new ComrclDrft();
        if (null != info) {
            comrclDrft.setIdNb(info.getDraftNumber());
            comrclDrft.setIsseAmt(String.valueOf(info.getDraftAmount().setScale(2)));
        }
        Issnc Issnc2 = new Issnc();
        if (!FMHelper.isEmpty((String)info.getDraftRemark())) {
            Issnc2.setRmrkByPropsr(info.getDraftRemark());
        } else {
            Issnc2.setRmrkByPropsr(null);
        }
        Drwr drwr = new Drwr();
        if (drwr.getRole() != null) {
            drwr.setRole(info.getDrawerRole().getValue());
        }
        if (null != info) {
            drwr.setCmonId(info.getBizPromoterOrgCode());
        }
        if (info.getDrawerElecSign() != null) {
            drwr.setElctrncSgntr(info.getDrawerElecSign());
        } else {
            drwr.setElctrncSgntr("12334");
        }
        Acct acct = new Acct();
        acct.setId(info.getDrawerAccount());
        acct.setAcctSvcr(info.getDrawerBank());
        drwr.setAcct(acct);
        Agcy agcy = new Agcy();
        Acct acct2 = new Acct();
        acct2.setAcctSvcr(info.getDrawerCarryBank());
        agcy.setAcct(acct2);
        drwr.setAgcy(agcy);
        cr.setComrclDrft(comrclDrft);
        cr.setIssnc(Issnc2);
        cr.setDrwr(drwr);
        ksmg.setDocumentCommercialDraft(cr);
        return ksmg;
    }

    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        TipsTicketCollectorBillInfo tc = (TipsTicketCollectorBillInfo)billBaseInfo;
        CommercialDraftIssuanceRequest cr = (CommercialDraftIssuanceRequest)kmsg.getDocumentCommercialDraft();
        String idNb = cr.getComrclDrft().getIdNb();
        String holderOrgCode = tc.getBizPromoterOrgCode();
        ECDSBillStatusEnum eenum = ECDSCommon.findElecDraftBillState(ctx, holderOrgCode, idNb);
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, idNb, holderOrgCode, tc.getId().toString(), eenum, ElecDraftActionEnum.SEND, DraftMessageEnum.M003, null);
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        TipsTicketCollectorBillInfo actinfo = (TipsTicketCollectorBillInfo)billBaseInfo;
        ElecDraftBillInfo info = ECDSCommon.findElecDraftBillInfoByIndb(ctx, actinfo.getDraftNumber());
        return info.getPayeeBank();
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        TipsTicketCollectorBillInfo actinfo = (TipsTicketCollectorBillInfo)billBaseInfo;
        return actinfo.getDrawerBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        TipsTicketCollectorBillInfo actinfo = (TipsTicketCollectorBillInfo)billBaseInfo;
        return actinfo.getDraftNumber();
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String acctId;
        String actorBank;
        CommercialDraftIssuanceRequest ct = (CommercialDraftIssuanceRequest)kmsg.getDocumentCommercialDraft();
        String bizOrgNumber = ct.getDrwr().getCmonId();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = ct.getDrwr().getAcct().getAcctSvcr(), acctId = ct.getDrwr().getAcct().getId());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getDrwr().setRole(oinfo.getOrgUnitRoleType().getValue());
    }
}

