/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.DraftRegisterBillInfo;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRegisterRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.Accptr;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.Drwr;
import com.kingdee.eas.fm.ecore.app.bean.node.Pyee;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.fm.ecore.app.util.DateUtil;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;

public class SendHandlerRegisterRequest
implements ISendHandler {
    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) {
        DraftRegisterBillInfo di = (DraftRegisterBillInfo)billBaseInfo;
        KMsg kMsg = new KMsg();
        ComrclDrft comrclDrft = new ComrclDrft();
        comrclDrft.setTp(di.getDraftType().getValue());
        comrclDrft.setIsseAmt(di.getDraftAmount().setScale(2).toString());
        if (null != di.getIssueDate()) {
            comrclDrft.setIsseDt(DateTimeUtils.formatDate((Date)di.getIssueDate()));
        }
        if (null != di.getDueDate()) {
            comrclDrft.setDueDt(DateTimeUtils.formatDate((Date)di.getDueDate()));
        }
        if (di.getBanEndorsement() != null) {
            comrclDrft.setBanEndrsmtMk(di.getBanEndorsement().getValue());
        }
        comrclDrft.setRmrk(di.getRemark());
        Drwr drwr = new Drwr();
        if (di.getDrawerRole() != null) {
            drwr.setRole(di.getDrawerRole().getValue());
        }
        drwr.setNm(di.getDrawerName());
        drwr.setCmonId(di.getDrawerOrgCode());
        drwr.setElctrncSgntr(di.getDrawerElecSign());
        drwr.setCdtRatgs(di.getDrawerCreditRat());
        if (null != di.getDrawerRtDueDate()) {
            drwr.setCdtRatgDueDt(DateUtil.getDateStr(di.getDrawerRtDueDate()));
        }
        drwr.setCdtRatgAgcy(di.getDrawerCdtRater());
        Acct acct = new Acct();
        acct.setId(di.getDrawerAccount());
        acct.setAcctSvcr(di.getDrawerBank());
        drwr.setAcct(acct);
        Accptr accptr = new Accptr();
        accptr.setNm(di.getAcceptorName());
        Acct acct2 = new Acct();
        acct2.setAcctSvcr(di.getAcceptorBank());
        acct2.setId(di.getAcceptorAccount());
        accptr.setAcct(acct2);
        Pyee pyee = new Pyee();
        pyee.setNm(di.getPayeeName());
        Acct acct3 = new Acct();
        acct3.setId(di.getPayeeAccount());
        acct3.setAcctSvcr(di.getPayeeBank());
        pyee.setAcct(acct3);
        CommercialDraftRegisterRequest commercialDraftRegisterRequest = new CommercialDraftRegisterRequest();
        commercialDraftRegisterRequest.setComrclDrft(comrclDrft);
        commercialDraftRegisterRequest.setDrwr(drwr);
        commercialDraftRegisterRequest.setAccptr(accptr);
        commercialDraftRegisterRequest.setPyee(pyee);
        kMsg.setDocumentCommercialDraft(commercialDraftRegisterRequest);
        return kMsg;
    }

    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        DraftRegisterBillInfo di = (DraftRegisterBillInfo)billBaseInfo;
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, null, di.getBizPromoterOrgCode(), di.getId().toString(), null, ElecDraftActionEnum.SEND, DraftMessageEnum.M001, null);
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        DraftRegisterBillInfo info = (DraftRegisterBillInfo)billBaseInfo;
        return info.getAcceptorBank();
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        DraftRegisterBillInfo info = (DraftRegisterBillInfo)billBaseInfo;
        return info.getDrawerBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String acctId;
        String actorBank;
        CommercialDraftRegisterRequest ct = (CommercialDraftRegisterRequest)kmsg.getDocumentCommercialDraft();
        DraftRegisterBillInfo di = (DraftRegisterBillInfo)billBaseInfo;
        String bizOrgNumber = ct.getDrwr().getCmonId();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = ct.getDrwr().getAcct().getAcctSvcr(), acctId = ct.getDrwr().getAcct().getId());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getDrwr().setRole(oinfo.getOrgUnitRoleType().getValue());
        ct.getDrwr().setNm(oinfo.getOrgUnitName());
        String cnumber = ct.getAccptr().getAcct().getAcctSvcr();
        BEBankInfo cbi = ECDSCommon.checkBEBank(ctx, cnumber);
        if (cbi == null) {
            throw new BOSException(ECDSCommon.PART_CHECK_ERROR);
        }
        ct.getAccptr().setNm(cbi.getName());
        String snumber = ct.getPyee().getAcct().getAcctSvcr();
        BEBankInfo sbi = ECDSCommon.checkBEBank(ctx, snumber);
        if (sbi == null) {
            throw new BOSException(ECDSCommon.PART_CHECK_ERROR);
        }
        di.setDrawerRole(oinfo.getOrgUnitRoleType());
    }
}

