/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.ecore.ActionCancelBillInfo;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.BusinessNotificationCollection;
import com.kingdee.eas.fm.ecore.BusinessNotificationFactory;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.RecourseAgreementRequestBillInfo;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.RoleEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.EdrafException;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.RcrsAgreeApplyBillFactory;
import com.kingdee.eas.fm.edraf.RcrsAgreeApplyBillInfo;
import com.kingdee.eas.fm.edraf.app.AbstractRcrsAgreeApplyBillControllerBean;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftRcrsAgreeBillFactory;
import com.kingdee.eas.fm.edrafent.DraftRcrsAgreeBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RcrsAgreeApplyBillControllerBean
extends AbstractRcrsAgreeApplyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.RcrsAgreeApplyBillControllerBean");

    @Override
    public void checkDraftApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RcrsAgreeApplyBillInfo info = (RcrsAgreeApplyBillInfo)model;
        if (info.isIsCancelDraft() && info.getEndECDSState() != ECDSBillStatusEnum.FJFZSTYQCDQS && info.getEndECDSState() != ECDSBillStatusEnum.JFZSTYQCDQS) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"57_RcrsAgreeApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (info.getOperateState().getValue() != 0 && info.getCommunicationStatus().getValue() != 2) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"1_AcceptanceApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RcrsAgreeApplyBillInfo info = (RcrsAgreeApplyBillInfo)model;
        RecourseAgreementRequestBillInfo rcrsInfo = new RecourseAgreementRequestBillInfo();
        rcrsInfo.setDraftNumber(info.getCommercialDraft().getDraftNumber());
        rcrsInfo.setDraftAmount(info.getCommercialDraft().getDraftAmount());
        rcrsInfo.setAgreeDate(info.getRecourseDate());
        rcrsInfo.setAgreeAmount(info.getRecourseAmt());
        rcrsInfo.setAgreeRemark(info.getRemark());
        rcrsInfo.setAgreemanType(RoleEnum.RC01);
        rcrsInfo.setAgreemanName(info.getRecourserName().getName());
        rcrsInfo.setGroupId(info.getRecourseOrgCode());
        String eletricSign = "";
        if (info.getApplyCompany() != null) {
            eletricSign = EdrafUtil.getSignatureByBillId(ctx, info.getSourceBillId(), info.getApplyCompany().getId().toString());
        }
        rcrsInfo.setAgreemanSgin(eletricSign);
        rcrsInfo.setAgreemanAccount(info.getRecourseAccount().getBankAccountNumber());
        rcrsInfo.setAgreemanBank(info.getRecourseBankNum().getNumber());
        rcrsInfo.setSourceBillId(info.getId().toString());
        rcrsInfo.setBizPromoterOrgCode(info.getRecourseOrgCode());
        rcrsInfo.setBizSerialNumber(info.getBizCode());
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterInfo status = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)info.getCommercialDraft().getDraftNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("actionType", (Object)ElecDraftActionEnum.RECEIVE_WAIT_REPLY, CompareType.EQUALS));
        status.getFilterItems().add(new FilterItemInfo("communicatedDraftStatus", (Object)ECDSBillStatusEnum.FJFZSDQC, CompareType.EQUALS));
        status.getFilterItems().add(new FilterItemInfo("communicatedDraftStatus", (Object)ECDSBillStatusEnum.JFZSDQC, CompareType.EQUALS));
        status.setMaskString("(#0 or #1)");
        filter.mergeFilter(status, "and");
        SorterItemInfo sortInfo = new SorterItemInfo("createtime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        env.setSorter(sortCol);
        env.setFilter(filter);
        BusinessNotificationCollection coll = BusinessNotificationFactory.getLocalInstance((Context)ctx).getBusinessNotificationCollection(env);
        rcrsInfo.setOrgMessageId(coll.get(0).getMessageID());
        rcrsInfo.setOrgMessageTime(coll.get(0).getMessageTime());
        return rcrsInfo;
    }

    @Override
    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        sic.add(new SelectorItemInfo("recourserName.*"));
        sic.add(new SelectorItemInfo("recourseAccount.*"));
        sic.add(new SelectorItemInfo("recourseBankNum.*"));
        return sic;
    }

    @Override
    public DraftApplyBillBaseCollection getBillCollection(Context ctx, Set idSet, SelectorItemCollection sic) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)FCOperateStateEnum.save, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_READY, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.PROCESS_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("returnOpinion", null, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or ((#3 or #4) and #5))");
        env.setSelector(sic);
        env.setFilter(filter);
        DraftApplyBillBaseCollection registerCol = RcrsAgreeApplyBillFactory.getLocalInstance(ctx).getDraftApplyBillBaseCollection(env);
        if (registerCol == null || registerCol.size() == 0) {
            throw new EdrafException(EdrafException.SUBMIT_ERROR);
        }
        return registerCol;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.ZSTYQCSQ;
    }

    @Override
    protected void _rewriteECDSMess(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
        DraftRcrsAgreeBillInfo draftInfo;
        RcrsAgreeApplyBillInfo endorInfo = this.getRcrsAgreeApplyBillInfo(ctx, (IObjectPK)new ObjectUuidPK(sourceBillId));
        if (endorInfo != null && endorInfo.getSourceBillId() != null && endorInfo.isIsCancelDraft() && ecdsApplyBillStatus == ApplyBillStatusEnum.RECEIVE_033_OK && (draftInfo = DraftRcrsAgreeBillFactory.getLocalInstance((Context)ctx).getDraftRcrsAgreeBillInfo((IObjectPK)new ObjectUuidPK(endorInfo.getSourceBillId()))) != null && draftInfo.getSourceBillId() != null) {
            String sourceId = draftInfo.getSourceBillId();
            StringBuffer sb = new StringBuffer();
            sb.append("update T_EDT_DraftSignUp  set FObjectBillType=null where fid=?");
            String sql = sb.toString();
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{sourceId});
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSCancelBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RcrsAgreeApplyBillInfo info = (RcrsAgreeApplyBillInfo)model;
        ActionCancelBillInfo cancelBillInfo = new ActionCancelBillInfo();
        CommercialDraftInfo draftInfo = info.getCommercialDraft();
        cancelBillInfo.setDraftNumber(draftInfo.getDraftNumber());
        cancelBillInfo.setDraftAmount(draftInfo.getDraftAmount());
        String eletricSign = "";
        if (info.getApplyCompany() != null) {
            eletricSign = EdrafUtil.getSignatureByBillId(ctx, info.getSourceBillId(), info.getApplyCompany().getId().toString());
        }
        cancelBillInfo.setEletricSign(eletricSign);
        cancelBillInfo.setCancelOrgCode(info.getRecourseOrgCode());
        cancelBillInfo.setCancelAccount(info.getRecourseAccount().getBankAccountNumber());
        cancelBillInfo.setCancelBank(info.getRecourseBankNum().getNumber());
        cancelBillInfo.setBizPromoterOrgCode(info.getRecourseOrgCode());
        return cancelBillInfo;
    }
}

