/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.ActionCancelBillInfo;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.BanEndorsementMarkEnum;
import com.kingdee.eas.fm.ecore.DiscountAgainInfo;
import com.kingdee.eas.fm.ecore.DiscountTypeEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.SettlementMarkEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.ITransDistApplyBill;
import com.kingdee.eas.fm.edraf.TransDistApplyBillCollection;
import com.kingdee.eas.fm.edraf.TransDistApplyBillFactory;
import com.kingdee.eas.fm.edraf.TransDistApplyBillInfo;
import com.kingdee.eas.fm.edraf.TransDistKindEnum;
import com.kingdee.eas.fm.edraf.app.AbstractTransDistApplyBillControllerBean;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftKindEnum;
import com.kingdee.eas.fm.edrafent.DraftStockBillCollection;
import com.kingdee.eas.fm.edrafent.DraftStockBillFactory;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillOperateEnum;
import com.kingdee.eas.fm.edrafent.IDraftStockBill;
import com.kingdee.eas.fm.edrafent.util.EdrafentUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class TransDistApplyBillControllerBean
extends AbstractTransDistApplyBillControllerBean {
    private static final long serialVersionUID = 6409776036985409184L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.TransDistApplyBillControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TransDistApplyBillInfo billInfo = (TransDistApplyBillInfo)model;
        if (billInfo.getOperateState().equals((Object)FCOperateStateEnum.save)) {
            billInfo.setOperateState(FCOperateStateEnum.SUBMIT1);
        }
        return super._submit(ctx, (IObjectValue)billInfo);
    }

    @Override
    protected void _submit(Context ctx, Set set) throws BOSException, EASBizException {
        List ids = FMHelper.set2List((Set)set);
        if (ids != null && ids.size() == 1) {
            ITransDistApplyBill iTransDistApplyBill = TransDistApplyBillFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("operateState");
            TransDistApplyBillInfo info = iTransDistApplyBill.getTransDistApplyBillInfo((IObjectPK)new ObjectUuidPK(ids.get(0).toString()), sic);
            if (info.getOperateState() == FCOperateStateEnum.save) {
                info.setOperateState(FCOperateStateEnum.SUBMIT1);
                iTransDistApplyBill.updatePartial((CoreBaseInfo)info, sic);
                super.submit(ctx, (CoreBaseInfo)info);
            } else {
                this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"74_RpdTransDistApplyBillControllerBean", (Locale)ctx.getLocale()));
            }
        } else if (ids != null && ids.size() > 1) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("operateState");
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
            view.setFilter(filter);
            ITransDistApplyBill iTransDistApplyBill = TransDistApplyBillFactory.getLocalInstance(ctx);
            TransDistApplyBillCollection coll = iTransDistApplyBill.getTransDistApplyBillCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                if (coll.get(i).getOperateState() != FCOperateStateEnum.save) continue;
                coll.get(i).setOperateState(FCOperateStateEnum.SUBMIT1);
                iTransDistApplyBill.updatePartial((CoreBaseInfo)coll.get(i), sic);
                super.submit(ctx, (CoreBaseInfo)coll.get(i));
            }
        }
    }

    @Override
    protected void _audit(Context ctx, Set set) throws BOSException, EASBizException {
        List ids = FMHelper.set2List((Set)set);
        if (ids != null && ids.size() == 1) {
            ITransDistApplyBill iTransDistApplyBill = TransDistApplyBillFactory.getLocalInstance(ctx);
            TransDistApplyBillInfo info = iTransDistApplyBill.getTransDistApplyBillInfo((IObjectPK)new ObjectUuidPK(ids.get(0).toString()));
            if (info.getOperateState() == FCOperateStateEnum.SUBMIT1) {
                this._audit4WF(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
            } else {
                this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"75_RpdTransDistApplyBillControllerBean", (Locale)ctx.getLocale()));
            }
        } else if (ids != null && ids.size() > 1) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
            view.setFilter(filter);
            ITransDistApplyBill iTransDistApplyBill = TransDistApplyBillFactory.getLocalInstance(ctx);
            TransDistApplyBillCollection coll = iTransDistApplyBill.getTransDistApplyBillCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                if (coll.get(i).getOperateState() != FCOperateStateEnum.SUBMIT1) continue;
                this._audit4WF(ctx, (IObjectPK)new ObjectUuidPK(coll.get(i).getId().toString()), (IObjectValue)coll.get(i));
            }
        }
    }

    @Override
    protected void _unAudit(Context ctx, Set set) throws BOSException, EASBizException {
        List ids = FMHelper.set2List((Set)set);
        if (ids != null && ids.size() == 1) {
            ITransDistApplyBill iTransDistApplyBill = TransDistApplyBillFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("operateState");
            TransDistApplyBillInfo info = iTransDistApplyBill.getTransDistApplyBillInfo((IObjectPK)new ObjectUuidPK(ids.get(0).toString()), sic);
            if (info.getOperateState() == FCOperateStateEnum.AUDITED) {
                info.setOperateState(FCOperateStateEnum.save);
                iTransDistApplyBill.updatePartial((CoreBaseInfo)info, sic);
                this.unAudit4WF(ctx, info);
            } else {
                this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"61_ReDiscountApplyBillControllerBean", (Locale)ctx.getLocale()));
            }
        } else if (ids != null && ids.size() > 1) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("operateState");
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
            view.setFilter(filter);
            ITransDistApplyBill iTransDistApplyBill = TransDistApplyBillFactory.getLocalInstance(ctx);
            TransDistApplyBillCollection coll = iTransDistApplyBill.getTransDistApplyBillCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                if (coll.get(i).getOperateState() != FCOperateStateEnum.AUDITED) continue;
                coll.get(i).setOperateState(FCOperateStateEnum.save);
                iTransDistApplyBill.updatePartial((CoreBaseInfo)coll.get(i), sic);
                this.unAudit4WF(ctx, coll.get(i));
            }
        }
    }

    @Override
    protected void _draftCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ITransDistApplyBill iTransDistApplyBill = TransDistApplyBillFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("operateState");
        sic.add("commercialDraft.draftECDSStatus");
        TransDistApplyBillInfo info = iTransDistApplyBill.getTransDistApplyBillInfo(pk, sic);
        if (this.checkDraftCancel(info)) {
            info.setOperateState(FCOperateStateEnum.CANCEL);
            iTransDistApplyBill.updatePartial((CoreBaseInfo)info, sic);
            TransDistApplyBillInfo info2 = iTransDistApplyBill.getTransDistApplyBillInfo(pk);
            info2.setId(null);
            info2.setDraftSourceBill(info.getId().toString());
            info2.setOperateState(FCOperateStateEnum.save);
            info2.setIsCancelDraft(true);
            info2.setNumber(null);
            info2.setSubmitDate(null);
            info2.setSubmitter(null);
            info2.setBizCode(null);
            info2.setCommunicationStatus(ECDSCommunicationStatusEnum.SUBMIT_READY);
            IObjectPK info2PK = iTransDistApplyBill.addnew((CoreBaseInfo)info2);
            EdrafentUtil.saveBotpRelation((Context)ctx, (CoreBillBaseInfo)new DraftStockBillInfo(), (CoreBillBaseInfo)info2, (String)info2.getSourceBillId(), (String)info2PK.toString());
        } else {
            this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"84_TransDistApplyBillControllerBean", (Locale)ctx.getLocale()));
        }
    }

    private boolean checkDraftCancel(TransDistApplyBillInfo info) {
        ECDSBillStatusEnum draftECDSStatus = null;
        if (info == null || info.getCommercialDraft() == null || info.getCommercialDraft().getDraftECDSStatus() == null) {
            return false;
        }
        draftECDSStatus = info.getCommercialDraft().getDraftECDSStatus();
        return draftECDSStatus != null && (draftECDSStatus == ECDSBillStatusEnum.HGSZHTXDQS || draftECDSStatus == ECDSBillStatusEnum.MDSZHTXDQS) && !info.isIsCancelDraft() && info.getOperateState() != FCOperateStateEnum.CANCEL;
    }

    protected void _deleteBatchData(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        HashSet<IObjectPK> ids = new HashSet<IObjectPK>();
        for (int i = 0; i < pkArray.length; ++i) {
            ids.add(pkArray[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        view.setFilter(filter);
        ITransDistApplyBill iTransDistApplyBill = TransDistApplyBillFactory.getLocalInstance(ctx);
        TransDistApplyBillCollection coll = iTransDistApplyBill.getTransDistApplyBillCollection(view);
        TransDistApplyBillInfo info = null;
        LinkedList<String> newIDS = new LinkedList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (info.getOperateState() == FCOperateStateEnum.save || info.getOperateState() == FCOperateStateEnum.SUBMIT1) {
                SelectorItemCollection sic;
                newIDS.add(info.getId().toString());
                BOTRelationFactory.getLocalInstance((Context)ctx).removeRelationByDestObjId(info.getId().toString(), "2B1A7202");
                if (info.isIsCancelDraft()) {
                    sic = new SelectorItemCollection();
                    sic.add("id");
                    sic.add("OperateState");
                    TransDistApplyBillInfo applyBillInfo = iTransDistApplyBill.getTransDistApplyBillInfo((IObjectPK)new ObjectUuidPK(info.getDraftSourceBill()), sic);
                    applyBillInfo.setOperateState(FCOperateStateEnum.submit);
                    iTransDistApplyBill.updatePartial((CoreBaseInfo)applyBillInfo, sic);
                    continue;
                }
                sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("draftStockOperate");
                sic.add("turnDiscount");
                IDraftStockBill iDraftStockBill = DraftStockBillFactory.getLocalInstance((Context)ctx);
                DraftStockBillInfo stockInfo = iDraftStockBill.getDraftStockBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()), sic);
                stockInfo.setDraftStockOperate(DraftStockBillOperateEnum.REGISTER);
                stockInfo.setTurnDiscount(false);
                iDraftStockBill.updatePartial((CoreBaseInfo)stockInfo, sic);
                continue;
            }
            if (coll.size() != 1) continue;
            this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"77_RpdTransDistApplyBillControllerBean", (Locale)ctx.getLocale()));
        }
        IObjectPK[] newPKS = new IObjectPK[newIDS.size()];
        for (int i = 0; i < newIDS.size(); ++i) {
            newPKS[i] = new ObjectUuidPK(newIDS.get(i).toString());
        }
        super._deleteBatchData(ctx, newPKS);
    }

    @Override
    protected void _registerAccount(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("endECDSState", (Object)"130206", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endECDSState", (Object)"130106", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isTally", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.setMaskString("#0 and ((#1 or #2) and #3)");
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("commercialDraft.id");
        selectors.add("commercialDraft.number");
        selectors.add("commercialDraft.draftECDSStatus");
        selectors.add("commercialDraft.draftAmount");
        selectors.add("inAccount.id");
        selectors.add("inAccount.number");
        selectors.add("inAccount.name");
        selectors.add("inAccount.isBank");
        selectors.add("inAccount.isCash");
        selectors.add("inAccount.account.id");
        selectors.add("inAccount.account.number");
        selectors.add("inAccount.account.name");
        selectors.add("inAccount.currency.id");
        selectors.add("inAccount.currency.number");
        selectors.add("inAccount.currency.name");
        view.setSelector(selectors);
        view.setFilter(filter);
        ITransDistApplyBill iTransDistApplyBill = TransDistApplyBillFactory.getLocalInstance(ctx);
        TransDistApplyBillCollection coll = iTransDistApplyBill.getTransDistApplyBillCollection(view);
        if (coll == null || coll.size() == 0) {
            this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"85_TransDistApplyBillControllerBean", (Locale)ctx.getLocale()));
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < coll.size(); ++i) {
            TransDistApplyBillInfo info = coll.get(i);
            if (info.isIsTally()) {
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"64_ReDiscountApplyBillControllerBean", (Locale)ctx.getLocale())).append(info.getNumber()).append(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"86_TransDistApplyBillControllerBean", (Locale)ctx.getLocale())).append("\n");
                continue;
            }
            if (info.getInAccount() != null && info.getInAccount().isIsBank()) continue;
            if (info.getInAccount() == null) {
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"64_ReDiscountApplyBillControllerBean", (Locale)ctx.getLocale())).append(info.getNumber()).append(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"66_ReDiscountApplyBillControllerBean", (Locale)ctx.getLocale()));
                continue;
            }
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"64_ReDiscountApplyBillControllerBean", (Locale)ctx.getLocale())).append(info.getNumber()).append(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"87_TransDistApplyBillControllerBean", (Locale)ctx.getLocale()));
        }
        if (sb.length() != 0) {
            NumericExceptionSubItem item = new NumericExceptionSubItem("{0}", "{0}");
            EASBizException exec = new EASBizException(item, (Object[])new String[]{sb.toString()});
            throw exec;
        }
        HashSet<BOSUuid> redSet = new HashSet<BOSUuid>();
        Iterator it = coll.iterator();
        TransDistApplyBillInfo info = null;
        while (it.hasNext()) {
            Date date;
            Date now;
            info = (TransDistApplyBillInfo)it.next();
            JournalInfo journalInfo = new JournalInfo();
            redSet.add(info.getId());
            PeriodInfo peroid = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info.getCompany());
            Date bizDate = now = new Date();
            if (peroid != null && (date = peroid.getBeginDate()).compareTo(now) > 0) {
                bizDate = date;
            }
            journalInfo.setCompany(info.getCompany());
            journalInfo.setBizDate(bizDate);
            journalInfo.setBillNumber(info.getNumber());
            journalInfo.setBillId(info.getId().toString());
            journalInfo.setDebitAmount(info.getTransDistRealPayAmount());
            journalInfo.setCreateDate(bizDate);
            journalInfo.setType(JournalTypeEnum.BANK);
            journalInfo.setAccountBank(info.getInAccount());
            journalInfo.setAccountView(info.getInAccount().getAccount());
            journalInfo.setCurrency(info.getInAccount().getCurrency());
            journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
            journalInfo.setSource(JournalSourceEnum.BYBILL);
            journalInfo.setPeriod(peroid);
            journalInfo.setDescription(info.getDistOutRemark());
            JournalFactory.getLocalInstance((Context)ctx).addnew(journalInfo);
        }
        if (redSet == null || redSet.size() <= 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"85_TransDistApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        String sql = "update T_EDR_TransDistApplyBill set FIsTally=? where " + FMHelper.buildIn((String)"FID", (Object[])redSet.toArray());
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1)});
    }

    @Override
    protected void _unRegisterAccount(Context ctx, Set set) throws BOSException, EASBizException {
        Set idSet = set;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filters = filter.getFilterItems();
        filters.add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filters.add(new FilterItemInfo("istally", (Object)Boolean.TRUE));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        view.setSelector(selectors);
        view.setFilter(filter);
        TransDistApplyBillCollection coll = TransDistApplyBillFactory.getLocalInstance(ctx).getTransDistApplyBillCollection(view);
        if (coll != null && coll.size() > 0) {
            HashSet<BOSUuid> redset = new HashSet<BOSUuid>();
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                redset.add(coll.get(i).getId());
            }
            if (redset != null && redset.size() > 0) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("billId", (Object)set, CompareType.INCLUDE));
                JournalFactory.getLocalInstance((Context)ctx).delete(filter);
                String sql = "update T_EDR_TransDistApplyBill set FIsTally=? where " + FMHelper.buildIn((String)"FID", (Object[])redset.toArray());
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(0)});
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"88_TransDistApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    public void checkDraftApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TransDistApplyBillInfo info = (TransDistApplyBillInfo)model;
        if (info.isIsCancelDraft() && info.getEndECDSState() != ECDSBillStatusEnum.MDSZHTXDQS && info.getEndECDSState() != ECDSBillStatusEnum.HGSZHTXDQS) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"89_TransDistApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (info.getOperateState() != FCOperateStateEnum.AUDITED && info.getCommunicationStatus() != ECDSCommunicationStatusEnum.SUBMIT_FAIL) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"1_AcceptanceApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TransDistApplyBillInfo info = (TransDistApplyBillInfo)model;
        DiscountAgainInfo coreInfo = new DiscountAgainInfo();
        coreInfo.setBillNumber(info.getCommercialDraft().getDraftNumber());
        coreInfo.setBillAmount(info.getCommercialDraft().getDraftAmount());
        coreInfo.setDiscountType(info.getTransDistKind() == TransDistKindEnum.HUIGOUSHIZHUANTIEXIAN ? DiscountTypeEnum.RM01 : DiscountTypeEnum.RM00);
        coreInfo.setRequestDate(info.getTransDistReqDate());
        coreInfo.setRate(info.getTransDistRate().multiply(new BigDecimal("0.01")).setScale(6, 0));
        coreInfo.setPayfor(info.getTransDistRealPayAmount());
        coreInfo.setAssignmentMark(info.isIsAttorn() ? BanEndorsementMarkEnum.EM00 : BanEndorsementMarkEnum.EM01);
        coreInfo.setBalanceMark(info.isIsOnLine() ? SettlementMarkEnum.SM00 : SettlementMarkEnum.SM01);
        coreInfo.setDiscounterName(info.getDistOutName().getName());
        coreInfo.setBizPromoterOrgCode(info.getOrgCode());
        coreInfo.setDiscounterSgin("0");
        coreInfo.setDiscounterAccount(info.getDistOutAccount().getBankAccountNumber());
        coreInfo.setDiscounterBank(info.getDistOutBankNum());
        coreInfo.setBizSerialNumber(info.getBizCode());
        coreInfo.setByDiscounterName(info.getDistInName());
        coreInfo.setByDiscounterAccount(info.getDistInAccount());
        coreInfo.setByDiscounterBank(info.getDistInBankNum());
        coreInfo.setBackOpenDate(info.getTransDistKind() == TransDistKindEnum.MAIDUANSHIZHUANTIEXIAN ? null : info.getTransDistBackStartDate());
        coreInfo.setBackCloseDate(info.getTransDistKind() == TransDistKindEnum.MAIDUANSHIZHUANTIEXIAN ? null : info.getTransDistBackEndDate());
        coreInfo.setBackRate(info.getTransDistKind() == TransDistKindEnum.MAIDUANSHIZHUANTIEXIAN ? null : info.getTransDistBackRate().multiply(new BigDecimal("0.01")).setScale(2, 6));
        coreInfo.setBackMoney(info.getTransDistKind() == TransDistKindEnum.MAIDUANSHIZHUANTIEXIAN ? null : info.getTransDistBackAmount());
        coreInfo.setBtchNb(info.getBatchNumber());
        coreInfo.setDiscounterRemark(info.getDistOutRemark());
        coreInfo.setDiscountBankBak(info.getInAccount().getBankAccountNumber());
        return coreInfo;
    }

    @Override
    public DraftApplyBillBaseCollection getBillCollection(Context ctx, Set idSet, SelectorItemCollection sic) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        env.setSelector(sic);
        env.setFilter(filter);
        DraftApplyBillBaseCollection transDistColl = TransDistApplyBillFactory.getLocalInstance(ctx).getDraftApplyBillBaseCollection(env);
        return transDistColl;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.ZTXSQ_ZHUAN;
    }

    @Override
    protected void _rewriteECDSMess(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
        TransDistApplyBillInfo billInfo = TransDistApplyBillFactory.getLocalInstance(ctx).getTransDistApplyBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
        if (billInfo.isIsCancelDraft()) {
            String stockId;
            String billId;
            String sql = null;
            int opstate = 0;
            if (billInfo.getCommunicationStatus().equals((Object)ECDSCommunicationStatusEnum.PROCESS_FAIL) && (billId = billInfo.getDraftSourceBill()) != null) {
                sql = "update T_EDR_TransDistApplyBill set FOperateState=? where FID='" + billId + "'";
                opstate = 1;
            }
            if (billInfo.getCommunicationStatus().equals((Object)ECDSCommunicationStatusEnum.PROCESS_SUCCESS) && (stockId = billInfo.getSourceBillId()) != null) {
                sql = "UPDATE T_EDT_DraftStockBill SET FDraftStockOperate=?,FTurnDiscount=0 where FID='" + stockId + "'";
                opstate = 0;
            }
            if (sql != null) {
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(opstate)});
            }
        }
        if (!(ecdsApplyBillStatus != ApplyBillStatusEnum.RECEIVE_033_ERROR && ecdsApplyBillStatus != ApplyBillStatusEnum.RECEIVE_031_BAN || sourceBillId == null || sourceBillId.equals(""))) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("sourceBillID");
            view.setSelector(sic);
            TransDistApplyBillInfo transDistApplyBillInfo = TransDistApplyBillFactory.getLocalInstance(ctx).getTransDistApplyBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId), sic);
            String stockBillID = transDistApplyBillInfo.getSourceBillId().toString();
            if (stockBillID == null || stockBillID.equals("")) {
                // empty if block
            }
            SelectorItemCollection sic1 = new SelectorItemCollection();
            sic1.add("id");
            sic1.add("draftStockOperate");
            sic1.add("turnDiscount");
            IDraftStockBill iDraftStockBill = DraftStockBillFactory.getLocalInstance((Context)ctx);
            DraftStockBillInfo stockInfo = iDraftStockBill.getDraftStockBillInfo((IObjectPK)new ObjectUuidPK(transDistApplyBillInfo.getSourceBillId().toString()), sic1);
            stockInfo.setDraftStockOperate(DraftStockBillOperateEnum.REGISTER);
            stockInfo.setTurnDiscount(false);
            iDraftStockBill.updatePartial((CoreBaseInfo)stockInfo, sic1);
        }
    }

    @Override
    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = super.getSelector();
        sic.add("distOutName.*");
        sic.add("distOutAccount.*");
        sic.add("distInName.*");
        sic.add("distInAccount.*");
        sic.add("inAccount.*");
        sic.add("company.*");
        return sic;
    }

    @Override
    public ApplyBillBaseInfo convertToECDSCancelBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TransDistApplyBillInfo transDistApplyBillInfo = (TransDistApplyBillInfo)model;
        ActionCancelBillInfo cancelBillInfo = new ActionCancelBillInfo();
        CommercialDraftInfo draftInfo = transDistApplyBillInfo.getCommercialDraft();
        cancelBillInfo.setDraftNumber(draftInfo.getDraftNumber());
        cancelBillInfo.setDraftAmount(draftInfo.getDraftAmount());
        cancelBillInfo.setEletricSign("0");
        cancelBillInfo.setCancelOrgCode(transDistApplyBillInfo.getOrgCode());
        cancelBillInfo.setCancelAccount(transDistApplyBillInfo.getDistOutAccount().getBankAccountNumber());
        cancelBillInfo.setCancelBank(transDistApplyBillInfo.getDistOutBankNum());
        cancelBillInfo.setBizPromoterOrgCode(transDistApplyBillInfo.getOrgCode());
        return cancelBillInfo;
    }

    @Override
    protected boolean _checkStockBill(Context ctx, List ids) throws BOSException, EASBizException {
        DraftKindEnum dke = null;
        AccountBankInfo holderAccount = null;
        BEBankInfo holderBankNumber = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)ids), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("draftKind", (Object)new Integer(1), CompareType.NOTEQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("commercialDraft.*");
        view.setSelector(sic);
        DraftStockBillCollection stockColl = DraftStockBillFactory.getLocalInstance((Context)ctx).getDraftStockBillCollection(view);
        if (stockColl == null || stockColl.size() == 0) {
            return false;
        }
        DraftStockBillInfo stockInfo = null;
        for (int i = 0; i < stockColl.size(); ++i) {
            stockInfo = stockColl.get(i);
            if (stockInfo == null) {
                return false;
            }
            if (stockInfo.isTurnDiscount()) {
                return false;
            }
            if (!this.check1(stockInfo)) {
                return false;
            }
            if (!this.check2(stockInfo)) {
                return false;
            }
            if (!this.check3(stockInfo)) {
                return false;
            }
            if (!this.check4(stockInfo)) {
                return false;
            }
            if (!this.check5(stockInfo, dke)) {
                return false;
            }
            if (this.check6(stockInfo, holderAccount, holderBankNumber)) continue;
            return false;
        }
        return true;
    }

    private boolean check6(DraftStockBillInfo stockInfo, AccountBankInfo holderAccount, BEBankInfo holderBankNumber) {
        boolean isPassHolderAccount = false;
        boolean isPassHolderBankNumber = false;
        if (holderAccount == null) {
            isPassHolderAccount = true;
        } else if (holderAccount == stockInfo.getHolderAccount()) {
            isPassHolderAccount = true;
        }
        if (holderBankNumber == null) {
            isPassHolderBankNumber = true;
        } else if (holderBankNumber == stockInfo.getHolderBankNumber()) {
            isPassHolderBankNumber = true;
        }
        return isPassHolderAccount && isPassHolderBankNumber;
    }

    private boolean check5(DraftStockBillInfo stockInfo, DraftKindEnum dke) {
        if (dke == null) {
            return true;
        }
        return dke == stockInfo.getDraftKind();
    }

    private boolean check4(DraftStockBillInfo stockInfo) {
        return stockInfo.isIsAttorn();
    }

    private boolean check3(DraftStockBillInfo stockInfo) {
        return !stockInfo.isCollateral() && !stockInfo.isRecourse() && !stockInfo.isPresent();
    }

    private boolean check2(DraftStockBillInfo stockInfo) {
        CommercialDraftInfo comm = stockInfo.getCommercialDraft();
        if (comm == null) {
            return false;
        }
        return comm.getDraftECDSStatus() == ECDSBillStatusEnum.MDSTXYQS || comm.getDraftECDSStatus() == ECDSBillStatusEnum.HGSTXYYSHJZR || comm.getDraftECDSStatus() == ECDSBillStatusEnum.MDSZHTXYQS || comm.getDraftECDSStatus() == ECDSBillStatusEnum.HGSZHTXSHYQS || comm.getDraftECDSStatus() == ECDSBillStatusEnum.HGSZHTXYYSHJZR || comm.getDraftECDSStatus() == ECDSBillStatusEnum.HGSZTXSHYQS || comm.getDraftECDSStatus() == ECDSBillStatusEnum.ZYJCYQS || comm.getDraftECDSStatus() == ECDSBillStatusEnum.YHMPYQS || comm.getDraftECDSStatus() == null || comm.getDraftECDSStatus() == ECDSBillStatusEnum.NoBill;
    }

    private boolean check1(DraftStockBillInfo info) {
        return info.getDraftStockOperate() == DraftStockBillOperateEnum.REGISTER;
    }

    protected void _submitToECDS(Context ctx, List idList) throws BOSException, EASBizException {
        List ids = idList;
        boolean isFitA = true;
        boolean isFitB = true;
        ITransDistApplyBill iTransDistApplyBill = TransDistApplyBillFactory.getLocalInstance(ctx);
        if (ids != null && ids.size() == 1) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("draftKind");
            sic.add("operateState");
            sic.add("communicationStatus");
            TransDistApplyBillInfo info = iTransDistApplyBill.getTransDistApplyBillInfo((IObjectPK)new ObjectUuidPK(ids.get(0).toString()), sic);
            isFitA = this.isFitA(info);
            isFitB = this.isFitB(info);
            if (isFitA && isFitB) {
                iTransDistApplyBill.batchCommitECDS(FMHelper.list2Set((List)ids));
                info.setOperateState(FCOperateStateEnum.submit);
                iTransDistApplyBill.updatePartial((CoreBaseInfo)info, sic);
            } else if (!isFitA && isFitB) {
                this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"90_TransDistApplyBillControllerBean", (Locale)ctx.getLocale()));
            } else if (isFitA && !isFitB) {
                this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"71_ReDiscountApplyBillControllerBean", (Locale)ctx.getLocale()));
            } else {
                this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"72_ReDiscountApplyBillControllerBean", (Locale)ctx.getLocale()));
            }
        } else if (ids != null && ids.size() > 1) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("draftKind");
            sic.add("operateState");
            sic.add("communicationStatus");
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)ids), CompareType.INCLUDE));
            view.setFilter(filter);
            TransDistApplyBillCollection coll = iTransDistApplyBill.getTransDistApplyBillCollection(view);
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                isFitA = this.isFitA(coll.get(i));
                isFitB = this.isFitB(coll.get(i));
                if (!isFitA || !isFitB) continue;
                idSet.add(coll.get(i).getId().toString());
            }
            if (idSet.isEmpty()) {
                this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"72_ReDiscountApplyBillControllerBean", (Locale)ctx.getLocale()));
            } else {
                iTransDistApplyBill.batchCommitECDS(idSet);
                this.changeOperateState(ctx, idSet, FCOperateStateEnum.submit);
            }
        }
    }

    private void throwBizException(String msg) throws EASBizException {
        NumericExceptionSubItem item = new NumericExceptionSubItem("{0}", "{0}");
        EASBizException exec = new EASBizException(item, (Object[])new String[]{msg.toString()});
        throw exec;
    }

    private void changeOperateState(Context ctx, Set ids, FCOperateStateEnum status) throws BOSException {
        StringBuffer sql = new StringBuffer();
        List idList = FMHelper.set2List((Set)ids);
        if (idList.size() > 0) {
            sql.append("update T_EDR_TransDistApplyBill set FOperateState=").append(status.getValue()).append(" where FID in(");
            sql.append("'").append(idList.get(0).toString()).append("'");
            for (int i = 1; i < idList.size(); ++i) {
                sql.append(" ,'").append(idList.get(i).toString()).append("'");
            }
            sql.append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ITransDistApplyBill iTransDistApplyBill = TransDistApplyBillFactory.getLocalInstance(ctx);
        TransDistApplyBillInfo baseInfo = (TransDistApplyBillInfo)model;
        baseInfo.setOperateState(FCOperateStateEnum.AUDITED);
        baseInfo.setAuditor(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        baseInfo.setAuditDate(new Date());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("operateState"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("auditDate"));
        iTransDistApplyBill.updatePartial((CoreBaseInfo)baseInfo, sic);
    }

    private boolean isFitB(TransDistApplyBillInfo info) {
        return info.getDraftKind() == DraftKindEnum.ELECDRAFT;
    }

    private boolean isFitA(TransDistApplyBillInfo info) {
        return info.getOperateState() == FCOperateStateEnum.AUDITED || info.getCommunicationStatus() == ECDSCommunicationStatusEnum.SUBMIT_FAIL;
    }

    @Override
    protected void _unAudit4WF(Context ctx, IObjectValue model) throws BOSException {
    }
}

