/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.security.EASSignatureCollection;
import com.kingdee.eas.base.security.EASSignatureFactory;
import com.kingdee.eas.base.security.EASSignatureInfo;
import com.kingdee.eas.base.security.IEASSignature;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.ecore.BusinessNotificationFactory;
import com.kingdee.eas.fm.ecore.BusinessNotificationInfo;
import com.kingdee.eas.fm.ecore.ECoreExceptionTrackerFactory;
import com.kingdee.eas.fm.ecore.ECoreExceptionTrackerInfo;
import com.kingdee.eas.fm.ecore.ECoreExceptionTypeEnum;
import com.kingdee.eas.fm.edraf.IOrgUnitCode;
import com.kingdee.eas.fm.edraf.OrgUnitCodeCollection;
import com.kingdee.eas.fm.edraf.OrgUnitCodeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EdrafUtil {
    public static boolean checkIsFinanceCompany(Context ctx, String companyId) throws BOSException {
        boolean flag = false;
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("relatedCompany.id", (Object)companyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isFinanceCompany", (Object)Boolean.TRUE, CompareType.EQUALS));
        env.setFilter(filter);
        IBank ibank = null;
        ibank = ctx == null ? BankFactory.getRemoteInstance() : BankFactory.getLocalInstance((Context)ctx);
        BankCollection col = ibank.getBankCollection(env);
        if (col != null && col.size() > 0) {
            flag = true;
        }
        return flag;
    }

    public static CompanyOrgUnitInfo getCompanyByOrgCode(Context ctx, String orgCode) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.appendFilterItem("orgCode", (Object)orgCode);
        filterInfo.appendFilterItem("isUsing", (Object)Boolean.TRUE);
        evi.setFilter(filterInfo);
        IOrgUnitCode iOrgUnitCode = null;
        iOrgUnitCode = ctx == null ? OrgUnitCodeFactory.getRemoteInstance() : OrgUnitCodeFactory.getLocalInstance(ctx);
        OrgUnitCodeCollection col = iOrgUnitCode.getOrgUnitCodeCollection(evi);
        if (col != null && col.size() > 0) {
            return col.get(0).getCompany();
        }
        return null;
    }

    public static String getOrgCodeByCompany(Context ctx, String companyID) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.appendFilterItem("company", (Object)companyID);
        filterInfo.appendFilterItem("isUsing", (Object)Boolean.TRUE);
        evi.setFilter(filterInfo);
        IOrgUnitCode iOrgUnitCode = null;
        iOrgUnitCode = ctx == null ? OrgUnitCodeFactory.getRemoteInstance() : OrgUnitCodeFactory.getLocalInstance(ctx);
        OrgUnitCodeCollection col = iOrgUnitCode.getOrgUnitCodeCollection(evi);
        if (col != null && col.size() > 0) {
            return col.get(0).getOrgCode();
        }
        return null;
    }

    public static BankInfo getBankInfoByCompany(Context ctx, String companyId) throws BOSException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("relatedCompany.id", (Object)companyId, CompareType.EQUALS));
        env.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("accountBank.*");
        env.setSelector(sic);
        IBank ibank = null;
        ibank = ctx == null ? BankFactory.getRemoteInstance() : BankFactory.getLocalInstance((Context)ctx);
        BankCollection col = ibank.getBankCollection(env);
        if (col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    public static void updateBuzNotice(Context ctx, String buzNotifyID, boolean isSuccess, String errors) throws BOSException, EASBizException {
        BusinessNotificationInfo info = BusinessNotificationFactory.getLocalInstance((Context)ctx).getBusinessNotificationInfo((IObjectPK)new ObjectStringPK(buzNotifyID));
        if (isSuccess) {
            info.setISendClient(true);
            Date date = new Date();
            info.setSendTime(new Timestamp(date.getTime()));
            info.setIsHandleError(false);
        } else {
            info.setISendClient(false);
            info.setIsHandleError(true);
            ECoreExceptionTrackerInfo ecorInfo = new ECoreExceptionTrackerInfo();
            ecorInfo.setBizCode(info.getBizSerialNumber());
            ecorInfo.setDraftNumber(info.getDraftNumber());
            ecorInfo.setDirection(true);
            ecorInfo.setEType(ECoreExceptionTypeEnum.REC_BOSEXCEPTION);
            ecorInfo.setSenderOrgNumber(info.getHolderOrgCode());
            ecorInfo.setECause(errors);
            ecorInfo.setMessageID(info.getMessageID());
            ECoreExceptionTrackerFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)ecorInfo);
        }
        BusinessNotificationFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), info);
    }

    public static CompanyOrgUnitInfo getFinCompany(Context ctx) throws BOSException {
        CompanyOrgUnitInfo company = null;
        IBank ibank = null;
        ibank = ctx == null ? BankFactory.getRemoteInstance() : BankFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isFinanceCompany", (Object)Boolean.TRUE, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("relatedCompany.*"));
        view.setSelector(sic);
        BankCollection bankCol = ibank.getBankCollection(view);
        if (bankCol != null && bankCol.size() > 0) {
            company = bankCol.get(0).getRelatedCompany();
        }
        return company;
    }

    public static boolean checkCurrCompanyIsFinCompany(Context ctx, String finCompanyId) {
        boolean flag = false;
        CompanyOrgUnitInfo company = null;
        company = ctx == null ? ContextHelperFactory.getRemoteInstance().getCurrentCompany() : ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        if (company != null && finCompanyId != null && finCompanyId.equals(company.getId().toString())) {
            flag = true;
        }
        return flag;
    }

    public static String getSignatureByBillId(Context ctx, String sourceBillId, String applyCompanyId) throws BOSException, EASBizException {
        String signature = "0";
        if (sourceBillId != null && applyCompanyId != null && !EdrafUtil.checkIsFinanceCompany(ctx, applyCompanyId)) {
            EASSignatureInfo sigInfo;
            IEASSignature easSignture = null;
            easSignture = ctx == null ? EASSignatureFactory.getRemoteInstance() : EASSignatureFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("objectid", (Object)applyCompanyId, CompareType.EQUALS));
            view.setFilter(filter);
            SorterItemCollection sortItem = new SorterItemCollection();
            SorterItemInfo sort = new SorterItemInfo("createTime");
            sort.setSortType(SortType.DESCEND);
            sortItem.add(sort);
            view.setSorter(sortItem);
            EASSignatureCollection signatureCol = easSignture.getEASSignatureCollection(view);
            if (signatureCol != null && signatureCol.size() > 0 && (sigInfo = signatureCol.get(0)) != null && sigInfo.getSignature() != null) {
                signature = sigInfo.getSignature();
            }
        }
        return signature;
    }

    public static BigDecimal getDateDif(String time1, String time2) throws ParseException {
        BigDecimal quot = new BigDecimal("0");
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
        if (time1.trim().equals("") || time2.trim().equals("")) {
            return quot;
        }
        Date date1 = ft.parse(time1);
        Date date2 = ft.parse(time2);
        quot = new BigDecimal(date1.getTime() - date2.getTime());
        BigDecimal sub = new BigDecimal(86400000);
        quot = quot.divide(sub, 6);
        return quot;
    }

    public static int compareByDate(Date dateLeft, Date dateRight) throws ParseException {
        Date ld = EdrafUtil.simpleDate(dateLeft);
        Date sd = EdrafUtil.simpleDate(dateRight);
        return ld.compareTo(sd);
    }

    public static Date simpleDate(Date date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date d = date != null ? date : new Date();
        return format.parse(format.format(d));
    }
}

