/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.PaperDraftBillBaseInfo;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.app.util.EcdsSerNumber;
import com.kingdee.eas.fm.edraf.AcceptanceRegisterBillFactory;
import com.kingdee.eas.fm.edraf.AcceptanceRegisterBillInfo;
import com.kingdee.eas.fm.edraf.DraftTypeEnum;
import com.kingdee.eas.fm.edraf.DrawTypeEnum;
import com.kingdee.eas.fm.edraf.EdrafException;
import com.kingdee.eas.fm.edraf.ManipulateStateEnum;
import com.kingdee.eas.fm.edraf.MutualResultEnum;
import com.kingdee.eas.fm.edraf.PaperDraftBillBaseCollection;
import com.kingdee.eas.fm.edraf.app.AbstractAcceptanceRegisterBillControllerBean;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcceptanceRegisterBillControllerBean
extends AbstractAcceptanceRegisterBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.AcceptanceRegisterBillControllerBean");

    @Override
    protected void initInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    public boolean checkDraftApplyBill(IObjectValue model) {
        AcceptanceRegisterBillInfo acceptanceInfo = (AcceptanceRegisterBillInfo)model;
        MutualResultEnum mutualResult = acceptanceInfo.getMutualResult();
        return mutualResult != null && (mutualResult.equals((Object)MutualResultEnum.ARRANGEDSUMBIT) || mutualResult.equals((Object)MutualResultEnum.SUMBITFAIL) || mutualResult.equals((Object)MutualResultEnum.TAKEBIZFAIL) && acceptanceInfo.getReturnOption() == null);
    }

    @Override
    public SelectorItemCollection getSelector() {
        return super.getSelector();
    }

    @Override
    public PaperDraftBillBaseCollection getBillCollection(Context ctx, Set idSet, SelectorItemCollection sic) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("manipulateState", (Object)ManipulateStateEnum.SAVE, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("mutualResult", (Object)MutualResultEnum.ARRANGEDSUMBIT, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("mutualResult", (Object)MutualResultEnum.SUMBITFAIL, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("mutualResult", (Object)MutualResultEnum.TAKEBIZFAIL, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("returnOption", null, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and #1 and (#2 or ((#3 or #4) and #5))");
        viewInfo.setSelector(sic);
        viewInfo.setFilter(filterInfo);
        PaperDraftBillBaseCollection colls = AcceptanceRegisterBillFactory.getLocalInstance(ctx).getPaperDraftBillBaseCollection(viewInfo);
        if (colls == null || colls.size() < 1) {
            throw new EdrafException(EdrafException.SUBMIT_ERROR);
        }
        return colls;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AcceptanceRegisterBillInfo acceptanceInfo = (AcceptanceRegisterBillInfo)model;
        acceptanceInfo.setDrawType(DrawTypeEnum.NOT);
        acceptanceInfo.setNumber(String.valueOf(EcdsSerNumber.getPK()));
        acceptanceInfo.setManipulateState(ManipulateStateEnum.SAVE);
        acceptanceInfo.setMutualResult(MutualResultEnum.ARRANGEDSUMBIT);
        acceptanceInfo.setSubmitCompany(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany());
        String sourceBillId = acceptanceInfo.getSourceBillId();
        PayableBillInfo billInfo = null;
        if (sourceBillId != null && !sourceBillId.equals("")) {
            billInfo = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
        }
        if (acceptanceInfo.getRegisterCompany() == null) {
            acceptanceInfo.setRegisterCompany(billInfo == null ? null : billInfo.getCompany());
        }
        return super._addnew(ctx, (IObjectValue)acceptanceInfo);
    }

    @Override
    public PaperDraftBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AcceptanceRegisterBillInfo regInfo = (AcceptanceRegisterBillInfo)model;
        com.kingdee.eas.fm.ecore.AcceptanceRegisterBillInfo billInfo = new com.kingdee.eas.fm.ecore.AcceptanceRegisterBillInfo();
        if (regInfo.getPaperType() != null) {
            billInfo.setDraftType(regInfo.getPaperType().equals((Object)DraftTypeEnum.DC01) ? com.kingdee.eas.fm.ecore.DraftTypeEnum.AC01 : com.kingdee.eas.fm.ecore.DraftTypeEnum.AC02);
        }
        billInfo.setDraftNumber(regInfo.getPaperNumber());
        billInfo.setDraftAmount(regInfo.getBillAmount());
        billInfo.setIssueDate(regInfo.getPaperOutData());
        billInfo.setDueDate(regInfo.getDraftData());
        billInfo.setAcceptDate(regInfo.getAcceptData());
        billInfo.setContractNum(regInfo.getContractNumber());
        billInfo.setAcceptPactNumber(null);
        billInfo.setAcceptorName(regInfo.getAccepter());
        billInfo.setAcceptorBank(regInfo.getAcceptLine());
        billInfo.setDrawerName(regInfo.getDrawerName());
        billInfo.setPayeeName(regInfo.getPayeeName());
        billInfo.setRemark(regInfo.getRemark());
        billInfo.setBizPromoterOrgCode(regInfo.getDrawerOrgCode());
        return billInfo;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.ZPCDDJ;
    }

    @Override
    public void delPaperDraftBillBase(Context ctx, String sourceIDList, String destobjecIDs, String copyBillIDs) throws BOSException, EASBizException {
    }

    @Override
    public void comeBack(Context ctx, String parm, String id, String opinion) throws BOSException, EASBizException {
        AcceptanceRegisterBillInfo regInfo = AcceptanceRegisterBillFactory.getLocalInstance(ctx).getAcceptanceRegisterBillInfo((IObjectPK)new ObjectUuidPK(id));
        String sourceBillId = regInfo.getSourceBillId();
        if (FMHelper.isEmpty((String)sourceBillId)) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"2_AcceptanceRegisterBillControllerBean", (Locale)ctx.getLocale())});
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        sic.add(new SelectorItemInfo("CreditLimit.CreditUsage.*"));
        PayableBillInfo billInfo = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId), sic);
        if (regInfo.getMutualResult().equals((Object)MutualResultEnum.ARRANGEDSUMBIT)) {
            AcceptanceRegisterBillFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(regInfo.getId()));
        } else if (regInfo.getMutualResult().equals((Object)MutualResultEnum.SUMBITFAIL) || regInfo.getMutualResult().equals((Object)MutualResultEnum.TAKEBIZFAIL) || regInfo.getMutualResult().equals((Object)MutualResultEnum.TAKEBIZSUCCEE) && regInfo.getSourceBillId() != null) {
            IBOTRelation relation = BOTRelationFactory.getLocalInstance((Context)ctx);
            String sql = "DELETE T_BOT_Relation WHERE FSrcObjectID='" + sourceBillId + "' and FDestObjectID='" + id + "'";
            DbUtil.execute((Context)ctx, (String)sql);
            regInfo.setReturnOption(opinion);
            regInfo.setBackOpinion(opinion);
            AcceptanceRegisterBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(regInfo.getId()), (CoreBaseInfo)regInfo);
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"3_AcceptanceRegisterBillControllerBean", (Locale)ctx.getLocale())});
        }
        billInfo.setIsAccept(false);
        billInfo.setIsAcceptSubmit(false);
        billInfo.setAcceptDate(null);
        billInfo.setReturnOption(opinion);
        PayableBillFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(billInfo.getId()), (CoreBaseInfo)billInfo);
    }

    @Override
    public void setSourceBill(Context ctx, String sourceBillId, String opinion) throws BOSException, EASBizException {
    }

    @Override
    public void rewriteApplyBill(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
    }
}

