/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.NoteDetailRequestBody;
import com.kingdee.bos.ebservice.NoteReceivableBody;
import com.kingdee.bos.ebservice.NoteReceivableDetail;
import com.kingdee.bos.ebservice.NoteStatusBody;
import com.kingdee.bos.ebservice.NoteStatusDetail;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.assistant.WorkCalendarException;
import com.kingdee.eas.basedata.assistant.WorkCalendarFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.model.MsgInfo;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.NoteTypeEnum;
import com.kingdee.eas.fm.be.app.service.NoteReceivableOpUtil;
import com.kingdee.eas.fm.be.app.service.NoteUpdateStautsUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.be.app.util.NoteBizInfo;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.PaperDraftBillBaseInfo;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.edraf.CollectAccessionBillCollection;
import com.kingdee.eas.fm.edraf.CollectAccessionBillFactory;
import com.kingdee.eas.fm.edraf.CollectAccessionBillInfo;
import com.kingdee.eas.fm.edraf.CollectRegisterBillCollection;
import com.kingdee.eas.fm.edraf.CollectRegisterBillEntryCollection;
import com.kingdee.eas.fm.edraf.CollectRegisterBillEntryFactory;
import com.kingdee.eas.fm.edraf.CollectRegisterBillEntryInfo;
import com.kingdee.eas.fm.edraf.CollectRegisterBillFactory;
import com.kingdee.eas.fm.edraf.CollectRegisterBillInfo;
import com.kingdee.eas.fm.edraf.ICollectAccessionBill;
import com.kingdee.eas.fm.edraf.ICollectRegisterBill;
import com.kingdee.eas.fm.edraf.ManipulateStateEnum;
import com.kingdee.eas.fm.edraf.MutualResultEnum;
import com.kingdee.eas.fm.edraf.StateEnum;
import com.kingdee.eas.fm.edraf.app.AbstractCollectRegisterBillControllerBean;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.DiscountBillSubsidiaryBookProvider;
import com.kingdee.eas.fm.nt.ElecBillClearingEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.NTBookHelper;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.app.BillServerUtil;
import com.kingdee.eas.fm.nt.app.DiscountBillBookNotifyBuilder;
import com.kingdee.eas.fm.nt.app.util.DraftBEUtil;
import com.kingdee.eas.fm.nt.app.util.ReceivableBillCommitToBEUtil;
import com.kingdee.eas.fm.ntp.NTPException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;

public class CollectRegisterBillControllerBean
extends AbstractCollectRegisterBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.CollectRegisterBillControllerBean");
    public final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    @Override
    public boolean checkDraftApplyBill(IObjectValue model) {
        return false;
    }

    @Override
    public CollectRegisterBillCollection getObjectSet(Context ctx, Set set) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.receivablebill.*"));
        sic.add(new SelectorItemInfo("entrys.receivablebill.acceptorBank.id"));
        sic.add(new SelectorItemInfo("entrys.receivablebill.acceptorBank.beProvince"));
        sic.add(new SelectorItemInfo("entrys.receivablebill.acceptorBank.beCity"));
        sic.add(new SelectorItemInfo("entrys.receivablebill.holderAccount.id"));
        sic.add(new SelectorItemInfo("entrys.receivablebill.holderAccount.name"));
        sic.add(new SelectorItemInfo("entrys.receivablebill.holderAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("entrys.receivablebill.ntType.*"));
        sic.add(new SelectorItemInfo("entrys.receivablebill.ntType.group"));
        sic.add(new SelectorItemInfo("entrys.receivablebill.currency.*"));
        sic.add(new SelectorItemInfo("entrys.receivablebill.company.*"));
        sic.add(new SelectorItemInfo("entrys.receivablebill.payeeAccount.account"));
        sic.add(new SelectorItemInfo("entrys.receivablebill.payeeAccount.bank"));
        sic.add(new SelectorItemInfo("payeeNum.*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("paperType"));
        sic.add(new SelectorItemInfo("paperNumber"));
        sic.add(new SelectorItemInfo("payerName"));
        sic.add(new SelectorItemInfo("payerBank"));
        sic.add(new SelectorItemInfo("paperOutData"));
        sic.add(new SelectorItemInfo("draftData"));
        sic.add(new SelectorItemInfo("collectData"));
        sic.add(new SelectorItemInfo("payeeBank"));
        sic.add(new SelectorItemInfo("lessonNumber"));
        sic.add(new SelectorItemInfo("billAmount"));
        sic.add(new SelectorItemInfo("bank.*"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("bank.number"));
        sic.add(new SelectorItemInfo("isEnregister"));
        sic.add(new SelectorItemInfo("holderAccount.id"));
        sic.add(new SelectorItemInfo("holderAccount.name"));
        sic.add(new SelectorItemInfo("holderAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("acceptBank.BeProvince"));
        sic.add(new SelectorItemInfo("acceptBank.BeCity"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        CollectRegisterBillCollection collection = CollectRegisterBillFactory.getLocalInstance(ctx).getCollectRegisterBillCollection(view);
        return collection;
    }

    @Override
    protected IObjectCollection _getObjectSet(Context ctx, Set collectRegisterSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("collectData"));
        sic.add(new SelectorItemInfo("bank.*"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("bank.number"));
        sic.add(new SelectorItemInfo("payeeNum.id"));
        sic.add(new SelectorItemInfo("payeeNum.name"));
        sic.add(new SelectorItemInfo("payeeNum.number"));
        sic.add(new SelectorItemInfo("currecy"));
        sic.add(new SelectorItemInfo("rate"));
        sic.add(new SelectorItemInfo("billAmount"));
        sic.add(new SelectorItemInfo("lostMoney"));
        sic.add(new SelectorItemInfo("payerName"));
        sic.add(new SelectorItemInfo("payerBank"));
        sic.add(new SelectorItemInfo("payerNum"));
        sic.add(new SelectorItemInfo("payerAddress"));
        sic.add(new SelectorItemInfo("payeeName"));
        sic.add(new SelectorItemInfo("payeeBank"));
        sic.add(new SelectorItemInfo("payeeAddress"));
        sic.add(new SelectorItemInfo("contentfund"));
        sic.add(new SelectorItemInfo("collectionName"));
        sic.add(new SelectorItemInfo("billNumber"));
        sic.add(new SelectorItemInfo("lessonNumber"));
        sic.add(new SelectorItemInfo("paperNumber"));
        sic.add(new SelectorItemInfo("paperOutData"));
        sic.add(new SelectorItemInfo("paperType"));
        sic.add(new SelectorItemInfo("draftData"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("billAmount"));
        sic.add(new SelectorItemInfo("isEnregister"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("isEnregister"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)collectRegisterSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        CollectRegisterBillCollection collection = this.getCollectRegisterBillCollection(ctx, view);
        return collection;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return null;
    }

    @Override
    public PaperDraftBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    public Set getNextBillIDList(Context ctx, Set idSet) throws BOSException {
        HashSet<String> nextBillIdList = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("manipulateState", (Object)"02", CompareType.NOTEQUALS));
        view.setFilter(filter);
        view.setSelector(sic);
        CollectAccessionBillCollection collection = CollectAccessionBillFactory.getLocalInstance(ctx).getCollectAccessionBillCollection(view);
        CollectAccessionBillInfo accessbillInfo = null;
        for (int i = 0; i < collection.size(); ++i) {
            accessbillInfo = collection.get(i);
            nextBillIdList.add(accessbillInfo.getId().toString());
        }
        return nextBillIdList;
    }

    @Override
    protected boolean _delCancelCollectBill(Context ctx, Set idSet, String parm) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() < 1) {
            return false;
        }
        boolean flags = false;
        ICollectRegisterBill iCollectRegisterBill = (ICollectRegisterBill)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(idSet.iterator().next().toString());
        HashSet<String> sourceIDList = new HashSet<String>();
        HashSet<String> destobjectIDList = new HashSet<String>();
        HashSet<String> copyBillIDList = new HashSet<String>();
        Set nextBillIDList = this.getNextBillIDList(ctx, idSet);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("manipulateState", (Object)"01", CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        view.setSelector(sic);
        CollectRegisterBillCollection collection = iCollectRegisterBill.getCollectRegisterBillCollection(view);
        if (collection == null || collection.size() == 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"5_CollectRegisterBillControllerBean", (Locale)ctx.getLocale())});
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CollectRegisterBillInfo object = (CollectRegisterBillInfo)iterator.next();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)object.getId(), CompareType.EQUALS));
            if (CollectAccessionBillFactory.getLocalInstance(ctx).exists(filter)) {
                String desId = object.getId().toString();
                String oql = "select * where sourceBillId='" + desId + "'";
                CollectAccessionBillInfo billInfo = CollectAccessionBillFactory.getLocalInstance(ctx).getCollectAccessionBillInfo(oql);
                if (billInfo != null && billInfo.getManipulateState().equals((Object)ManipulateStateEnum.SUMBIT)) {
                    flags = true;
                }
            }
            if (flags) continue;
            if (object.getCopyBillID() == null || object.getCopyBillID().equals("")) {
                CollectRegisterBillEntryCollection entrys = object.getEntrys();
                for (int i = 0; i < entrys.size(); ++i) {
                    String receivableBill = entrys.get(i).getReceivablebill().getId().toString();
                    sourceIDList.add(receivableBill);
                }
            } else {
                copyBillIDList.add(object.getCopyBillID().toString());
            }
            destobjectIDList.add(object.getId().toString());
        }
        String sb = FMHelper.setTran2String(sourceIDList);
        String destobjecIDs = FMHelper.setTran2String(destobjectIDList);
        String copyBillIDs = FMHelper.setTran2String(copyBillIDList);
        String nextBillIDs = FMHelper.setTran2String((Set)nextBillIDList);
        StringBuffer sql = new StringBuffer();
        StringBuffer copySql = new StringBuffer();
        StringBuffer destSql = new StringBuffer();
        StringBuffer destEntrySql = new StringBuffer();
        StringBuffer delAccessSql = new StringBuffer();
        if (parm.equals("CollectRegisterBill")) {
            sql.append("update ").append("T_NT_ReceivableBill").append(" set FIsCollect = 0,FCollectNum=null,FCollectBankID=null").append(" where fid in ").append(sb.toString()).append("");
            copySql.append("update ").append("T_EDR_CollectRegisterBill").append(" set FManipulateState = '02' where fid in").append(copyBillIDs.toString()).append("");
            destSql.append("delete ").append("T_EDR_CollectRegisterBill").append(" where fid in ").append(destobjecIDs.toString()).append("");
            destEntrySql.append("delete ").append("T_EDR_CollectRegisterBillEntry").append(" where FParentID in ").append(destobjecIDs.toString()).append("");
            if (destobjectIDList.size() > 0) {
                delAccessSql.append("delete ").append("T_EDR_CollectAccessionBill").append(" where fid in ").append(nextBillIDs.toString()).append("");
            }
        }
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("delete from T_BOT_Relation ").append("WHERE FDESTOBJECTID in ").append(destobjecIDs.toString()).append("");
        StringBuffer sqlAccesionStr = new StringBuffer();
        if (destobjectIDList.size() > 0) {
            sqlAccesionStr.append("delete from T_BOT_Relation ").append("WHERE FDESTOBJECTID in ").append(nextBillIDs.toString()).append("");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
        DbUtil.execute((Context)ctx, (String)copySql.toString());
        DbUtil.execute((Context)ctx, (String)sqlStr.toString());
        DbUtil.execute((Context)ctx, (String)destSql.toString());
        DbUtil.execute((Context)ctx, (String)destEntrySql.toString());
        if (destobjectIDList.size() > 0) {
            DbUtil.execute((Context)ctx, (String)delAccessSql.toString());
            DbUtil.execute((Context)ctx, (String)sqlAccesionStr.toString());
        }
        return flags;
    }

    @Override
    public void delPaperDraftBillBase(Context ctx, String sourceIDList, String destobjecIDs, String copyBillIDs) throws BOSException, EASBizException {
    }

    @Override
    public void setSourceBill(Context ctx, String sourceBillId, String opinion) throws BOSException, EASBizException {
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CollectRegisterBillInfo billInfo = (CollectRegisterBillInfo)model;
        String sourceBillId = billInfo.getSourceBillId();
        ReceivableBillInfo receivableBillInfo = null;
        if (sourceBillId != null && !sourceBillId.equals("")) {
            receivableBillInfo = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillInfo((IObjectPK)new ObjectStringPK(sourceBillId));
        }
        billInfo.setRegisterCompany(receivableBillInfo == null ? null : receivableBillInfo.getCompany());
        billInfo.setCreateTime(new Timestamp(new Date().getTime()));
        IObjectPK pk = super._addnew(ctx, (IObjectValue)billInfo);
        if (billInfo.getSourceBillId() != null) {
            if (BOSUuid.read((String)billInfo.getSourceBillId()).getType().equals((Object)new ReceivableBillInfo().getBOSType())) {
                this.afterAddNew(ctx, pk, model);
            } else {
                NTBookHelper.autoBookJournal((Context)ctx, (String)pk.toString(), (CompanyOrgUnitInfo)billInfo.getCompany(), (String)DiscountBillBookNotifyBuilder.class.getName());
                NTBookHelper.bookSubsidiary((Context)ctx, (String)pk.toString(), (String)DiscountBillSubsidiaryBookProvider.class.getName());
            }
        }
        return pk;
    }

    public void afterAddNew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CollectRegisterBillInfo collectRegiInfo = (CollectRegisterBillInfo)model;
        CollectRegisterBillEntryCollection entrys = collectRegiInfo.getEntrys();
        if (entrys != null && entrys.size() > 0) {
            for (int i = 0; i < entrys.size(); ++i) {
                ReceivableBillInfo recBill = entrys.get(i).getReceivablebill();
                if (recBill == null) continue;
                FinUtils.addBotRelation((Context)ctx, (String)recBill.getId().toString(), (String)pk.toString());
                String updateSQL = "update t_nt_ReceivableBill set FIsCollect = ?, FCollectBankId = ?, FCollectNum =? where fid = ?";
                String collectBankId = collectRegiInfo.getBank() == null ? "" : collectRegiInfo.getBank().getId().toString();
                String collectNum = collectRegiInfo.getPayeeNum() == null ? "" : collectRegiInfo.getPayeeNum().getBankAccountNumber();
                DbUtil.execute((Context)ctx, (String)updateSQL, (Object[])new Object[]{true, collectBankId, collectNum, recBill.getId().toString()});
            }
        } else {
            FinUtils.addBotRelation((Context)ctx, (String)collectRegiInfo.getSourceBillId(), (String)pk.toString());
        }
    }

    @Override
    public void rewriteApplyBill(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
    }

    protected Set _saveCollectAccession(Context ctx, CoreBaseCollection collection) throws BOSException, EASBizException {
        ICollectAccessionBill accessionFactory = CollectAccessionBillFactory.getLocalInstance(ctx);
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        if (collection == null || collection.size() < 1) {
            return null;
        }
        HashSet set = new HashSet();
        HashSet<String> sorrceSet = new HashSet<String>();
        IObjectPK pk = null;
        for (CollectAccessionBillInfo object : collection) {
            pk = accessionFactory.addnew((CoreBaseInfo)object);
            sorrceSet.add(object.getSourceBillId().toString());
            BOTRelationInfo relateInfo = new BOTRelationInfo();
            relateInfo.setSrcEntityID(BOSUuid.read((String)object.getSourceBillId()).getType().toString());
            relateInfo.setDestEntityID(BOSUuid.read((String)pk.toString()).getType().toString());
            relateInfo.setSrcObjectID(object.getSourceBillId());
            relateInfo.setDestObjectID(pk.toString());
            relateInfo.setDate(new Date());
            relateInfo.setOperatorID("unknown");
            relateInfo.setIsEffected(true);
            relateInfo.setType(0);
            iBOTRelation.addnew(relateInfo);
        }
        String sql = "update T_EDR_CollectRegisterBill set FIsEnregister = 1 where fid in " + FMHelper.setTran2String(sorrceSet);
        DbUtil.execute((Context)ctx, (String)sql);
        return set;
    }

    @Override
    protected Set _saveCollectAccession(Context ctx, Set set) throws BOSException, EASBizException {
        CollectRegisterBillCollection registerCol = CollectRegisterBillFactory.getLocalInstance(ctx).getObjectSet(set);
        boolean falg = true;
        for (int j = 0; j < registerCol.size(); ++j) {
            BankInfo bankInfo;
            CollectRegisterBillInfo registerInfo = registerCol.get(j);
            if (registerInfo.isIsEnregister()) {
                falg = false;
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"6_CollectRegisterBillControllerBean", (Locale)ctx.getLocale())});
            }
            if (registerInfo.getBank() == null || (bankInfo = registerInfo.getBank()).isIsFinanceCompany()) continue;
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"7_CollectRegisterBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (falg) {
            CollectRegisterBillInfo billInfo = null;
            CollectAccessionBillInfo accessionBillInfo = null;
            CoreBaseCollection cbCollection = new CoreBaseCollection();
            for (int i = 0; i < registerCol.size(); ++i) {
                billInfo = registerCol.get(i);
                accessionBillInfo = new CollectAccessionBillInfo();
                accessionBillInfo.setLastbearer(billInfo.getCompany().getName());
                accessionBillInfo.setPaperType(billInfo.getPaperType());
                accessionBillInfo.setPaperNumber(billInfo.getPaperNumber());
                accessionBillInfo.setAccepter(billInfo.getPayerName());
                accessionBillInfo.setAcceptLineName(billInfo.getPayerBank());
                accessionBillInfo.setPaperOutData(billInfo.getPaperOutData());
                accessionBillInfo.setDraftData(billInfo.getDraftData());
                accessionBillInfo.setPayeeDate(billInfo.getCollectData());
                if (billInfo.getBank() != null) {
                    accessionBillInfo.setPayeeBankName(billInfo.getBank().getName());
                }
                accessionBillInfo.setBankFountainhead(billInfo.getPayeeNum() == null ? null : billInfo.getPayeeNum().getBankAccountNumber());
                accessionBillInfo.setAcceptData(new Date());
                accessionBillInfo.setAcceptLine(billInfo.getPayeeBank());
                accessionBillInfo.setPayeeBankLine(billInfo.getPayeeBank());
                accessionBillInfo.setLessonNumber(billInfo.getLessonNumber());
                accessionBillInfo.setBillAmount(billInfo.getBillAmount());
                accessionBillInfo.setManipulateState(ManipulateStateEnum.SAVE);
                accessionBillInfo.setSourceBillId(billInfo.getId().toString());
                accessionBillInfo.setMutualResult(MutualResultEnum.ARRANGEDSUMBIT);
                cbCollection.add((CoreBaseInfo)accessionBillInfo);
            }
            ICollectAccessionBill accessionFactory = CollectAccessionBillFactory.getLocalInstance(ctx);
            IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            if (cbCollection == null || cbCollection.size() < 1) {
                return null;
            }
            HashSet<String> sorrceSet = new HashSet<String>();
            IObjectPK pk = null;
            for (CollectAccessionBillInfo object : cbCollection) {
                pk = accessionFactory.addnew((CoreBaseInfo)object);
                sorrceSet.add(object.getSourceBillId().toString());
                BOTRelationInfo relateInfo = new BOTRelationInfo();
                relateInfo.setSrcEntityID(BOSUuid.read((String)object.getSourceBillId()).getType().toString());
                relateInfo.setDestEntityID(BOSUuid.read((String)pk.toString()).getType().toString());
                relateInfo.setSrcObjectID(object.getSourceBillId());
                relateInfo.setDestObjectID(pk.toString());
                relateInfo.setDate(new Date());
                relateInfo.setOperatorID("unknown");
                relateInfo.setIsEffected(true);
                relateInfo.setType(0);
                iBOTRelation.addnew(relateInfo);
            }
            String sql = "update T_EDR_CollectRegisterBill set FIsEnregister = 1 where fid in " + FMHelper.setTran2String(sorrceSet);
            DbUtil.execute((Context)ctx, (String)sql);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _commitToBE(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{idSet.size() + ""});
        CollectRegisterBillCollection colls = this.getObjectSet(ctx, idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList idList = new ArrayList(idSet);
        ArrayList<MsgInfo> msgList = new ArrayList<MsgInfo>(idSet.size());
        ArrayList<MsgInfo> errList = new ArrayList<MsgInfo>();
        int fail = 0;
        try {
            Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
            for (int i = 0; i < colls.size(); ++i) {
                CollectRegisterBillInfo info = colls.get(i);
                Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                String msg = this.verify(ctx, isLocked, info);
                MsgInfo msgInfo = new MsgInfo();
                msgInfo.setId(info.getId().toString());
                msgInfo.setNumber(info.getPaperNumber());
                msgInfo.setMsg(msg);
                msgList.add(msgInfo);
                if (msg != null) continue;
                TreeMap<String, List<CollectRegisterBillEntryInfo>> accNoMap = new TreeMap<String, List<CollectRegisterBillEntryInfo>>();
                CollectRegisterBillEntryCollection entrys = info.getEntrys();
                for (int j = 0; j < entrys.size(); ++j) {
                    CollectRegisterBillEntryInfo entry = entrys.get(j);
                    ReceivableBillInfo recBill = entry.getReceivablebill();
                    String accNo = recBill.getHolderAccount().getBankAccountNumber();
                    ArrayList<CollectRegisterBillEntryInfo> lst = (ArrayList<CollectRegisterBillEntryInfo>)accNoMap.get(accNo);
                    if (lst == null) {
                        lst = new ArrayList<CollectRegisterBillEntryInfo>();
                    }
                    lst.add(entry);
                    accNoMap.put(accNo, lst);
                }
                if (accNoMap.size() <= 0) continue;
                this.doProcess(ctx, accNoMap, info, errList);
            }
            if (errList != null && errList.size() > 0) {
                block5: for (MsgInfo msgInfo : msgList) {
                    for (MsgInfo errInfo : errList) {
                        if (!errInfo.getId().equals(msgInfo.getId())) continue;
                        msgInfo.setMsg(errInfo.getMsg());
                        continue block5;
                    }
                }
            }
            for (MsgInfo msgInfo : msgList) {
                if (EmptyUtil.isEmpty((String)msgInfo.getMsg())) continue;
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"070_COMMITBE_FAILED", (String[])new String[]{msgInfo.getNumber(), msgInfo.getMsg()}));
                ++fail;
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        if (fail == 0) {
            result.setError(0);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"068_ALL_COMMITBE_SUCCESS");
        } else {
            result.setError(1);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"069_COMMITBE_RESULT", (String[])new String[]{String.valueOf(idSet.size() - fail), String.valueOf(fail)});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    private List<MsgInfo> doProcess(Context ctx, Map<String, List<CollectRegisterBillEntryInfo>> accNoMap, CollectRegisterBillInfo info, List<MsgInfo> errList) {
        NoteReceivableOpUtil recOpUtil = new NoteReceivableOpUtil();
        for (String key : accNoMap.keySet()) {
            BigDecimal totalAmount = BigDecimal.ZERO;
            List<CollectRegisterBillEntryInfo> entryList = accNoMap.get(key);
            for (CollectRegisterBillEntryInfo entry : entryList) {
                totalAmount = totalAmount.add(entry.getReceivablebill().getBillAmt());
            }
            try {
                this.doCommitBE(ctx, recOpUtil, key, totalAmount, entryList, info);
            }
            catch (Exception e) {
                this.setErrMsgList(errList, info, e.getMessage());
            }
        }
        return errList;
    }

    private void setErrMsgList(List<MsgInfo> errList, CollectRegisterBillInfo info, String message) {
        MsgInfo msgInfo = new MsgInfo();
        msgInfo.setId(info.getId().toString());
        msgInfo.setNumber(info.getPaperNumber());
        msgInfo.setMsg(message);
        errList.add(msgInfo);
    }

    private void doCommitBE(Context ctx, NoteReceivableOpUtil recOpUtil, String accNo, BigDecimal totalAmount, List<CollectRegisterBillEntryInfo> entryList, CollectRegisterBillInfo info) throws BOSException, EASBizException {
        logger.debug((Object)"begin to commitToBE CollectRegisterBillInfo");
        ReceivableBillCollection coll = new ReceivableBillCollection();
        try {
            this.beforeCommitBE(ctx, info.isIsCommitToBE(), entryList);
            NoteReceivableBody body = this.parseCollectRegisterBody(ctx, totalAmount, entryList, info);
            NoteBizInfo bizInfo = new NoteBizInfo();
            bizInfo.setBankAcct(accNo);
            bizInfo.setNoteType(NoteTypeEnum.COLLECTREGISTER_BILL);
            NoteReceivableDetail[] detail = recOpUtil.noteRecOp(ctx, bizInfo, body);
            this.afterProcess(ctx, entryList, detail, true);
            info.setIsCommitToBE(true);
            info.setSubmiter(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
            info.setSubmitData(DateUtil.getDayBegin());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("isCommitToBE"));
            sic.add(new SelectorItemInfo("submiter"));
            sic.add(new SelectorItemInfo("submitData"));
            this.updatePartial(ctx, (CoreBaseInfo)info, sic);
            CollectRegisterBillEntryCollection entrys = info.getEntrys();
            for (int i = 0; i < entrys.size(); ++i) {
                ReceivableBillInfo recBill = entrys.get(i).getReceivablebill();
                coll.add(recBill);
            }
        }
        catch (BEException e) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception((Context)ctx, (ReceivableBillCollection)coll);
            this.afterCommit4Exception(ctx, entryList);
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception((Context)ctx, (ReceivableBillCollection)coll);
            this.afterCommit4Exception(ctx, entryList);
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception((Context)ctx, (ReceivableBillCollection)coll);
            this.afterCommit4Exception(ctx, entryList);
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            if (err instanceof AxisFault && ((AxisFault)err).getFaultString().indexOf("SAXException") != -1) {
                throw new BEException(BEException.EBSERVICE_PARAM_PARSE_ERROR);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private void afterCommit4Exception(Context ctx, List<CollectRegisterBillEntryInfo> entryList) throws EASBizException, BOSException {
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int i = 0; i < entryList.size(); ++i) {
            CollectRegisterBillEntryInfo entry = entryList.get(i);
            entry.setBankReturnStatus(BankReturnStatusEnum.COMMIT_FAIL);
            colls.add((CoreBaseInfo)entry);
        }
        CollectRegisterBillEntryFactory.getLocalInstance(ctx).updateBatchData(colls);
    }

    private void afterProcess(Context ctx, List<CollectRegisterBillEntryInfo> entryList, NoteReceivableDetail[] details, boolean commitBE) throws EASBizException, BOSException {
        CoreBaseCollection coll = new CoreBaseCollection();
        CoreBaseCollection recColl = new CoreBaseCollection();
        for (int i = 0; i < entryList.size(); ++i) {
            CollectRegisterBillEntryInfo entry = entryList.get(i);
            ReceivableBillInfo recInfo = entry.getReceivablebill();
            String detailSeqID = recInfo.getDetailSeqID();
            for (int j = 0; j < details.length; ++j) {
                NoteReceivableDetail detail = details[j];
                if (!detailSeqID.equals(detail.getDetailSeqID())) continue;
                if (commitBE) {
                    entry.setLastElecStatus(entry.getElecBillStatus());
                    entry.setRevers1(detail.getRedemptionEDate());
                }
                entry.setBankReturnStatus(DraftBEUtil.transferState((String)detail.getEbStatus()));
                if (recInfo.getSource().equals((Object)BillSourceEnum.BYNEW)) {
                    ElecBillStatusEnum elecBillStatusEnum = null;
                    elecBillStatusEnum = entry.isIsCommitCancel() ? BillServerUtil.setElecBillStatus((String)"collectRegister_Cancle", (ReceivableBillInfo)recInfo, (NoteReceivableDetail)detail) : BillServerUtil.setElecBillStatus((String)"collectRegister", (ReceivableBillInfo)recInfo, (NoteReceivableDetail)detail);
                    if (!EmptyUtil.isEmpty((Object)elecBillStatusEnum)) {
                        entry.setElecBillStatus(elecBillStatusEnum);
                    }
                    BillServerUtil.setStartAndEndNo((Context)ctx, (String)detail.getKeepFlag(), (String)detail.getEbStatus(), (ReceivableBillInfo)recInfo);
                    entry.setReserveds(detail.getKeepFlag());
                } else if (!EmptyUtil.isEmpty((String)detail.getNoteStatus())) {
                    entry.setElecBillStatus(ElecBillStatusEnum.getEnum((String)detail.getNoteStatus()));
                    recInfo.setElecBillStatus(ElecBillStatusEnum.getEnum((String)detail.getNoteStatus()));
                }
                entry.setBankReturnMsg(detail.getBankStatusMsg());
                logger.error((Object)("\u63d0\u793a\u4ed8\u6b3e\u64a4\u9500\u6210\u529f\u540e\u540c\u6b65\u94f6\u884c\u72b6\u6001\uff1a\u94f6\u4f01\u8fd4\u56de\u7535\u7968\u72b6\u6001 = " + detail.getEbStatus() + "\u5e94\u6536\u7968\u636eid\uff1a" + recInfo.getId().toString()));
                recInfo.setBankReturnStatus(DraftBEUtil.transferState((String)detail.getEbStatus()));
                recInfo.setBankReturnMsg(detail.getBankStatusMsg());
                if (entry.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS) {
                    logger.error((Object)("\u63d0\u793a\u4ed8\u6b3e\u64a4\u9500 \u662f\u5426\u6210\u529f detail.getReservedFiled2() = " + detail.getReservedFiled2()));
                    if ("note_cancle".equals(detail.getReservedFiled2())) {
                        this.setNoteCancelSign(ctx, entry, recInfo, true);
                    }
                } else if (entry.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL && !"note_cancle".equals(detail.getReservedFiled2())) {
                    this.setNoteCancelSign(ctx, entry, recInfo, false);
                }
                if (entry.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL && entry.isIsCommitCancel()) {
                    entry.setIsCommitCancel(false);
                }
                recColl.add((CoreBaseInfo)recInfo);
            }
            coll.add((CoreBaseInfo)entry);
        }
        if (recColl != null && recColl.size() > 0) {
            BillServerUtil.updateBizBillSettle((Context)ctx, (CoreBaseCollection)recColl);
            ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recColl);
        }
        CollectRegisterBillEntryFactory.getLocalInstance(ctx).updateBatchData(coll);
    }

    private void setNoteCancelSign(Context ctx, CollectRegisterBillEntryInfo entry, ReceivableBillInfo recInfo, boolean isnotecancel) {
        boolean NT011 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("NT011", (IObjectPK)new ObjectUuidPK(recInfo.getCompany().getId()));
        if (NT011) {
            recInfo.setBillState(BillStateEnum.Audit);
        } else {
            recInfo.setBillState(BillStateEnum.SAVED);
        }
        if (isnotecancel) {
            entry.setIsNoteCancel(true);
            entry.setElecBillStatus(entry.getLastElecStatus());
            entry.setBankReturnMsg("\u64a4\u9500\u64cd\u4f5c\u6210\u529f\u7968\u636e\u72b6\u6001\uff1a" + entry.getElecBillStatus().getAlias());
            recInfo.setElecBillStatus(entry.getLastElecStatus());
        }
        recInfo.setIsCollect(false);
        recInfo.setDigest(null);
        recInfo.setTransferDate(null);
        recInfo.setCollectBank(null);
        recInfo.setCollectNum(null);
    }

    private void beforeCommitBE(Context ctx, boolean isCommitBE, List<CollectRegisterBillEntryInfo> entryList) throws EASBizException, BOSException {
        String[] serialNos = beServiceHelper.getSerialNumber((int)entryList.size());
        CoreBaseCollection recBillCollection = new CoreBaseCollection();
        for (int i = 0; i < entryList.size(); ++i) {
            CollectRegisterBillEntryInfo entry = entryList.get(i);
            ReceivableBillInfo recInfo = entry.getReceivablebill();
            recInfo.setDetailSeqID(serialNos[i]);
            recInfo.setBatchSeqID(serialNos[0]);
            if (isCommitBE && entry.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) {
                entry.setBankReturnStatus(null);
                entry.setBankReturnMsg(null);
            }
            recBillCollection.add((CoreBaseInfo)recInfo);
        }
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recBillCollection);
    }

    private NoteReceivableBody parseCollectRegisterBody(Context ctx, BigDecimal totalAmount, List<CollectRegisterBillEntryInfo> entryList, CollectRegisterBillInfo info) {
        NoteReceivableBody body = new NoteReceivableBody();
        String seqID = entryList.get(0).getReceivablebill().getBatchSeqID();
        body.setBatchSeqID(seqID);
        body.setBatchBizNo(seqID);
        body.setTotalCount(String.valueOf(entryList.size()));
        body.setTotalAmount(totalAmount.setScale(2, 4).toString());
        body.setNoteReceiableDetail(this.parseCollectRegisterDetail(ctx, entryList, info));
        return body;
    }

    private NoteReceivableDetail[] parseCollectRegisterDetail(Context ctx, List<CollectRegisterBillEntryInfo> entryList, CollectRegisterBillInfo info) {
        NoteReceivableDetail[] details = new NoteReceivableDetail[entryList.size()];
        for (int i = 0; i < entryList.size(); ++i) {
            CollectRegisterBillEntryInfo entry = entryList.get(i);
            ReceivableBillInfo recBill = entry.getReceivablebill();
            NoteReceivableDetail detail = new NoteReceivableDetail();
            detail.setDetailSeqID(recBill.getDetailSeqID());
            detail.setDetailBizNo(recBill.getDetailSeqID());
            detail.setBillNo(recBill.getDraftPackageNumber());
            detail.setDraftType(recBill.getNtType().getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept) ? "AC01" : "AC02");
            detail.setOppAccName(recBill.getAcceptorName());
            detail.setOppAccNo(recBill.getAcceptorAccountName());
            detail.setOppBankName(recBill.getAcceptanceBankName());
            detail.setOppCnapsCode(recBill.getAcceptorBankNum());
            if (recBill.getAcceptorBank() != null) {
                detail.setOppProvince(recBill.getAcceptorBank().getBeProvince());
                detail.setOppCity(recBill.getAcceptorBank().getBeCity());
            }
            detail.setTransferFlag(recBill.isIsTransfer() ? "EM00" : "EM01");
            detail.setReservedFiled1(recBill.getDrawerName() + "|" + recBill.getDrawerAccountName() + "|" + recBill.getDrawerBankName());
            logger.error((Object)("DrawerName = " + recBill.getDrawerName() + "DrawerAccountName = " + recBill.getDrawerAccountName() + "DrawerBankName = " + recBill.getDrawerBankName()));
            logger.error((Object)("detail.getReservedFiled1()= " + detail.getReservedFiled1()));
            detail.setBookingDate(DraftBEUtil.date2String((Date)info.getCollectData(), (String)"yyyyMMddHHmmss"));
            Date dueDate = recBill.getExpiredDate();
            Date workCalendarDate = recBill.getExpiredDate();
            if (recBill.getExpiredDate() != null) {
                try {
                    boolean flag = false;
                    for (int j = 0; j < 15; ++j) {
                        flag = WorkCalendarFactory.getLocalInstance((Context)ctx).isWorkDay("00000000-0000-0000-0000-000000000000CCE7AED4", false, workCalendarDate);
                        if (flag) {
                            dueDate = workCalendarDate;
                            break;
                        }
                        workCalendarDate = DateUtil.getNextDay((Date)workCalendarDate, (int)1);
                    }
                }
                catch (WorkCalendarException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (!EmptyUtil.isEmpty((Object)recBill.getIssuesDate())) {
                detail.setIssueDate(DraftBEUtil.date2String((Date)recBill.getIssuesDate(), (String)"yyyyMMdd"));
            } else {
                logger.error((Object)("recBill.getIssuesDate() \u4e3a\u7a7a,ID: " + recBill.getId()));
            }
            detail.setDueDate(DraftBEUtil.date2String((Date)dueDate, (String)"yyyyMMdd"));
            detail.setOppAccNo(recBill.getAcceptorAccountName());
            detail.setOppAmount(recBill.getBillAmt().setScale(2, 4).toString());
            detail.setDesc(entry.getDescription());
            detail.setOtherInfo(info.getClearingEnum().getValue());
            if (info.getCollectData().before(DateUtil.getNextDay((Date)recBill.getExpiredDate(), (int)10))) {
                detail.setOperationCode("20");
            } else {
                detail.setOperationCode("21");
            }
            if (recBill.getSource().equals((Object)BillSourceEnum.BYNEW)) {
                BillServerUtil.setKeepFlag((NoteReceivableDetail)detail, (ReceivableBillInfo)recBill);
                String bankRefKey = BillServerUtil.getBankRefKey((Context)ctx, (ReceivableBillInfo)recBill);
                detail.setKeepFlag(detail.getKeepFlag() + ";bankRefKey=" + bankRefKey);
            }
            details[i] = detail;
        }
        return details;
    }

    private String verify(Context ctx, boolean isLocked, CollectRegisterBillInfo info) throws EASBizException, BOSException {
        String msg = null;
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"ent_CollectRegisterBill_commitToBe");
        if (!isPermission) {
            msg = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"086_NO_COMMITBE_AUTHRIZED");
        } else if (!isLocked) {
            msg = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
        } else if (info.getBillMedium() != BillMediumEnum.ELECTRONIC) {
            msg = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"018_ELECTRIC_CAN_COMMITBE");
        } else {
            if (info.isIsCommitToBE()) {
                msg = info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"9_common", (Locale)ctx.getLocale());
            }
            CollectRegisterBillEntryCollection entrys = info.getEntrys();
            for (int i = 0; i < entrys.size(); ++i) {
                CollectRegisterBillEntryInfo entry = entrys.get(i);
                ReceivableBillInfo recInfo = entry.getReceivablebill();
                if (!info.getCollectData().after(DateUtil.getNextDay((Date)recInfo.getExpiredDate(), (int)10)) || !EmptyUtil.isEmpty((String)entry.getDescription())) continue;
                msg = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"146_OVERDUE_DESC_NOTNULL");
                msg = msg + ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"10_common", (Locale)ctx.getLocale()) + recInfo.getDraftNumber() + "\uff1b";
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _syncBeStatus(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{idSet.size() + ""});
        CollectRegisterBillCollection colls = this.getObjectSet(ctx, idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList idList = new ArrayList(idSet);
        ArrayList<MsgInfo> msgList = new ArrayList<MsgInfo>(idSet.size());
        ArrayList<MsgInfo> errList = new ArrayList<MsgInfo>();
        int fail = 0;
        try {
            Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
            for (int i = 0; i < colls.size(); ++i) {
                CollectRegisterBillInfo info = colls.get(i);
                Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                String msg = this.verify4Sync(ctx, isLocked, info);
                MsgInfo msgInfo = new MsgInfo();
                msgInfo.setId(info.getId().toString());
                msgInfo.setNumber(info.getPaperNumber());
                msgInfo.setMsg(msg);
                msgList.add(msgInfo);
                if (msg != null) continue;
                TreeMap<String, List<CollectRegisterBillEntryInfo>> batchSeqMap = new TreeMap<String, List<CollectRegisterBillEntryInfo>>();
                CollectRegisterBillEntryCollection entrys = info.getEntrys();
                for (int j = 0; j < entrys.size(); ++j) {
                    CollectRegisterBillEntryInfo entry = entrys.get(j);
                    ReceivableBillInfo recBill = entry.getReceivablebill();
                    if (EmptyUtil.isEmpty((String)recBill.getBatchSeqID()) || entry.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL || entry.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS || entry.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL) continue;
                    String batchSeqID = recBill.getBatchSeqID();
                    ArrayList<CollectRegisterBillEntryInfo> lst = (ArrayList<CollectRegisterBillEntryInfo>)batchSeqMap.get(batchSeqID);
                    if (lst == null) {
                        lst = new ArrayList<CollectRegisterBillEntryInfo>();
                    }
                    lst.add(entry);
                    batchSeqMap.put(batchSeqID, lst);
                }
                if (batchSeqMap.size() <= 0) continue;
                this.doSyncStatus(ctx, batchSeqMap, info, errList);
            }
            if (errList != null && errList.size() > 0) {
                block5: for (MsgInfo msgInfo : msgList) {
                    for (MsgInfo errInfo : errList) {
                        if (!errInfo.getId().equals(msgInfo.getId())) continue;
                        msgInfo.setMsg(errInfo.getMsg());
                        continue block5;
                    }
                }
            }
            for (MsgInfo msgInfo : msgList) {
                if (EmptyUtil.isEmpty((String)msgInfo.getMsg())) continue;
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"058_SYNCSTATUS_FAILED", (String[])new String[]{msgInfo.getNumber(), msgInfo.getMsg()}));
                ++fail;
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        if (fail == 0) {
            result.setError(0);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"059_ALL_SYNCSTATUS_SUCCESS");
        } else {
            result.setError(1);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"060_SYNCSTATUS_RESULT", (String[])new String[]{String.valueOf(idSet.size() - fail), String.valueOf(fail)});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    private List<MsgInfo> doSyncStatus(Context ctx, Map<String, List<CollectRegisterBillEntryInfo>> batchSeqMap, CollectRegisterBillInfo info, List<MsgInfo> errList) {
        NoteReceivableOpUtil recOpUtil = new NoteReceivableOpUtil();
        for (String key : batchSeqMap.keySet()) {
            List<CollectRegisterBillEntryInfo> entryList = batchSeqMap.get(key);
            for (int i = 0; i < entryList.size(); ++i) {
                CollectRegisterBillEntryInfo entry = entryList.get(i);
                info.setElecBillStatus(info.getLastElecStatus());
                try {
                    CollectRegisterBillEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(entry.getId().toString()), entry);
                    continue;
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            try {
                NoteReceivableDetail[] details = this.queryRec(ctx, recOpUtil, entryList);
                if (details == null) {
                    throw new NTPException(NTPException.BE_RECORD_NOTEXIST);
                }
                this.afterProcess(ctx, entryList, details, false);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                this.setErrMsgList(errList, info, e.getMessage());
            }
        }
        return errList;
    }

    private NoteReceivableDetail[] queryRec(Context ctx, NoteReceivableOpUtil recOpUtil, List<CollectRegisterBillEntryInfo> entryList) throws BEException {
        NoteReceivableDetail[] details = null;
        NoteReceivableBody body = new NoteReceivableBody();
        body.setBatchSeqID(entryList.get(0).getReceivablebill().getBatchSeqID());
        String accNo = entryList.get(0).getReceivablebill().getHolderAccount().getBankAccountNumber();
        try {
            details = recOpUtil.queryNoteReceivable(ctx, accNo, body);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
        return details;
    }

    private String verify4Sync(Context ctx, boolean isLocked, CollectRegisterBillInfo info) throws EASBizException, BOSException {
        String msg = null;
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"edr_CollectRegisterBill_syncBeStatus");
        if (!isPermission) {
            msg = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"087_NO_SYNCSTATUS_AUTHRIZED");
        } else if (!isLocked) {
            msg = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
        } else if (!info.isIsCommitToBE()) {
            msg = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"062_CANNOT_SYNCSTATUS");
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _updateBeStatus(Context ctx, Set idSet, BankReturnStatusEnum status) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{idSet.size() + ""});
        CollectRegisterBillCollection colls = this.getObjectSet(ctx, idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList idList = new ArrayList(idSet);
        ArrayList<MsgInfo> msgList = new ArrayList<MsgInfo>(idSet.size());
        ArrayList<MsgInfo> errList = new ArrayList<MsgInfo>();
        int fail = 0;
        try {
            Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
            for (int i = 0; i < colls.size(); ++i) {
                CollectRegisterBillInfo info = colls.get(i);
                Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                String msg = this.verify4Update(ctx, isLocked, info);
                MsgInfo msgInfo = new MsgInfo();
                msgInfo.setId(info.getId().toString());
                msgInfo.setNumber(info.getPaperNumber());
                msgInfo.setMsg(msg);
                msgList.add(msgInfo);
                if (msg != null) continue;
                ArrayList<CollectRegisterBillEntryInfo> updateList = new ArrayList<CollectRegisterBillEntryInfo>();
                CollectRegisterBillEntryCollection entrys = info.getEntrys();
                for (int j = 0; j < entrys.size(); ++j) {
                    CollectRegisterBillEntryInfo entry = entrys.get(j);
                    if (entry.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) continue;
                    entry.setBankReturnStatus(status);
                    updateList.add(entry);
                }
                if (updateList.size() <= 0) continue;
                try {
                    this.doUpdateStatus(ctx, updateList);
                    continue;
                }
                catch (Exception e) {
                    this.setErrMsgList(errList, info, e.getMessage());
                }
            }
            if (errList != null && errList.size() > 0) {
                block7: for (MsgInfo msgInfo : msgList) {
                    for (MsgInfo errInfo : errList) {
                        if (!errInfo.getId().equals(msgInfo.getId())) continue;
                        msgInfo.setMsg(errInfo.getMsg());
                        continue block7;
                    }
                }
            }
            for (MsgInfo msgInfo : msgList) {
                if (EmptyUtil.isEmpty((String)msgInfo.getMsg())) continue;
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"073_UPDATESTATUS_FAILED", (String[])new String[]{msgInfo.getNumber(), msgInfo.getMsg()}));
                ++fail;
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        if (fail == 0) {
            result.setError(0);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"074_ALL_UPDATESTATUS_SUCCESS");
        } else {
            result.setError(1);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"075_UPDATESTATUS_RESULT", (String[])new String[]{String.valueOf(idSet.size() - fail), String.valueOf(fail)});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    private void doUpdateStatus(Context ctx, List<CollectRegisterBillEntryInfo> updateList) throws BEException {
        logger.debug((Object)"begin to updateBeStatus CollectRegisterBillInfo");
        NoteUpdateStautsUtil util = new NoteUpdateStautsUtil();
        NoteStatusBody body = new NoteStatusBody();
        body.setTotalCount(String.valueOf(updateList.size()));
        body.setDetails(this.parseUpdteDetail(ctx, updateList));
        try {
            NoteStatusDetail[] details = util.updateNoteStatus(ctx, null, body);
            this.afterProcess4Update(ctx, updateList, details);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private void afterProcess4Update(Context ctx, List<CollectRegisterBillEntryInfo> updateList, NoteStatusDetail[] details) throws EASBizException, BOSException {
        CoreBaseCollection coll = new CoreBaseCollection();
        CoreBaseCollection recColl = new CoreBaseCollection();
        for (int i = 0; i < updateList.size(); ++i) {
            CollectRegisterBillEntryInfo entry = updateList.get(i);
            ReceivableBillInfo recInfo = entry.getReceivablebill();
            String detailSeqID = recInfo.getDetailSeqID();
            for (int j = 0; j < details.length; ++j) {
                NoteStatusDetail detail = details[j];
                if (!detailSeqID.equals(detail.getDetailSeqID())) continue;
                entry.setBankReturnStatus(DraftBEUtil.transferState((String)detail.getEbStatus()));
                entry.setBankReturnMsg(detail.getBankStatusMsg());
                logger.error((Object)("\u63d0\u793a\u4ed8\u6b3e\u64a4\u9500\u6210\u529f\u540e\u540c\u6b65\u94f6\u884c\u72b6\u6001\uff1a\u94f6\u4f01\u8fd4\u56de\u7535\u7968\u72b6\u6001 = " + detail.getEbStatus() + "\u7968\u636eid = " + recInfo.getId().toString()));
                if (!EmptyUtil.isEmpty((String)detail.getNoteStatus())) {
                    recInfo.setElecBillStatus(ElecBillStatusEnum.getEnum((String)detail.getNoteStatus()));
                }
                if (entry.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS) {
                    logger.error((Object)("\u63d0\u793a\u4ed8\u6b3e\u64a4\u9500 \u662f\u5426\u6210\u529f detail.getReservedFiled2() = " + entry.isIsNoteCancel()));
                    if (entry.isIsCommitCancel()) {
                        this.setNoteCancelSign(ctx, entry, recInfo, true);
                    } else {
                        entry.setElecBillStatus(ElecBillStatusEnum.NT000000);
                        recInfo.setElecBillStatus(ElecBillStatusEnum.NT000000);
                    }
                } else if (entry.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL) {
                    this.setNoteCancelSign(ctx, entry, recInfo, false);
                    entry.setIsCommitCancel(false);
                }
                recColl.add((CoreBaseInfo)recInfo);
            }
            coll.add((CoreBaseInfo)entry);
        }
        if (recColl != null && recColl.size() > 0) {
            ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recColl);
        }
        CollectRegisterBillEntryFactory.getLocalInstance(ctx).updateBatchData(coll);
    }

    private NoteStatusDetail[] parseUpdteDetail(Context ctx, List<CollectRegisterBillEntryInfo> updateList) {
        NoteStatusDetail[] details = new NoteStatusDetail[updateList.size()];
        for (int i = 0; i < updateList.size(); ++i) {
            CollectRegisterBillEntryInfo entry = updateList.get(i);
            NoteStatusDetail detail = new NoteStatusDetail();
            detail.setDetailSeqID(entry.getReceivablebill().getDetailSeqID());
            detail.setBatchSeqID(entry.getReceivablebill().getBatchSeqID());
            detail.setEbStatus(entry.getBankReturnStatus().getName());
            detail.setEbNoteType("noteRecivable");
            detail.setUpdateReason(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"065_EDITBESTATUS_BYHAND"));
            detail.setOperator(ContextUtil.getCurrentUserInfo((Context)ctx).getName());
            detail.setOrganizationName(ContextUtil.getCurrentFIUnit((Context)ctx).getName());
            details[i] = detail;
        }
        return details;
    }

    private String verify4Update(Context ctx, boolean isLocked, CollectRegisterBillInfo info) throws EASBizException, BOSException {
        String msg = null;
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"edr_CollectRegisterBill_editBeStatus");
        if (!isPermission) {
            msg = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"088_NO_EDITSTATUS_AUTHRIZED");
        } else if (!isLocked) {
            msg = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
        } else if (!info.isIsCommitToBE()) {
            msg = ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"11_common", (Locale)ctx.getLocale());
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _noteCancle(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{idSet.size() + ""});
        CollectRegisterBillCollection colls = this.getObjectSet(ctx, idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList idList = new ArrayList(idSet);
        ArrayList<MsgInfo> msgList = new ArrayList<MsgInfo>(idSet.size());
        ArrayList<MsgInfo> errList = new ArrayList<MsgInfo>();
        int fail = 0;
        try {
            Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
            for (int i = 0; i < colls.size(); ++i) {
                CollectRegisterBillInfo info = colls.get(i);
                Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                String msg = null;
                if (!isLocked.booleanValue()) {
                    msg = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
                } else if (!ElecBillStatusEnum.NT200001.equals((Object)info.getElecBillStatus())) {
                    msg = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"153_NoteCancle", (String[])new String[]{info.getPaperNumber()});
                }
                if (msg == null && info.isIsCommitCancel()) {
                    msg = info.getPaperNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"12_common", (Locale)ctx.getLocale());
                }
                MsgInfo msgInfo = new MsgInfo();
                msgInfo.setId(info.getId().toString());
                msgInfo.setNumber(info.getPaperNumber());
                msgInfo.setMsg(msg);
                msgList.add(msgInfo);
                if (msg != null) continue;
                TreeMap<String, ArrayList<CollectRegisterBillEntryInfo>> accNoMap = new TreeMap<String, ArrayList<CollectRegisterBillEntryInfo>>();
                CollectRegisterBillEntryCollection entrys = info.getEntrys();
                for (int j = 0; j < entrys.size(); ++j) {
                    CollectRegisterBillEntryInfo entry = entrys.get(j);
                    ReceivableBillInfo recBill = entry.getReceivablebill();
                    String accNo = recBill.getHolderAccount().getBankAccountNumber();
                    ArrayList<CollectRegisterBillEntryInfo> lst = (ArrayList<CollectRegisterBillEntryInfo>)accNoMap.get(accNo);
                    if (lst == null) {
                        lst = new ArrayList<CollectRegisterBillEntryInfo>();
                    }
                    lst.add(entry);
                    accNoMap.put(accNo, lst);
                }
                if (accNoMap.size() <= 0) continue;
                for (String accNo : accNoMap.keySet()) {
                    BigDecimal totalAmount = BigDecimal.ZERO;
                    List entryList = (List)accNoMap.get(accNo);
                    StringBuffer notenos = new StringBuffer();
                    for (int k = 0; k < entryList.size(); ++k) {
                        CollectRegisterBillEntryInfo entry = (CollectRegisterBillEntryInfo)entryList.get(k);
                        totalAmount = totalAmount.add(entry.getReceivablebill().getBillAmt());
                        if (k < entryList.size() - 1) {
                            notenos.append(entry.getReceivablebill().getDraftNumber()).append(";");
                            continue;
                        }
                        notenos.append(entry.getReceivablebill().getDraftNumber());
                    }
                    try {
                        this.doNoteCancle(ctx, accNo, totalAmount, entryList, info);
                    }
                    catch (Exception e) {
                        this.setErrMsgList(errList, info, e.getMessage());
                    }
                }
            }
            if (errList != null && errList.size() > 0) {
                block9: for (MsgInfo msgInfo : msgList) {
                    for (MsgInfo errInfo : errList) {
                        if (!errInfo.getId().equals(msgInfo.getId())) continue;
                        msgInfo.setMsg(errInfo.getMsg());
                        continue block9;
                    }
                }
            }
            for (MsgInfo msgInfo : msgList) {
                if (EmptyUtil.isEmpty((String)msgInfo.getMsg())) continue;
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"154_NoteCancle", (String[])new String[]{msgInfo.getNumber(), msgInfo.getMsg()}));
                ++fail;
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        if (fail == 0) {
            result.setError(0);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"155_NoteCancle");
        } else {
            result.setError(1);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"156_NoteCancle", (String[])new String[]{String.valueOf(idSet.size() - fail), String.valueOf(fail)});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    private void doNoteCancle(Context ctx, String accNo, BigDecimal totalAmount, List<CollectRegisterBillEntryInfo> entryList, CollectRegisterBillInfo info) throws BOSException, EASBizException {
        logger.debug((Object)"begin to NoteCancle CollectRegisterBillInfo");
        ReceivableBillCollection coll = new ReceivableBillCollection();
        try {
            this.beforeCommitBE(ctx, info.isIsCommitToBE(), entryList);
            NoteReceivableOpUtil noteReceivableOpUtil = new NoteReceivableOpUtil();
            NoteReceivableBody noteReceivableBody = this.parseNoteReceivableBody(ctx, entryList, totalAmount, info);
            NoteBizInfo bizInfo = new NoteBizInfo();
            bizInfo.setBankAcct(accNo);
            bizInfo.setNoteType(NoteTypeEnum.NOTE_CANCLE);
            logger.error((Object)"\u2014\u2014\u2014\u2014\u2014\u2014before noteCancle\u2014\u2014\u2014\u2014\u2014\u2014");
            NoteReceivableDetail[] noteReceivableDetails = noteReceivableOpUtil.noteRecOp(ctx, bizInfo, noteReceivableBody);
            logger.error((Object)"\u2014\u2014\u2014\u2014\u2014\u2014end noteCancle\u2014\u2014\u2014\u2014\u2014\u2014");
            for (int i = 0; i < entryList.size(); ++i) {
                CollectRegisterBillEntryInfo entry = entryList.get(i);
                entry.setIsCommitCancel(true);
                coll.add(entry.getReceivablebill());
            }
            this.afterProcess(ctx, entryList, noteReceivableDetails, false);
        }
        catch (BEException e) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception((Context)ctx, (ReceivableBillCollection)coll);
            this.afterCommit4Exception(ctx, entryList);
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception((Context)ctx, (ReceivableBillCollection)coll);
            this.afterCommit4Exception(ctx, entryList);
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception((Context)ctx, (ReceivableBillCollection)coll);
            this.afterCommit4Exception(ctx, entryList);
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            if (err instanceof AxisFault && ((AxisFault)err).getFaultString().indexOf("SAXException") != -1) {
                throw new BEException(BEException.EBSERVICE_PARAM_PARSE_ERROR);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private NoteDetailRequestBody parseNoteDetailRequestBody(Context ctx, String notenos, List<CollectRegisterBillInfo> infoList) {
        NoteDetailRequestBody body = new NoteDetailRequestBody();
        body.setNoteNo(notenos);
        body.setTranType("20");
        body.setPageNum("1");
        StringBuffer expireDateStr = new StringBuffer();
        for (int i = 0; i < infoList.size(); ++i) {
            CollectRegisterBillInfo info = infoList.get(i);
            if (i < infoList.size() - 1) {
                expireDateStr.append(this.sdf.format(info.getDraftData())).append(";");
                continue;
            }
            expireDateStr.append(this.sdf.format(info.getDraftData()));
        }
        body.setKeepFlag(expireDateStr.toString());
        return body;
    }

    @Override
    protected void _receiving(Context ctx, Set idSet) throws BOSException, EASBizException {
        try {
            CollectRegisterBillCollection colls = this.getObjectSet(ctx, idSet);
            IReceivableBill iReceivable = ReceivableBillFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < colls.size(); ++i) {
                CollectRegisterBillInfo info = colls.get(i);
                if (!ElecBillClearingEnum.online_clearing.equals((Object)info.getClearingEnum())) continue;
                ReceivingBillInfo recBillInfo = new ReceivingBillInfo();
                ReceivableBillCollection coll = new ReceivableBillCollection();
                CollectRegisterBillEntryCollection entrys = info.getEntrys();
                for (int a = 0; a < entrys.size(); ++a) {
                    CollectRegisterBillEntryInfo entry = entrys.get(a);
                    ReceivableBillInfo recInfo = entry.getReceivablebill();
                    if (!ElecBillStatusEnum.NT000000.equals((Object)recInfo.getElecBillStatus()) || BillStateEnum.GATHERED.equals((Object)recInfo.getBillState()) || !BankReturnStatusEnum.BANK_SUCCESS.equals((Object)entry.getBankReturnStatus())) continue;
                    coll.add(entry.getReceivablebill());
                }
                if (coll.size() <= 0) continue;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String bizDate = sdf.format(new Date());
                recBillInfo.setBizDate(sdf.parse(bizDate));
                recBillInfo.setRecDate(sdf.parse(bizDate));
                recBillInfo.setPayeeAccountBank(coll.get(0).getPayeeAccount());
                recBillInfo.setPayeeAccount(coll.get(0).getPayeeAccount().getAccount());
                IBank iBank = BankFactory.getLocalInstance((Context)ctx);
                BankInfo bankInfo = iBank.getBankInfo((IObjectPK)new ObjectUuidPK(coll.get(0).getPayeeAccount().getBank().getId()));
                recBillInfo.setPayeeBank(bankInfo);
                recBillInfo.setExchangeRate(coll.get(0).getExchangeRate());
                iReceivable.batchReceiving(recBillInfo, coll);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u63d0\u793a\u4ed8\u6b3e\u53cd\u5199\u72b6\u6001\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private NoteReceivableBody parseNoteReceivableBody(Context ctx, List<CollectRegisterBillEntryInfo> entryList, BigDecimal totalAmount, CollectRegisterBillInfo info) throws EASBizException, BOSException {
        NoteReceivableBody body = new NoteReceivableBody();
        body.setBatchSeqID(entryList.get(0).getReceivablebill().getBatchSeqID());
        body.setBatchBizNo(entryList.get(0).getReceivablebill().getBatchSeqID());
        body.setTotalCount(String.valueOf(entryList.size()));
        body.setTotalAmount(totalAmount.toString());
        NoteReceivableDetail[] details = new NoteReceivableDetail[entryList.size()];
        for (int i = 0; i < entryList.size(); ++i) {
            NoteReceivableDetail detail;
            CollectRegisterBillEntryInfo entry = entryList.get(i);
            details[i] = detail = this.parseNoteReceiableDetail(ctx, info, entry);
        }
        body.setNoteReceiableDetail(details);
        return body;
    }

    private NoteReceivableDetail parseNoteReceiableDetail(Context ctx, CollectRegisterBillInfo info, CollectRegisterBillEntryInfo entry) throws EASBizException, BOSException {
        ReceivableBillInfo recBill = entry.getReceivablebill();
        NoteReceivableDetail detail = new NoteReceivableDetail();
        detail.setDetailSeqID(recBill.getDetailSeqID());
        detail.setDetailBizNo(recBill.getDetailSeqID());
        detail.setOppAccNo(recBill.getAcceptorAccountName());
        detail.setOppBankName(recBill.getAcceptanceBankName());
        detail.setOppAccName(recBill.getAcceptorName());
        detail.setOppCnapsCode(recBill.getAcceptorBankNum());
        detail.setOppAmount(recBill.getBillAmt().setScale(2).toString());
        detail.setBillNo(recBill.getDraftPackageNumber());
        detail.setDraftType(recBill.getNtType().getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept) ? "AC01" : "AC02");
        detail.setTransferFlag(recBill.isIsTransfer() ? "EM00" : "EM01");
        detail.setBookingDate(DraftBEUtil.date2String((Date)info.getCollectData(), (String)"yyyyMMddHHmmss"));
        detail.setIssueDate(DraftBEUtil.date2String((Date)recBill.getIssuesDate(), (String)"yyyyMMdd"));
        detail.setDueDate(DraftBEUtil.date2String((Date)recBill.getExpiredDate(), (String)"yyyyMMdd"));
        detail.setDesc(entry.getDescription());
        if (entry.getElecBillStatus() != null) {
            detail.setNoteStatus(entry.getElecBillStatus().getValue());
        }
        detail.setDesc(entry.getDescription());
        detail.setOperationCode("20");
        detail.setOperationName("\u63d0\u793a\u4ed8\u6b3e\u64a4\u9500");
        detail.setOtherInfo(info.getClearingEnum().getValue());
        detail.setRedemptionEDate(entry.getRevers1());
        detail.setReservedFiled2(recBill.getDrawerName() + "|" + recBill.getDrawerAccountName() + "|" + recBill.getDrawerBankName());
        if (recBill.getSource().equals((Object)BillSourceEnum.BYNEW)) {
            BillServerUtil.setKeepFlag((NoteReceivableDetail)detail, (ReceivableBillInfo)recBill);
            CollectRegisterBillEntryCollection entrys = info.getEntrys();
            String keepFlag = detail.getKeepFlag();
            for (int j = 0; j < entrys.size(); ++j) {
                CollectRegisterBillEntryInfo entryInfo = entrys.get(j);
                if (entryInfo.getReceivablebill() == null || !entryInfo.getReceivablebill().getId().toString().equals(recBill.getId().toString()) || EmptyUtil.isEmpty((String)entryInfo.getReserveds())) continue;
                String[] reserveds = entryInfo.getReserveds().split(";");
                for (int k = 0; k < reserveds.length; ++k) {
                    String returnValue = reserveds[k].trim();
                    if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("bankRefKey=".toUpperCase(Locale.ENGLISH))) {
                        keepFlag = keepFlag + ";" + returnValue;
                    }
                    if (!returnValue.toUpperCase(Locale.ENGLISH).startsWith("bankRefDate=".toUpperCase(Locale.ENGLISH))) continue;
                    keepFlag = keepFlag + ";" + returnValue;
                }
            }
            detail.setKeepFlag(keepFlag);
        }
        return detail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _noteCancleEntrys(Context ctx, List idList, Set entryIdSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"13_common", (String[])new String[]{entryIdSet.size() + ""});
        CollectRegisterBillCollection coll = this.getObjectSet(ctx, new HashSet(idList));
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        int fail = 0;
        for (int i = 0; i < coll.size(); ++i) {
            CollectRegisterBillInfo info = coll.get(i);
            CollectRegisterBillEntryCollection entrys = info.getEntrys();
            CollectRegisterBillEntryCollection noteEntrys = new CollectRegisterBillEntryCollection();
            for (int j = 0; j < entrys.size(); ++j) {
                CollectRegisterBillEntryInfo entry = entrys.get(j);
                if (!entryIdSet.contains(entry.getId().toString())) continue;
                noteEntrys.add(entry);
            }
            boolean isLock = iMutex.requestObjIDForUpdate(ctx, info.getId().toString());
            try {
                this.verifyNoteCancelHead(ctx, isLock, info);
            }
            catch (Exception e) {
                fail += noteEntrys.size();
                for (int m = 0; m < noteEntrys.size(); ++m) {
                    ReceivableBillInfo receivable = noteEntrys.get(m).getReceivablebill();
                    result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"14_common", (String[])new String[]{receivable.getDraftNumber()}) + e.getMessage());
                }
                if (!isLock) continue;
                iMutex.releaseObjIDForUpdate(ctx, info.getId().toString());
                continue;
            }
            try {
                TreeMap<String, ArrayList<CollectRegisterBillEntryInfo>> accNoMap = new TreeMap<String, ArrayList<CollectRegisterBillEntryInfo>>();
                for (int j = 0; j < noteEntrys.size(); ++j) {
                    CollectRegisterBillEntryInfo entry = noteEntrys.get(j);
                    ReceivableBillInfo recBill = entry.getReceivablebill();
                    try {
                        this.verifyNoteCancelEntry(ctx, entry);
                    }
                    catch (Exception e) {
                        ++fail;
                        result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"14_common", (String[])new String[]{recBill.getDraftNumber()}) + e.getMessage());
                        continue;
                    }
                    String accNo = recBill.getHolderAccount().getBankAccountNumber();
                    ArrayList<CollectRegisterBillEntryInfo> lst = (ArrayList<CollectRegisterBillEntryInfo>)accNoMap.get(accNo);
                    if (lst == null) {
                        lst = new ArrayList<CollectRegisterBillEntryInfo>();
                    }
                    lst.add(entry);
                    accNoMap.put(accNo, lst);
                }
                if (accNoMap.size() == 0) continue;
                for (String accNo : accNoMap.keySet()) {
                    BigDecimal totalAmount = BigDecimal.ZERO;
                    List entryList = (List)accNoMap.get(accNo);
                    for (int k = 0; k < entryList.size(); ++k) {
                        CollectRegisterBillEntryInfo entry = (CollectRegisterBillEntryInfo)entryList.get(k);
                        totalAmount = totalAmount.add(entry.getReceivablebill().getBillAmt());
                    }
                    try {
                        this.doNoteCancle(ctx, accNo, totalAmount, entryList, info);
                    }
                    catch (Exception e) {
                        fail += entryList.size();
                        for (int m = 0; m < entryList.size(); ++m) {
                            ReceivableBillInfo receivable = ((CollectRegisterBillEntryInfo)entryList.get(m)).getReceivablebill();
                            result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"14_common", (String[])new String[]{receivable.getDraftNumber()}) + e.getMessage());
                        }
                    }
                }
                continue;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(ctx, info.getId().toString());
                }
            }
        }
        if (fail == 0) {
            result.setError(0);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"155_NoteCancle");
        } else {
            result.setError(1);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"156_NoteCancle", (String[])new String[]{String.valueOf(entryIdSet.size() - fail), String.valueOf(fail)});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    private void verifyNoteCancelHead(Context ctx, boolean isLock, CollectRegisterBillInfo info) throws NTException {
        if (!isLock) {
            throw new NTException(NTException.COMMON, new Object[]{FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI")});
        }
        if (!info.isIsCommitToBE()) {
            throw new NTException(NTException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"15_common", (Locale)ctx.getLocale())});
        }
    }

    private void verifyNoteCancelEntry(Context ctx, CollectRegisterBillEntryInfo entry) throws NTException {
        if (!ElecBillStatusEnum.NT200001.equals((Object)entry.getElecBillStatus())) {
            throw new NTException(NTException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"16_common", (Locale)ctx.getLocale())});
        }
        if (entry.isIsCommitCancel()) {
            throw new NTException(NTException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"17_common", (Locale)ctx.getLocale())});
        }
    }

    private CollectRegisterBillEntryCollection getEntrys(Context ctx, Set entryIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("receivablebill.*"));
        sic.add(new SelectorItemInfo("receivablebill.acceptorBank.id"));
        sic.add(new SelectorItemInfo("receivablebill.acceptorBank.beProvince"));
        sic.add(new SelectorItemInfo("receivablebill.acceptorBank.beCity"));
        sic.add(new SelectorItemInfo("receivablebill.holderAccount.id"));
        sic.add(new SelectorItemInfo("receivablebill.holderAccount.name"));
        sic.add(new SelectorItemInfo("receivablebill.holderAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("receivablebill.ntType.*"));
        sic.add(new SelectorItemInfo("receivablebill.ntType.group"));
        sic.add(new SelectorItemInfo("receivablebill.currency.*"));
        sic.add(new SelectorItemInfo("receivablebill.company.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)entryIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        CollectRegisterBillEntryCollection entrys = CollectRegisterBillEntryFactory.getLocalInstance(ctx).getCollectRegisterBillEntryCollection(view);
        return entrys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _updateEntryStatus(Context ctx, List idList, List statusList) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"13_common", (String[])new String[]{statusList.size() + ""});
        CollectRegisterBillCollection coll = this.getObjectSet(ctx, new HashSet(idList));
        HashMap<String, BankReturnStatusEnum> entry_statusMap = new HashMap<String, BankReturnStatusEnum>();
        for (int i = 0; i < statusList.size(); ++i) {
            Map map = (Map)statusList.get(i);
            String id = (String)map.get("id");
            BankReturnStatusEnum status = (BankReturnStatusEnum)map.get("bankReturnStatus");
            entry_statusMap.put(id, status);
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        int fail = 0;
        for (int i = 0; i < coll.size(); ++i) {
            CollectRegisterBillInfo info = coll.get(i);
            if (!info.isIsCommitToBE()) continue;
            ArrayList<CollectRegisterBillEntryInfo> updateList = new ArrayList<CollectRegisterBillEntryInfo>();
            CollectRegisterBillEntryCollection entrys = info.getEntrys();
            for (int j = 0; j < entrys.size(); ++j) {
                CollectRegisterBillEntryInfo entry = entrys.get(j);
                if (!entry_statusMap.keySet().contains(entry.getId().toString())) continue;
                entry.setBankReturnStatus((BankReturnStatusEnum)entry_statusMap.get(entry.getId().toString()));
                updateList.add(entry);
            }
            if (updateList.size() == 0) continue;
            boolean isLock = iMutex.requestObjIDForUpdate(ctx, info.getId().toString());
            try {
                if (!isLock) {
                    throw new NTException(NTException.COMMON, new Object[]{FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI")});
                }
                this.doUpdateStatus(ctx, updateList);
                continue;
            }
            catch (Exception e) {
                fail += updateList.size();
                for (int m = 0; m < updateList.size(); ++m) {
                    ReceivableBillInfo receivable = ((CollectRegisterBillEntryInfo)updateList.get(m)).getReceivablebill();
                    result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"18_common", (String[])new String[]{receivable.getDraftNumber()}) + e.getMessage());
                }
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(ctx, info.getId().toString());
                }
            }
        }
        if (fail == 0) {
            result.setError(0);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"074_ALL_UPDATESTATUS_SUCCESS");
        } else {
            result.setError(1);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"075_UPDATESTATUS_RESULT", (String[])new String[]{String.valueOf(statusList.size() - fail), String.valueOf(fail)});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _audit(Context ctx, Set idSet, boolean fromWF) throws BOSException, EASBizException {
        String errorCode = "0";
        StringBuffer errorMsg = new StringBuffer();
        UserInfo userInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditor"));
        userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            CollectRegisterBillInfo info = this.getCollectRegisterBillInfo(ctx, (IObjectPK)new ObjectUuidPK((String)it.next()));
            if (!StateEnum.SUBMITTED.equals((Object)info.getState())) {
                errorMsg.append(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"19_common", (String[])new String[]{info.getNumber()}));
                errorCode = "1";
                continue;
            }
            info.setState(StateEnum.AUDITED);
            info.setAuditor(userInfo);
            this.updatePartial(ctx, (CoreBaseInfo)info, sic);
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("errorCode", errorCode);
        ret.put("errorMsg", errorMsg.toString());
        return ret;
    }

    @Override
    protected Map _antiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        String errorCode = "0";
        StringBuffer errorMsg = new StringBuffer();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditor"));
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            CollectRegisterBillInfo info = this.getCollectRegisterBillInfo(ctx, (IObjectPK)new ObjectUuidPK((String)it.next()));
            if (!StateEnum.AUDITED.equals((Object)info.getState())) {
                errorMsg.append(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"20_common", (String[])new String[]{info.getNumber()}));
                errorCode = "1";
                continue;
            }
            if (info.isIsCommitToBE()) {
                errorMsg.append(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"21_common", (String[])new String[]{info.getNumber()}));
                errorCode = "1";
                continue;
            }
            info.setState(StateEnum.SAVED);
            info.setAuditor(null);
            this.updatePartial(ctx, (CoreBaseInfo)info, sic);
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("errorCode", errorCode);
        ret.put("errorMsg", errorMsg.toString());
        return ret;
    }

    @Override
    protected Map _submit(Context ctx, Set idSet) throws BOSException, EASBizException {
        String errorCode = "0";
        StringBuffer errorMsg = new StringBuffer();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            CollectRegisterBillInfo info = this.getCollectRegisterBillInfo(ctx, (IObjectPK)new ObjectUuidPK((String)it.next()));
            if (!StateEnum.SAVED.equals((Object)info.getState()) && !StateEnum.SUBMITTED.equals((Object)info.getState())) {
                errorMsg.append(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.common.FMCommonResource", (String)"22_common", (String[])new String[]{info.getNumber()}));
                errorCode = "1";
                continue;
            }
            info.setState(StateEnum.SUBMITTED);
            this.submit(ctx, (CoreBaseInfo)info);
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("errorCode", errorCode);
        ret.put("errorMsg", errorMsg.toString());
        return ret;
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(pk.toString());
        this._audit(ctx, idSet, true);
    }

    @Override
    protected void _antiAudit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(pk.toString());
        this._antiAudit(ctx, idSet);
    }
}

