/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.BanEndorsementMarkEnum;
import com.kingdee.eas.fm.ecore.DiscountRequestBillInfo;
import com.kingdee.eas.fm.ecore.DiscountTypeEnum;
import com.kingdee.eas.fm.ecore.ECoreQueryServiceFacadeFactory;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.SettlementMarkEnum;
import com.kingdee.eas.fm.edraf.DiscountReqApplyBillEntryFactory;
import com.kingdee.eas.fm.edraf.DiscountReqApplyBillEntryInfo;
import com.kingdee.eas.fm.edraf.DiscountReqApplyBillFactory;
import com.kingdee.eas.fm.edraf.DiscountReqApplyBillInfo;
import com.kingdee.eas.fm.edraf.DiscouontReqApplyBizBillFactory;
import com.kingdee.eas.fm.edraf.DiscouontReqApplyBizBillInfo;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseInfo;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.EdrafSysNotificationFacadeFactory;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.app.AbstractDiscouontReqApplyBizBillControllerBean;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class DiscouontReqApplyBizBillControllerBean
extends AbstractDiscouontReqApplyBizBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.DiscouontReqApplyBizBillControllerBean");

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void checkBeforeAddNew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void initInfo(Context ctx, IObjectValue model) {
    }

    @Override
    public void checkDraftApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    public ApplyBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DiscouontReqApplyBizBillInfo bizBillInfo = (DiscouontReqApplyBizBillInfo)model;
        DiscountReqApplyBillEntryInfo entryInfo = bizBillInfo.getEntry();
        DiscountReqApplyBillInfo billInfo = entryInfo.getBill();
        if (billInfo != null && billInfo.getId() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("discountOutUser.*"));
            sic.add(new SelectorItemInfo("discountOutAccount.*"));
            sic.add(new SelectorItemInfo("discountOutBankNumber.*"));
            sic.add(new SelectorItemInfo("discountInUser.*"));
            sic.add(new SelectorItemInfo("discountInAccount.*"));
            sic.add(new SelectorItemInfo("discountInBankNumber.*"));
            sic.add(new SelectorItemInfo("discountMoneyInAccount.*"));
            sic.add(new SelectorItemInfo("discountMoneyBankNumber.*"));
            String id = billInfo.getId().toString();
            billInfo = DiscountReqApplyBillFactory.getLocalInstance(ctx).getDiscountReqApplyBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
        DiscountRequestBillInfo reqInfo = new DiscountRequestBillInfo();
        reqInfo.setNumber(billInfo.getNumber());
        reqInfo.setBillAmount(entryInfo.getDraftAmount());
        reqInfo.setBillNumber(entryInfo.getDraftNumber());
        reqInfo.setRequestDate(billInfo.getDiscountApplyDate());
        reqInfo.setDiscountType(billInfo.getDiscountType().equals((Object)com.kingdee.eas.fm.edrafent.DiscountTypeEnum.RM00) ? DiscountTypeEnum.RM01 : DiscountTypeEnum.RM00);
        reqInfo.setRate(billInfo.getDiscountRate().multiply(new BigDecimal("0.01")).setScale(6, 0));
        reqInfo.setPayfor(entryInfo.getDiscountMoney().setScale(2, 0));
        reqInfo.setAssignmentMark(billInfo.isIsAttorn() ? BanEndorsementMarkEnum.EM00 : BanEndorsementMarkEnum.EM01);
        if (billInfo.getDiscountType().equals((Object)com.kingdee.eas.fm.edrafent.DiscountTypeEnum.RM00)) {
            reqInfo.setBackOpenDate(billInfo.getDiscountRedStartDate());
            reqInfo.setBackCloseDate(billInfo.getDiscountRedEndDate());
            reqInfo.setBackRate(billInfo.getDiscountRedRate().multiply(new BigDecimal("0.01")).setScale(6, 0));
            reqInfo.setBackMoney(entryInfo.getDiscountInMoney().setScale(2, 0));
        }
        reqInfo.setBalanceMark(billInfo.isIsLine() ? SettlementMarkEnum.SM00 : SettlementMarkEnum.SM01);
        reqInfo.setTxCtrctNb(billInfo.getContractNumber());
        reqInfo.setInvcNb(billInfo.getInvoiceNumber());
        reqInfo.setDiscounterRemark(entryInfo.getDiscountOutRamark());
        reqInfo.setDiscounterAccount(billInfo.getDiscountOutAccount().getBankAccountNumber());
        reqInfo.setAccountId(billInfo.getDiscountMoneyInAccount().getBankAccountNumber());
        reqInfo.setBankId(billInfo.getDiscountMoneyBankNum());
        reqInfo.setDiscounterName(billInfo.getDiscountOutUser().getName());
        reqInfo.setGroupId(billInfo.getOrgUnitCode());
        String eletricSign = EdrafUtil.getSignatureByBillId(ctx, billInfo.getSourceBillId(), billInfo.getApplyCompany().getId().toString());
        reqInfo.setDiscounterSgin(eletricSign);
        reqInfo.setDiscounterBank(billInfo.getDiscountOutBankNumber());
        reqInfo.setByDiscounterName(billInfo.getDiscountInUser().getName());
        reqInfo.setByDiscounterAccount(billInfo.getDiscountInAccount());
        reqInfo.setByDiscounterBank(billInfo.getDiscountInBankNumber());
        reqInfo.setBizPromoterOrgCode(billInfo.getOrgUnitCode());
        reqInfo.setBizSerialNumber(bizBillInfo.getBizCode());
        return reqInfo;
    }

    @Override
    public DraftApplyBillBaseCollection getBillCollection(Context ctx, Set idSet, SelectorItemCollection sic) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.TXSQ;
    }

    @Override
    protected void updateBillOperateState(Context ctx, DraftApplyBillBaseInfo billInfo) throws EASBizException, BOSException {
        DiscouontReqApplyBizBillInfo bizBillInfo = (DiscouontReqApplyBizBillInfo)billInfo;
        DiscountReqApplyBillEntryInfo entryInfo = bizBillInfo.getEntry();
        DiscountReqApplyBillInfo disBillInfo = entryInfo.getBill();
        if (disBillInfo != null && disBillInfo.getId() != null) {
            disBillInfo = DiscountReqApplyBillFactory.getLocalInstance(ctx).getDiscountReqApplyBillInfo((IObjectPK)new ObjectUuidPK(disBillInfo.getId().toString()));
        }
        disBillInfo.setOperateState(FCOperateStateEnum.submit);
        disBillInfo.setSubmitDate(new Date());
        disBillInfo.setSubmitCompany(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany());
        disBillInfo.setSubmitter(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        disBillInfo.setDiscountApplyDate(ECoreQueryServiceFacadeFactory.getLocalInstance((Context)ctx).getSystemDate());
        String bizCode = billInfo.getBizCode();
        if (bizCode == null) {
            bizCode = EdrafSysNotificationFacadeFactory.getLocalInstance(ctx).generateBizCode(this.getRequestType(), billInfo.getBOSType().toString());
            billInfo.setBizCode(bizCode);
        }
        DiscountReqApplyBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(disBillInfo.getId()), (CoreBaseInfo)disBillInfo);
        if (billInfo.getSourceBillId() != null) {
            String id = billInfo.getSourceBillId();
            String oql = "update T_EDT_DraftDiscountReqBill set FFinanceOperateState=? where FID='" + id + "'";
            DbUtil.execute((Context)ctx, (String)oql, (Object[])new Object[]{new Integer(1)});
        }
        entryInfo.setCommunResult(ECDSCommunicationStatusEnum.SUBMIT_SUCCESS);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("communResult"));
        DiscountReqApplyBillEntryFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)entryInfo, sic);
    }

    @Override
    protected void _rewriteECDSMess(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.draftStockBill.id"));
        DiscouontReqApplyBizBillInfo bizBillInfo = DiscouontReqApplyBizBillFactory.getLocalInstance(ctx).getDiscouontReqApplyBizBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId), sic);
        DiscountReqApplyBillEntryInfo entryInfo = bizBillInfo.getEntry();
        entryInfo.setCommunResult(bizBillInfo.getCommunicationStatus());
        entryInfo.setEndStatu(bizBillInfo.getEndECDSState());
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("communResult"));
        sic.add(new SelectorItemInfo("endStatu"));
        DiscountReqApplyBillEntryFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)entryInfo, sic);
        if (bizBillInfo.getCommunicationStatus().equals((Object)ECDSCommunicationStatusEnum.PROCESS_FAIL) && entryInfo.getDraftStockBill().getId() != null) {
            String stockId = entryInfo.getDraftStockBill().getId().toString();
            String oql = "update T_EDT_DraftStockBill set FDraftStockOperate=? where FID='" + stockId + "'";
            DbUtil.execute((Context)ctx, (String)oql, (Object[])new Object[]{new Integer(0)});
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSCancelBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }
}

