/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.ecore.ActionCancelBillInfo;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.DraftBizTypeEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.GuaranteeRequestBillInfo;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.RoleEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.EdrafException;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.GuaranteeApplyBillFactory;
import com.kingdee.eas.fm.edraf.GuaranteeApplyBillInfo;
import com.kingdee.eas.fm.edraf.app.AbstractGuaranteeApplyBillControllerBean;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.fm.edrafent.CommercialDraftBackSideEntryCollection;
import com.kingdee.eas.fm.edrafent.CommercialDraftBackSideEntryFactory;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftGuaranteeRequestBillFactory;
import com.kingdee.eas.fm.edrafent.DraftGuaranteeRequestBillInfo;
import com.kingdee.eas.fm.edrafent.DraftRegisterBillFactory;
import com.kingdee.eas.fm.edrafent.DraftRegisterBillInfo;
import com.kingdee.eas.fm.edrafent.IDraftGuaranteeRequestBill;
import com.kingdee.eas.fm.edrafent.IDraftRegisterBill;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class GuaranteeApplyBillControllerBean
extends AbstractGuaranteeApplyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.GuaranteeApplyBillControllerBean");

    @Override
    public void checkDraftApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GuaranteeApplyBillInfo billInfo = (GuaranteeApplyBillInfo)model;
        ECDSCommunicationStatusEnum state = billInfo.getCommunicationStatus();
        if (billInfo.isIsCancelDraft() && billInfo.getEndECDSState() != ECDSBillStatusEnum.BZDQS) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"37_GuaranteeApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (!(state == null || state.equals((Object)ECDSCommunicationStatusEnum.SUBMIT_READY) || (state.equals((Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL) || state.equals((Object)ECDSCommunicationStatusEnum.PROCESS_FAIL)) && billInfo.getReturnOpinion() == null)) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"1_AcceptanceApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GuaranteeApplyBillInfo billInfo = (GuaranteeApplyBillInfo)model;
        GuaranteeRequestBillInfo applyBillInfo = new GuaranteeRequestBillInfo();
        CommercialDraftInfo commDraft = billInfo.getCommercialDraft();
        if (commDraft == null || commDraft.getDraftNumber() == null || commDraft.getDraftAmount() == null || commDraft.getHolderOrgCode() == null) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"38_GuaranteeApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        applyBillInfo.setDraftNumber(commDraft.getDraftNumber());
        applyBillInfo.setDraftAmount(commDraft.getDraftAmount());
        applyBillInfo.setWarranteeOrgCode(commDraft.getHolderOrgCode());
        applyBillInfo.setWarranteeRole(RoleEnum.RC01);
        if (billInfo.getApplyDate() != null && billInfo.getByAssurerName() != null && billInfo.getByAssurerAcctSv() != null && billInfo.getAssurerName() != null && billInfo.getAssurersAccount() != null && billInfo.getAssurersBankNumber() != null) {
            applyBillInfo.setApplyDate(billInfo.getApplyDate());
            applyBillInfo.setWarranteeName(billInfo.getByAssurerName().getName());
            if (billInfo.getByAssurerBank() != null) {
                applyBillInfo.setWarranteeAccount(billInfo.getByAssurerBank().getBankAccountNumber());
            } else {
                applyBillInfo.setWarranteeAccount("0");
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"38_GuaranteeApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        applyBillInfo.setWarranteeBank(billInfo.getByAssurerAcctSv().getNumber());
        applyBillInfo.setGuarantorName(billInfo.getAssurerName().getName());
        applyBillInfo.setGuarantorAccount(billInfo.getAssurersAccount());
        applyBillInfo.setGuarantorBank(billInfo.getAssurersBankNumber());
        applyBillInfo.setBatchNumber(billInfo.getBatch());
        applyBillInfo.setWarranteeRemark(billInfo.getRemark());
        String eletricSign = "0";
        if (billInfo.getApplyCompany() != null) {
            eletricSign = EdrafUtil.getSignatureByBillId(ctx, billInfo.getSourceBillId(), billInfo.getApplyCompany().getId().toString());
        }
        applyBillInfo.setWarranteeElecSign(eletricSign);
        applyBillInfo.setBizSerialNumber(billInfo.getBizCode());
        applyBillInfo.setBizPromoterOrgCode(commDraft.getHolderOrgCode());
        return applyBillInfo;
    }

    @Override
    public DraftApplyBillBaseCollection getBillCollection(Context ctx, Set idSet, SelectorItemCollection sic) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)FCOperateStateEnum.save, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_READY, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.PROCESS_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("returnOpinion", null, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or ((#3 or #4) and #5))");
        env.setSelector(sic);
        env.setFilter(filter);
        DraftApplyBillBaseCollection registerCol = GuaranteeApplyBillFactory.getLocalInstance(ctx).getDraftApplyBillBaseCollection(env);
        if (registerCol == null || registerCol.size() == 0) {
            throw new EdrafException(EdrafException.SUBMIT_ERROR);
        }
        return registerCol;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.BZSQ;
    }

    @Override
    public ApplyBillBaseInfo convertToECDSCancelBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GuaranteeApplyBillInfo guaranteeBillInfo = (GuaranteeApplyBillInfo)model;
        ActionCancelBillInfo cancelBillInfo = new ActionCancelBillInfo();
        CommercialDraftInfo draftInfo = guaranteeBillInfo.getCommercialDraft();
        cancelBillInfo.setDraftNumber(draftInfo.getDraftNumber());
        cancelBillInfo.setDraftAmount(draftInfo.getDraftAmount());
        String eletricSign = "0";
        if (guaranteeBillInfo.getApplyCompany() != null) {
            eletricSign = EdrafUtil.getSignatureByBillId(ctx, guaranteeBillInfo.getSourceBillId(), guaranteeBillInfo.getApplyCompany().getId().toString());
        }
        cancelBillInfo.setEletricSign(eletricSign);
        cancelBillInfo.setCancelOrgCode(draftInfo.getHolderOrgCode());
        cancelBillInfo.setCancelAccount(guaranteeBillInfo.getByAssurerBank().getBankAccountNumber());
        cancelBillInfo.setCancelBank(guaranteeBillInfo.getByAssurerAcctSv().getNumber());
        cancelBillInfo.setBizPromoterOrgCode(draftInfo.getHolderOrgCode());
        return cancelBillInfo;
    }

    @Override
    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = super.getSelector();
        sic.add("byAssurerName.name");
        sic.add("byAssurerAcctSv.number");
        sic.add("byAssurerBank.bankAccountNumber");
        sic.add("assurerName.name");
        return sic;
    }

    @Override
    protected void _rewriteECDSMess(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
        BOSObjectType bosType;
        BOSObjectType registerType;
        DraftGuaranteeRequestBillInfo draftInfo;
        IDraftGuaranteeRequestBill iDraftGuaranteeRequestBill;
        GuaranteeApplyBillInfo endorInfo = this.getGuaranteeApplyBillInfo(ctx, (IObjectPK)new ObjectUuidPK(sourceBillId));
        if (endorInfo != null && endorInfo.getSourceBillId() != null && (ecdsApplyBillStatus == ApplyBillStatusEnum.RECEIVE_031_OK || ecdsApplyBillStatus == ApplyBillStatusEnum.RECEIVE_031_BAN || ecdsApplyBillStatus == ApplyBillStatusEnum.RECEIVE_033_OK || ecdsApplyBillStatus == ApplyBillStatusEnum.RECEIVE_033_ERROR)) {
            iDraftGuaranteeRequestBill = DraftGuaranteeRequestBillFactory.getLocalInstance((Context)ctx);
            draftInfo = iDraftGuaranteeRequestBill.getDraftGuaranteeRequestBillInfo((IObjectPK)new ObjectUuidPK(endorInfo.getSourceBillId()));
            SelectorItemCollection selCollection = new SelectorItemCollection();
            if (endorInfo.isIsCancelDraft() && (ecdsApplyBillStatus == ApplyBillStatusEnum.RECEIVE_031_OK || ecdsApplyBillStatus == ApplyBillStatusEnum.RECEIVE_033_OK)) {
                selCollection.add(new SelectorItemInfo("operateState"));
                draftInfo.setOperateState(OperateStateEnum.CANCEL);
            }
            selCollection.add(new SelectorItemInfo("endState"));
            draftInfo.setEndState(endorInfo.getEndECDSState());
            iDraftGuaranteeRequestBill.updatePartial((CoreBaseInfo)draftInfo, selCollection);
        }
        if (endorInfo != null && endorInfo.getSourceBillId() != null && !endorInfo.isIsCancelDraft() && ecdsApplyBillStatus == ApplyBillStatusEnum.RECEIVE_031_OK && (draftInfo = (iDraftGuaranteeRequestBill = DraftGuaranteeRequestBillFactory.getLocalInstance((Context)ctx)).getDraftGuaranteeRequestBillInfo((IObjectPK)new ObjectUuidPK(endorInfo.getSourceBillId()))) != null && (registerType = new DraftRegisterBillInfo().getBOSType()).equals((Object)(bosType = BOSUuid.read((String)draftInfo.getSourceBillId()).getType()))) {
            IDraftRegisterBill iDraftRegisterBill = DraftRegisterBillFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection se = new SelectorItemCollection();
            se.add(new SelectorItemInfo("*"));
            se.add(new SelectorItemInfo("commercialDraft.*"));
            DraftRegisterBillInfo draftRegisterBillInfo = iDraftRegisterBill.getDraftRegisterBillInfo((IObjectPK)new ObjectUuidPK(draftInfo.getSourceBillId()), se);
            EntityViewInfo env = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)draftRegisterBillInfo.getCommercialDraft().getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("formerOrgCode", (Object)draftRegisterBillInfo.getCommercialDraft().getDrawerOrgCode(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("draftBizType", (Object)DraftBizTypeEnum.BAOZHENG, CompareType.EQUALS));
            env.setFilter(filter);
            CommercialDraftBackSideEntryCollection entryColl = CommercialDraftBackSideEntryFactory.getLocalInstance((Context)ctx).getCommercialDraftBackSideEntryCollection(env);
            if (entryColl != null && entryColl.size() == 1) {
                SelectorItemCollection selColl = new SelectorItemCollection();
                selColl.add(new SelectorItemInfo("assurersName"));
                selColl.add(new SelectorItemInfo("assurersBankNumber"));
                selColl.add(new SelectorItemInfo("assurersAccount"));
                selColl.add(new SelectorItemInfo("assurerAddress"));
                selColl.add(new SelectorItemInfo("assurDate"));
                draftRegisterBillInfo.setAssurersName(draftInfo.getAssurerName());
                draftRegisterBillInfo.setAssurersBankNumber(draftInfo.getAssurersBankNumber());
                draftRegisterBillInfo.setAssurersAccount(draftInfo.getAssurersAccount());
                draftRegisterBillInfo.setAssurerAddress(entryColl.get(0).getGuarnteeAddress());
                draftRegisterBillInfo.setAssurDate(entryColl.get(0).getDraftSignInDate());
                iDraftRegisterBill.updatePartial((CoreBaseInfo)draftRegisterBillInfo, selColl);
            }
        }
    }
}

