/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.edraf.EdrafException;
import com.kingdee.eas.fm.edraf.IOrgUnitCode;
import com.kingdee.eas.fm.edraf.OrgUnitCodeCollection;
import com.kingdee.eas.fm.edraf.OrgUnitCodeFactory;
import com.kingdee.eas.fm.edraf.OrgUnitCodeInfo;
import com.kingdee.eas.fm.edraf.app.AbstractOrgUnitCodeControllerBean;
import com.kingdee.eas.fm.edrafent.CommercialDraftCollection;
import com.kingdee.eas.fm.edrafent.CommercialDraftFactory;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class OrgUnitCodeControllerBean
extends AbstractOrgUnitCodeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.OrgUnitCodeControllerBean");

    @Override
    protected void _cancel(Context ctx, Set idSet) throws BOSException, EASBizException {
        String sql = "update T_EDR_OrgUnitCode set FIsUsing= ? where " + FMHelper.buildIn((String)"FID", (Object[])idSet.toArray());
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{Boolean.FALSE});
    }

    @Override
    protected void _cancelCancel(Context ctx, Set idSet) throws BOSException, EASBizException {
        String sql = "update T_EDR_OrgUnitCode set FIsUsing= ? where " + FMHelper.buildIn((String)"FID", (Object[])idSet.toArray());
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{Boolean.TRUE});
    }

    @Override
    protected void _codeRemove(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isUsing", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        env.setFilter(filter);
        OrgUnitCodeCollection col = OrgUnitCodeFactory.getLocalInstance(ctx).getOrgUnitCodeCollection(env);
        HashSet<BOSUuid> set = new HashSet<BOSUuid>();
        if (col.size() > 0) {
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                OrgUnitCodeInfo info = col.get(i);
                if (this.checkRelation(ctx, info)) continue;
                set.add(info.getId());
            }
        }
        if (set.size() > 0) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            OrgUnitCodeFactory.getLocalInstance(ctx).delete(filter);
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IOrgUnitCode code = OrgUnitCodeFactory.getLocalInstance(ctx);
        OrgUnitCodeInfo info = (OrgUnitCodeInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgCode", (Object)info.getOrgCode(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId(), CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        if (code.exists(filter)) {
            throw new EdrafException(EdrafException.CODEERROR);
        }
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IOrgUnitCode icode = OrgUnitCodeFactory.getLocalInstance(ctx);
        OrgUnitCodeInfo info = (OrgUnitCodeInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgCode", (Object)info.getOrgCode(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId(), CompareType.EQUALS));
        filter.setMaskString("#0 and (#1 or #2)");
        if (icode.exists(filter)) {
            throw new EdrafException(EdrafException.CODEERROR);
        }
        super._update(ctx, pk, model);
    }

    private boolean checkRelation(Context ctx, OrgUnitCodeInfo info) throws BOSException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("drawerOrgCode", (Object)info.getOrgCode(), CompareType.EQUALS));
        env.setFilter(filter);
        CommercialDraftCollection commInfo = CommercialDraftFactory.getLocalInstance((Context)ctx).getCommercialDraftCollection(env);
        return commInfo.size() > 0;
    }
}

