/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.ecore.ActionCancelBillInfo;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.RecourseNotificationBillInfo;
import com.kingdee.eas.fm.ecore.RecourseReasonEnum;
import com.kingdee.eas.fm.ecore.RecourseTypeEnum;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.EdrafException;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.RecourseApplyBillFactory;
import com.kingdee.eas.fm.edraf.RecourseApplyBillInfo;
import com.kingdee.eas.fm.edraf.app.AbstractRecourseApplyBillControllerBean;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftRecourseBillFactory;
import com.kingdee.eas.fm.edrafent.DraftRecourseBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillFactory;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RecourseApplyBillControllerBean
extends AbstractRecourseApplyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.RecourseApplyBillControllerBean");

    @Override
    public void checkDraftApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RecourseApplyBillInfo billInfo = (RecourseApplyBillInfo)model;
        if (billInfo.isIsCancelDraft() && billInfo.getEndECDSState() != ECDSBillStatusEnum.JFZSDQC && billInfo.getEndECDSState() != ECDSBillStatusEnum.FJFZSDQC) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"58_RecourseApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (billInfo.getOperateState() != FCOperateStateEnum.save && billInfo.getCommunicationStatus() != ECDSCommunicationStatusEnum.SUBMIT_FAIL) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"1_AcceptanceApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RecourseApplyBillInfo info = (RecourseApplyBillInfo)model;
        RecourseNotificationBillInfo recourseInfo = new RecourseNotificationBillInfo();
        recourseInfo.setRecourseType(info.getRecourseType().getValue().equals("RT00") ? RecourseTypeEnum.RT00 : RecourseTypeEnum.RT01);
        recourseInfo.setRecourseData(info.getApplyDate());
        recourseInfo.setRecourseAmount(info.getRecourseAmt());
        recourseInfo.setRecourseCode(info.getRecourseReason().getValue().equals("RC00") ? RecourseReasonEnum.RC00 : RecourseReasonEnum.RC01);
        recourseInfo.setRecourseRemark(info.getRemark());
        recourseInfo.setRecourseName(info.getRecourserName().getName());
        recourseInfo.setRecourseBizCode(info.getRecourseOrgCode());
        recourseInfo.setRecourseAccout(info.getRecourseAccount().getBankAccountNumber());
        recourseInfo.setRecourseBank(info.getRecourseBankNum().getNumber());
        recourseInfo.setByRecName(info.getByRecourseName());
        recourseInfo.setByRecCode(info.getByRecourOrgCode());
        recourseInfo.setByRecAccout(info.getByRecourseAccou());
        recourseInfo.setByRecBank(info.getByRecouBankNum());
        recourseInfo.setDraftNumber(info.getCommercialDraft().getDraftNumber());
        recourseInfo.setDraftAmount(info.getCommercialDraft().getDraftAmount());
        recourseInfo.setSourceBillId(info.getId().toString());
        recourseInfo.setRecoursElecSign(EdrafUtil.getSignatureByBillId(ctx, info.getSourceBillId(), info.getApplyCompany().getId().toString()));
        recourseInfo.setBizPromoterOrgCode(info.getRecourseOrgCode());
        recourseInfo.setBizSerialNumber(info.getBizCode());
        return recourseInfo;
    }

    @Override
    public DraftApplyBillBaseCollection getBillCollection(Context ctx, Set idSet, SelectorItemCollection sic) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)FCOperateStateEnum.save, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_READY, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.PROCESS_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("returnOpinion", null, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or ((#3 or #4) and #5))");
        env.setSelector(sic);
        env.setFilter(filter);
        DraftApplyBillBaseCollection coll = RecourseApplyBillFactory.getLocalInstance(ctx).getDraftApplyBillBaseCollection(env);
        if (coll == null || coll.size() == 0) {
            throw new EdrafException(EdrafException.SUBMIT_ERROR);
        }
        return coll;
    }

    @Override
    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("recourseAccount.*"));
        sic.add(new SelectorItemInfo("recourseBankNum.*"));
        sic.add(new SelectorItemInfo("recourserName.name"));
        return sic;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.ZSTZ;
    }

    @Override
    protected void _rewriteECDSMess(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
        DraftRecourseBillInfo draftInfo;
        RecourseApplyBillInfo endorInfo = this.getRecourseApplyBillInfo(ctx, (IObjectPK)new ObjectUuidPK(sourceBillId));
        if (endorInfo != null && endorInfo.getSourceBillId() != null && endorInfo.isIsCancelDraft() && ecdsApplyBillStatus == ApplyBillStatusEnum.RECEIVE_033_OK && (draftInfo = DraftRecourseBillFactory.getLocalInstance((Context)ctx).getDraftRecourseBillInfo((IObjectPK)new ObjectUuidPK(endorInfo.getSourceBillId()))) != null && draftInfo.getSourceBillId() != null && draftInfo.isIsCancelDraft()) {
            DraftStockBillInfo stockInfo = DraftStockBillFactory.getLocalInstance((Context)ctx).getDraftStockBillInfo((IObjectPK)new ObjectUuidPK(draftInfo.getSourceBillId()));
            SelectorItemCollection selCollection = new SelectorItemCollection();
            selCollection.add(new SelectorItemInfo("recourse"));
            stockInfo.setRecourse(false);
            DraftStockBillFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)stockInfo, selCollection);
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSCancelBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RecourseApplyBillInfo info = (RecourseApplyBillInfo)model;
        ActionCancelBillInfo cancelBillInfo = new ActionCancelBillInfo();
        CommercialDraftInfo draftInfo = info.getCommercialDraft();
        cancelBillInfo.setDraftNumber(draftInfo.getDraftNumber());
        cancelBillInfo.setDraftAmount(draftInfo.getDraftAmount());
        String eletricSign = "";
        if (info.getApplyCompany() != null) {
            eletricSign = EdrafUtil.getSignatureByBillId(ctx, info.getSourceBillId(), info.getApplyCompany().getId().toString());
        }
        cancelBillInfo.setEletricSign(eletricSign);
        cancelBillInfo.setCancelOrgCode(info.getRecourseOrgCode());
        cancelBillInfo.setCancelAccount(info.getRecourseAccount().getBankAccountNumber());
        cancelBillInfo.setCancelBank(info.getRecourseBankNum().getNumber());
        cancelBillInfo.setBizPromoterOrgCode(info.getRecourseOrgCode());
        return cancelBillInfo;
    }
}

