/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.FMBillBaseInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.PaperDraftBillBaseInfo;
import com.kingdee.eas.fm.ecore.RegisterInformationQueryBillInfo;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.edraf.DraftTypeEnum;
import com.kingdee.eas.fm.edraf.MutualResultEnum;
import com.kingdee.eas.fm.edraf.RegisterInformationOperateStateEnum;
import com.kingdee.eas.fm.edraf.RegisterInformationsInfo;
import com.kingdee.eas.fm.edraf.app.AbstractRegisterInformationsControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import org.apache.log4j.Logger;

public class RegisterInformationsControllerBean
extends AbstractRegisterInformationsControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.RegisterInformationsControllerBean");

    @Override
    protected void initInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMBillBaseInfo info = (FMBillBaseInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
    }

    @Override
    protected void checkBeforeAddNew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RegisterInformationsInfo info = (RegisterInformationsInfo)model;
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this._checkNumberDup(ctx, (IObjectValue)info);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RegisterInformationsInfo info = (RegisterInformationsInfo)model;
        info.setMutualResult(MutualResultEnum.ARRANGEDSUMBIT);
        info.setOperateState(RegisterInformationOperateStateEnum.SAVE);
        return super._addnew(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    @Override
    public boolean checkDraftApplyBill(IObjectValue model) {
        RegisterInformationsInfo billInfo = (RegisterInformationsInfo)model;
        MutualResultEnum result = billInfo.getMutualResult();
        return result != null && (result.equals((Object)MutualResultEnum.ARRANGEDSUMBIT) || result.equals((Object)MutualResultEnum.SUMBITFAIL));
    }

    @Override
    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    @Override
    public PaperDraftBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RegisterInformationsInfo regInfo = (RegisterInformationsInfo)model;
        RegisterInformationQueryBillInfo billInfo = new RegisterInformationQueryBillInfo();
        if (regInfo.getPaperType() != null) {
            billInfo.setDraftType(regInfo.getPaperType().equals((Object)DraftTypeEnum.DC01) ? com.kingdee.eas.fm.ecore.DraftTypeEnum.AC01 : com.kingdee.eas.fm.ecore.DraftTypeEnum.AC02);
        }
        billInfo.setDraftNumber(regInfo.getPaperNumber());
        billInfo.setDraftAmount(regInfo.getBillAmount());
        billInfo.setIssueDate(regInfo.getPaperOutData());
        billInfo.setDueDate(regInfo.getDueDate());
        billInfo.setAcceptorBank(regInfo.getAcceptLine());
        billInfo.setId(regInfo.getId());
        billInfo.setBizPromoterOrgCode(regInfo.getDrawerOrgCode());
        billInfo.setBizSerialNumber(regInfo.getBizCode());
        CompanyOrgUnitInfo company = regInfo.getSelectCompany();
        if (company != null) {
            String companyId = company.getId().toString();
            EntityViewInfo viewinfo = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("relatedCompany", (Object)companyId));
            viewinfo.setFilter(fi);
            BankCollection accountBankCol = BankFactory.getLocalInstance((Context)ctx).getBankCollection(viewinfo);
            if (accountBankCol != null && accountBankCol.size() > 0) {
                BEBankInfo bebankInfo = BEBankFactory.getLocalInstance((Context)ctx).getBEBankInfo((IObjectPK)new ObjectStringPK(accountBankCol.get(0).getAccountBank().getId().toString()));
                billInfo.setQryBkAcct(bebankInfo.getNumber());
            }
        }
        return billInfo;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.ZPDJXXCX;
    }

    @Override
    public void delPaperDraftBillBase(Context ctx, String sourceIDList, String destobjecIDs, String copyBillIDs) throws BOSException, EASBizException {
    }

    @Override
    public void setSourceBill(Context ctx, String sourceBillId, String opinion) throws BOSException, EASBizException {
    }

    @Override
    public void rewriteApplyBill(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
    }
}

