/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.PaperDraftBillBaseInfo;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.SettlementRegisterBillInfo;
import com.kingdee.eas.fm.edraf.AbstractPaperDraftBillBaseInfo;
import com.kingdee.eas.fm.edraf.AcceptanceRegisterBillFactory;
import com.kingdee.eas.fm.edraf.AcceptanceRegisterBillInfo;
import com.kingdee.eas.fm.edraf.DraftTypeEnum;
import com.kingdee.eas.fm.edraf.DrawTypeEnum;
import com.kingdee.eas.fm.edraf.IAcceptanceRegisterBill;
import com.kingdee.eas.fm.edraf.MutualResultEnum;
import com.kingdee.eas.fm.edraf.SquareRegisterBillInfo;
import com.kingdee.eas.fm.edraf.app.AbstractSquareRegisterBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import org.apache.log4j.Logger;

public class SquareRegisterBillControllerBean
extends AbstractSquareRegisterBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.SquareApplyBillControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SquareRegisterBillInfo billInfo = (SquareRegisterBillInfo)model;
        billInfo.setFailCause("");
        String sourceBillId = billInfo.getSourceBillId();
        AbstractPaperDraftBillBaseInfo acceptanceBillInfo = null;
        if (sourceBillId != null && !sourceBillId.equals("")) {
            acceptanceBillInfo = AcceptanceRegisterBillFactory.getLocalInstance(ctx).getAcceptanceRegisterBillInfo((IObjectPK)new ObjectStringPK(sourceBillId));
        }
        if (billInfo.getRegisterCompany() == null) {
            billInfo.setRegisterCompany(acceptanceBillInfo == null ? null : acceptanceBillInfo.getRegisterCompany());
        }
        return super._addnew(ctx, (IObjectValue)billInfo);
    }

    @Override
    public boolean checkDraftApplyBill(IObjectValue model) {
        SquareRegisterBillInfo billInfo = (SquareRegisterBillInfo)model;
        MutualResultEnum result = billInfo.getMutualResult();
        return result != null && (result.equals((Object)MutualResultEnum.ARRANGEDSUMBIT) || result.equals((Object)MutualResultEnum.SUMBITFAIL));
    }

    @Override
    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.ZPJQDJ;
    }

    @Override
    public PaperDraftBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SquareRegisterBillInfo regInfo = (SquareRegisterBillInfo)model;
        SettlementRegisterBillInfo billInfo = new SettlementRegisterBillInfo();
        if (regInfo.getPaperType() != null) {
            billInfo.setDraftType(regInfo.getPaperType().equals((Object)DraftTypeEnum.DC01) ? com.kingdee.eas.fm.ecore.DraftTypeEnum.AC01 : com.kingdee.eas.fm.ecore.DraftTypeEnum.AC02);
        }
        billInfo.setDraftNumber(regInfo.getPaperNumber());
        billInfo.setDraftAmount(regInfo.getBillAmount());
        billInfo.setIssueDate(regInfo.getPaperOutData());
        billInfo.setDueDate(regInfo.getDraftData());
        billInfo.setRemark(regInfo.getRemark());
        billInfo.setPayDate(regInfo.getPaymentDate());
        billInfo.setAcceptorName(regInfo.getAccepter());
        billInfo.setAcceptorBank(regInfo.getAcceptLine());
        billInfo.setPayerName(regInfo.getLastBearerName());
        billInfo.setId(regInfo.getId());
        billInfo.setBizPromoterOrgCode(regInfo.getDrawerOrgCode());
        billInfo.setBizSerialNumber(regInfo.getBizCode());
        return billInfo;
    }

    @Override
    public void delPaperDraftBillBase(Context ctx, String sourceIDList, String destobjecIDs, String copyBillIDs) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        StringBuffer copySql = new StringBuffer();
        StringBuffer destSql = new StringBuffer();
        sql.append("update ").append("T_EDR_AcceptanceRegisterBill").append(" set FDrawType = 0 where fid in ").append(sourceIDList.toString()).append("");
        copySql.append("update ").append("T_EDR_SquareRegisterBill").append(" set FManipulateState = '02' where fid in").append(copyBillIDs.toString()).append("");
        destSql.append("delete ").append("T_EDR_SquareRegisterBill").append(" where fid in ").append(destobjecIDs.toString()).append("");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        DbUtil.execute((Context)ctx, (String)copySql.toString());
        DbUtil.execute((Context)ctx, (String)destSql.toString());
    }

    @Override
    public void setSourceBill(Context ctx, String sourceBillId, String opinion) throws BOSException, EASBizException {
        IAcceptanceRegisterBill iAcceptanceRegisterBill = AcceptanceRegisterBillFactory.getLocalInstance(ctx);
        AcceptanceRegisterBillInfo billInfo = iAcceptanceRegisterBill.getAcceptanceRegisterBillInfo((IObjectPK)new ObjectStringPK(sourceBillId));
        billInfo.setDrawType(DrawTypeEnum.NOT);
        String returnOpinion = billInfo.getReturnOption();
        returnOpinion = !StringUtils.isEmpty((String)returnOpinion) && !returnOpinion.equals("") ? returnOpinion + opinion : opinion;
        String str = returnOpinion;
        if (returnOpinion.length() > 256) {
            str = returnOpinion.substring(0, 255);
        }
        billInfo.setReturnOption(str);
        iAcceptanceRegisterBill.save((CoreBaseInfo)billInfo);
    }

    @Override
    public void rewriteApplyBill(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
    }
}

