/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.ActionCancelBillInfo;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.BanEndorsementMarkEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.RepurchaseDiscountTurnRedeemReqInfo;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.SettlementMarkEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.IRpdTransDistApplyBill;
import com.kingdee.eas.fm.edraf.RpdTransDistApplyBillCollection;
import com.kingdee.eas.fm.edraf.RpdTransDistApplyBillFactory;
import com.kingdee.eas.fm.edraf.RpdTransDistApplyBillInfo;
import com.kingdee.eas.fm.edraf.app.AbstractRpdTransDistApplyBillControllerBean;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftKindEnum;
import com.kingdee.eas.fm.edrafent.DraftSignUpFactory;
import com.kingdee.eas.fm.edrafent.DraftSignUpInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillCollection;
import com.kingdee.eas.fm.edrafent.DraftStockBillFactory;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillOperateEnum;
import com.kingdee.eas.fm.edrafent.IDraftSignUp;
import com.kingdee.eas.fm.edrafent.IDraftStockBill;
import com.kingdee.eas.fm.edrafent.util.EdrafentUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RpdTransDistApplyBillControllerBean
extends AbstractRpdTransDistApplyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.RpdTransDistApplyBillControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RpdTransDistApplyBillInfo billInfo = (RpdTransDistApplyBillInfo)model;
        if (billInfo.getOperateState().equals((Object)FCOperateStateEnum.save)) {
            billInfo.setOperateState(FCOperateStateEnum.SUBMIT1);
        }
        return super._submit(ctx, (IObjectValue)billInfo);
    }

    @Override
    protected void _submit(Context ctx, Set set) throws BOSException, EASBizException {
        List ids = FMHelper.set2List((Set)set);
        if (ids != null && ids.size() == 1) {
            IRpdTransDistApplyBill iTransDistApplyBill = RpdTransDistApplyBillFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("operateState");
            RpdTransDistApplyBillInfo info = iTransDistApplyBill.getRpdTransDistApplyBillInfo((IObjectPK)new ObjectUuidPK(ids.get(0).toString()), sic);
            if (info.getOperateState() == FCOperateStateEnum.save) {
                info.setOperateState(FCOperateStateEnum.SUBMIT1);
                iTransDistApplyBill.updatePartial((CoreBaseInfo)info, sic);
                super.submit(ctx, (CoreBaseInfo)info);
            } else {
                this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"74_RpdTransDistApplyBillControllerBean", (Locale)ctx.getLocale()));
            }
        } else if (ids != null && ids.size() > 1) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("operateState");
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
            view.setFilter(filter);
            IRpdTransDistApplyBill iTransDistApplyBill = RpdTransDistApplyBillFactory.getLocalInstance(ctx);
            RpdTransDistApplyBillCollection coll = iTransDistApplyBill.getRpdTransDistApplyBillCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                if (coll.get(i).getOperateState() != FCOperateStateEnum.save) continue;
                coll.get(i).setOperateState(FCOperateStateEnum.SUBMIT1);
                iTransDistApplyBill.updatePartial((CoreBaseInfo)coll.get(i), sic);
                super.submit(ctx, (CoreBaseInfo)coll.get(i));
            }
        }
    }

    @Override
    protected void _audit(Context ctx, Set set) throws BOSException, EASBizException {
        List ids = FMHelper.set2List((Set)set);
        if (ids != null && ids.size() == 1) {
            IRpdTransDistApplyBill iTransDistApplyBill = RpdTransDistApplyBillFactory.getLocalInstance(ctx);
            RpdTransDistApplyBillInfo info = iTransDistApplyBill.getRpdTransDistApplyBillInfo((IObjectPK)new ObjectUuidPK(ids.get(0).toString()));
            if (info.getOperateState() == FCOperateStateEnum.SUBMIT1) {
                this._audit4WF(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
            } else {
                this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"75_RpdTransDistApplyBillControllerBean", (Locale)ctx.getLocale()));
            }
        } else if (ids != null && ids.size() > 1) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
            view.setFilter(filter);
            IRpdTransDistApplyBill iRpdTransDistApplyBill = RpdTransDistApplyBillFactory.getLocalInstance(ctx);
            RpdTransDistApplyBillCollection coll = iRpdTransDistApplyBill.getRpdTransDistApplyBillCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                if (coll.get(i).getOperateState() != FCOperateStateEnum.SUBMIT1) continue;
                this._audit4WF(ctx, (IObjectPK)new ObjectUuidPK(coll.get(i).getId().toString()), (IObjectValue)coll.get(i));
            }
        }
    }

    @Override
    protected void _unAudit(Context ctx, Set set) throws BOSException, EASBizException {
        List ids = FMHelper.set2List((Set)set);
        if (ids != null && ids.size() == 1) {
            IRpdTransDistApplyBill iRpdTransDistApplyBill = RpdTransDistApplyBillFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("operateState");
            RpdTransDistApplyBillInfo info = iRpdTransDistApplyBill.getRpdTransDistApplyBillInfo((IObjectPK)new ObjectUuidPK(ids.get(0).toString()), sic);
            if (info.getOperateState() == FCOperateStateEnum.AUDITED) {
                info.setOperateState(FCOperateStateEnum.save);
                iRpdTransDistApplyBill.updatePartial((CoreBaseInfo)info, sic);
                this.unAudit4WF(ctx, info);
            } else {
                this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"61_ReDiscountApplyBillControllerBean", (Locale)ctx.getLocale()));
            }
        } else if (ids != null && ids.size() > 1) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("operateState");
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
            view.setFilter(filter);
            IRpdTransDistApplyBill iRpdTransDistApplyBill = RpdTransDistApplyBillFactory.getLocalInstance(ctx);
            RpdTransDistApplyBillCollection coll = iRpdTransDistApplyBill.getRpdTransDistApplyBillCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                if (coll.get(i).getOperateState() != FCOperateStateEnum.AUDITED) continue;
                coll.get(i).setOperateState(FCOperateStateEnum.save);
                iRpdTransDistApplyBill.updatePartial((CoreBaseInfo)coll.get(i), sic);
                this.unAudit4WF(ctx, coll.get(i));
            }
        }
    }

    protected void _financeCompany(Context ctx, Set set) throws BOSException, EASBizException {
    }

    protected void _bankCorporate(Context ctx, Set set) throws BOSException, EASBizException {
    }

    @Override
    protected void _draftCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IRpdTransDistApplyBill iRpdTransDistApplyBill = RpdTransDistApplyBillFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("operateState");
        sic.add("commercialDraft.draftECDSStatus");
        sic.add("communicationStatus");
        RpdTransDistApplyBillInfo info = iRpdTransDistApplyBill.getRpdTransDistApplyBillInfo(pk, sic);
        if (this.checkDraftCancel(info)) {
            info.setOperateState(FCOperateStateEnum.CANCEL);
            iRpdTransDistApplyBill.updatePartial((CoreBaseInfo)info, sic);
            RpdTransDistApplyBillInfo info2 = iRpdTransDistApplyBill.getRpdTransDistApplyBillInfo(pk);
            info2.setId(null);
            info2.setNumber(null);
            info2.setDraftSourceBill(info.getId().toString());
            info2.setBizCode(null);
            info2.setOperateState(FCOperateStateEnum.save);
            info2.setIsCancelDraft(true);
            info2.setSubmitDate(null);
            info2.setSubmitter(null);
            info2.setCommunicationStatus(ECDSCommunicationStatusEnum.SUBMIT_READY);
            IObjectPK info2PK = iRpdTransDistApplyBill.addnew((CoreBaseInfo)info2);
            EdrafentUtil.saveBotpRelation((Context)ctx, (CoreBillBaseInfo)new DraftStockBillInfo(), (CoreBillBaseInfo)info2, (String)info2.getSourceBillId(), (String)info2PK.toString());
        } else {
            this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"76_RpdTransDistApplyBillControllerBean", (Locale)ctx.getLocale()));
        }
    }

    private boolean checkDraftCancel(RpdTransDistApplyBillInfo info) {
        ECDSBillStatusEnum draftECDSStatus = null;
        if (info == null || info.getCommercialDraft() == null || info.getCommercialDraft().getDraftECDSStatus() == null) {
            return false;
        }
        draftECDSStatus = info.getCommercialDraft().getDraftECDSStatus();
        return draftECDSStatus != null && draftECDSStatus == ECDSBillStatusEnum.HGSZHTXSHDQS && !info.isIsCancelDraft() && info.getOperateState() != FCOperateStateEnum.CANCEL;
    }

    private void throwBizException(String msg) throws EASBizException {
        NumericExceptionSubItem item = new NumericExceptionSubItem("{0}", "{0}");
        EASBizException exec = new EASBizException(item, (Object[])new String[]{msg.toString()});
        throw exec;
    }

    @Override
    protected boolean _checkStockBill(Context ctx, List ids) throws BOSException, EASBizException {
        DraftKindEnum dke = null;
        AccountBankInfo holderAccount = null;
        BEBankInfo holderBankNumber = null;
        EntityViewInfo view = new EntityViewInfo();
        CompanyOrgUnitInfo replyName = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)ids), CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("commercialDraft.*");
        view.setSelector(sic);
        DraftStockBillCollection stockColl = DraftStockBillFactory.getLocalInstance((Context)ctx).getDraftStockBillCollection(view);
        if (stockColl == null) {
            return false;
        }
        DraftStockBillInfo stockInfo = null;
        DraftSignUpInfo signUpInfo = null;
        IDraftSignUp iDraftSignUp = DraftSignUpFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < stockColl.size(); ++i) {
            stockInfo = stockColl.get(i);
            if (stockInfo == null) {
                return false;
            }
            if (!this.check1(stockInfo)) {
                return false;
            }
            if (!this.check2(stockInfo)) {
                return false;
            }
            if (!this.check3(stockInfo, dke)) {
                return false;
            }
            if (stockInfo.getSourceBillId() == null) {
                return false;
            }
            signUpInfo = iDraftSignUp.getDraftSignUpInfo((IObjectPK)new ObjectUuidPK(stockInfo.getSourceBillId().toString()));
            if (signUpInfo == null || signUpInfo.getReplyName() == null) {
                return false;
            }
            if (replyName == null) {
                replyName = signUpInfo.getReplyName();
            } else if (!replyName.equals((Object)signUpInfo.getReplyName())) {
                return false;
            }
            if (this.check5(stockInfo, holderAccount, holderBankNumber)) continue;
            return false;
        }
        return true;
    }

    private boolean check5(DraftStockBillInfo stockInfo, AccountBankInfo holderAccount, BEBankInfo holderBankNumber) {
        boolean isPassHolderAccount = false;
        boolean isPassHolderBankNumber = false;
        if (holderAccount == null) {
            isPassHolderAccount = true;
        } else if (holderAccount == stockInfo.getHolderAccount()) {
            isPassHolderAccount = true;
        }
        if (holderBankNumber == null) {
            isPassHolderBankNumber = true;
        } else if (holderBankNumber == stockInfo.getHolderBankNumber()) {
            isPassHolderBankNumber = true;
        }
        return isPassHolderAccount && isPassHolderBankNumber;
    }

    private boolean check4(DraftStockBillInfo stockInfo) {
        return true;
    }

    private boolean check1(DraftStockBillInfo info) {
        return info.getDraftStockOperate() == DraftStockBillOperateEnum.REGISTER;
    }

    private boolean check2(DraftStockBillInfo stockInfo) {
        CommercialDraftInfo comm = stockInfo.getCommercialDraft();
        if (comm == null) {
            return false;
        }
        return comm.getDraftECDSStatus() == ECDSBillStatusEnum.HGSZHTXYZSHKFR || comm.getDraftECDSStatus() == null || comm.getDraftECDSStatus() == ECDSBillStatusEnum.NoBill;
    }

    private boolean check3(DraftStockBillInfo stockInfo, DraftKindEnum dke) {
        if (dke == null) {
            return true;
        }
        return dke == stockInfo.getDraftKind();
    }

    protected void _deleteBatchData(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        HashSet<IObjectPK> ids = new HashSet<IObjectPK>();
        for (int i = 0; i < pkArray.length; ++i) {
            ids.add(pkArray[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        view.setFilter(filter);
        IRpdTransDistApplyBill iRpdTransDistApplyBill = RpdTransDistApplyBillFactory.getLocalInstance(ctx);
        RpdTransDistApplyBillCollection coll = iRpdTransDistApplyBill.getRpdTransDistApplyBillCollection(view);
        RpdTransDistApplyBillInfo info = null;
        LinkedList<String> newIDS = new LinkedList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (info.getOperateState() == FCOperateStateEnum.save || info.getOperateState() == FCOperateStateEnum.SUBMIT1) {
                SelectorItemCollection sic;
                newIDS.add(info.getId().toString());
                BOTRelationFactory.getLocalInstance((Context)ctx).removeRelationByDestObjId(info.getId().toString(), "2B1A7202");
                if (info.isIsCancelDraft()) {
                    sic = new SelectorItemCollection();
                    sic.add("id");
                    sic.add("OperateState");
                    RpdTransDistApplyBillInfo applyBillInfo = iRpdTransDistApplyBill.getRpdTransDistApplyBillInfo((IObjectPK)new ObjectUuidPK(info.getDraftSourceBill()), sic);
                    applyBillInfo.setOperateState(FCOperateStateEnum.submit);
                    iRpdTransDistApplyBill.updatePartial((CoreBaseInfo)applyBillInfo, sic);
                    continue;
                }
                sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("draftStockOperate");
                IDraftStockBill iDraftStockBill = DraftStockBillFactory.getLocalInstance((Context)ctx);
                DraftStockBillInfo stockInfo = iDraftStockBill.getDraftStockBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()), sic);
                stockInfo.setDraftStockOperate(DraftStockBillOperateEnum.REGISTER);
                iDraftStockBill.updatePartial((CoreBaseInfo)stockInfo, sic);
                continue;
            }
            if (coll.size() != 1) continue;
            this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"77_RpdTransDistApplyBillControllerBean", (Locale)ctx.getLocale()));
        }
        IObjectPK[] newPKS = new IObjectPK[newIDS.size()];
        for (int i = 0; i < newIDS.size(); ++i) {
            newPKS[i] = new ObjectUuidPK(newIDS.get(i).toString());
        }
        super._deleteBatchData(ctx, newPKS);
    }

    @Override
    public void checkDraftApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RpdTransDistApplyBillInfo info = (RpdTransDistApplyBillInfo)model;
        if (info.isIsCancelDraft() && info.getEndECDSState() != ECDSBillStatusEnum.HGSZHTXSHDQS) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"78_RpdTransDistApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (info.getOperateState() != FCOperateStateEnum.AUDITED && info.getCommunicationStatus() != ECDSCommunicationStatusEnum.SUBMIT_FAIL) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"1_AcceptanceApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RpdTransDistApplyBillInfo info = (RpdTransDistApplyBillInfo)model;
        RepurchaseDiscountTurnRedeemReqInfo coreInfo = new RepurchaseDiscountTurnRedeemReqInfo();
        coreInfo.setDraftNumber(info.getCommercialDraft().getDraftNumber());
        coreInfo.setDraftAmount(info.getCommercialDraft().getDraftAmount());
        coreInfo.setReqDate(info.getTransDistReqDate());
        coreInfo.setRedeemInterRate(info.getTransDistBackRate() == null ? null : info.getTransDistBackRate().multiply(new BigDecimal("0.01")).setScale(2, 0));
        coreInfo.setRedeemPaidAmt(info.getTransDistBackRealAmount().setScale(6, 4));
        coreInfo.setBanEndorsement(info.isIsAttorn() ? BanEndorsementMarkEnum.EM00 : BanEndorsementMarkEnum.EM01);
        coreInfo.setSettlementMark(info.isIsOnLine() ? SettlementMarkEnum.SM00 : SettlementMarkEnum.SM01);
        coreInfo.setBatch(info.getBatchNumber() == null ? null : info.getBatchNumber().toString());
        coreInfo.setRemark(info.getDistOutRemark());
        coreInfo.setDrawerOrgCode(info.getOrgCode());
        coreInfo.setDrawerElecSign("0");
        coreInfo.setDrawerAccount(info.getDistInAccount().getBankAccountNumber());
        coreInfo.setDrawerBank(info.getDistInBankNum());
        coreInfo.setBizPromoterOrgCode(info.getOrgCode());
        coreInfo.setBizSerialNumber(info.getBizCode());
        return coreInfo;
    }

    @Override
    public ApplyBillBaseInfo convertToECDSCancelBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RpdTransDistApplyBillInfo rpdTransDistApplyBillInfo = (RpdTransDistApplyBillInfo)model;
        ActionCancelBillInfo cancelBillInfo = new ActionCancelBillInfo();
        CommercialDraftInfo draftInfo = rpdTransDistApplyBillInfo.getCommercialDraft();
        cancelBillInfo.setDraftNumber(draftInfo.getDraftNumber());
        cancelBillInfo.setDraftAmount(draftInfo.getDraftAmount());
        cancelBillInfo.setEletricSign("0");
        cancelBillInfo.setCancelOrgCode(rpdTransDistApplyBillInfo.getOrgCode());
        cancelBillInfo.setCancelAccount(rpdTransDistApplyBillInfo.getDistInAccount().getBankAccountNumber());
        cancelBillInfo.setCancelBank(rpdTransDistApplyBillInfo.getDistInBankNum());
        cancelBillInfo.setBizPromoterOrgCode(rpdTransDistApplyBillInfo.getOrgCode());
        return cancelBillInfo;
    }

    @Override
    public DraftApplyBillBaseCollection getBillCollection(Context ctx, Set idSet, SelectorItemCollection sic) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        env.setSelector(sic);
        env.setFilter(filter);
        DraftApplyBillBaseCollection rpdTransColl = RpdTransDistApplyBillFactory.getLocalInstance(ctx).getDraftApplyBillBaseCollection(env);
        return rpdTransColl;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.HGSZTXSHSQ_ZHUAN;
    }

    @Override
    protected void _rewriteECDSMess(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
        RpdTransDistApplyBillInfo billInfo = RpdTransDistApplyBillFactory.getLocalInstance(ctx).getRpdTransDistApplyBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
        if (billInfo.isIsCancelDraft()) {
            String stockId;
            String billId;
            String sql = null;
            int opstate = 0;
            if (billInfo.getCommunicationStatus().equals((Object)ECDSCommunicationStatusEnum.PROCESS_FAIL) && (billId = billInfo.getDraftSourceBill()) != null) {
                sql = "update T_EDR_RpdTransDistApplyBill set FOperateState=? where FID='" + billId + "'";
                opstate = 1;
            }
            if (billInfo.getCommunicationStatus().equals((Object)ECDSCommunicationStatusEnum.PROCESS_SUCCESS) && (stockId = billInfo.getSourceBillId()) != null) {
                sql = "UPDATE T_EDT_DraftStockBill SET FDraftStockOperate=?,FTurnDiscount=0 where FID='" + stockId + "'";
                opstate = 0;
            }
            if (sql != null) {
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(opstate)});
            }
        }
        if (!(ecdsApplyBillStatus != ApplyBillStatusEnum.RECEIVE_033_ERROR && ecdsApplyBillStatus != ApplyBillStatusEnum.RECEIVE_031_BAN || sourceBillId == null || sourceBillId.equals(""))) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("sourceBillID");
            view.setSelector(sic);
            RpdTransDistApplyBillInfo rpdtransDistApplyBillInfo = RpdTransDistApplyBillFactory.getLocalInstance(ctx).getRpdTransDistApplyBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId), sic);
            String stockBillID = rpdtransDistApplyBillInfo.getSourceBillId().toString();
            if (stockBillID == null || stockBillID.equals("")) {
                // empty if block
            }
            SelectorItemCollection sic1 = new SelectorItemCollection();
            sic1.add("id");
            sic1.add("draftStockOperate");
            IDraftStockBill iDraftStockBill = DraftStockBillFactory.getLocalInstance((Context)ctx);
            DraftStockBillInfo stockInfo = iDraftStockBill.getDraftStockBillInfo((IObjectPK)new ObjectUuidPK(rpdtransDistApplyBillInfo.getSourceBillId().toString()), sic1);
            stockInfo.setDraftStockOperate(DraftStockBillOperateEnum.REGISTER);
            iDraftStockBill.updatePartial((CoreBaseInfo)stockInfo, sic1);
        }
    }

    @Override
    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = super.getSelector();
        sic.add("distOutName.*");
        sic.add("distOutAccount.*");
        sic.add("distInName.*");
        sic.add("distInAccount.*");
        sic.add("inAccount.*");
        sic.add("company.*");
        return sic;
    }

    @Override
    protected void _registerAccount(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("endECDSState", (Object)"140006"));
        filter.getFilterItems().add(new FilterItemInfo("isTally", (Object)Boolean.FALSE));
        filter.setMaskString("#0 and #1 and #2");
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("commercialDraft.id");
        selectors.add("commercialDraft.number");
        selectors.add("commercialDraft.draftECDSStatus");
        selectors.add("commercialDraft.draftAmount");
        selectors.add("inAccount.id");
        selectors.add("inAccount.number");
        selectors.add("inAccount.name");
        selectors.add("inAccount.isBank");
        selectors.add("inAccount.isCash");
        selectors.add("inAccount.account.id");
        selectors.add("inAccount.account.number");
        selectors.add("inAccount.account.name");
        selectors.add("inAccount.currency.id");
        selectors.add("inAccount.currency.number");
        selectors.add("inAccount.currency.name");
        view.setSelector(selectors);
        view.setFilter(filter);
        IRpdTransDistApplyBill iRpdTransDistApplyBill = RpdTransDistApplyBillFactory.getLocalInstance(ctx);
        RpdTransDistApplyBillCollection coll = iRpdTransDistApplyBill.getRpdTransDistApplyBillCollection(view);
        if (coll == null || coll.size() == 0) {
            this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"79_RpdTransDistApplyBillControllerBean", (Locale)ctx.getLocale()));
        }
        Iterator it = coll.iterator();
        HashSet<BOSUuid> redSet = new HashSet<BOSUuid>();
        RpdTransDistApplyBillInfo info = null;
        while (it.hasNext()) {
            Date date;
            Date now;
            info = (RpdTransDistApplyBillInfo)it.next();
            redSet.add(info.getId());
            JournalInfo journalInfo = new JournalInfo();
            PeriodInfo peroid = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info.getCompany());
            Date bizDate = now = new Date();
            if (peroid != null && (date = peroid.getBeginDate()).compareTo(now) > 0) {
                bizDate = date;
            }
            journalInfo.setCompany(info.getCompany());
            journalInfo.setBizDate(bizDate);
            journalInfo.setBillNumber(info.getNumber());
            journalInfo.setBillId(info.getId().toString());
            journalInfo.setDebitAmount(info.getTransDistBackAmount());
            journalInfo.setCreateDate(bizDate);
            journalInfo.setType(JournalTypeEnum.BANK);
            journalInfo.setAccountBank(info.getInAccount());
            journalInfo.setAccountView(info.getInAccount().getAccount());
            journalInfo.setCurrency(info.getInAccount().getCurrency());
            journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
            journalInfo.setSource(JournalSourceEnum.BYBILL);
            journalInfo.setPeriod(peroid);
            journalInfo.setDescription(info.getDistOutRemark());
            JournalFactory.getLocalInstance((Context)ctx).addnew(journalInfo);
        }
        if (redSet == null || redSet.size() <= 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"79_RpdTransDistApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        String sql = "update T_EDR_RpdTransDistApplyBill set FIsTally=? where " + FMHelper.buildIn((String)"FID", (Object[])redSet.toArray());
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1)});
    }

    @Override
    protected void _unRegisterAccount(Context ctx, Set set) throws BOSException, EASBizException {
        Set idSet = set;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filters = filter.getFilterItems();
        filters.add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filters.add(new FilterItemInfo("istally", (Object)Boolean.TRUE));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        view.setSelector(selectors);
        view.setFilter(filter);
        RpdTransDistApplyBillCollection coll = RpdTransDistApplyBillFactory.getLocalInstance(ctx).getRpdTransDistApplyBillCollection(view);
        if (coll != null && coll.size() > 0) {
            HashSet<BOSUuid> redset = new HashSet<BOSUuid>();
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                redset.add(coll.get(i).getId());
            }
            if (redset != null && redset.size() > 0) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("billId", (Object)set, CompareType.INCLUDE));
                JournalFactory.getLocalInstance((Context)ctx).delete(filter);
                String sql = "update T_EDR_RpdTransDistApplyBill set FIsTally=? where " + FMHelper.buildIn((String)"FID", (Object[])redset.toArray());
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(0)});
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"80_RpdTransDistApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    protected void _submitToECDS(Context ctx, List idList) throws BOSException, EASBizException {
        List ids = idList;
        boolean isFitA = true;
        boolean isFitB = true;
        IRpdTransDistApplyBill iRpdTransDistApplyBill = RpdTransDistApplyBillFactory.getLocalInstance(ctx);
        if (ids != null && ids.size() == 1) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("draftKind");
            sic.add("operateState");
            sic.add("communicationStatus");
            RpdTransDistApplyBillInfo info = iRpdTransDistApplyBill.getRpdTransDistApplyBillInfo((IObjectPK)new ObjectUuidPK(ids.get(0).toString()), sic);
            isFitA = this.isFitA(info);
            isFitB = this.isFitB(info);
            if (isFitA && isFitB) {
                iRpdTransDistApplyBill.batchCommitECDS(FMHelper.list2Set((List)ids));
                info.setOperateState(FCOperateStateEnum.submit);
                iRpdTransDistApplyBill.updatePartial((CoreBaseInfo)info, sic);
            } else if (!isFitA && isFitB) {
                this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"81_RpdTransDistApplyBillControllerBean", (Locale)ctx.getLocale()));
            } else if (isFitA && !isFitB) {
                this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"82_RpdTransDistApplyBillControllerBean", (Locale)ctx.getLocale()));
            } else {
                this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"83_RpdTransDistApplyBillControllerBean", (Locale)ctx.getLocale()));
            }
        } else if (ids != null && ids.size() > 1) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("draftKind");
            sic.add("operateState");
            sic.add("communicationStatus");
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)ids), CompareType.INCLUDE));
            view.setFilter(filter);
            RpdTransDistApplyBillCollection coll = iRpdTransDistApplyBill.getRpdTransDistApplyBillCollection(view);
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                isFitA = this.isFitA(coll.get(i));
                isFitB = this.isFitB(coll.get(i));
                if (!isFitA || !isFitB) continue;
                idSet.add(coll.get(i).getId().toString());
            }
            if (idSet.isEmpty()) {
                this.throwBizException(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"83_RpdTransDistApplyBillControllerBean", (Locale)ctx.getLocale()));
            } else {
                iRpdTransDistApplyBill.batchCommitECDS(idSet);
                this.changeOperateState(ctx, idSet, FCOperateStateEnum.submit);
            }
        }
    }

    private void changeOperateState(Context ctx, Set ids, FCOperateStateEnum status) throws BOSException {
        StringBuffer sql = new StringBuffer();
        List idList = FMHelper.set2List((Set)ids);
        if (idList.size() > 0) {
            sql.append("update T_EDR_RpdTransDistApplyBill set FOperateState=").append(status.getValue()).append(" where FID in(");
            sql.append("'").append(idList.get(0).toString()).append("'");
            for (int i = 1; i < idList.size(); ++i) {
                sql.append(" ,'").append(idList.get(i).toString()).append("'");
            }
            sql.append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IRpdTransDistApplyBill iRpdTransDistApplyBill = RpdTransDistApplyBillFactory.getLocalInstance(ctx);
        RpdTransDistApplyBillInfo baseInfo = (RpdTransDistApplyBillInfo)model;
        baseInfo.setOperateState(FCOperateStateEnum.AUDITED);
        baseInfo.setAuditor(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        baseInfo.setAuditDate(new Date());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("operateState"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("auditDate"));
        iRpdTransDistApplyBill.updatePartial((CoreBaseInfo)baseInfo, sic);
    }

    private boolean isFitB(RpdTransDistApplyBillInfo info) {
        return info.getDraftKind() == DraftKindEnum.ELECDRAFT;
    }

    private boolean isFitA(RpdTransDistApplyBillInfo info) {
        return info.getOperateState() == FCOperateStateEnum.AUDITED || info.getCommunicationStatus() == ECDSCommunicationStatusEnum.SUBMIT_FAIL;
    }

    @Override
    protected void _unAudit4WF(Context ctx, IObjectValue model) throws BOSException {
    }
}

