/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMBillBaseInfo;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseInfo;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.IDraftApplyBillBase;
import com.kingdee.eas.fm.edrafent.CommunicationWayEnum;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseCollection;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseInfo;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftRegisterBillInfo;
import com.kingdee.eas.fm.edrafent.IDrafentApplyBillBase;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.app.AbstractDrafentApplyBillBaseControllerBean;
import com.kingdee.eas.fm.edrafent.util.EdrafentUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class DrafentApplyBillBaseControllerBean
extends AbstractDrafentApplyBillBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edrafent.app.DrafentApplyBillBaseControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DrafentApplyBillBaseInfo baseInfo = (DrafentApplyBillBaseInfo)model;
        if (baseInfo.getOperateState().equals((Object)OperateStateEnum.SAVE)) {
            baseInfo.setOperateState(OperateStateEnum.SUBMIT);
        }
        return super._submit(ctx, (IObjectValue)baseInfo);
    }

    @Override
    protected void _cancelApply(Context ctx, String billId, DraftApplyTypeEnum cancelType) throws BOSException, EASBizException {
        IDrafentApplyBillBase iDrafentApplyBillBase = (IDrafentApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(BOSUuid.read((String)billId).getType());
        DrafentApplyBillBaseInfo info = iDrafentApplyBillBase.getDrafentApplyBillBaseInfo((IObjectPK)new ObjectStringPK(billId));
        SelectorItemCollection sic = new SelectorItemCollection();
        this.checkCanBeCancelled(ctx, (IObjectValue)info, cancelType);
        if (info instanceof DraftRegisterBillInfo) {
            if (cancelType == DraftApplyTypeEnum.CHENGDUI) {
                ((DraftRegisterBillInfo)info).setClewAccept(false);
                sic.add(new SelectorItemInfo("clewAccept"));
            } else if (cancelType == DraftApplyTypeEnum.SHOUPIAO) {
                ((DraftRegisterBillInfo)info).setClewDrawer(false);
                sic.add(new SelectorItemInfo("clewDrawer"));
            }
        } else {
            info.setIsCancelDraft(true);
            sic.add(new SelectorItemInfo("isCancelDraft"));
            this.setBillState(info, sic);
        }
        info.setReturnOpinion(null);
        info.setSubmitDate(DateHelper.getTime());
        info.setSubmitCompany(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany());
        info.setSubmitter(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        sic.add(new SelectorItemInfo("returnOpinion"));
        sic.add(new SelectorItemInfo("submitDate"));
        sic.add(new SelectorItemInfo("submitCompany"));
        sic.add(new SelectorItemInfo("submitter"));
        iDrafentApplyBillBase.updatePartial((CoreBaseInfo)info, sic);
        if (info.getCommunicationWay().getValue() == 1) {
            String applyBillInfo = this.getApplyBillClassName(cancelType);
            try {
                Class<?> clz = Class.forName(applyBillInfo.toString());
                Object fetcher = clz.newInstance();
                IDraftApplyBillBase iDraftApplyBillBase = (IDraftApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(((FMBillBaseInfo)fetcher).getBOSType());
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.appendFilterItem("sourceBillId", (Object)info.getId().toString());
                filter.appendFilterItem("isCancelDraft", (Object)Boolean.FALSE);
                filter.appendFilterItem("communicationStatus", (Object)new Integer(1));
                evi.setFilter(filter);
                SorterItemInfo sorterInfo = new SorterItemInfo("createTime");
                sorterInfo.setSortType(SortType.DESCEND);
                SorterItemCollection sorterCol = new SorterItemCollection();
                sorterCol.add(sorterInfo);
                evi.setSorter(sorterCol);
                DraftApplyBillBaseCollection col = iDraftApplyBillBase.getDraftApplyBillBaseCollection(evi);
                if (col == null || col.size() == 0) {
                    throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u65e0\u6cd5\u83b7\u53d6\u8d22\u52a1\u516c\u53f8\u7aef\u539f\u4e1a\u52a1\u7533\u8bf7\u5355\u636e"});
                }
                DraftApplyBillBaseInfo srcApplyInfo = col.get(0);
                DraftApplyBillBaseInfo cancelApplyInfo = (DraftApplyBillBaseInfo)srcApplyInfo.clone();
                cancelApplyInfo.setId(null);
                cancelApplyInfo.setNumber(null);
                cancelApplyInfo.setIsCancelDraft(true);
                cancelApplyInfo.setDraftSourceBill(srcApplyInfo.getId().toString());
                cancelApplyInfo.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                cancelApplyInfo.setCreateTime(null);
                cancelApplyInfo.setBizCode(null);
                cancelApplyInfo.setLastUpdateUser(null);
                cancelApplyInfo.setLastUpdateTime(null);
                cancelApplyInfo.setSourceBillId(billId);
                cancelApplyInfo.setOperateState(FCOperateStateEnum.save);
                cancelApplyInfo.setCommunicationStatus(ECDSCommunicationStatusEnum.SUBMIT_READY);
                IObjectPK cancelPK = iDraftApplyBillBase.addnew((CoreBaseInfo)cancelApplyInfo);
                EdrafentUtil.saveBotpRelation(ctx, (CoreBillBaseInfo)info, (CoreBillBaseInfo)cancelApplyInfo, info.getId().toString(), cancelPK.toString());
                try {
                    this.cancelApply4WF(ctx, info);
                }
                catch (Exception e) {
                    throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u63d0\u4ea4\u8d22\u52a1\u516c\u53f8\u5de5\u4f5c\u6d41\u9519\u8bef "});
                }
            }
            catch (Exception e) {
                throw new FMException(FMException.COMMMONEXCEPTION, (Throwable)e, new Object[]{"\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7533\u8bf7\u7c7b\u578b\u7684\u8d22\u52a1\u516c\u53f8\u7533\u8bf7\u5355\u5b9e\u4f53"});
            }
        }
    }

    protected void setBillState(DrafentApplyBillBaseInfo info, SelectorItemCollection sic) {
        info.setOperateState(OperateStateEnum.CANCEL);
        sic.add(new SelectorItemInfo("operateState"));
    }

    protected void checkCanBeCancelled(Context ctx, IObjectValue model, DraftApplyTypeEnum cancelType) throws EASBizException, BOSException {
        DrafentApplyBillBaseInfo info = (DrafentApplyBillBaseInfo)model;
        if (!info.getOperateState().equals((Object)OperateStateEnum.SUBMITGATEWAY)) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u6240\u9009\u5355\u636e\u4e0d\u7b26\u5408\u64a4\u9500\u4e1a\u52a1\u6761\u4ef6\uff01"});
        }
    }

    protected abstract String getApplyBillClassName(DraftApplyTypeEnum var1);

    protected abstract String getBankBillClassName(DraftApplyTypeEnum var1);

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DrafentApplyBillBaseInfo baseInfo = (DrafentApplyBillBaseInfo)model;
        baseInfo.setAuditDate(new Timestamp(new Date().getTime()));
        baseInfo.setOperateState(OperateStateEnum.AUDIT);
        baseInfo.setAuditor(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        IDrafentApplyBillBase iDrafentApplyBillBase = (IDrafentApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(baseInfo.getBOSType());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("operateState"));
        sic.add(new SelectorItemInfo("auditor"));
        iDrafentApplyBillBase.updatePartial((CoreBaseInfo)baseInfo, sic);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void _batchSubmitFC(Context ctx, Set idSet, DraftApplyTypeEnum applyType) throws BOSException, EASBizException {
        DrafentApplyBillBaseCollection baseCol = this.getBillBaseCollection(ctx, idSet, applyType);
        if (baseCol == null || baseCol.size() <= 0) throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u64cd\u4f5c\u72b6\u6001\u4e3a\u5ba1\u6279\u7684\u5355\u636e\u624d\u53ef\u4ee5\u63d0\u4ea4\u8d22\u52a1\u516c\u53f8\uff01"});
        CoreBaseCollection col = new CoreBaseCollection();
        DrafentApplyBillBaseInfo baseInfo = null;
        try {
            String applyBillInfo = this.getApplyBillClassName(applyType);
            Class<?> clz = Class.forName(applyBillInfo.toString());
            Object fetcher = clz.newInstance();
            IDraftApplyBillBase iDraftApplyBillBase = (IDraftApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(((FMBillBaseInfo)fetcher).getBOSType());
            int n = baseCol.size();
            for (int i = 0; i < n; ++i) {
                baseInfo = baseCol.get(i);
                DraftApplyBillBaseInfo applyBaseInfo = this.getApplyBillBaseInfo(baseInfo, applyType);
                if (applyBaseInfo.getApplyCompany() == null) {
                    applyBaseInfo.setApplyCompany(baseInfo.getCompany());
                }
                applyBaseInfo.setSourceBillId(baseInfo.getId().toString());
                applyBaseInfo.setCompany(null);
                IObjectPK pk = iDraftApplyBillBase.addnew((CoreBaseInfo)applyBaseInfo);
                EdrafentUtil.saveBotpRelation(ctx, (CoreBillBaseInfo)baseInfo, (CoreBillBaseInfo)applyBaseInfo, baseInfo.getId().toString(), pk.toString());
                DrafentApplyBillBaseInfo billInfo = this.reversBillState(ctx, baseInfo, applyType);
                col.add((CoreBaseInfo)billInfo);
                try {
                    this.commitFC4WF(ctx, baseInfo);
                    continue;
                }
                catch (Exception e) {
                    throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u63d0\u4ea4\u8d22\u52a1\u516c\u53f8\u5de5\u4f5c\u6d41\u9519\u8bef "});
                }
            }
            if (col == null || col.size() <= 0) return;
            IDrafentApplyBillBase iDrafentApplyBillBase = (IDrafentApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(new DrafentApplyBillBaseInfo().getBOSType());
            iDrafentApplyBillBase.update(col);
            return;
        }
        catch (Exception e) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u8f6c\u6362\u8d22\u52a1\u516c\u53f8\u7aef\u5b9e\u4f53\u51fa\u9519: " + e.getMessage()});
        }
    }

    public DrafentApplyBillBaseInfo reversBillState(Context ctx, DrafentApplyBillBaseInfo baseInfo, DraftApplyTypeEnum applyType) {
        baseInfo.setOperateState(OperateStateEnum.SUBMITGATEWAY);
        baseInfo.setFinanceOperateState(com.kingdee.eas.fm.edrafent.FCOperateStateEnum.save);
        CompanyOrgUnitInfo companyName = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        UserInfo userName = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        baseInfo.setCommunicationWay(CommunicationWayEnum.WITH_FINANCINGCOMPANY);
        baseInfo.setSubmitCompany(companyName);
        baseInfo.setSubmitter(userName);
        baseInfo.setSubmitDate(DateHelper.getTime());
        baseInfo.setReturnOpinion(null);
        return baseInfo;
    }

    public DrafentApplyBillBaseCollection getBillBaseCollection(Context ctx, Set idSet, DraftApplyTypeEnum applyType) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.AUDIT, CompareType.EQUALS));
        env.setFilter(filter);
        env.setSelector(this.getSelector());
        Iterator iterator = idSet.iterator();
        String id = iterator.next().toString();
        IDrafentApplyBillBase iDrafentApplyBillBase = (IDrafentApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(id);
        DrafentApplyBillBaseCollection baseColl = iDrafentApplyBillBase.getDrafentApplyBillBaseCollection(env);
        if (baseColl == null || baseColl.size() == 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u6240\u9009\u8bb0\u5f55\u4e0d\u6ee1\u8db3\u64cd\u4f5c\u6761\u4ef6\uff01"});
        }
        return baseColl;
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        return sic;
    }

    public abstract DraftApplyBillBaseInfo getApplyBillBaseInfo(DrafentApplyBillBaseInfo var1, DraftApplyTypeEnum var2);

    @Override
    protected void _commitFC4WF(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _unAudit4WF(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _cancelApply4WF(Context ctx, IObjectValue model) throws BOSException {
    }
}

