/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edraf.CollateralApplyBillInfo;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseInfo;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edrafent.CommercialDraftFactory;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseCollection;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseInfo;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftCollateralizationRequestCollection;
import com.kingdee.eas.fm.edrafent.DraftCollateralizationRequestFactory;
import com.kingdee.eas.fm.edrafent.DraftCollateralizationRequestInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillFactory;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.IDrafentApplyBillBase;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.PawneeRelationEnum;
import com.kingdee.eas.fm.edrafent.app.AbstractDraftCollateralizationRequestControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class DraftCollateralizationRequestControllerBean
extends AbstractDraftCollateralizationRequestControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edrafent.app.DraftCollateralizationRequestControllerBean");

    protected void initInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.initInfo(ctx, model);
    }

    protected void afterAddNew(Context ctx, IObjectPK returnPK, IObjectValue model) throws BOSException, EASBizException {
        super.afterAddNew(ctx, returnPK, model);
        DraftCollateralizationRequestInfo info = this.getDraftCollateralizationRequestInfo(ctx, returnPK);
        if (info != null && info.getSourceBillId() != null) {
            DraftStockBillInfo stockInfo = DraftStockBillFactory.getLocalInstance(ctx).getDraftStockBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
            stockInfo.setCollateral(true);
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("collateral"));
            DraftStockBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)stockInfo, selColl);
            BOTRelationInfo relateInfo = new BOTRelationInfo();
            relateInfo.setSrcEntityID(stockInfo.getId().toString());
            relateInfo.setDestEntityID(BOSUuid.read((String)returnPK.toString()).getType().toString());
            relateInfo.setSrcObjectID(stockInfo.getId().toString());
            relateInfo.setDestObjectID(returnPK.toString());
            relateInfo.setDate(new Date());
            relateInfo.setOperatorID("unknown");
            relateInfo.setIsEffected(true);
            relateInfo.setType(0);
            BOTRelationFactory.getLocalInstance((Context)ctx).addnew(relateInfo);
        }
    }

    protected void checkBeforeAddNew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.checkBeforeAddNew(ctx, model);
    }

    @Override
    public DraftApplyBillBaseInfo getApplyBillBaseInfo(DrafentApplyBillBaseInfo baseInfo, DraftApplyTypeEnum applyType) {
        CollateralApplyBillInfo newBillInfo = null;
        if (baseInfo instanceof DraftCollateralizationRequestInfo) {
            DraftCollateralizationRequestInfo info = (DraftCollateralizationRequestInfo)baseInfo;
            newBillInfo = new CollateralApplyBillInfo();
            newBillInfo.setIsAttorn(info.isIsAttorn());
            newBillInfo.setRemark(info.getRemark());
            newBillInfo.setPledgorOrgCode(info.getPledgorOrgCode());
            newBillInfo.setPkIssueDate(info.getPkIssueDate());
            newBillInfo.setPledgorName(info.getPledgorName());
            newBillInfo.setPledgorBank(info.getPledgorBank());
            newBillInfo.setPledgorAcctSvcr(info.getPledgorAcctSvcr());
            if (info.getPawneeRelation() == PawneeRelationEnum.BlocIn) {
                newBillInfo.setPawneeName(info.getPawneeName());
            } else {
                newBillInfo.setInstitution(info.getInstitution());
            }
            newBillInfo.setPawneeNumber(info.getPawneeNumber());
            newBillInfo.setPawneeAcctSvcr(info.getPawneeAcctSvcr());
            newBillInfo.setCommercialDraft(info.getCommercialDraft());
            newBillInfo.setOperateState(FCOperateStateEnum.save);
            newBillInfo.setCommunicationStatus(ECDSCommunicationStatusEnum.SUBMIT_READY);
            newBillInfo.setPkIssueDate(info.getPkIssueDate());
            newBillInfo.setSourceBillId(info.getId().toString());
            newBillInfo.setStartECDSState(info.getCommercialDraft().getDraftECDSStatus());
            newBillInfo.setEndECDSState(info.getCommercialDraft().getDraftECDSStatus());
            newBillInfo.setBatchNumber(info.getBatchNumber());
            newBillInfo.setApplyCompany(info.getCompany());
            newBillInfo.setApplyDate(info.getPkIssueDate());
        }
        return newBillInfo;
    }

    @Override
    public DrafentApplyBillBaseCollection getBillBaseCollection(Context ctx, Set idSet, DraftApplyTypeEnum applyType) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.AUDIT, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("commercialDraft.draftECDSStatus", null));
        env.setFilter(filter);
        env.setSelector(this.getSelector());
        DrafentApplyBillBaseCollection baseColl = DraftCollateralizationRequestFactory.getLocalInstance(ctx).getDrafentApplyBillBaseCollection(env);
        if (baseColl != null && baseColl.size() > 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u6240\u9009\u8bb0\u5f55\u4e0d\u6ee1\u8db3\u64cd\u4f5c\u6761\u4ef6\uff01"});
        }
        EntityViewInfo env1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter1.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.AUDIT, CompareType.EQUALS));
        env1.setFilter(filter1);
        env1.setSelector(this.getSelector());
        Iterator iterator = idSet.iterator();
        String id = iterator.next().toString();
        IDrafentApplyBillBase iDrafentApplyBillBase = (IDrafentApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(id);
        DrafentApplyBillBaseCollection coll = iDrafentApplyBillBase.getDrafentApplyBillBaseCollection(env1);
        if (coll == null || coll.size() == 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u6240\u9009\u8bb0\u5f55\u4e0d\u6ee1\u8db3\u64cd\u4f5c\u6761\u4ef6\uff01"});
        }
        return coll;
    }

    @Override
    protected void _commitBankCorporate(Context ctx, IObjectPK objectPK) throws BOSException, EASBizException {
    }

    @Override
    protected void _audit(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)new Integer(1), CompareType.EQUALS));
        envi.setFilter(filter);
        DraftCollateralizationRequestCollection coll = this.getDraftCollateralizationRequestCollection(ctx, envi);
        if (coll.size() <= 0) {
            throw new EASBizException(new NumericExceptionSubItem("811341", "\u63d0\u4ea4\u72b6\u6001\u7684\u5355\u53ef\u5ba1\u6279\uff01"));
        }
        for (int i = 0; i < coll.size(); ++i) {
            DraftCollateralizationRequestInfo info = coll.get(i);
            if (info.getOperateState().getValue() != 1) continue;
            super._audit4WF(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
        }
    }

    @Override
    protected void _unAudit(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)new Integer(2), CompareType.EQUALS));
        envi.setFilter(filter);
        DraftCollateralizationRequestCollection coll = this.getDraftCollateralizationRequestCollection(ctx, envi);
        if (coll.size() <= 0) {
            throw new EASBizException(new NumericExceptionSubItem("811341", "\u5ba1\u6279\u72b6\u6001\u7684\u5355\u624d\u53ef\u53cd\u5ba1\u6279\uff01"));
        }
        for (int i = 0; i < coll.size(); ++i) {
            DraftCollateralizationRequestInfo info = coll.get(i);
            if (info.getOperateState().getValue() != 2) continue;
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("operateState"));
            selColl.add(new SelectorItemInfo("auditDate"));
            selColl.add(new SelectorItemInfo("auditor"));
            info.setOperateState(OperateStateEnum.SAVE);
            info.setAuditDate(null);
            info.setAuditor(null);
            this.updatePartial(ctx, (CoreBaseInfo)info, selColl);
            super.unAudit4WF(ctx, info);
        }
    }

    @Override
    protected void _submit(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)new Integer(0), CompareType.EQUALS));
        envi.setFilter(filter);
        DraftCollateralizationRequestCollection coll = this.getDraftCollateralizationRequestCollection(ctx, envi);
        if (coll.size() <= 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u4fdd\u5b58\u72b6\u6001\u7684\u8d28\u62bc\u5355\u624d\u5141\u8bb8\u63d0\u4ea4\uff01"});
        }
        for (int i = 0; i < coll.size(); ++i) {
            DraftCollateralizationRequestInfo info = coll.get(i);
            super.submit(ctx, (CoreBaseInfo)info);
        }
    }

    protected void isCanDelete(Context ctx, IObjectPK pk, CoreBillBaseInfo coreBillInfo) throws BOSException, EASBizException {
        super.isCanDelete(ctx, pk, coreBillInfo);
        DraftCollateralizationRequestInfo info = this.getDraftCollateralizationRequestInfo(ctx, pk);
        if (info.getOperateState().getValue() == 0 || info.getOperateState().getValue() == 1) {
            if (info.getFinanceOperateState() != com.kingdee.eas.fm.edrafent.FCOperateStateEnum.init_Value) {
                throw new EASBizException(new NumericExceptionSubItem("123088", "\u5df2\u5ba1\u6279\u6216\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u53ef\u5220\u9664\uff01"));
            }
        } else {
            throw new EASBizException(new NumericExceptionSubItem("123088", "\u5df2\u5ba1\u6279\u6216\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u53ef\u5220\u9664\uff01"));
        }
    }

    @Override
    protected void checkCanBeCancelled(Context ctx, IObjectValue model, DraftApplyTypeEnum cancelType) throws EASBizException, BOSException {
        DraftCollateralizationRequestInfo billInfo = (DraftCollateralizationRequestInfo)model;
        if (billInfo.getCommercialDraft() == null) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u7968\u636e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u64a4\u7968\u64cd\u4f5c\uff01"});
        }
        CommercialDraftInfo commercialDraftInfo = CommercialDraftFactory.getLocalInstance(ctx).getCommercialDraftInfo((IObjectPK)new ObjectUuidPK(billInfo.getCommercialDraft().getId().toString()));
        if (!commercialDraftInfo.getDraftECDSStatus().equals((Object)ECDSBillStatusEnum.ZYDQS) || !billInfo.getOperateState().equals((Object)OperateStateEnum.SUBMITGATEWAY)) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u7535\u7968\u72b6\u6001\u4e3a\u8d28\u62bc\u5f85\u7b7e\u6536\u4e14\u64cd\u4f5c\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\u7f51\u5173\u7684\u5355\u636e\u624d\u53ef\u4ee5\u8fdb\u884c\u64a4\u9500\u64cd\u4f5c\uff01"});
        }
    }

    @Override
    protected String getApplyBillClassName(DraftApplyTypeEnum cancelType) {
        return CollateralApplyBillInfo.class.getName();
    }

    @Override
    protected String getBankBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String stockId = this.getDraftCollateralizationRequestInfo(ctx, pk).getSourceBillId();
        super.delete(ctx, pk);
        if (stockId != null) {
            DraftStockBillInfo stockInfo = DraftStockBillFactory.getLocalInstance(ctx).getDraftStockBillInfo((IObjectPK)new ObjectUuidPK(stockId));
            stockInfo.setCollateral(false);
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("collateral"));
            DraftStockBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)stockInfo, selColl);
        }
    }
}

