/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseInfo;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseInfo;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftCreditInfomationBillCollection;
import com.kingdee.eas.fm.edrafent.DraftCreditInfomationBillFactory;
import com.kingdee.eas.fm.edrafent.DraftCreditInfomationBillInfo;
import com.kingdee.eas.fm.edrafent.app.AbstractDraftCreditInfomationBillControllerBean;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class DraftCreditInfomationBillControllerBean
extends AbstractDraftCreditInfomationBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edrafent.app.DraftCreditInfomationBillControllerBean");

    @Override
    protected void _submitToFin(Context ctx, Set idSet) throws BOSException, EASBizException {
    }

    @Override
    protected void _submitToECDS(Context ctx, Set idSet) throws BOSException, EASBizException {
    }

    @Override
    protected void _tally(Context ctx, Set ids) throws BOSException, EASBizException {
        DraftCreditInfomationBillInfo info;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filters = filter.getFilterItems();
        filters.add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("commercialDraft.id");
        selectors.add("commercialDraft.number");
        selectors.add("commercialDraft.draftECDSStatus");
        selectors.add("acceptorAccount.id");
        selectors.add("acceptorAccount.number");
        selectors.add("acceptorAccount.name");
        selectors.add("acceptorAccount.isBank");
        selectors.add("acceptorAccount.isCash");
        selectors.add("acceptorAccount.account.id");
        selectors.add("acceptorAccount.account.number");
        selectors.add("acceptorAccount.account.name");
        selectors.add("acceptorAccount.currency.id");
        selectors.add("acceptorAccount.currency.number");
        selectors.add("acceptorAccount.currency.name");
        view.setSelector(selectors);
        view.setFilter(filter);
        DraftCreditInfomationBillCollection coll = DraftCreditInfomationBillFactory.getLocalInstance(ctx).getDraftCreditInfomationBillCollection(view);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (info.isTally()) {
                sb.append("\u5355\u636e:").append(info.getNumber()).append("\u4e3a\u5df2\u767b\u5e10\u72b6\u6001\n");
                continue;
            }
            if (info.getAcceptorAccount() == null || !info.getAcceptorAccount().isIsBank()) {
                if (info.getAcceptorAccount() == null) {
                    sb.append("\u5355\u636e:").append(info.getNumber()).append("\u94f6\u884c\u8d26\u76ee\u4e3a\u7a7a\n");
                    continue;
                }
                sb.append("\u5355\u636e:").append(info.getNumber()).append("\u94f6\u884c\u8d26\u6237 \u7684\u79d1\u76ee\u5fc5\u987b\u4e3a\u94f6\u884c\u79d1\u76ee\u624d\u5141\u8bb8\u767b\u5e10\n");
                continue;
            }
            if (info.getCommercialDraft() != null && ECDSBillStatusEnum.PJYJQ.equals((Object)info.getCommercialDraft().getDraftECDSStatus())) continue;
            if (info.getCommercialDraft() == null) {
                sb.append("\u5355\u636e:").append(info.getNumber()).append("\u7968\u636e\u5151\u4ed8\u4fe1\u606f\u4e3a\u7a7a\n");
                continue;
            }
            sb.append("\u5355\u636e:").append(info.getNumber()).append("\u7968\u636e\u5151\u4ed8\u4fe1\u606f\u7684\u7535\u7968\u72b6\u6001\u4e0d\u4e3a\u7968\u636e\u5df2\u7ed3\u6e05\n");
        }
        if (sb.length() != 0) {
            NumericExceptionSubItem item = new NumericExceptionSubItem("{0}", "{0}");
            EASBizException exec = new EASBizException(item, (Object[])new String[]{sb.toString()});
            throw exec;
        }
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            Date date;
            Date now;
            info = (DraftCreditInfomationBillInfo)it.next();
            JournalInfo journalInfo = new JournalInfo();
            PeriodInfo peroid = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info.getCompany());
            Date bizDate = now = new Date();
            if (peroid != null && (date = peroid.getBeginDate()).compareTo(now) > 0) {
                bizDate = date;
            }
            journalInfo.setCompany(info.getCompany());
            journalInfo.setBizDate(bizDate);
            journalInfo.setBillNumber(info.getNumber());
            journalInfo.setBillId(info.getId().toString());
            journalInfo.setCreditAmount(info.getPayAccount());
            journalInfo.setCreateDate(bizDate);
            journalInfo.setType(JournalTypeEnum.BANK);
            journalInfo.setAccountBank(info.getAcceptorAccount());
            journalInfo.setAccountView(info.getAcceptorAccount().getAccount());
            journalInfo.setCurrency(info.getAcceptorAccount().getCurrency());
            journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
            journalInfo.setSource(JournalSourceEnum.BYBILL);
            journalInfo.setPeriod(peroid);
            journalInfo.setDescription(info.getHolderRamark());
            JournalFactory.getLocalInstance((Context)ctx).addnew(journalInfo);
        }
        this.updateTallyStatus(ctx, coll, 1);
    }

    private void updateTallyStatus(Context ctx, DraftCreditInfomationBillCollection coll, int status) throws BOSException {
        StringBuffer updateTally = new StringBuffer();
        updateTally.append("update T_EDT_DraftCreditInfoBill set FTally=").append(status).append(" where FID in(");
        int size = coll.size();
        if (size <= 0) {
            return;
        }
        if (size > 0) {
            updateTally.append("'").append(coll.get(0).getId().toString()).append("'");
        }
        for (int i = 1; i < size; ++i) {
            updateTally.append(" ,'").append(coll.get(i).getId().toString()).append("'");
        }
        updateTally.append(")");
        DbUtil.execute((Context)ctx, (String)updateTally.toString());
    }

    @Override
    protected void _unTally(Context ctx, Set ids) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filters = filter.getFilterItems();
        filters.add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        filters.add(new FilterItemInfo("tally", (Object)Boolean.TRUE));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        view.setSelector(selectors);
        view.setFilter(filter);
        DraftCreditInfomationBillCollection coll = DraftCreditInfomationBillFactory.getLocalInstance(ctx).getDraftCreditInfomationBillCollection(view);
        int size = coll.size();
        StringBuffer oql = new StringBuffer();
        oql.append("where billId in (");
        if (size <= 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u6ca1\u6709\u627e\u5230\u7b26\u5408\u53cd\u767b\u5e10\u7684"});
        }
        oql.append("'").append(coll.get(0).getId().toString()).append("'");
        for (int i = 1; i < coll.size(); ++i) {
            oql.append(",'").append(coll.get(i).getId().toString()).append("'");
        }
        oql.append(")");
        JournalFactory.getLocalInstance((Context)ctx).delete(oql.toString());
        this.updateTallyStatus(ctx, coll, 0);
    }

    @Override
    protected String getApplyBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    @Override
    protected String getBankBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    @Override
    public DraftApplyBillBaseInfo getApplyBillBaseInfo(DrafentApplyBillBaseInfo baseInfo, DraftApplyTypeEnum applyType) {
        return null;
    }
}

