/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseInfo;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.RegisterApplyBillCollection;
import com.kingdee.eas.fm.edraf.RegisterApplyBillInfo;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.CommunicationWayEnum;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseInfo;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftDestructionRequestBillCollection;
import com.kingdee.eas.fm.edrafent.DraftDestructionRequestBillInfo;
import com.kingdee.eas.fm.edrafent.DraftRegisterBillFactory;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.app.AbstractDraftDestructionRequestBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class DraftDestructionRequestBillControllerBean
extends AbstractDraftDestructionRequestBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edrafent.app.DraftDestructionRequestBillControllerBean");

    protected void isCanDelete(Context ctx, IObjectPK pk, CoreBillBaseInfo coreBillInfo) throws BOSException, EASBizException {
        super.isCanDelete(ctx, pk, coreBillInfo);
        DraftDestructionRequestBillInfo info = this.getDraftDestructionRequestBillInfo(ctx, pk);
        if (info.getOperateState().getValue() != 0 && info.getOperateState().getValue() != 1) {
            throw new EASBizException(new NumericExceptionSubItem("123088", EASResource.getString((String)"com.kingdee.eas.fm.edrafent.EdratentResource", (String)"cannotdelete")));
        }
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sourceBillId = this.getValue(ctx, pk).get("sourceBillId").toString();
        super.delete(ctx, pk);
        SelectorItemCollection selColl = new SelectorItemCollection();
        selColl.add(new SelectorItemInfo("isCancelDraft"));
        CoreBaseInfo model = DraftRegisterBillFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(sourceBillId));
        model.setBoolean("isCancelDraft", false);
        DraftRegisterBillFactory.getLocalInstance(ctx).updatePartial(model, selColl);
    }

    @Override
    protected void _submit(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        envi.setFilter(filter);
        DraftDestructionRequestBillCollection coll = this.getDraftDestructionRequestBillCollection(ctx, envi);
        for (int i = 0; i < coll.size(); ++i) {
            DraftDestructionRequestBillInfo info = coll.get(i);
            if (info.getOperateState().getValue() != 0) continue;
            super.submit(ctx, (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _commitFinanceCompany(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        envi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("draftRegisterBill.*"));
        sic.add(new SelectorItemInfo("draftRegisterBill.amountAccount.*"));
        sic.add(new SelectorItemInfo("draftRegisterBill.commercialDraft.*"));
        envi.setSelector(sic);
        DraftDestructionRequestBillCollection coll = this.getDraftDestructionRequestBillCollection(ctx, envi);
        for (int i = 0; i < coll.size(); ++i) {
            DraftDestructionRequestBillInfo info = coll.get(i);
            if (info.getOperateState().getValue() != 2) continue;
            try {
                this.commitFC4WF(ctx, info);
            }
            catch (Exception e) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u63d0\u4ea4\u8d22\u52a1\u516c\u53f8\u5de5\u4f5c\u6d41\u9519\u8bef "});
            }
            if (null == info.getSourceBillId()) continue;
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            BTPTransformResult btpResult = iBTPManager.transform((CoreBillBaseInfo)info, new RegisterApplyBillInfo().getBOSType().toString());
            IObjectCollection col = btpResult.getBills();
            if (null != col && col instanceof RegisterApplyBillCollection) {
                RegisterApplyBillCollection newColl = (RegisterApplyBillCollection)col;
                RegisterApplyBillInfo newBillInfo = newColl.get(0);
                newBillInfo.setIsCancelDraft(true);
                CommercialDraftInfo commInfo = info.getDraftRegisterBill().getCommercialDraft();
                newBillInfo.setCommercialDraft(commInfo);
                newBillInfo.setDraftNumber(commInfo.getDraftNumber());
                newBillInfo.setStartECDSState(commInfo.getDraftECDSStatus());
                newBillInfo.setEndECDSState(commInfo.getDraftECDSStatus());
                newBillInfo.setSourceBillId(info.getId().toString());
                newBillInfo.setProcedureRate(info.getDraftRegisterBill().getProcedureRate());
                newBillInfo.setMoneySum(info.getDraftRegisterBill().getMoneySum());
                newBillInfo.setAmountAccount(info.getDraftRegisterBill().getAmountAccount());
                newBillInfo.setOperateState(FCOperateStateEnum.save);
                newBillInfo.setCommunicationStatus(ECDSCommunicationStatusEnum.SUBMIT_READY);
                newBillInfo.setDescription(info.getDraftRegisterBill().getDescription());
                newBillInfo.setAssurersAccount(info.getDraftRegisterBill().getAssurersAccount());
                newBillInfo.setAssurersBankNumber(info.getDraftRegisterBill().getAssurersBankNumber());
                newBillInfo.setApplyCompany(info.getCompany());
                newBillInfo.setApplyDate(new Date());
                newBillInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                newBillInfo.setReturnOpinion(null);
                newBillInfo.setCompany(null);
                iBTPManager.saveRelations((CoreBillBaseInfo)newBillInfo, btpResult.getBOTRelationCollection());
            }
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("operateState"));
            sc.add(new SelectorItemInfo("financeOperateState"));
            sc.add(new SelectorItemInfo("submitDate"));
            sc.add(new SelectorItemInfo("submitter"));
            sc.add(new SelectorItemInfo("submitCompany"));
            sc.add(new SelectorItemInfo("communicationWay"));
            sc.add(new SelectorItemInfo("returnOpinion"));
            info.setFinanceOperateState(com.kingdee.eas.fm.edrafent.FCOperateStateEnum.save);
            info.setSubmitDate(DateHelper.getTime());
            info.setSubmitCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
            info.setSubmitter(ContextUtil.getCurrentUserInfo((Context)ctx));
            info.setOperateState(OperateStateEnum.SUBMITGATEWAY);
            info.setReturnOpinion(null);
            info.setCommunicationWay(CommunicationWayEnum.WITH_FINANCINGCOMPANY);
            this.updatePartial(ctx, (CoreBaseInfo)info, sc);
        }
    }

    @Override
    protected void _commitBankCorporate(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        envi.setFilter(filter);
        DraftDestructionRequestBillCollection coll = this.getDraftDestructionRequestBillCollection(ctx, envi);
        for (int i = 0; i < coll.size(); ++i) {
            DraftDestructionRequestBillInfo billInfo = coll.get(i);
            if (billInfo.getOperateState().getValue() != 2) continue;
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("financeOperateState"));
            sc.add(new SelectorItemInfo("submitDate"));
            sc.add(new SelectorItemInfo("submitter"));
            sc.add(new SelectorItemInfo("submitCompany"));
            sc.add(new SelectorItemInfo("communicationWay"));
            billInfo.setFinanceOperateState(com.kingdee.eas.fm.edrafent.FCOperateStateEnum.save);
            billInfo.setSubmitDate(DateHelper.getTime());
            billInfo.setSubmitCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
            billInfo.setSubmitter(ContextUtil.getCurrentUserInfo((Context)ctx));
            billInfo.setOperateState(OperateStateEnum.SUBMITGATEWAY);
            billInfo.setCommunicationWay(CommunicationWayEnum.WITH_BEBANK);
            this.updatePartial(ctx, (CoreBaseInfo)billInfo, sc);
        }
    }

    @Override
    protected String getApplyBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    @Override
    protected String getBankBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    @Override
    public DraftApplyBillBaseInfo getApplyBillBaseInfo(DrafentApplyBillBaseInfo baseInfo, DraftApplyTypeEnum applyType) {
        return null;
    }

    @Override
    protected void _audit(Context ctx, Set set) throws BOSException, EASBizException {
        DraftDestructionRequestBillInfo info;
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        envi.setFilter(filter);
        DraftDestructionRequestBillCollection coll = this.getDraftDestructionRequestBillCollection(ctx, envi);
        if (coll.size() == 1 && (info = coll.get(0)).getOperateState().getValue() != 1) {
            throw new EASBizException(new NumericExceptionSubItem("811341", "\u63d0\u4ea4\u72b6\u6001\u7684 \u64a4\u7968\u7533\u8bf7\u53ef\u5ba1\u6279\uff01"));
        }
        for (int i = 0; i < coll.size(); ++i) {
            DraftDestructionRequestBillInfo info2 = coll.get(i);
            if (info2.getOperateState().getValue() != 1) continue;
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("operateState"));
            selColl.add(new SelectorItemInfo("auditDate"));
            selColl.add(new SelectorItemInfo("auditor"));
            info2.setOperateState(OperateStateEnum.AUDIT);
            info2.setAuditDate(DateHelper.getTime());
            info2.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            this.updatePartial(ctx, (CoreBaseInfo)info2, selColl);
            this.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(info2.getId()), info2);
        }
    }

    @Override
    protected void _unAudit(Context ctx, Set set) throws BOSException, EASBizException {
        DraftDestructionRequestBillInfo info;
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        envi.setFilter(filter);
        DraftDestructionRequestBillCollection coll = this.getDraftDestructionRequestBillCollection(ctx, envi);
        if (coll.size() == 1 && (info = coll.get(0)).getOperateState() != OperateStateEnum.AUDIT) {
            throw new EASBizException(new NumericExceptionSubItem("811341", "\u5ba1\u6279\u72b6\u6001\u7684 \u64a4\u7968\u7533\u8bf7\u53ef\u53cd\u5ba1\u6279\uff01"));
        }
        for (int i = 0; i < coll.size(); ++i) {
            DraftDestructionRequestBillInfo info2 = coll.get(i);
            if (info2.getOperateState().getValue() != 2) continue;
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("operateState"));
            selColl.add(new SelectorItemInfo("auditDate"));
            selColl.add(new SelectorItemInfo("auditor"));
            info2.setOperateState(OperateStateEnum.SAVE);
            info2.setAuditDate(null);
            info2.setAuditor(null);
            this.updatePartial(ctx, (CoreBaseInfo)info2, selColl);
            this.unAudit4WF(ctx, info2);
        }
    }
}

