/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseInfo;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseInfo;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftDiscountBizBillCollection;
import com.kingdee.eas.fm.edrafent.DraftDiscountBizBillFactory;
import com.kingdee.eas.fm.edrafent.DraftDiscountBizBillInfo;
import com.kingdee.eas.fm.edrafent.app.AbstractDraftDiscountBizBillControllerBean;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class DraftDiscountBizBillControllerBean
extends AbstractDraftDiscountBizBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edrafent.app.DraftDiscountBizBillControllerBean");

    @Override
    protected void _loginAccount(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("commercialDraft.draftECDSStatus", (Object)ECDSBillStatusEnum.HGSTXYQS, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("commercialDraft.draftECDSStatus", (Object)ECDSBillStatusEnum.MDSTXYQS, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isLogin", (Object)Boolean.TRUE, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and (#1 or #2) and #3");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("discountMoneyInAccount.*"));
        sic.add(new SelectorItemInfo("discountMoneyInAccount.currency.*"));
        sic.add(new SelectorItemInfo("discountMoneyInAccount.account.*"));
        env.setSelector(sic);
        env.setFilter(filter);
        DraftDiscountBizBillCollection billCol = DraftDiscountBizBillFactory.getLocalInstance(ctx).getDraftDiscountBizBillCollection(env);
        HashSet<BOSUuid> set = new HashSet<BOSUuid>();
        if (billCol != null && billCol.size() > 0) {
            JournalInfo journalInfo = null;
            PeriodInfo peroid = null;
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                Date now;
                DraftDiscountBizBillInfo info = billCol.get(i);
                set.add(info.getId());
                journalInfo = new JournalInfo();
                peroid = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info.getCompany());
                Date bizDate = now = new Date();
                if (peroid != null) {
                    Date date = peroid.getBeginDate();
                    if (date.compareTo(now) > 0) {
                        bizDate = date;
                    }
                } else {
                    throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u5f53\u524d\u7ec4\u7ec7\u65e0\u542f\u7528\u671f\u95f4\uff0c\u8bf7\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\u540e\u518d\u8fdb\u884c\u767b\u8d26\u64cd\u4f5c\uff01"});
                }
                journalInfo.setCompany(info.getCompany());
                journalInfo.setBizDate(bizDate);
                journalInfo.setBillNumber(info.getNumber());
                journalInfo.setBillId(info.getId().toString());
                journalInfo.setDebitAmount(info.getDiscountAmount());
                journalInfo.setCreateDate(bizDate);
                journalInfo.setType(JournalTypeEnum.BANK);
                journalInfo.setAccountBank(info.getDiscountMoneyInAccount());
                journalInfo.setAccountView(info.getDiscountMoneyInAccount().getAccount());
                journalInfo.setCurrency(info.getDiscountMoneyInAccount().getCurrency());
                journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
                journalInfo.setSource(JournalSourceEnum.BYBILL);
                journalInfo.setPeriod(peroid);
                journalInfo.setDescription(info.getDiscountOutRemark());
                JournalFactory.getLocalInstance((Context)ctx).addnew(journalInfo);
            }
            if (set != null && set.size() > 0) {
                String sql = "update T_EDT_DraftDiscountBizBill set FIsLogin=? where " + FMHelper.buildIn((String)"FID", (Object[])set.toArray());
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Boolean(true)});
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u5df2\u7b7e\u6536\u7684\u8d34\u73b0\u5355\u624d\u5141\u8bb8\u767b\u8d26\uff01"});
        }
    }

    @Override
    protected void _unLoginAccount(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashSet<BOSUuid> set;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isLogin", (Object)Boolean.TRUE, CompareType.EQUALS));
        view.setFilter(filter);
        DraftDiscountBizBillCollection coll = DraftDiscountBizBillFactory.getLocalInstance(ctx).getDraftDiscountBizBillCollection(view);
        if (coll.size() > 0) {
            set = new HashSet<BOSUuid>();
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                set.add(coll.get(i).getId());
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u5df2\u767b\u8d26\u7684\u8d34\u73b0\u5355\u624d\u5141\u8bb8\u53cd\u767b\u8d26\uff01"});
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", set, CompareType.INCLUDE));
        JournalFactory.getLocalInstance((Context)ctx).delete(filter);
        String sql = "update T_EDT_DraftDiscountBizBill set FIsLogin=? where " + FMHelper.buildIn((String)"FID", (Object[])set.toArray());
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Boolean(false)});
    }

    @Override
    protected String getApplyBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    @Override
    protected String getBankBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    @Override
    public DraftApplyBillBaseInfo getApplyBillBaseInfo(DrafentApplyBillBaseInfo baseInfo, DraftApplyTypeEnum applyType) {
        return null;
    }
}

