/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.edraf.DiscountReqApplyBillEntryFactory;
import com.kingdee.eas.fm.edraf.DiscountReqApplyBillEntryInfo;
import com.kingdee.eas.fm.edraf.DiscountReqApplyBillFactory;
import com.kingdee.eas.fm.edraf.DiscountReqApplyBillInfo;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseInfo;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DiscountDraftTypeEnum;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseInfo;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftDiscountReqBillCollection;
import com.kingdee.eas.fm.edrafent.DraftDiscountReqBillEntryCollection;
import com.kingdee.eas.fm.edrafent.DraftDiscountReqBillEntryFactory;
import com.kingdee.eas.fm.edrafent.DraftDiscountReqBillEntryInfo;
import com.kingdee.eas.fm.edrafent.DraftDiscountReqBillFactory;
import com.kingdee.eas.fm.edrafent.DraftDiscountReqBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillOperateEnum;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.app.AbstractDraftDiscountReqBillControllerBean;
import com.kingdee.eas.fm.edrafent.util.EdrafentUtil;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class DraftDiscountReqBillControllerBean
extends AbstractDraftDiscountReqBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edrafent.app.DraftDiscountReqBillControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.revaseStatu(ctx, model);
        IObjectPK pk = super._addnew(ctx, model);
        this.saveBOTPRelation(ctx, pk, model);
        return pk;
    }

    private void saveBOTPRelation(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException {
        DraftDiscountReqBillInfo billInfo = (DraftDiscountReqBillInfo)model;
        DraftDiscountReqBillEntryCollection entryCol = billInfo.getEntrys();
        if (entryCol != null && entryCol.size() > 0) {
            int n = entryCol.size();
            for (int i = 0; i < n; ++i) {
                DraftDiscountReqBillEntryInfo entryInfo = entryCol.get(i);
                if (entryInfo.getDraftStockBill() != null && entryInfo.getDraftStockBill().getId() != null) {
                    String stockId = entryInfo.getDraftStockBill().getId().toString();
                    EdrafentUtil.saveBotpRelation(ctx, (CoreBillBaseInfo)entryInfo.getDraftStockBill(), (CoreBillBaseInfo)billInfo, stockId, billInfo.getId().toString());
                }
                if (entryInfo.getReceivableBill() == null || entryInfo.getReceivableBill().getId() == null) continue;
                String receId = entryInfo.getReceivableBill().getId().toString();
                EdrafentUtil.saveBotpRelation(ctx, (CoreBillBaseInfo)entryInfo.getReceivableBill(), (CoreBillBaseInfo)billInfo, receId, billInfo.getId().toString());
            }
        }
    }

    private void revaseStatu(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DraftDiscountReqBillInfo billInfo = (DraftDiscountReqBillInfo)model;
        if (billInfo != null && billInfo.getId() != null) {
            this.reverstStatu(ctx, billInfo);
        }
        DiscountDraftTypeEnum draftType = billInfo.getDiscountDraftType();
        DraftDiscountReqBillEntryCollection entryCol = billInfo.getEntrys();
        if (entryCol.size() > 0) {
            int size = entryCol.size();
            HashSet<BOSUuid> set = null;
            if (draftType.equals((Object)DiscountDraftTypeEnum.DC00)) {
                set = new HashSet<BOSUuid>();
                for (int i = 0; i < size; ++i) {
                    DraftDiscountReqBillEntryInfo entryInfo = entryCol.get(i);
                    if (entryInfo.getDraftStockBill() == null || entryInfo.getDraftStockBill().getId() == null) continue;
                    set.add(entryInfo.getDraftStockBill().getId());
                }
                if (set != null && set.size() > 0) {
                    String sql = "update T_EDT_DraftStockBill set FDraftStockOperate=2 where " + FMHelper.buildIn((String)"FID", (Object[])set.toArray());
                    DbUtil.execute((Context)ctx, (String)sql);
                }
            } else {
                set = new HashSet();
                for (int i = 0; i < size; ++i) {
                    DraftDiscountReqBillEntryInfo entryInfo = entryCol.get(i);
                    if (entryInfo.getReceivableBill() == null || entryInfo.getReceivableBill().getId() == null) continue;
                    set.add(entryInfo.getReceivableBill().getId());
                }
                if (set != null && set.size() > 0) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
                    view.setFilter(filter);
                    ReceivableBillCollection recCol = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillCollection(view);
                    if (recCol.size() > 0) {
                        CoreBaseCollection col = new CoreBaseCollection();
                        int j = recCol.size();
                        for (int k = 0; k < j; ++k) {
                            ReceivableBillInfo info = recCol.get(k);
                            if (info.getBillState().equals((Object)BillStateEnum.DISCOUNTED)) continue;
                            info.setBillLastState(info.getBillState());
                            col.add((CoreBaseInfo)info);
                        }
                        ReceivableBillFactory.getLocalInstance((Context)ctx).update(col);
                    }
                    String sql = "update T_NT_ReceivableBill set FBillState=3 where " + FMHelper.buildIn((String)"FID", (Object[])set.toArray());
                    DbUtil.execute((Context)ctx, (String)sql);
                }
            }
        }
    }

    private void reverstStatu(Context ctx, DraftDiscountReqBillInfo billInfo) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)billInfo.getId(), CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add(new SelectorItemInfo("receivableBill.*"));
        sic.add(new SelectorItemInfo("draftStockBill.*"));
        env.setFilter(filter);
        env.setSelector(sic);
        DraftDiscountReqBillEntryCollection entryCol = DraftDiscountReqBillEntryFactory.getLocalInstance(ctx).getDraftDiscountReqBillEntryCollection(env);
        if (entryCol != null && entryCol.size() > 0) {
            IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            if (billInfo.getDiscountDraftType().equals((Object)DiscountDraftTypeEnum.DC00)) {
                HashSet<BOSUuid> set = new HashSet<BOSUuid>();
                int n = entryCol.size();
                for (int i = 0; i < n; ++i) {
                    DraftDiscountReqBillEntryInfo entryInfo = entryCol.get(i);
                    DraftStockBillInfo stockInfo = entryInfo.getDraftStockBill();
                    if (!stockInfo.getDraftStockOperate().equals((Object)DraftStockBillOperateEnum.DISCOUNT)) continue;
                    set.add(stockInfo.getId());
                }
                if (set != null && set.size() > 0) {
                    String sql = "update T_EDT_DraftStockBill set FDraftStockOperate=0 where " + FMHelper.buildIn((String)"FID", (Object[])set.toArray());
                    DbUtil.execute((Context)ctx, (String)sql);
                    iBOTRelation.removeRelationByDestObjId(billInfo.getId().toString(), new DraftStockBillInfo().getBOSType().toString());
                }
            } else {
                CoreBaseCollection col = new CoreBaseCollection();
                int n = entryCol.size();
                for (int i = 0; i < n; ++i) {
                    ReceivableBillInfo receivableInfo = entryCol.get(i).getReceivableBill();
                    if (!receivableInfo.getBillState().equals((Object)BillStateEnum.DISCOUNTED)) continue;
                    receivableInfo.setBillState(receivableInfo.getBillLastState());
                    col.add((CoreBaseInfo)receivableInfo);
                }
                if (col != null && col.size() > 0) {
                    ReceivableBillFactory.getLocalInstance((Context)ctx).update(col);
                    iBOTRelation.removeRelationByDestObjId(billInfo.getId().toString(), new ReceivableBillInfo().getBOSType().toString());
                }
            }
        }
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.revaseStatu(ctx, model);
        super._submit(ctx, pk, model);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.revaseStatu(ctx, model);
        return super._submit(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DraftDiscountReqBillInfo info = (DraftDiscountReqBillInfo)model;
        this.revaseStatu(ctx, (IObjectValue)info);
        if (info.getNumber() != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
            if (DraftDiscountReqBillFactory.getLocalInstance(ctx).exists(filter)) {
                throw new EASBizException(new NumericExceptionSubItem("66998", "\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01"));
            }
        }
        this.saveBOTPRelation(ctx, pk, model);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DraftDiscountReqBillInfo draftInfo = DraftDiscountReqBillFactory.getLocalInstance(ctx).getDraftDiscountReqBillInfo(pk);
        if ((draftInfo.getOperateState().equals((Object)OperateStateEnum.SAVE) || draftInfo.getOperateState().equals((Object)OperateStateEnum.SUBMIT)) && (draftInfo.getFinanceOperateState() == null || draftInfo.getFinanceOperateState().equals((Object)com.kingdee.eas.fm.edrafent.FCOperateStateEnum.init_Value))) {
            EntityViewInfo env = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)pk, CompareType.EQUALS));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add(new SelectorItemInfo("receivableBill.*"));
            sic.add(new SelectorItemInfo("draftStockBill.*"));
            env.setFilter(filter);
            env.setSelector(sic);
            DraftDiscountReqBillEntryCollection entryCol = DraftDiscountReqBillEntryFactory.getLocalInstance(ctx).getDraftDiscountReqBillEntryCollection(env);
            if (entryCol != null && entryCol.size() > 0) {
                IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
                HashSet<BOSUuid> stockSet = new HashSet<BOSUuid>();
                CoreBaseCollection col = new CoreBaseCollection();
                int n = entryCol.size();
                for (int i = 0; i < n; ++i) {
                    ReceivableBillInfo receivableInfo;
                    DraftDiscountReqBillEntryInfo entryInfo = entryCol.get(i);
                    if (entryInfo.getDraftStockBill() != null && entryInfo.getDraftStockBill().getId() != null) {
                        stockSet.add(entryInfo.getDraftStockBill().getId());
                    }
                    if (entryInfo.getReceivableBill() == null || entryInfo.getReceivableBill().getId() == null || !(receivableInfo = entryCol.get(i).getReceivableBill()).getBillState().equals((Object)BillStateEnum.DISCOUNTED)) continue;
                    receivableInfo.setBillState(receivableInfo.getBillLastState());
                    col.add((CoreBaseInfo)receivableInfo);
                }
                if (stockSet != null && stockSet.size() > 0) {
                    String sql = "update T_EDT_DraftStockBill set FDraftStockOperate=? where " + FMHelper.buildIn((String)"FID", (Object[])stockSet.toArray());
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(0)});
                    iBOTRelation.removeRelationByDestObjId(pk.toString(), new DraftStockBillInfo().getBOSType().toString());
                }
                if (col != null && col.size() > 0) {
                    ReceivableBillFactory.getLocalInstance((Context)ctx).update(col);
                    iBOTRelation.removeRelationByDestObjId(pk.toString(), new ReceivableBillInfo().getBOSType().toString());
                }
            }
            super._delete(ctx, pk);
        }
    }

    @Override
    protected void _draftSubmit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.SAVE, CompareType.EQUALS));
        env.setFilter(filter);
        DraftDiscountReqBillCollection col = DraftDiscountReqBillFactory.getLocalInstance(ctx).getDraftDiscountReqBillCollection(env);
        if (col.size() > 0) {
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                super.submit(ctx, (CoreBaseInfo)col.get(i));
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u4fdd\u5b58\u72b6\u6001\u7684\u8d34\u73b0\u7533\u8bf7\u5355\u624d\u5141\u8bb8\u63d0\u4ea4\uff01"});
        }
    }

    @Override
    protected void _batchSubmitFC(Context ctx, Set idSet, DraftApplyTypeEnum applyType) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.AUDIT, CompareType.EQUALS));
        env.setFilter(filter);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("entrys.*");
        selectors.add("entrys.draftStockBill.commercialDraft.*");
        env.setSelector(selectors);
        DraftDiscountReqBillCollection billCol = DraftDiscountReqBillFactory.getLocalInstance(ctx).getDraftDiscountReqBillCollection(env);
        if (billCol.size() > 0) {
            HashSet<String> set = new HashSet<String>();
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                DraftDiscountReqBillInfo reqBillInfo = billCol.get(i);
                set.add(reqBillInfo.getId().toString());
                DiscountReqApplyBillInfo disInfo = new DiscountReqApplyBillInfo();
                disInfo.setApplyCompany(reqBillInfo.getCompany());
                disInfo.setCompany(EdrafUtil.getFinCompany((Context)ctx));
                disInfo.setDiscountDraftType(reqBillInfo.getDiscountDraftType());
                disInfo.setDiscountType(reqBillInfo.getDiscountType());
                disInfo.setDiscountOutUser(reqBillInfo.getDiscountOutUser());
                disInfo.setDiscountOutAccount(reqBillInfo.getDiscountOutAccount());
                disInfo.setDiscountOutBankNumber(reqBillInfo.getDiscountOutBankNumber());
                disInfo.setDiscountOutRemark(reqBillInfo.getDiscountOutRemark());
                disInfo.setOrgUnitCode(reqBillInfo.getOrgUnitCode());
                disInfo.setDiscountInUser(reqBillInfo.getDiscountInUser());
                disInfo.setDiscountInAccount(reqBillInfo.getDiscountInAccount());
                disInfo.setDiscountInBankNumber(reqBillInfo.getDiscountInBankNumber());
                disInfo.setIsLine(reqBillInfo.isIsLine());
                disInfo.setIsAttorn(reqBillInfo.isIsAttorn());
                disInfo.setDiscountRate(reqBillInfo.getDiscountRate());
                disInfo.setDiscountMoneyInAccount(reqBillInfo.getDiscountMoneyInAccount());
                disInfo.setDiscountMoneyBankNum(reqBillInfo.getDiscountMoneyBankNum());
                disInfo.setContractNumber(reqBillInfo.getContractNumber());
                disInfo.setInvoiceNumber(reqBillInfo.getInvoiceNumber());
                disInfo.setBatchNumber(reqBillInfo.getBatchNumber());
                disInfo.setDiscountRedStartDate(reqBillInfo.getDiscountRedStartDate());
                disInfo.setDiscountRedEndDate(reqBillInfo.getDiscountRedEndDate());
                disInfo.setDiscountRedRate(reqBillInfo.getDiscountRedRate());
                disInfo.setSourceBillId(reqBillInfo.getId().toString());
                disInfo.setOperateState(FCOperateStateEnum.save);
                disInfo.setDiscountApplyDate(reqBillInfo.getDiscountApplyDate());
                IObjectPK pk = DiscountReqApplyBillFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)disInfo);
                String reqId = reqBillInfo.getId().toString();
                EdrafentUtil.saveBotpRelation(ctx, (CoreBillBaseInfo)reqBillInfo, (CoreBillBaseInfo)disInfo, reqId, pk.toString());
                DraftDiscountReqBillEntryCollection entryCol = reqBillInfo.getEntrys();
                CoreBaseCollection col = new CoreBaseCollection();
                this.commitFC4WF(ctx, reqBillInfo);
                if (entryCol == null || entryCol.size() <= 0) continue;
                DiscountReqApplyBillEntryInfo applyEntryinfo = null;
                int k = entryCol.size();
                for (int j = 0; j < k; ++j) {
                    DraftDiscountReqBillEntryInfo entryInfo = entryCol.get(j);
                    applyEntryinfo = new DiscountReqApplyBillEntryInfo();
                    applyEntryinfo.setDraftNumber(entryInfo.getDraftNumber());
                    applyEntryinfo.setDraftType(entryInfo.getDraftType());
                    applyEntryinfo.setIssuDate(entryInfo.getIssuDate());
                    applyEntryinfo.setDueDate(entryInfo.getDueDate());
                    applyEntryinfo.setDraftAmount(entryInfo.getDraftAmount());
                    applyEntryinfo.setDrawerName(entryInfo.getDrawerName());
                    applyEntryinfo.setAcceptorName(entryInfo.getAcceptorName());
                    applyEntryinfo.setDiscountMoney(entryInfo.getDiscountMoney());
                    applyEntryinfo.setDiscountInMoney(entryInfo.getDiscountInMoney());
                    applyEntryinfo.setDiscountOutRamark(entryInfo.getDiscountOutRamark());
                    applyEntryinfo.setReceivableBill(entryInfo.getReceivableBill());
                    applyEntryinfo.setSourceEntryID(entryInfo.getId().toString());
                    applyEntryinfo.setBill(disInfo);
                    applyEntryinfo.setIsSelect(true);
                    if (entryInfo.getDraftStockBill() != null) {
                        applyEntryinfo.setCommunResult(ECDSCommunicationStatusEnum.SUBMIT_READY);
                        DraftStockBillInfo stockInfo = entryInfo.getDraftStockBill();
                        applyEntryinfo.setDraftStockBill(stockInfo);
                        CommercialDraftInfo commInfo = stockInfo.getCommercialDraft();
                        applyEntryinfo.setStartStatu(commInfo.getDraftECDSStatus());
                        applyEntryinfo.setEndStatu(commInfo.getDraftECDSStatus());
                    }
                    col.add((CoreBaseInfo)applyEntryinfo);
                }
                if (col == null || col.size() <= 0) continue;
                DiscountReqApplyBillEntryFactory.getLocalInstance((Context)ctx).addnew(col);
            }
            if (set.size() > 0) {
                CompanyOrgUnitInfo companyName = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
                UserInfo userName = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
                DraftDiscountReqBillInfo info = new DraftDiscountReqBillInfo();
                info.setSubmitDate(DateHelper.getTime());
                String sql = "update T_EDT_DraftDiscountReqBill set FCommunicationWay=1,FOperateState=?,FFinanceOperateState=2,FReturnOpinion=?,FSubmitDate=?,FSubmitterID=?,FSubmitCompanyID=? where " + FMHelper.buildIn((String)"FID", (Object[])set.toArray());
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(3), null, info.getSubmitDate(), userName.getId().toString(), companyName.getId().toString()});
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u5ba1\u6279\u72b6\u6001\u7684\u8d34\u73b0\u7533\u8bf7\u5355\u624d\u5141\u8bb8\u63d0\u4ea4\u8d22\u52a1\u516c\u53f8\uff01"});
        }
    }

    @Override
    protected void _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.SUBMIT, CompareType.EQUALS));
        env.getSelector().add(new SelectorItemInfo("id"));
        env.setFilter(filter);
        DraftDiscountReqBillCollection billCol = DraftDiscountReqBillFactory.getLocalInstance(ctx).getDraftDiscountReqBillCollection(env);
        if (billCol.size() > 0) {
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                DraftDiscountReqBillInfo billInfo = billCol.get(i);
                this.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()), billInfo);
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u63d0\u4ea4\u72b6\u6001\u7684\u8d34\u73b0\u7533\u8bf7\u5355\u624d\u5141\u8bb8\u5ba1\u6279\uff01"});
        }
    }

    @Override
    protected void _unAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Object[] idArray;
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.AUDIT, CompareType.EQUALS));
        env.getSelector().add(new SelectorItemInfo("id"));
        env.setFilter(filter);
        DraftDiscountReqBillCollection billCol = DraftDiscountReqBillFactory.getLocalInstance(ctx).getDraftDiscountReqBillCollection(env);
        if (billCol.size() > 0) {
            idArray = new String[billCol.size()];
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                idArray[i] = billCol.get(i).getId().toString();
                this.unAudit4WF(ctx, billCol.get(i));
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u5ba1\u6279\u72b6\u6001\u7684\u8d34\u73b0\u7533\u8bf7\u5355\u624d\u5141\u8bb8\u53cd\u5ba1\u6279\uff01"});
        }
        String sql = "update T_EDT_DraftDiscountReqBill set FOperateState=?,FAuditDate=? where " + FMHelper.buildIn((String)"FID", (Object[])idArray);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(0), null});
    }

    @Override
    protected String getApplyBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    @Override
    protected String getBankBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    @Override
    public DraftApplyBillBaseInfo getApplyBillBaseInfo(DrafentApplyBillBaseInfo baseInfo, DraftApplyTypeEnum cancelType) {
        return null;
    }
}

