/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseInfo;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.GuaranteeApplyBillCollection;
import com.kingdee.eas.fm.edraf.GuaranteeApplyBillFactory;
import com.kingdee.eas.fm.edraf.GuaranteeApplyBillInfo;
import com.kingdee.eas.fm.edrafent.CommercialDraftFactory;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseInfo;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftGuaranteeRequestBillCollection;
import com.kingdee.eas.fm.edrafent.DraftGuaranteeRequestBillInfo;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.app.AbstractDraftGuaranteeRequestBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Set;
import org.apache.log4j.Logger;

public class DraftGuaranteeRequestBillControllerBean
extends AbstractDraftGuaranteeRequestBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edrafent.app.DraftGuaranteeRequestBillControllerBean");

    protected void initInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.initInfo(ctx, model);
    }

    protected void checkBeforeAddNew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.checkBeforeAddNew(ctx, model);
    }

    @Override
    public DraftApplyBillBaseInfo getApplyBillBaseInfo(DrafentApplyBillBaseInfo baseInfo, DraftApplyTypeEnum applyType) {
        GuaranteeApplyBillInfo newBillInfo = null;
        if (baseInfo instanceof DraftGuaranteeRequestBillInfo) {
            DraftGuaranteeRequestBillInfo billInfo = (DraftGuaranteeRequestBillInfo)baseInfo;
            newBillInfo = new GuaranteeApplyBillInfo();
            newBillInfo.setIsCancelDraft(false);
            newBillInfo.setGuaranteeType(billInfo.getGuaranteeType());
            newBillInfo.setCommercialDraft(billInfo.getCommercialDraft());
            newBillInfo.setCommunicationStatus(ECDSCommunicationStatusEnum.SUBMIT_READY);
            newBillInfo.setOperateState(FCOperateStateEnum.save);
            newBillInfo.setApplyCompany(billInfo.getCompany());
            newBillInfo.setApplyDate(billInfo.getGuaranteeDate());
            newBillInfo.setGuaranteeDate(billInfo.getGuaranteeDate());
            newBillInfo.setByAssurerName(billInfo.getByAssurerName());
            newBillInfo.setByAssurerBank(billInfo.getByAssurerBank());
            newBillInfo.setByAssurerAcctSv(billInfo.getByAssurerAcctSv());
            newBillInfo.setAssurerName(billInfo.getAssurerName());
            newBillInfo.setAssurersBankNumber(billInfo.getAssurersBankNumber());
            newBillInfo.setAssurerAddress(billInfo.getAssurerAddress());
            newBillInfo.setAssurersAccount(billInfo.getAssurersAccount());
            newBillInfo.setContractNumber(billInfo.getContractNumber());
            newBillInfo.setBatch(billInfo.getBatch());
            newBillInfo.setIsTransfer(billInfo.isIsTransfer());
            newBillInfo.setDrwrCdtRatgAgcy(billInfo.getDrwrCdtRatgAgcy());
            newBillInfo.setDrwrCdtRatgs(billInfo.getDrwrCdtRatgs());
            newBillInfo.setDrwrCdtRDDate(billInfo.getDrwrCdtRDDate());
            newBillInfo.setAccpCdtRatgAgcy(billInfo.getAccpCdtRatgAgcy());
            newBillInfo.setAccptCdtRatgs(billInfo.getAccptCdtRatgs());
            newBillInfo.setAccptrCdtRDDate(billInfo.getAccptrCdtRDDate());
            newBillInfo.setRemark(billInfo.getRemark());
            newBillInfo.setSourceBillId(billInfo.getId().toString());
            newBillInfo.setStartECDSState(billInfo.getCommercialDraft().getDraftECDSStatus());
            newBillInfo.setEndECDSState(billInfo.getCommercialDraft().getDraftECDSStatus());
        }
        return newBillInfo;
    }

    protected void isCanDelete(Context ctx, IObjectPK pk, CoreBillBaseInfo coreBillInfo) throws BOSException, EASBizException {
        super.isCanDelete(ctx, pk, coreBillInfo);
        DraftGuaranteeRequestBillInfo info = this.getDraftGuaranteeRequestBillInfo(ctx, pk);
        if (info.getOperateState().getValue() == 0 || info.getOperateState().getValue() == 1) {
            if (info.getFinanceOperateState() != com.kingdee.eas.fm.edrafent.FCOperateStateEnum.init_Value) {
                throw new EASBizException(new NumericExceptionSubItem("123088", "\u5df2\u5ba1\u6279\u6216\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u53ef\u5220\u9664\uff01"));
            }
        } else {
            throw new EASBizException(new NumericExceptionSubItem("123088", "\u5df2\u5ba1\u6279\u6216\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u53ef\u5220\u9664\uff01"));
        }
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super.delete(ctx, pk);
    }

    @Override
    protected void _submit(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)new Integer(0), CompareType.EQUALS));
        envi.setFilter(filter);
        DraftGuaranteeRequestBillCollection coll = this.getDraftGuaranteeRequestBillCollection(ctx, envi);
        if (coll.size() <= 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u4fdd\u5b58\u72b6\u6001\u7684\u5355\u624d\u5141\u8bb8\u63d0\u4ea4\uff01"});
        }
        for (int i = 0; i < coll.size(); ++i) {
            DraftGuaranteeRequestBillInfo info = coll.get(i);
            super.submit(ctx, (CoreBaseInfo)info);
        }
    }

    @Override
    protected void checkCanBeCancelled(Context ctx, IObjectValue model, DraftApplyTypeEnum cancelType) throws EASBizException, BOSException {
        DraftGuaranteeRequestBillInfo billInfo = (DraftGuaranteeRequestBillInfo)model;
        String srcID = billInfo.getId().toString();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("sourceBillId", (Object)srcID);
        SorterItemInfo sortInfo = new SorterItemInfo("createtime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        evi.setSorter(sortCol);
        evi.setFilter(filter);
        GuaranteeApplyBillCollection col = GuaranteeApplyBillFactory.getLocalInstance((Context)ctx).getGuaranteeApplyBillCollection(evi);
        if (col == null || col.size() == 0 || billInfo.getCommercialDraft() == null) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u83b7\u53d6\u4e0d\u5230\u8d22\u52a1\u516c\u53f8\u7533\u8bf7\u5355\uff0c\u4e0d\u80fd\u505a\u64a4\u9500\u64cd\u4f5c\uff01"});
        }
        GuaranteeApplyBillInfo guaranteeApplyBillInfo = col.get(0);
        if (guaranteeApplyBillInfo.getCommunicationStatus() != ECDSCommunicationStatusEnum.SUBMIT_SUCCESS) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u4e0e\u4eba\u884c\u901a\u8baf\u7ed3\u679c\u4e3a\u63d0\u4ea4\u6210\u529f\u540e\u624d\u53ef\u64a4\u6d88"});
        }
        CommercialDraftInfo commercialDraftInfo = CommercialDraftFactory.getLocalInstance(ctx).getCommercialDraftInfo((IObjectPK)new ObjectUuidPK(billInfo.getCommercialDraft().getId().toString()));
        if (!commercialDraftInfo.getDraftECDSStatus().equals((Object)ECDSBillStatusEnum.BZDQS) || billInfo.isIsCancelDraft() || !billInfo.getOperateState().equals((Object)OperateStateEnum.SUBMITGATEWAY)) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u4fdd\u8bc1\u5f85\u7b7e\u6536\u3001\u672a\u64a4\u9500\u3001\u64cd\u4f5c\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\u7f51\u5173\u7684\u4fdd\u8bc1\u7533\u8bf7\u5355\u624d\u53ef\u4ee5\u8fdb\u884c\u64a4\u9500\u64cd\u4f5c\uff01"});
        }
    }

    @Override
    protected String getApplyBillClassName(DraftApplyTypeEnum cancelType) {
        return GuaranteeApplyBillInfo.class.getName();
    }

    @Override
    protected String getBankBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    @Override
    protected void _audit(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)new Integer(1), CompareType.EQUALS));
        envi.setFilter(filter);
        DraftGuaranteeRequestBillCollection coll = this.getDraftGuaranteeRequestBillCollection(ctx, envi);
        if (coll.size() <= 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u63d0\u4ea4\u72b6\u6001\u7684\u5355\u624d\u53ef\u5ba1\u6279\uff01"});
        }
        for (int i = 0; i < coll.size(); ++i) {
            DraftGuaranteeRequestBillInfo info = coll.get(i);
            if (info.getOperateState().getValue() != 1) continue;
            super._audit4WF(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
        }
    }

    @Override
    protected void _unAudit(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)new Integer(2), CompareType.EQUALS));
        envi.setFilter(filter);
        DraftGuaranteeRequestBillCollection coll = this.getDraftGuaranteeRequestBillCollection(ctx, envi);
        if (coll.size() <= 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u5ba1\u6279\u72b6\u6001\u7684\u5355\u624d\u53ef\u53cd\u5ba1\u6279\uff01"});
        }
        for (int i = 0; i < coll.size(); ++i) {
            DraftGuaranteeRequestBillInfo info = coll.get(i);
            if (info.getOperateState().getValue() != 2) continue;
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("operateState"));
            selColl.add(new SelectorItemInfo("auditDate"));
            selColl.add(new SelectorItemInfo("auditor"));
            info.setOperateState(OperateStateEnum.SAVE);
            info.setAuditDate(null);
            info.setAuditor(null);
            this.updatePartial(ctx, (CoreBaseInfo)info, selColl);
            super.unAudit4WF(ctx, info);
        }
    }

    protected void setBillState(DrafentApplyBillBaseInfo info) {
    }
}

